<!DOCTYPE html>
<html>
<head>
    <title>Login Test</title>
    <style>
        body { font-family: Arial; max-width: 500px; margin: 50px auto; padding: 20px; }
        .result { padding: 15px; margin: 20px 0; border-radius: 5px; }
        .success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        input { width: 100%; padding: 10px; margin: 5px 0; }
        button { width: 100%; padding: 12px; background: #007bff; color: white; border: none; cursor: pointer; }
        button:hover { background: #0056b3; }
    </style>
</head>
<body>
    <h2>🔐 IndusProERP - Direct Login Test</h2>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Include Laravel bootstrap
        require_once __DIR__ . '/../vendor/autoload.php';
        $app = require_once __DIR__ . '/../bootstrap/app.php';
        $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

        $email = $_POST['email'] ?? '';
        $password = $_POST['password'] ?? '';

        echo '<div class="result">';

        // Find user
        $user = \App\Models\User::where('email', $email)->first();

        if (!$user) {
            echo '<div class="error">❌ User not found with email: ' . htmlspecialchars($email) . '</div>';
        } else {
            echo '<strong>User Found:</strong><br>';
            echo 'Name: ' . htmlspecialchars($user->name) . '<br>';
            echo 'Email: ' . htmlspecialchars($user->email) . '<br>';
            echo 'Role: ' . htmlspecialchars($user->role) . '<br>';
            echo 'Email Verified: ' . ($user->email_verified_at ? '✅ Yes' : '❌ No') . '<br><br>';

            // Check password
            if (\Illuminate\Support\Facades\Hash::check($password, $user->password)) {
                echo '<div class="success">✅ <strong>PASSWORD CORRECT!</strong><br><br>';
                echo 'Authentication would succeed. The issue is with your browser/session.<br><br>';
                echo '<strong>Next Steps:</strong><br>';
                echo '1. Clear ALL browser data (cookies, cache)<br>';
                echo '2. Close and reopen browser<br>';
                echo '3. Try login at: <a href="/induspro/public/login">/induspro/public/login</a><br>';
                echo '</div>';
            } else {
                echo '<div class="error">❌ <strong>PASSWORD INCORRECT!</strong><br>';
                echo 'Please use: Admin@123</div>';
            }
        }

        echo '</div>';
    }
    ?>

    <form method="POST">
        <label><strong>Email:</strong></label>
        <input type="email" name="email" value="superadmin@gmail.com" required>

        <label><strong>Password:</strong></label>
        <input type="password" name="password" placeholder="Admin@123" required>

        <button type="submit">🔍 Test Login Credentials</button>
    </form>

    <div style="margin-top: 30px; padding: 15px; background: #e7f3ff; border-radius: 5px;">
        <strong>📋 Available Test Accounts:</strong><br><br>
        <code>superadmin@gmail.com</code> / <code>Admin@123</code><br>
        <code>admin@induspro.com</code> / <code>Admin@123</code><br>
        <code>ravi@gmail.com</code> / <code>Admin@123</code><br>
        <code>prbkrbt@gmail.com</code> / <code>Admin@123</code>
    </div>
</body>
</html>
