/**
 * -----------------------------Start of the script for Quotation page-------------------------------------------------------------------
 */
window.addEventListener('load', async () => {

    //-----------------------------------------------------------------------------------
    // Retrieve the RFQ data from session storage
    const currentRFQId = sessionStorage.getItem('currentRfqQuoteId');

    if(currentRFQId){
        const response = await fetch('/api/v1/customers');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const companyData = await response.json();
        // Retrieve RFQ data from localStorage
        const response1 = await fetch(`/api/v1/rfqs/${currentRFQId}`);
            if (!response1.ok) {
                throw new Error('HTTP error! Status: ${response.status}');
            }
        const currentRFQ = await response1.json();

        if (currentRFQ) {
            // Populate the form fields with the RFQ data
            document.getElementById("custRefNo").value = currentRFQ.cusRefNo;
            document.getElementById("rfqNo").value = currentRFQ.rfqNo;
            document.getElementById("rfqDate").value = currentRFQ.rfqDate;
            document.getElementById("companyNameSelect").value = currentRFQ.customer;
            document.getElementById("productType").value = currentRFQ.productType;
            document.getElementById("partNo").value = currentRFQ.partNo;
            document.getElementById("project-materialNo").value = currentRFQ.projectMaterialNo;
            document.getElementById("drawingNo").value = currentRFQ.drawingNo;
            document.getElementById("drawingRev").value = currentRFQ.drawingRev;
            document.getElementById("quantity").value = currentRFQ.quantity;
            document.getElementById("quantityUOM").value = currentRFQ.uom;
            document.getElementById("description").value = currentRFQ.note;
        
            if(currentRFQ.customer) {

                const CompanyKey = currentRFQ.customer;  // This is the selected company name

                // Find the company object matching the selected company name
                const selectedCompany = companyData.find(company => company.companyName === CompanyKey);

                if (selectedCompany) {
                    // Populate fields with company details
                    document.getElementById("address").value = selectedCompany.billingAddress || '';
                    document.getElementById("gst").value = selectedCompany.gstNo || '';
                    document.getElementById("phone").value = selectedCompany.companyContact || '';
                    document.getElementById("email").value = selectedCompany.companyEmail || '';
                } else {
                    // Handle case where the company is not found
                    console.error("Company data not found for company:", CompanyKey);
                }
            }

            const rawMaterials = currentRFQ.rawMaterials;

            // Check if rawMaterials exists in localStorage
            if (rawMaterials && rawMaterials.length > 0) {
                const checkbox = document.querySelector('#checkbox1');
                const table = document.querySelector('#table1');
                const addRowBtn = document.getElementById(`add-row-1`);

                checkbox.checked = true;
                table.classList.remove('hidden');
                addRowBtn.style.display = 'block';
                table.querySelector('tbody').innerHTML = '';
                rawMaterials.forEach((rawMaterial, index) => {
                    addNewRow(rawMaterial.name, index + 1);
                });
            }
        }
    }

    //---------------------------------------------------------------------------------------
    // Quotation edit logic
    const quotationId = sessionStorage.getItem('currentQuotationId');

    if (quotationId) {
        // Retrieve the list from local storage
        const response2 = await fetch(`/api/v1/quotations/${quotationId}`);
        if (!response2.ok) {
            throw new Error('HTTP error! Status: ${response.status}');
        }
        const quotationData = await response2.json();   

        if (quotationData) {
            // Populate basic form fields
            document.getElementById('quotationNo').value = quotationData.quotationNo1;
            document.getElementById('quotationDate').value = quotationData.quotationDate;
            document.getElementById('companyNameSelect').value = quotationData.companyName;
            document.getElementById('email').value = quotationData.companyEmail;
            document.getElementById('phone').value = quotationData.companyPhone;
            document.getElementById('gst').value = quotationData.gstNo;
            document.getElementById('address').value = quotationData.address;

            // Populate RFQ and part details
            document.getElementById("custRefNo").value = quotationData.custRefNo;
            document.getElementById('rfqNo').value = quotationData.rfqNo;
            document.getElementById('rfqDate').value = quotationData.rfqDate;
            document.getElementById('partNo').value = quotationData.partNo;
            document.getElementById('project-materialNo').value = quotationData.projectMaterialNo;
            document.getElementById('drawingNo').value = quotationData.drawingId;
            document.getElementById('drawingRev').value = quotationData.drawingRevision;
            document.getElementById('description').value = quotationData.projectDescription;
            document.getElementById('quantity').value = quotationData.quantity;
            document.getElementById('quantityUOM').value = quotationData.quantityUOM;

            // Populate product type and other details
            document.getElementById('productType').value = quotationData.productType;

            // Populate product tables based on checkbox selection
            if (quotationData.rawMaterialCharges && quotationData.rawMaterialCharges.length > 0) {
                document.getElementById('checkbox1').checked = true;
                document.querySelector('#table1').classList.remove('hidden');
                populateTable1('table1', quotationData.rawMaterialCharges);
            }
            if (quotationData.conversionCosts && quotationData.conversionCosts.length > 0) {
                document.getElementById('checkbox2').checked = true;
                document.querySelector('#table2').classList.remove('hidden');
                populateTable2('table2', quotationData.conversionCosts);
            }
            if (quotationData.packingCharges && quotationData.packingCharges.length > 0) {
                document.getElementById('checkbox3').checked = true;
                document.querySelector('#table3').classList.remove('hidden');
                populateTable3('table3', quotationData.packingCharges);
            }
            document.getElementById('quoteNote').value = quotationData.quoteNote;
            // Populate totals and additional data
            document.getElementById('totalAmount').value = quotationData.totalAmount;
            document.getElementById('qt-discount').value = quotationData.discount;
            document.getElementById('roundUp').value = quotationData.roundUp;
            document.getElementById('grandTotal').value = quotationData.grandTotal;
            document.getElementById('GT-in-letters').value = quotationData.inWords;

            console.log("Quotation data pre-filled successfully:", quotationData);
        } else {
            console.error(`Quotation with ID ${quotationId} not found.`);
        }
    }

    // Helper function to add a row to the specified table with the given data

    // Get today's date in YYYY-MM-DD format
    const today = new Date().toISOString().split('T')[0];
    // Set the default value of the date input to today's date
    document.getElementById('quotationDate').value = today;

    

    // Set the quotationNo ID when the form loads
    //   document.getElementById('quotationNo').value = generateQuotationId();

    // Add event listeners to the table rows
    document.querySelector(`.RMtable tbody`).addEventListener('input', (event) => {
        const row = event.target.closest('tr'); // Get the row containing the input that was changed

        // Check if the input or select is inside a row of the table
        if (row) {
            calculateRMCost(row);  // Call calculateRMCost for the specific row
            calculateRowValue1(row);  // Call calculateRowValue1 for the specific row
        }
    });

    /**
    * -----------------------------Start of the script for calculation-------------------------------------------------------------------
    */

    // Initialize event listeners for all tables
    ['table1', 'table2', 'table3'].forEach(tableID => {
        const rows = document.querySelectorAll(`#${tableID} tbody tr`);
        rows.forEach(row => {
            row.querySelectorAll('input').forEach(input => {
                input.addEventListener('input', calculateTotals);
            });
        });
    });

    // updateGrandTotalInWords();
    sessionStorage.removeItem('currentRfqQuoteId');
    sessionStorage.removeItem('currentQuotationId');
});

// Save form data to local storage on form submission
document.getElementById('quotationContent').addEventListener('submit', async function (event) {
    event.preventDefault();

    try {
        // Gather form data
        const formData = {
            quotationNo1: document.getElementById('quotationNo').value.trim(),
            quotationDate: document.getElementById('quotationDate').value.trim(),
            companyName: document.getElementById('companyNameSelect').value.trim(),
            companyEmail: document.getElementById('email').value.trim(),
            companyPhone: document.getElementById('phone').value.trim(),
            gstNo: document.getElementById('gst').value.trim(),
            address: document.getElementById('address').value.trim(),
            custRefNo: document.getElementById("custRefNo").value.trim(),
            rfqNo: document.getElementById('rfqNo').value.trim(),
            rfqDate: document.getElementById('rfqDate').value.trim(),
            partNo: document.getElementById('partNo').value.trim(),
            projectMaterialNo: document.getElementById('project-materialNo').value.trim(),
            drawingId: document.getElementById('drawingNo').value.trim(),
            drawingRevision: document.getElementById('drawingRev').value.trim(),
            quantity: parseFloat(document.getElementById('quantity').value) || 0,
            quantityUOM: document.getElementById('quantityUOM').value.trim(),
            projectDescription: document.getElementById('description').value.trim(),
            productType: document.getElementById('productType').value.trim(),
            rawMaterialCharges: getTable1DataIfChecked('checkbox1', 'table1') || [],
            conversionCosts: getTable2DataIfChecked('checkbox2', 'table2') || [],
            packingCharges: getTable3DataIfChecked('checkbox3', 'table3') || [],
            quoteNote: document.getElementById('quoteNote').value.trim(),
            totalAmount: parseFloat(document.getElementById('totalAmount').value) || 0,
            discount: parseFloat(document.getElementById('qt-discount').value) || 0,
            roundUp: parseFloat(document.getElementById('roundUp').value) || 0,
            grandTotal: parseFloat(document.getElementById('grandTotal').value) || 0,
            inWords: document.getElementById('GT-in-letters').value.trim(),
            pdfDataUrl: null // Will be updated after PDF generation
        };

        console.log("Form Data before sending:", formData);

        // Ensure required fields are filled
        if (!formData.quotationNo1 || !formData.companyName || !formData.grandTotal) {
            alert("Please fill all required fields.");
            return;
        }

        // Generate PDF and update formData
        const pdfDataUrl = await generateAndSavePDF();
        if (!pdfDataUrl) {
            alert("Error generating PDF. Please try again.");
            return;
        }
        formData.pdfDataUrl = pdfDataUrl;

        console.log("Updated Form Data with PDF:", formData);

        // Fetch existing quotations
        const response = await fetch('/api/v1/quotations/');
        if (!response.ok) {
            throw new Error(`Failed to fetch quotations: ${response.statusText}`);
        }
        const savedData = await response.json();

        // Check for existing quotation
        const existingQuotation = savedData.find(item => item.quotationNo1 === formData.quotationNo1);

        if (existingQuotation) {
            const userConfirmation = confirm(`A quotation with ${formData.quotationNo1} already exists. Do you want to overwrite it?`);
            if (userConfirmation) {
                await updateQuotation(existingQuotation.id, formData);
            } else {
                alert("The data was not saved.");
                return;
            }
        } else {
            await createQuotation(formData);
        }

        // Reset form and clear session storage
        resetForm();
        sessionStorage.removeItem('currentRfqQuoteId');
        sessionStorage.removeItem('currentQuotationId');

        // Redirect to quotation table page
        window.location.href = "quotation-datatable.html";

    } catch (error) {
        console.error("Error saving quotation:", error);
        alert("Error saving quotation. Please check the console for details.");
    }
});

/**
 * Function to send POST request to create a new quotation
 */
async function createQuotation(formData) {
    try {
        const response = await fetch('/api/v1/quotations/', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(formData)
        });

        if (!response.ok) {
            const errorData = await response.json();
            console.error("Create Quotation API Error:", errorData);
            alert(`Error: ${JSON.stringify(errorData)}`);
            return;
        }

        alert(`Quotation ${formData.quotationNo1} saved successfully.`);
    } catch (error) {
        console.error("Failed to create quotation:", error);
        alert("Error creating quotation. Please try again.");
    }
}

/**
 * Function to send PUT request to update an existing quotation
 */
async function updateQuotation(id, formData) {
    try {
        const response = await fetch(`/api/v1/quotations/${id}/`, {
            method: 'PUT',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(formData)
        });

        if (!response.ok) {
            const errorData = await response.json();
            console.error("Update Quotation API Error:", errorData);
            alert(`Error: ${JSON.stringify(errorData)}`);
            return;
        }

        alert(`Quotation ${formData.quotationNo1} updated successfully.`);
    } catch (error) {
        console.error("Failed to update quotation:", error);
        alert("Error updating quotation. Please try again.");
    }
}

/**
 * Utility function to fetch table data if checkbox is checked
 */
function getTable1DataIfChecked(checkboxId, tableId) {
    return document.getElementById(checkboxId).checked ? getTableData(tableId) : [];
}

function getTable2DataIfChecked(checkboxId, tableId) {
    return document.getElementById(checkboxId).checked ? getTableData(tableId) : [];
}

function getTable3DataIfChecked(checkboxId, tableId) {
    return document.getElementById(checkboxId).checked ? getTableData(tableId) : [];
}

/**
 * Dummy function to generate and save PDF (replace with actual implementation)
 */
async function generateAndSavePDF() {
    return new Promise((resolve) => {
        setTimeout(() => {
            resolve("data:application/pdf;base64,..."); // Mock PDF data URL
        }, 1000);
    });
}

/**
 * Dummy function to reset the form (replace with actual implementation)
 */
function resetForm() {
    document.getElementById('quotationContent').reset();
}

// Function to fetch table data
function getTableData(tableId) {
    const table = document.getElementById(tableId);
    const rows = table.querySelectorAll('tbody tr');
    const tableData = [];

    rows.forEach(row => {
        const rowData = {};
        row.querySelectorAll('input').forEach(input => {
            rowData[input.name] = input.value;
        });
        tableData.push(rowData);
    });

    return tableData;
}
function generateAndSavePDF() {
    return new Promise((resolve, reject) => {
        const bodyElements = document.body.children;
        const quotationContent = document.getElementById("quotationContent");
        const originalDisplay = quotationContent.style.display;

        let opt = {
            margin: [0, 0, 0, 0],
            filename: 'quotation.pdf',
            image: { type: 'jpeg', quality: 0.98 },
            html2canvas: { scale: 2 },
            jsPDF: { unit: 'in', format: 'a4', orientation: 'portrait' }
        };

        // Hide all elements except the quotation content
        for (let i = 0; i < bodyElements.length; i++) {
            if (bodyElements[i] !== quotationContent) {
                bodyElements[i].style.visibility = "hidden";
            }
        }

        // Hide buttons within quotation content to avoid including them in PDF
        const buttons = quotationContent.getElementsByTagName("button");
        for (let i = 0; i < buttons.length; i++) {
            buttons[i].style.visibility = "hidden";
        }

        // Adjust scaling and add specific classes based on product type
        quotationContent.style.width = "1920px";
        quotationContent.style.height = "100%";

        const productType = document.getElementById("productType").value;

        if (productType === "round") {
            quotationContent.classList.add("scale-round");
            opt.margin = [-10, 0, 0, 0];
            opt.html2canvas.scale = 2.2;
        } else if (productType === "rib") {
            quotationContent.classList.add("scale-rib");
            opt.margin = [-14, 0, 0, 0];
            opt.html2canvas.scale = 2;
        } else if (productType === "manual") {
            quotationContent.classList.add("scale-manual");
            opt.margin = [-12, 0, 0, 0];
            opt.html2canvas.scale = 1.8;
        } else {
            quotationContent.style.transform = "scale(0.36)";
            quotationContent.style.transformOrigin = "top left";
            opt.margin = [0, 0, 0, 0];
            opt.html2canvas.scale = 2;
        }

        // Generate PDF and convert to base64
        html2pdf()
            .set(opt)
            .from(quotationContent)
            .output('blob')
            .then((pdfBlob) => {
                const reader = new FileReader();
                reader.readAsDataURL(pdfBlob);
                reader.onloadend = () => {
                    resolve(reader.result); // Resolve promise with base64 PDF data
                };
            })
            .catch(err => {
                reject(err); // Reject promise if there's an error
            })
            .finally(() => {
                // Restore visibility for all elements
                for (let i = 0; i < bodyElements.length; i++) {
                    if (bodyElements[i] !== quotationContent) {
                        bodyElements[i].style.visibility = "";
                    }
                }

                for (let i = 0; i < buttons.length; i++) {
                    buttons[i].style.visibility = "";
                }

                // Reset scaling and styling adjustments
                quotationContent.classList.remove("scale-round", "scale-rib", "scale-manual");
                quotationContent.style.transform = "";
                quotationContent.style.transformOrigin = "";
                quotationContent.style.width = "";
                quotationContent.style.height = "";
                quotationContent.style.display = originalDisplay;
            });
    });
}

// function getTableData(tableId) {
//     const table = document.getElementById(tableId);
//     const rows = table.getElementsByTagName("tbody")[0].getElementsByTagName("tr");
//     let slNo = 1;
//     const data = [];

//     for (let row of rows) {
//         const rowData = {
//             slNo: slNo,
//             description: row.cells[1].getElementsByTagName("input")[0].value,
//             quantity: row.cells[2].getElementsByTagName("input")[0].value,
//             unit: row.cells[3].getElementsByTagName("input")[0].value,
//             rate: row.cells[4].getElementsByTagName("input")[0].value,
//             discount: row.cells[5].getElementsByTagName("input")[0].value,
//             value: row.cells[6].getElementsByTagName("input")[0].value,
//             sgst: row.cells[7].getElementsByTagName("input")[0].value,
//             cgst: row.cells[8].getElementsByTagName("input")[0].value,
//             igst: row.cells[9].getElementsByTagName("input")[0].value,
//             amount: row.cells[10].getElementsByTagName("input")[0].value,
//         };
//         data.push(rowData);
//         slNo++;
//     }

//     return data;
// }

// Add a new row to the product table
function addRow(tableId) {
    const table = document.getElementById(tableId).getElementsByTagName('tbody')[0];
    const row = table.insertRow();
    const slNo = table.rows.length;

    row.innerHTML = `
        <td>${slNo}</td>
        <td><input type="text" placeholder="Description"></td>
        <td><input type="number" placeholder="Quantity" oninput="calculateRowValue(this)"></td>
        <td><input type="text" placeholder="Unit"></td>
        <td><input type="number" placeholder="Rate" min="0" oninput="calculateRowValue(this)"></td>
        <td><input type="text" placeholder="Value" readonly></td>
        <td><button type="button" class="btn btn-danger" onclick="deleteRow(this)"><i class="fa fa-trash" aria-hidden="true"></i></button></td>
    `;
}
// Add a new row to the product table
function addRowWithDropdown(tableId) {
    const table = document.getElementById(tableId).getElementsByTagName('tbody')[0];
    const row = table.insertRow();
    const slNo = table.rows.length;

    row.innerHTML = `
        <td>${slNo}</td>
        <td><input list="conversionCost-options" name="conversionCost" id="conversionCost" placeholder="Select an option" oninput="calculateRowValue(this)"></td>
        <td><input type="number" placeholder="Quantity" oninput="calculateRowValue(this)"></td>
        <td><input type="text" placeholder="Unit"></td>
        <td><input type="number" placeholder="Rate" min="0" oninput="calculateRowValue(this)"></td>
        <td><input type="text" placeholder="Value" readonly></td>
        <td><button type="button" class="btn btn-danger" onclick="deleteRow(this)"><i class="fa fa-trash" aria-hidden="true"></i></button></td>
    `;
}
function addRowRM(tableId) {
    const table = document.getElementById(tableId).getElementsByTagName('tbody')[0];
    const row = table.insertRow();
    const slNo = table.rows.length; // Get the row number

    row.innerHTML = `
        <td>${slNo}</td>
        <td><input type="text" name="RawMaterial" placeholder="Raw Material"></td>
        <td><input type="text" name="MaterialaRate" placeholder="Rate"></td>
        <td><input type="text" name="ScrapRate" placeholder="Scrap Rate"></td>
        <td><input type="text" name="FinishWeight" placeholder="Finish Weight"></td>
        <td> <select name="rawmaterialtype" onchange="updateSizePlaceholders(this)">
                <option value="" disabled selected>Type</option>
                <option value="Rod">Rod</option>
                <option value="Plate">Plate</option>
                <option value="Pipe">Pipe</option>
                <option value="Other">Other</option>
            </select>
        </td>
        <td><input type="number" name="Quantity" placeholder="Quantity" min="0"></td>
        <td><input type="number" name="Size 1" placeholder="Size 1"></td>
        <td><input type="number" name="Size 2" placeholder="Size 2"></td>
        <td><input type="number" name="Size 3" placeholder="Size 3"></td>
        <td><input type="number" name="RM Cost" placeholder="RM Cost"></td>
        <td><input type="text" placeholder="Value" readonly></td>
        <td><button type="button" class="btn btn-danger" onclick="deleteRow(this)"><i class="fa fa-trash" aria-hidden="true"></i></button></td>
    `;
}

// Delete a row from the product table
function deleteRow(button) {
  const row = button.parentNode.parentNode;
  row.parentNode.removeChild(row);
  calculateTotals();
}

// Print the quotation
function printQuotation() {
  const bodyElements = document.body.children;
  const quotationContent = document.getElementById("quotationContent");

  // Hide all elements except the quotation content
  for (let i = 0; i < bodyElements.length; i++) {
      if (bodyElements[i] !== quotationContent) {
          bodyElements[i].style.visibility = "hidden";
      }
  }

  // Hide all buttons inside the quotation content
  const buttons = quotationContent.getElementsByTagName("button");
  for (let i = 0; i < buttons.length; i++) {
      buttons[i].style.visibility = "hidden";
  }

  // Make quotation content and its children visible
  quotationContent.style.visibility = "visible";
  for (let i = 0; i < quotationContent.children.length; i++) {
      quotationContent.children[i].style.visibility = "visible";
  }

  // Print the page with only the quotation content visible
  window.print();

  // Restore visibility of other elements after printing
  for (let i = 0; i < bodyElements.length; i++) {
      if (bodyElements[i] !== quotationContent) {
          bodyElements[i].style.visibility = "";
      }
  }

  // Restore visibility of buttons in the quotation content
  for (let i = 0; i < buttons.length; i++) {
      buttons[i].style.visibility = "";
  }
}
// Save the quotation (basic simulation)

// Quotation auto-generate

// Function to format the current date as dd-mm-yyyy
function formatDate(date) {
  const day = String(date.getDate()).padStart(2, '0');
  const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are zero-based
  const year = date.getFullYear();
  return `${day}-${month}-${year}`;
}
// Calculate the value for a row
function calculateRowValue(input) {
    const row = input.closest("tr");
    const quantity = parseFloat(row.cells[2].querySelector("input").value) || 0;
    const rate = parseFloat(row.cells[4].querySelector("input").value) || 0;

    // Calculate the base value for the row (Quantity * Rate - Discount)
    const baseValue = quantity * rate
    row.cells[5].querySelector("input").value = baseValue.toFixed(2);

    // Update all totals
    calculateTotals();
}
function calculateRowValue1(input) {
    const row = input.closest("tr");
    const quantity = parseFloat(row.cells[6].querySelector("input").value) || 0;
    const rate = parseFloat(row.cells[10].querySelector("input").value) || 0;

    // Calculate the base value for the row (Quantity * Rate - Discount)
    const baseValue = quantity * rate
    row.cells[11].querySelector("input").value = baseValue.toFixed(2);

    // Update all totals
    calculateTotals();
}
// Function to calculate totals (Subtotal, GSTs, and Grand Total)
function calculateTotals() {
    let subTotal = 0;

    // const rows = document.querySelectorAll("#table2 tbody tr") && document.querySelectorAll("#table3 tbody tr");
    const rows = [...document.querySelectorAll("#table2 tbody tr"), ...document.querySelectorAll("#table3 tbody tr")];

    const rowsTable1 = document.querySelectorAll("#table1 tbody tr");

    rows.forEach(row => {
        const baseValue = parseFloat(row.cells[5].querySelector("input").value) || 0;

        // Accumulate totals
        subTotal += baseValue;
    });

    rowsTable1.forEach(rows => {
        const baseValue1 = parseFloat(rows.cells[11].querySelector("input").value) || 0;
        // Accumulate totals
        subTotal += baseValue1;
    });

    let discount = document.getElementById("qt-discount").value;

    // Calculate grand total
    const grandTotalRaw = subTotal  * (1 - discount / 100);
    const roundUpAmount = Math.ceil(grandTotalRaw) - grandTotalRaw; // Round up to the next whole number
    const grandTotal = grandTotalRaw + roundUpAmount;

    // Update the summary fields
    document.getElementById("totalAmount").value = subTotal.toFixed(2);
    document.getElementById("roundUp").value = roundUpAmount.toFixed(2);
    document.getElementById("grandTotal").value = grandTotal.toFixed(2);

    // Update the grand total in words
    updateGrandTotalInWords(grandTotal);
}
// Function to convert numbers to words (Indian numbering format)
function convertNumberToWords(num) {
    const ones = ["", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"];
    const teens = ["", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"];
    const tens = ["", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"];
    const higherUnits = ["", "Thousand", "Lakh", "Crore"];

    if (isNaN(num) || num === 0) return 'Zero';

    let word = '';

    function processHundred(number) {
        let result = '';
        if (number > 99) {
            result += ones[Math.floor(number / 100)] + ' Hundred ';
            number %= 100;
        }
        if (number > 10 && number < 20) {
            result += teens[number - 10] + ' ';
        } else {
            result += tens[Math.floor(number / 10)] + ' ';
            result += ones[number % 10] + ' ';
        }
        return result.trim();
    }

    // Process the number in pairs for Indian format (thousands, lakhs, crores)
    const crorePart = Math.floor(num / 10000000);
    const lakhPart = Math.floor((num % 10000000) / 100000);
    const thousandPart = Math.floor((num % 100000) / 1000);
    const hundredPart = num % 1000;

    if (crorePart > 0) {
        word += processHundred(crorePart) + ' Crore ';
    }
    if (lakhPart > 0) {
        word += processHundred(lakhPart) + ' Lakh ';
    }
    if (thousandPart > 0) {
        word += processHundred(thousandPart) + ' Thousand ';
    }
    if (hundredPart > 0) {
        word += processHundred(hundredPart) ;
    }
    
    // Combine all the parts into the final word string
    word = word.trim() + ' Only';

    return word;
}
// Function to update the 'GT-in-letters' field
function updateGrandTotalInWords() {
  const grandTotal = parseFloat(document.getElementById('grandTotal').value) || 0;
  document.getElementById('GT-in-letters').value = convertNumberToWords(grandTotal);
}

// Update the 'GT-in-letters' field with the grand total in words
function updateGrandTotalInWords(grandTotal) {
    document.getElementById("GT-in-letters").value = convertNumberToWords(Math.round(grandTotal));
}

function pdfQuotation() {
    const bodyElements = document.body.children;
    const quotationContent = document.getElementById("quotationContent");
    const originalDisplay = quotationContent.style.display;

    let opt = {
        margin: [0, 0, 0, 0],  // Default margin, adjust for each type
        filename: 'quotation.pdf',
        image: { type: 'jpeg', quality: 0.98 },
        html2canvas: { scale: 2 },
        jsPDF: { unit: 'in', format: 'a4', orientation: 'portrait' }
    };

    // Hide all elements except the quotation content
    for (let i = 0; i < bodyElements.length; i++) {
        if (bodyElements[i] !== quotationContent) {
            bodyElements[i].style.visibility = "hidden";
        }
    }

    // Hide all buttons inside the quotation content
    const buttons = quotationContent.getElementsByTagName("button");
    for (let i = 0; i < buttons.length; i++) {
        buttons[i].style.visibility = "hidden";
    }

    // Apply scaling and adjust width and height (Customize these values)
    // quotationContent.style.transform = "scale(0.36)";  // Controls overall scale, adjust between 0.7 to 1.0 as needed
    // quotationContent.style.transformOrigin = "45px 40px";  // Origin of scaling, can be "center" or "top right" for adjustment
    // quotationContent.style.transformOrigin = "5% -10%";  // Near top-left

    quotationContent.style.width = "1920px";               // Width of content area; adjust if content is cropped
    quotationContent.style.height = "100%";              // Set height; use "auto" to allow flexible height

    const productType = document.getElementById("productType").value;


    // Adjust settings based on product type
    if (productType === "round") {
        quotationContent.classList.add("scale-round");
        opt.margin = [-10, 0, 0, 0];  // Example margin settings for round
        opt.html2canvas.scale = 2.2;
    } else if (productType === "rib") {
        quotationContent.classList.add("scale-rib");
        opt.margin = [-14, 0, 0, 0];  // Example margin settings for rib
        opt.html2canvas.scale = 2;
    } else if (productType === "manual") {
        quotationContent.classList.add("scale-manual");
        opt.margin = [-12, 0, 0, 0];  // Example margin settings for manual
        opt.html2canvas.scale = 1.8;
    } else {
        // Reset any transformations if no valid selection is made
        quotationContent.style.transform = "scale(1)";
        quotationContent.style.transformOrigin = "top left";
        opt.margin = [0, 0, 0, 0];
        opt.html2canvas.scale = 2;
    }
   

    // Optional: Customize page breaks by adding elements dynamically
    function enforcePageBreaks() {
        const sections = quotationContent.querySelectorAll('.section-to-break'); // Add page breaks to specific sections
        sections.forEach(section => {
            const pageBreak = document.createElement('div');
            pageBreak.style.pageBreakAfter = 'always';
            section.appendChild(pageBreak);
        });
    }
    enforcePageBreaks();  // Enable this function if you want to enforce page breaks at specific points

    // Generate the PDF
    html2pdf()
        .set(opt)
        .from(quotationContent)
        .save()
        .then(() => {
            console.log('PDF generated successfully');
        })
        .catch(err => {
            console.error('Error generating PDF:', err);
        })
        .finally(() => {
            // Restore visibility and scaling
            for (let i = 0; i < bodyElements.length; i++) {
                if (bodyElements[i] !== quotationContent) {
                    bodyElements[i].style.visibility = "";
                }
            }

            for (let i = 0; i < buttons.length; i++) {
                buttons[i].style.visibility = "";
            }

            // Clear all scaling and transformation classes or styles
            quotationContent.classList.remove("scale-round", "scale-rib", "scale-manual");

            // Reset scaling and display
            quotationContent.style.transform = "";
            quotationContent.style.transformOrigin = "";
            quotationContent.style.width = "";
            quotationContent.style.height = "";
            quotationContent.style.display = originalDisplay;
        });
}

function toggleTable(tableNumber) {
    const checkbox = document.getElementById(`checkbox${tableNumber}`);
    const table = document.getElementById(`table${tableNumber}`);
    const addRowBtn = document.getElementById(`add-row-${tableNumber}`);


    if (checkbox.checked) {
        table.classList.remove('hidden');
        addRowBtn.style.display = 'block';
    } else {
        table.classList.add('hidden');
        addRowBtn.style.display = 'none';
    }
}

// Function to add a row dynamically
function addNewRow(rawMaterialName, rowNumber) {
    const tableBody = document.querySelector('#table1 tbody');
    
    // Create a new row
    const newRow = document.createElement('tr');
    
    // Set up the new row's cells with raw material data
    newRow.innerHTML = `
        <td>${rowNumber}</td>
        <td><input type="text" name="RawMaterial" placeholder="Raw Material"  value="${rawMaterialName}"></td>
        <td><input type="text" name="MaterialaRate" placeholder="Rate"></td>
        <td><input type="text" name="ScrapRate" placeholder="Scrap Rate"></td>
        <td><input type="text" name="FinishWeight" placeholder="Finish Weight"></td>
        <td> <select name="rawmaterialtype" onchange="updateSizePlaceholders(this)">
                <option value="" disabled selected>Type</option>
                <option value="Rod">Rod</option>
                <option value="Plate">Plate</option>
                <option value="Pipe">Pipe</option>
                <option value="Other">Other</option>
            </select>
        </td>
        <td><input type="number" name="Quantity" placeholder="Quantity" min="0"></td>
        <td><input type="number" name="Size 1" placeholder="Size 1"></td>
        <td><input type="number" name="Size 2" placeholder="Size 2"></td>
        <td><input type="number" name="Size 3" placeholder="Size 3"></td>
        <td><input type="number" name="RM Cost" placeholder="RM Cost"></td>
        <td><input type="text" placeholder="Value" readonly></td>
        <td><button type="button" class="btn btn-danger" onclick="deleteRow(this)"><i class="fa fa-trash" aria-hidden="true"></i></button></td>
    `;
    // Append the new row to the table
    tableBody.appendChild(newRow);
}

function getTable3DataIfChecked(checkboxId, tableId) {
    const checkbox = document.getElementById(checkboxId);
    if (!checkbox.checked) {
        return []; // Return an empty array if the checkbox is not checked
    }

    const tableRows = document.querySelectorAll(`#${tableId} tbody tr`);
    const tableData = [];

    tableRows.forEach((row, index) => {
        const cells = row.querySelectorAll("input");
        tableData.push({
            slNo: index + 1, // Automatically generate the serial number
            description: cells[0]?.value.trim() || "",
            quantity: parseFloat(cells[1]?.value) || 0,
            unit: cells[2]?.value.trim() || "",
            rate: parseFloat(cells[3]?.value) || 0,
            value: parseFloat(cells[4]?.value) || 0,
        });
    });

    return tableData;
}

function getTable2DataIfChecked(checkboxId, tableId) {
    const checkbox = document.getElementById(checkboxId);
    if (!checkbox.checked) {
        return []; // Return an empty array if the checkbox is not checked
    }

    const tableRows = document.querySelectorAll(`#${tableId} tbody tr`);
    const tableData = [];

    tableRows.forEach((row, index) => {
        const descriptionDropdown = row.querySelector("select[name='rawmaterial']");
        const cells = row.querySelectorAll("input");

        tableData.push({
            slNo: index + 1,
            description: cells[0]?.value.trim() || "",
            quantity: parseFloat(cells[1]?.value) || 0,
            unit: cells[2]?.value.trim() || "",
            rate: parseFloat(cells[3]?.value) || 0,
            value: parseFloat(cells[4]?.value) || 0,
        });
    });

    return tableData;
}

function getTable1DataIfChecked(checkboxId, tableId) {
    const checkbox = document.getElementById(checkboxId);
    if (!checkbox.checked) {
        return []; // Return an empty array if the checkbox is not checked
    }

    const tableRows = document.querySelectorAll(`#${tableId} tbody tr`);
    const tableData = [];

    tableRows.forEach((row, index) => {
        const cells = row.querySelectorAll("input");
        const select = row.querySelector("select");
        
        // Extract data from input fields and select dropdown
        tableData.push({
            slNo: index + 1, // Automatically generate the serial number
            rawMaterial: cells[0]?.value.trim() || "",
            materialRate: parseFloat(cells[1]?.value) || 0,
            scrapRate: parseFloat(cells[2]?.value) || 0,
            finishWeight: parseFloat(cells[3]?.value) || 0,
            rmType: select?.value || "", // Value of the raw material type select dropdown
            quantity: parseFloat(cells[4]?.value) || 0,
            size1: parseFloat(cells[5]?.value) || 0,
            size2: parseFloat(cells[6]?.value) || 0,
            size3: parseFloat(cells[7]?.value) || 0,
            rmCost: parseFloat(cells[8]?.value) || 0,
            value: parseFloat(cells[9]?.value) || 0,
        });
    });

    return tableData;
}

// Function to populate product tables
function populateTable3(tableId, products) {
    const tableBody = document.querySelector(`#${tableId} tbody`);
    document.getElementById('add-row-3').style.display = 'block'
    tableBody.innerHTML = ''; // Clear existing rows

    products.forEach((product, index) => {
        const row = tableBody.insertRow();
        row.innerHTML = `
            <td>${index + 1}</td>
            <td><input type="text" name="description" value="${product.description}" placeholder="Description"></td>
            <td><input type="number" name="quantity" value="${product.quantity}" placeholder="Quantity" oninput="calculateRowValue(this)"></td>
            <td><input type="text" name="unit" value="${product.unit}" placeholder="Unit"></td>
            <td><input type="number" name="rate" value="${product.rate}" placeholder="Rate" oninput="calculateRowValue(this)"></td>
            <td><input type="text" name="value" value="${product.value}" placeholder="Value" readonly></td>
            <td><button class="btn btn-danger" onclick="deleteRow(this)"><i class="fa fa-trash" aria-hidden="true"></i></button></td>
        `;
    });
}

function populateTable2(tableId, tableData) {
    const tableBody = document.querySelector(`#${tableId} tbody`);
    document.getElementById('add-row-2').style.display = 'block'
    tableBody.innerHTML = ''; // Clear existing rows

    if (!tableData || tableData.length === 0) {
        return; // Do nothing if there's no data to populate
    }

    tableData.forEach((rowData, index) => {
        const row = tableBody.insertRow();
        row.innerHTML = `
            <td>${index + 1}</td>
            <td><input list="conversionCost-options" name="conversionCost" id="conversionCost" value="${rowData.description}" placeholder="Select an option"></td>
            <td><input type="number" value="${rowData.quantity}" placeholder="Quantity" oninput="calculateRowValue(this)"></td>
            <td><input type="text" value="${rowData.unit}" placeholder="Unit"></td>
            <td><input type="number" value="${rowData.rate}" placeholder="Rate" min="0" oninput="calculateRowValue(this)"></td>
            <td><input type="text" value="${rowData.value}" placeholder="Value" readonly></td>
            <td><button type="button" class="btn btn-danger" onclick="deleteRow(this)"><i class="fa fa-trash" aria-hidden="true"></i></button></td>
        `;
    });
}

function populateTable1(tableId, products) {
    const tableBody = document.querySelector(`#${tableId} tbody`);
    document.getElementById('add-row-1').style.display = 'block'
    tableBody.innerHTML = ''; // Clear existing rows

    products.forEach((product, index) => {
        const row = tableBody.insertRow();
        row.innerHTML = `
            <td>${index + 1}</td>
            <td><input type="text" name="RawMaterial" value="${product.rawMaterial}" placeholder="Raw Material"></td>
            <td><input type="number" name="MaterialaRate" value="${product.materialRate}" placeholder="Rate"></td>
            <td><input type="number" name="ScrapRate" value="${product.scrapRate}" placeholder="Scrap Rate"></td>
            <td><input type="number" name="FinishWeight" value="${product.finishWeight}" placeholder="Finish Weight"></td>
            <td>
                <select name="rawmaterialtype" value="${product.rmType}" onchange="updateSizePlaceholders(this)">
                    <option value="Rod" ${product.rmType === "Rod" ? "selected" : ""}>Rod</option>
                    <option value="Plate" ${product.rmType === "Plate" ? "selected" : ""}>Plate</option>
                    <option value="Pipe" ${product.rmType === "Pipe" ? "selected" : ""}>Pipe</option>
                    <option value="Other" ${product.rmType === "Other" ? "selected" : ""}>Other</option>
                </select>
            </td>
            <td><input type="number" name="Quantity" value="${product.quantity}" placeholder="Quantity" min="0"></td>
            <td><input type="number" name="Size 1" value="${product.size1}" placeholder="Size 1"></td>
            <td><input type="number" name="Size 2" value="${product.size2}" placeholder="Size 2"></td>
            <td><input type="number" name="Size 3" value="${product.size3}" placeholder="Size 3"></td>
            <td><input type="number" name="RM Cost" value="${product.rmCost}" placeholder="RM Cost"></td>
            <td><input type="text" name="Value" value="${product.value}" placeholder="Value" readonly></td>
            <td><button class="btn btn-danger" onclick="deleteRow(this)"><i class="fa fa-trash" aria-hidden="true"></i></button></td>
        `;
    });
}
//-------------------------------------------------------------------------
function updateSizePlaceholders(selectElement) {
    const selectedType = selectElement.value;
    
    // Get the row where the dropdown is located
    const row = selectElement.closest('tr');

    // Get the input elements for Size 1, Size 2, and Size 3
    const size1Input = row.querySelector('[name="Size 1"]');
    const size2Input = row.querySelector('[name="Size 2"]');
    const size3Input = row.querySelector('[name="Size 3"]');
    const RMCost = row.querySelector('[name="RM Cost"]');

    // Set the placeholder based on the selected type
    if (selectedType === 'Rod') {
        size1Input.placeholder = 'Rod Diameter';
        size2Input.placeholder = 'Rod Length';
        size3Input.placeholder = '';
        size1Input.readOnly = false;
        size2Input.readOnly = false;
        size3Input.readOnly = true;
        RMCost.readOnly = true;
        size1Input.value = '';
        size2Input.value = '';
        size3Input.value = '';
        RMCost.value = '';
    } else if (selectedType === 'Plate') {
        size1Input.placeholder = 'Plate Thickness';
        size2Input.placeholder = 'Plate Length';
        size3Input.placeholder = 'Plate Width';
        size1Input.readOnly = false;
        size2Input.readOnly = false;
        size3Input.readOnly = false;
        RMCost.readOnly = true;
        size1Input.value = '';
        size2Input.value = '';
        size3Input.value = '';
        RMCost.value = '';
    } else if (selectedType === 'Pipe') {
        size1Input.placeholder = 'Outer Diameter';
        size2Input.placeholder = 'Inner Diameter';
        size3Input.placeholder = 'Pipe Length';
        size1Input.readOnly = false;
        size2Input.readOnly = false;
        size3Input.readOnly = false;
        RMCost.readOnly = true;
        size1Input.value = '';
        size2Input.value = '';
        size3Input.value = '';
        RMCost.value = '';
    } else {
        size1Input.placeholder = 'Size 1';
        size2Input.placeholder = 'Size 2';
        size3Input.placeholder = 'Size 3';
        size1Input.readOnly = true;
        size2Input.readOnly = true;
        size3Input.readOnly = true;
        RMCost.readOnly = false;
        size1Input.value = '';
        size2Input.value = '';
        size3Input.value = '';
        RMCost.value = '';
    }    
}

async function calculateRMCost(row) {
    const rawMaterial = row.querySelector('[name="RawMaterial"]').value.trim();
    const material1 = rawMaterial.split('-')[1]?.trim();
    const rmRate = parseFloat(row.querySelector('[name="MaterialaRate"]').value) || 0;
    const scrapRate = parseFloat(row.querySelector('[name="ScrapRate"]').value) || 0;
    const finishWeight = parseFloat(row.querySelector('[name="FinishWeight"]').value) || 0;
    const size1 = (parseFloat(row.querySelector('[name="Size 1"]').value) || 0) * 0.001;
    const size2 = (parseFloat(row.querySelector('[name="Size 2"]').value) || 0) * 0.001;
    const size3 = (parseFloat(row.querySelector('[name="Size 3"]').value) || 0) * 0.001;
    const rawMaterialType = row.querySelector('[name="rawmaterialtype"]').value;
    const rmCostField = row.querySelector('[name="RM Cost"]');

    // Retrieve density from local storage
    // const rawMaterials = JSON.parse(localStorage.getItem('rawMaterials')) || [];

    const response = await fetch('/api/v1/raw-materials/');
    if (!response.ok) {
        throw new Error(`Failed to fetch quotations: ${response.statusText}`);
    }
    const rawMaterials = await response.json();
    const material = rawMaterials.find(mat => mat.name === material1);
    const density = material ? parseFloat(material.rmDensity) : 0;

    let scrapWeight = 0;
    let rmCost = 0;
    let rmWeight = 0;

    // Calculate RM Weight based on material type
    if (rawMaterialType === "Rod") {
        rmWeight = 3.142 * Math.pow(size1 / 2, 2) * size2 * density; // Volume * Density

        // Calculate Scrap Weight
        scrapWeight = rmWeight - finishWeight;

        // Calculate RM Cost in INR/Kg
        if (rmWeight > 0) {
            const totalCost = (rmWeight * rmRate) - (0.8 * (scrapWeight * scrapRate));
            rmCost = totalCost; // Convert to INR/kg
        }
        console.log(rmCost);
        // Update the RM Cost field
        rmCostField.value = isNaN(rmCost) ? "0.00" : rmCost.toFixed(2);

    } else if (rawMaterialType === "Plate") {
        rmWeight = size1 * size2 * size3 * density; // Volume * Density
        // Calculate Scrap Weight
        scrapWeight = rmWeight - finishWeight;

        // Calculate RM Cost in INR/Kg
        if (rmWeight > 0) {
            const totalCost = (rmWeight * rmRate) - (0.8 * (scrapWeight * scrapRate));
            rmCost = totalCost; // Convert to INR/kg
        }

        // Update the RM Cost field
        rmCostField.value = isNaN(rmCost) ? "0.00" : rmCost.toFixed(2);
        
    } else if (rawMaterialType === "Pipe") {
        rmWeight = (3.142 * Math.pow(size1 / 2, 2) * size3 - 
                    3.142 * Math.pow(size2 / 2, 2) * size3) * density; // (Outer Volume - Inner Volume) * Density

        // Calculate Scrap Weight
        scrapWeight = rmWeight - finishWeight;

        // Calculate RM Cost in INR/Kg
        if (rmWeight > 0) {
            const totalCost = (rmWeight * rmRate) - (0.8 * (scrapWeight * scrapRate));
            rmCost = totalCost; // Convert to INR/kg
        }

        // Update the RM Cost field
        rmCostField.value = isNaN(rmCost) ? "0.00" : rmCost.toFixed(2);
    }

    
}

// Add event listeners to the table rows
document.querySelectorAll('.RMtable tbody tr').forEach(row => {
    const inputs = row.querySelectorAll('input, select');

    // Attach input event listeners to all relevant fields
    inputs.forEach(input => {
        input.addEventListener('input', () => calculateRMCost(row));
        input.addEventListener('input', () =>  calculateRowValue1(row));
    });
});

