/**
 * ----------------------------- script for edit button-------------------------------------------------------------------
 */
// Use event delegation for the edit buttons
document.getElementById('dataTable').addEventListener('click', function(event) {
    if (event.target && event.target.classList.contains('edit-btn')) {
        const row = event.target.closest('tr');
        const machineId = row.cells[0].innerText; // Assuming first cell has the Machine ID

        // Store the Machine ID in session storage
        sessionStorage.setItem('currentMachineId', machineId);

        // Redirect to the form page for editing details
        window.location.href = 'add-machine.html';
    }
});

/**
 * ----------------------------- script for import details-------------------------------------------------------------------
 */


// Trigger the modal when the Import button is clicked
document.getElementById('import-button').addEventListener('click', function() {
    $('#importModal').modal('show');
});

// Handle the Excel file import
document.getElementById('importDataBtn').addEventListener('click', async function () {
    let fileInput = document.getElementById('excelFile');
    let file = fileInput.files[0]; // Get the uploaded file

    if (!file) {
        alert("Please select a file first.");
        return;
    }

    let reader = new FileReader();

    reader.onload = async function (e) {
        try {
            let data = e.target.result;
            let workbook = XLSX.read(data, { type: 'binary' });

            let sheetName = workbook.SheetNames[0];
            let sheet = workbook.Sheets[sheetName];

            let excelData = XLSX.utils.sheet_to_json(sheet);

            for (const row of excelData) {
                let rowData = {
                    machineId: row['Machine ID'] || '',
                    machineName: row['Machine Name'] || '',
                    machineSLNo: row['Machine SL No'] || '',
                    make: row['Make'] || '',
                    modelType: row['Model Type'] || '',
                    diameter: row['Diameter(mm)'] || '',
                    length: row['Length(m)'] || '',
                    weight: row['Weight(kg)'] || '',
                    remarks: row['Remarks'] || '',
                    status: row['Status'] || '',
                };

                try {
                    const response = await fetch('/api/addMachine/', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(rowData)
                    });

                    if (response.ok) {
                        // Close the modal
                        $('#importModal').modal('hide');
                        alert("Machine details imported successfully!");
                    } else {
                        console.error(`Failed to upload:`, rowData, await response.text());
                    }
                } catch (err) {
                    console.error("Fetch error:", err);
                }
            }
        } catch (err) {
            console.error("Error reading Excel file:", err);
        }
    };

    reader.readAsBinaryString(file);
});


// Function to append Excel data to the table
function appendExcelDataToTable(excelData) {
    let table = $('#dataTable').DataTable();

    excelData.forEach(function(rowData) {
        // Append the data to the DataTable
        table.row.add([
            rowData['Machine ID'] || '',
            rowData['Machine Name'] || '',
            rowData['Machine SL No'] || '',
            rowData['Make'] || '',
            rowData['Model Type'] || '',
            rowData['Diameter(mm)'] || '',
            rowData['Length(m) '] || '',
            rowData['Weight(kg)'] || '',
            rowData['Remarks'] || '',
            `<button class="btn btn-danger edit-btn" type="button">Edit</button>`
        ]).draw(false); // Use draw(false) to prevent a full redraw
    });
}



// Load data from localStorage when the page is loaded

/**
 * ----------------------------- script for export-buttons-------------------------------------------------------------------
 */

$(document).ready(function () {

    // Initialize the DataTable
    $('#dataTable').DataTable();

    // let storedData = localStorage.getItem('excelMachineData');
    
    // if (storedData) {
    //     // Parse the JSON data and append it to the table
    //     let excelData = JSON.parse(storedData);
    //     appendExcelDataToTable(excelData);
    // }


    // Retrieve saved Machine from local storage
    const savedData = JSON.parse(localStorage.getItem('MachineData')) || [];
    let table = $('#dataTable').DataTable();

    // Populate table with saved data
    savedData.forEach((item) => {
        // Append the data to the DataTable
        table.row.add([
            item.machineId || '',
            item.machineName || '',
            item.machineSLNo || '',
            item.make || '',
            item.modelType || '',
            item.diameter || '',
            item.length || '',
            item.weight || '',
            item.remarks || '',
            `<button class="btn btn-danger edit-btn">Edit</button>`
        ]).draw(false); // Use draw(false) to prevent a full redraw
    });
    

    // Initialize dropdown behavior
    $('#columnVisibility').on('click', function(event) {
        event.preventDefault(); // Prevent default action
        const $dropdownMenu = $(this).next('.dropdown-menu'); // Target the specific dropdown menu
        $('.dropdown-menu').not($dropdownMenu).hide(); // Hide other dropdowns
        $dropdownMenu.toggle(); // Toggle the associated dropdown menu
    });

    // Close dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.dropdown').length) {
            $('.dropdown-menu').hide(); // Hide all dropdowns
        }
    });

    // Handle column visibility when the checkbox state changes
    $(document).on('change', '.column-toggle', function () {
        updateColumnVisibility();
    });

    // Initial column visibility update
    updateColumnVisibility();

    // Function to copy visible table data
    $("#copy").click(function () {
        const table = document.getElementById("dataTable");
        const rows = table.querySelectorAll("tr");
        let textToCopy = "";

        // Get headers for copying
        const headers = [];
        table.querySelectorAll("thead th").forEach((header) => {
            const headerText = header.innerText.trim();  // Declare headerText here
            if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(header).is(':visible')) {
                headers.push(headerText);
            }
        });
        textToCopy += headers.join("\t") + "\n"; // Add headers

        // Get data from rows
        rows.forEach(row => {
            const cols = row.querySelectorAll("td, th");

            cols.forEach((col) => {
                const headerText = table.querySelectorAll("th")[col.cellIndex].innerText.trim();  // Declare headerText here
                // Exclude unwanted columns and check for visibility
                if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(col).is(':visible')) {
                    textToCopy += col.innerText.trim() + "\t"; // Add a tab between columns
                }
            });
            textToCopy += "\n"; // New line after each row
        });

        navigator.clipboard.writeText(textToCopy.trim());
        alert("Table data copied to clipboard!");
    });

    // Function to export visible table data as CSV
    $("#export-csv").click(function () {
        let csv = [];
        const rows = document.querySelectorAll("#dataTable tr");

        // Get headers for CSV
        const headers = [];
        document.querySelectorAll("#dataTable thead th").forEach((header) => {
            const headerText = header.innerText.trim();
            if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(header).is(':visible')) {
                headers.push(headerText);
            }
        });
        csv.push(headers.join(",")); // Add header row

        // Get data
        rows.forEach(row => {
            const cols = row.querySelectorAll("td, th");
            const csvRow = [];
            cols.forEach((col) => {
                const headerText = document.querySelectorAll("#dataTable th")[col.cellIndex].innerText.trim();
                // Exclude unwanted columns and check for visibility
                if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(col).is(':visible')) {
                    csvRow.push(col.innerText.replace(/,/g, " ")); // Replace commas to avoid issues
                }
            });
            if (csvRow.length > 0) { // Add only if the row has data
                csv.push(csvRow.join(",")); // Join the row values with a comma
            }
        });

        const csvString = csv.join("\n"); // Join rows with a new line
        const blob = new Blob([csvString], { type: "text/csv;charset=utf-8;" });
        const link = document.createElement("a");
        link.href = URL.createObjectURL(blob);
        link.setAttribute("download", "data.csv"); // Set the default filename
        link.click(); // Trigger the download
    });

    // Function to export visible table data as PDF
    $("#export-pdf").click(function () {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF({ orientation: 'landscape' }); // Set orientation to landscape
        const table = document.getElementById("dataTable");
        const headers = [];
        const data = [];

        // Get headers from the table
        const headerCols = table.querySelectorAll("thead th");
        headerCols.forEach((header) => {
            const headerText = header.innerText.trim(); // Declare headerText here
            // Exclude unwanted columns and check for visibility
            if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(header).is(':visible')) {
                headers.push(headerText);
            }
        });

        // Get data from the table rows
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach(row => {
            const rowData = [];
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim(); // Declare headerText here
                // Exclude unwanted columns and check for visibility
                if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(col).is(':visible')) {
                    rowData.push(col.innerText);
                }
            });
            if (rowData.length > 0) { // Add only if the row has data
                data.push(rowData);
            }
        });

        // Generate the PDF using autoTable plugin
        doc.autoTable({
            head: [headers],
            body: data,
            theme: 'grid',
            styles: { fontSize: 10 }
        });

        // Save the PDF
        doc.save('MachineData.pdf');
    });

    // Function to export visible table data as Excel
    $("#export-excel").click(function () {
        const table = document.getElementById("dataTable");
        const wb = XLSX.utils.book_new();
        const ws = XLSX.utils.aoa_to_sheet([]);

        // Get headers from the table, excluding the 'Status' column
        const headerRow = [];
        const headerCells = table.querySelectorAll("thead th");
        headerCells.forEach((headerCell) => {
            const headerText = headerCell.innerText.trim(); // Declare headerText here
            // Exclude unwanted columns and check for visibility
            if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(headerCell).is(':visible')) {
                headerRow.push(headerText); // Include only relevant headers
            }
        });
        XLSX.utils.sheet_add_aoa(ws, [headerRow], { origin: "A1" });

        // Get data from the table rows
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach((row, rowIndex) => {
            const rowData = [];
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim(); // Declare headerText here
                // Exclude unwanted columns and check for visibility
                if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(col).is(':visible')) {
                    rowData.push(col.innerText);
                }
            });
            if (rowData.length > 0) { // Add only if the row has data
                XLSX.utils.sheet_add_aoa(ws, [rowData], { origin: `A${rowIndex + 2}` });
            }
        });

        XLSX.utils.book_append_sheet(wb, ws, "Sheet1");
        XLSX.writeFile(wb, "Machinedata.xlsx"); // Set the default filename
    });

    // Function to print the visible table data
    $("#print").click(function () {
        const table = document.getElementById("dataTable");
        const newWindow = window.open("");
        newWindow.document.write("<html><head><title>Print</title></head><body>");
        newWindow.document.write("<table border='1' style='border-collapse: collapse;'>");

        // Get headers for print
        newWindow.document.write("<tr>");
        table.querySelectorAll("thead th").forEach(header => {
            const headerText = header.innerText.trim();
            // Exclude the 'Status' column and check for visibility
            if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(header).is(':visible')) {
                newWindow.document.write(`<th>${headerText}</th>`);
            }
        });
        newWindow.document.write("</tr>");

        // Get data
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach(row => {
            newWindow.document.write("<tr>");
            const cols = row.querySelectorAll("td");
            cols.forEach((col) => {
                const headerText = table.querySelectorAll("thead th")[col.cellIndex].innerText.trim();

                // Exclude the 'Status' column by comparing header text and check for visibility
                if (headerText !== 'Image' && headerText !== 'Status' && headerText !== 'View PDF' && $(col).is(':visible')) {
                    newWindow.document.write(`<td>${col.innerText}</td>`);
                }
            });
            newWindow.document.write("</tr>");
        });

        newWindow.document.write("</table>");
        newWindow.document.write("</body></html>");
        newWindow.document.close();
        newWindow.print();
    });
    
});


// Function to update column visibility based on checkbox state
function updateColumnVisibility() {
    $(".column-toggle").each(function () {
        const columnIndex = $(this).val();
        const isChecked = $(this).is(":checked");
        const table = $("#dataTable"); // Ensure this ID matches your actual table ID

        // Show or hide the column based on checkbox state
        table.find(`tr`).each(function () {
            $(this).find(`td:eq(${columnIndex}), th:eq(${columnIndex})`).css('display', isChecked ? '' : 'none');
        });
    });
}

// Merge new machine data with existing, avoiding duplicates
function mergeMachineData(existingData, newData) {
    newData.forEach(newMachine => {
        const existingIndex = existingData.findIndex(mc => mc.machineId === newMachine.machineId);
        if (existingIndex !== -1) {
            // Replace existing employee data with the new one
            existingData[existingIndex] = newMachine;
        } else {
            // Add new employee data
            existingData.push(newMachine);
        }
    });
    return existingData;
}
/**
 * ----------------------------- script for -------------------------------------------------------------------
 */

