// Production Chart
        const productionCtx = document.getElementById('productionChart').getContext('2d');
        const productionChart = new Chart(productionCtx, {
            type: 'line',
            data: {
                labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                datasets: [{
                    label: 'Units Produced',
                    data: [1200, 1900, 1700, 2100, 2300, 1500, 1000],
                    backgroundColor: 'rgba(52, 152, 219, 0.2)',
                    borderColor: 'rgba(52, 152, 219, 1)',
                    borderWidth: 2,
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
        
        // Status Chart
        const statusCtx = document.getElementById('statusChart').getContext('2d');
        const statusChart = new Chart(statusCtx, {
            type: 'doughnut',
            data: {
                labels: ['Running', 'Idle', 'Maintenance'],
                datasets: [{
                    data: [18, 3, 3],
                    backgroundColor: [
                        '#2ecc71',
                        '#f39c12',
                        '#e74c3c'
                    ],
                    borderWidth: 0
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                },
                cutout: '70%'
            }
        });
        
        // Simulate real-time data updates
        function updateData() {
            // Update production chart with random data
            const newData = productionChart.data.datasets[0].data.map(value => {
                const change = Math.floor(Math.random() * 200 - 100);
                return Math.max(500, value + change);
            });
            productionChart.data.datasets[0].data = newData;
            productionChart.update();
            
            // Update status chart with random data
            const running = Math.floor(Math.random() * 5) + 16;
            const idle = Math.floor(Math.random() * 3) + 2;
            const maintenance = 24 - running - idle;
            statusChart.data.datasets[0].data = [running, idle, maintenance];
            statusChart.update();
            
            // Update cards with random data
            document.querySelectorAll('.card-value')[0].textContent = '24';
            document.querySelectorAll('.card-value')[1].textContent = running;
            document.querySelectorAll('.card-value')[2].textContent = maintenance;
            document.querySelectorAll('.card-value')[3].textContent = Math.floor(Math.random() * 4);
            
            // Randomly change some operator statuses
            const statuses = ['available', 'busy', 'break'];
            document.querySelectorAll('.operator-status').forEach(el => {
                if (Math.random() > 0.7) {
                    const newStatus = statuses[Math.floor(Math.random() * statuses.length)];
                    el.className = 'operator-status ' + newStatus;
                    el.textContent = newStatus.charAt(0).toUpperCase() + newStatus.slice(1);
                }
            });
        }
        
        // Update data every 5 seconds
        setInterval(updateData, 5000);
        
        // Initial update
        updateData();