sessionStorage.removeItem('username');
sessionStorage.removeItem('loggedUserRole');

const baseURL = '/api/v1/accounts/'; // API endpoint

// Function to toggle password visibility
$(".login-toggle-password").click(function () {
    $(this).toggleClass("fa-eye fa-eye-slash");
    let input = $(this).parent().find("input");
    input.attr("type", input.attr("type") === "password" ? "text" : "password");
});

// Password validation function
function validatePassword(password) {
    const errors = [];

    if (!/[A-Z]/.test(password)) {
        errors.push('At least 1 uppercase letter [A-Z]');
    }
    if (!/[a-z]/.test(password)) {
        errors.push('At least 1 lowercase letter [a-z]');
    }
    if (!/[0-9]/.test(password)) {
        errors.push('At least 1 numeric value [0-9]');
    }
    if (!/[!@#$%^&*(),.?":{}|<>]/.test(password)) {
        errors.push('At least 1 special character [!@#$%^&*(),.?":{}|<>]');
    }
    if (password.length < 6 || password.length > 12) {
        errors.push('Password must contain 6 to 12 characters');
    }

    return errors;
}

// Show and clear error messages
function showError(elementId, message) {
    const errorElement = document.getElementById(elementId);
    errorElement.textContent = message;
    errorElement.style.display = 'block';
}

function clearError(elementId) {
    const errorElement = document.getElementById(elementId);
    errorElement.textContent = '';
    errorElement.style.display = 'none';
}

// Continuous password validation
document.getElementById('password').addEventListener('input', function () {
    const password = this.value.trim();
    clearError('passwordError');
    const passwordErrors = validatePassword(password);

    if (passwordErrors.length > 0) {
        showError('passwordError', passwordErrors[0]);
    } else {
        clearError('passwordError');
    }
});

// Function to authenticate user
async function loginUser(username, password) {
    try {
        const response = await fetch(baseURL);
        const users = await response.json();

        const user = users.find(user => user.username === username && user.password === password);

        if (user) {
            if (user.status === "approved") {
                alert('Login successful!');
                // Store the username in localStorage
                sessionStorage.setItem('username', user.username);
                
                window.location.href = 'customer-details.html';
            } else {
                showError('passwordError', 'Wait for admin approval.');
            }
        } else {
            showError('passwordError', 'Invalid username or password');
        }
    } catch (error) {
        console.error('Error:', error);
        showError('passwordError', 'Server error. Please try again later.');
    }
}

// Handle form submission
document.getElementById('loginLink').addEventListener('click', function (event) {
    event.preventDefault();

    const username = document.getElementById('exampleInputEmail').value.trim();
    const password = document.getElementById('password').value.trim();
    let isValid = true;

    if (!username) {
        showError('passwordError', 'Username is required');
        isValid = false;
    } else {
        clearError('passwordError');
    }

    const passwordErrors = validatePassword(password);
    if (passwordErrors.length > 0) {
        showError('passwordError', passwordErrors.join(', '));
        isValid = false;
    } else {
        clearError('passwordError');
    }

    if (isValid) {
        loginUser(username, password);
    }
});
