// ---------------------forgot-password page validation start------------------

// Updated Email validation function
function validateEmail(email) {
    const errors = [];
    const validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

    // Check if the email matches the regular expression pattern
    if (!email.match(validRegex)) {
        errors.push('Email format is invalid.');
    }

    return errors;
}

// Continuous email validation as the user types
document.getElementById('email').addEventListener('input', function () {
    const email = this.value.trim();
    clearError('emailError'); // Clear previous error message
    const emailErrors = validateEmail(email);

    // Show only the first relevant error message dynamically
    if (emailErrors.length > 0) {
        showError('emailError', emailErrors[0]);
    } else {
        clearError('emailError');
    }
});

// Password validation function
function validatePassword(password) {
    const errors = [];

    if (!/[A-Z]/.test(password)) {
        errors.push('At least 1 uppercase letter [A-Z]');
    }
    if (!/[a-z]/.test(password)) {
        errors.push('At least 1 lowercase letter [a-z]');
    }
    if (!/[0-9]/.test(password)) {
        errors.push('At least 1 numeric value [0-9]');
    }
    if (!/[!@#$%^&*(),.?":{}|<>]/.test(password)) {
        errors.push('At least 1 special character [!@#$%^&*(),.?":{}|<>]');
    }
    if (password.length < 6 || password.length > 12) {
        errors.push('Password must contain 6 to 12 characters');
    }

    return errors;
}
// Show and clear error message functions
function showError(elementId, message) {
    const errorElement = document.getElementById(elementId);
    errorElement.textContent = message;
    errorElement.style.display = 'block';
}

function clearError(elementId) {
    const errorElement = document.getElementById(elementId);
    errorElement.textContent = '';
    errorElement.style.display = 'none';
}
// Continuous password validation as the user types
document.getElementById('password').addEventListener('input', function () {
    const password = this.value.trim();
    clearError('passwordError'); // Clear previous error message
    const passwordErrors = validatePassword(password);

    // Show only the first relevant error message dynamically
    if (passwordErrors.length > 0) {
        showError('passwordError', passwordErrors[0]);
    } else {
        clearError('passwordError');
    }
});

// Confirm password matching function
function validateConfirmPassword(password, confirmPassword) {
    const errors = [];
    if (password !== confirmPassword) {
        errors.push('Passwords do not match');
    }
    return errors;
}
// Continuous validation for password matching as user types
document.getElementById('confirmPassword').addEventListener('input', function () {
    const password = document.getElementById('password').value.trim();
    const confirmPassword = this.value.trim();
    clearError('confirmPasswordError'); // Clear previous error message
    const confirmPasswordErrors = validateConfirmPassword(password, confirmPassword);

    // Show error message if passwords do not match
    if (confirmPasswordErrors.length > 0) {
        showError('confirmPasswordError', confirmPasswordErrors[0]);
    } else {
        clearError('confirmPasswordError');
    }
});

// Function to toggle password visibility
$(".reset-toggle-password").click(function() {
    $(this).toggleClass("fa-eye fa-eye-slash");
    input = $(this).parent().find("input");
    if (input.attr("type") == "password") {
        input.attr("type", "text");
    } else {
        input.attr("type", "password");
    }
});
$(".reset-toggle-confirmPassword").click(function() {
    $(this).toggleClass("fa-eye fa-eye-slash");
    input = $(this).parent().find("input");
    if (input.attr("type") == "password") {
        input.attr("type", "text");
    } else {
        input.attr("type", "password");
    }
});

// Handle form submission
document.getElementById('resetPassword').addEventListener('click', function (event) {
    event.preventDefault(); // Prevent form submission

    const email = document.getElementById('email').value.trim();
    const password = document.getElementById('password').value.trim();
    const confirmPassword = document.getElementById('confirmPassword').value.trim();
    let isValid = true;

    // Validate email on form submission
    const emailErrors = validateEmail(email);
    if (emailErrors.length > 0) {
        showError('emailError', emailErrors.join(', '));
        isValid = false;

    } else {
        clearError('emailError');
        console.log(email)
    }

    // Validate password on form submission
    const passwordErrors = validatePassword(password);
    if (passwordErrors.length > 0) {
        showError('passwordError', passwordErrors.join(', '));
        isValid = false;
    } else {
        clearError('passwordError');
    }

    // Validate confirm password on form submission
    const confirmPasswordErrors = validateConfirmPassword(password, confirmPassword);
    if (confirmPasswordErrors.length > 0) {
        showError('confirmPasswordError', confirmPasswordErrors.join(', '));
        isValid = false;
    } else {
        clearError('confirmPasswordError');
    }

    // If all fields are valid, proceed with form submission
    if (isValid) {
        window.location.href = 'login.html'; // Redirect to login page
    }
});