// window.addEventListener('load',async () => {

//     // localStorage.removeItem('MachineData');

//     // Retrieve the machine data from session storage
//     const editMachineId = sessionStorage.getItem('currentMachineId');

//     // Retrieve machine data from localStorage
//     // const MachineData1 = JSON.parse(localStorage.getItem('MachineData')) || [];
//     const response = await fetch('http://127.0.0.1:8000/addMachine/');
//         if (!response.ok) {
//             throw new Error(`HTTP error! Status: ${response.status}`);
//         }
//         const MachineData1 = await response.json() || [];
//     const currentData = MachineData1.find(machine => machine.id === editMachineId);

//     if (currentData) {
//         // Populate the form fields with the machine data
//         document.getElementById("machineId").value = currentData.machineId;
//         document.getElementById("machineName").value = currentData.machineName;
//         document.getElementById("machineSLNo").value = currentData.machineSLNo;
//         document.getElementById("make").value = currentData.make;
//         document.getElementById("modelType").value = currentData.modelType;
//         document.getElementById("diameter").value = currentData.diameter;
//         document.getElementById("length").value = currentData.length;
//         document.getElementById("weight").value = currentData.weight;
//         document.getElementById("remarks").value = currentData.remarks;

//     }

// });

window.addEventListener('load', async () => {
    try {
        // Retrieve the machine ID stored in sessionStorage
        const editMachineId = Number(sessionStorage.getItem('currentMachineId'));

        // Fetch machine data from API
        const response = await fetch('/api/addMachine/');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const MachineData1 = await response.json() || [];

        // Find the selected machine data
        const currentData = MachineData1.find(machine => machine.id === editMachineId);

        if (currentData) {
            // Populate the form fields with the machine data
            document.getElementById("machineId").value = currentData.machineId;
            document.getElementById("machineName").value = currentData.machineName;
            document.getElementById("machineSLNo").value = currentData.machineSLNo;
            document.getElementById("make").value = currentData.make;
            document.getElementById("modelType").value = currentData.modelType;
            document.getElementById("diameter").value = currentData.diameter;
            document.getElementById("length").value = currentData.length;
            document.getElementById("weight").value = currentData.weight;
            document.getElementById("remarks").value = currentData.remarks;
        } else {
            console.warn("Machine data not found for ID:", editMachineId);
        }

    } catch (error) {
        console.error("Error fetching machine data:", error);
    }
});

document.getElementById('machineForm').addEventListener('submit', async function(event) {
    event.preventDefault(); // Prevent default form submission

    // Gather form data
    const machineData = {
        machineId: document.getElementById('machineId').value,
        machineName: document.getElementById('machineName').value,
        machineSLNo: document.getElementById('machineSLNo').value,
        make: document.getElementById('make').value,
        modelType: document.getElementById('modelType').value,
        diameter: parseFloat(document.getElementById('diameter').value) || 0,
        length: parseFloat(document.getElementById('length').value) || 0,
        weight: parseFloat(document.getElementById('weight').value) || 0,
        remarks: document.getElementById('remarks').value,
    };

    // Retrieve existing data from api or initialize an empty array
    const response = await fetch('/api/addMachine/');
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
    const storedData = await response.json() || [];
    const existing = storedData.find(item => item.machineId === machineData.machineId);

    if (existing) {
        const userConfirmation = confirm(`A data with the ${machineData.machineId}  Machine ID already exists. Do you want to overwrite the data?`);

        if (userConfirmation) {
            if (!existing.id) throw new Error('Existing Machine ID is missing.');
    
            const updateResponse = await fetch(`/api/addMachine/${existing.id}/`, {
                method: 'PUT',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(machineData)
            });
    
            if (!updateResponse.ok) throw new Error(`Failed to update purchase order: ${updateResponse.statusText}`);
            alert(`Machine data has been updated successfully.`);
        } else {
            alert('The data was not saved.');
            return;
        }
    } else {
        const createResponse = await fetch('/api/addMachine/', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(machineData)
        });
    
        if (!createResponse.ok) throw new Error(`Failed to create Machine data: ${createResponse.statusText}`);
        alert('Machine data has been created successfully.');
    }
    sessionStorage.removeItem('currentMachineId');

    event.target.reset(); // Reset the form

    // Redirect to the data table page
    window.location.href = "machine-datatable.html";
});

