<!DOCTYPE html>
<html>
<head>
    <title>Debug Login</title>
    <style>
        body { font-family: Arial; max-width: 600px; margin: 50px auto; padding: 20px; background: #f5f5f5; }
        .box { background: white; padding: 20px; border-radius: 8px; margin: 20px 0; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        input { width: 100%; padding: 12px; margin: 8px 0; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        button { width: 100%; padding: 14px; background: #28a745; color: white; border: none; border-radius: 4px; font-size: 16px; cursor: pointer; }
        button:hover { background: #218838; }
        .error { background: #f8d7da; color: #721c24; padding: 12px; border-radius: 4px; margin: 10px 0; }
        .success { background: #d4edda; color: #155724; padding: 12px; border-radius: 4px; margin: 10px 0; }
        .info { background: #d1ecf1; color: #0c5460; padding: 12px; border-radius: 4px; margin: 10px 0; }
        pre { background: #f8f9fa; padding: 10px; border-radius: 4px; overflow-x: auto; }
    </style>
</head>
<body>
    <h2>🔍 IndusProERP - Debug Login</h2>

    <?php
    require_once __DIR__ . '/../vendor/autoload.php';
    $app = require_once __DIR__ . '/../bootstrap/app.php';
    $kernel = $app->make('Illuminate\Contracts\Http\Kernel');

    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\Facades\Hash;
    use App\Models\User;

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $email = $_POST['email'] ?? '';
        $password = $_POST['password'] ?? '';

        echo '<div class="box">';
        echo '<h3>🔍 Debug Information</h3>';

        // Step 1: Check user exists
        echo '<div class="info"><strong>Step 1: Finding User...</strong></div>';
        $user = User::where('email', $email)->first();

        if (!$user) {
            echo '<div class="error">❌ User not found with email: ' . htmlspecialchars($email) . '</div>';
            echo '<div class="info">💡 Available superadmin emails:<br>';
            $admins = User::where('role', 'superadmin')->get();
            foreach ($admins as $admin) {
                echo '- ' . htmlspecialchars($admin->email) . '<br>';
            }
            echo '</div>';
        } else {
            echo '<div class="success">✅ User Found!</div>';
            echo '<pre>';
            echo 'ID: ' . $user->id . "\n";
            echo 'Name: ' . htmlspecialchars($user->name) . "\n";
            echo 'Email: ' . htmlspecialchars($user->email) . "\n";
            echo 'Role: ' . htmlspecialchars($user->role) . "\n";
            echo 'Email Verified: ' . ($user->email_verified_at ? 'Yes ✅' : 'No ❌') . "\n";
            echo '</pre>';

            // Step 2: Check password
            echo '<div class="info"><strong>Step 2: Checking Password...</strong></div>';
            $passwordMatch = Hash::check($password, $user->password);

            if ($passwordMatch) {
                echo '<div class="success">✅ Password is CORRECT!</div>';
            } else {
                echo '<div class="error">❌ Password is INCORRECT!</div>';
                echo '<div class="info">💡 Try: Admin@123</div>';
            }

            // Step 3: Try Laravel Auth
            if ($passwordMatch) {
                echo '<div class="info"><strong>Step 3: Testing Laravel Auth...</strong></div>';

                try {
                    $request = Request::create('/login', 'POST', [
                        'email' => $email,
                        'password' => $password
                    ]);

                    if (Auth::attempt(['email' => $email, 'password' => $password])) {
                        echo '<div class="success">';
                        echo '<strong>🎉 AUTHENTICATION SUCCESSFUL!</strong><br><br>';
                        echo 'Logged in as: ' . Auth::user()->name . '<br>';
                        echo 'Role: ' . Auth::user()->role . '<br><br>';
                        echo '<strong>✅ Your credentials are 100% correct!</strong><br><br>';
                        echo '❓ <strong>Why login form fails?</strong><br>';
                        echo '→ Browser cache/cookies issue<br>';
                        echo '→ CSRF token mismatch<br>';
                        echo '→ JavaScript interference<br><br>';
                        echo '<strong>🔧 Solution:</strong><br>';
                        echo '1. Clear ALL browser data (Ctrl+Shift+Del)<br>';
                        echo '2. Close browser completely<br>';
                        echo '3. Try again in incognito mode<br>';
                        echo '4. Or use a different browser<br>';
                        echo '</div>';

                        // Create direct login link
                        echo '<div class="info">';
                        echo '<strong>🚀 Direct Login (Bypass):</strong><br>';
                        echo '<a href="force-login.php?email=' . urlencode($email) . '" style="display:inline-block; margin-top:10px; padding:10px 20px; background:#007bff; color:white; text-decoration:none; border-radius:4px;">Force Login & Redirect</a>';
                        echo '</div>';

                        Auth::logout();
                    } else {
                        echo '<div class="error">❌ Auth::attempt() failed (This shouldn\'t happen!)</div>';
                    }
                } catch (\Exception $e) {
                    echo '<div class="error">';
                    echo '❌ Error during authentication:<br>';
                    echo htmlspecialchars($e->getMessage());
                    echo '</div>';
                }
            }
        }
        echo '</div>';
    }
    ?>

    <div class="box">
        <h3>🔐 Test Login Credentials</h3>
        <form method="POST">
            <label><strong>Email:</strong></label>
            <input type="email" name="email" value="superadmin@gmail.com" required>

            <label><strong>Password:</strong></label>
            <input type="password" name="password" value="Admin@123" required>

            <button type="submit">🔍 Debug & Test Login</button>
        </form>
    </div>

    <div class="box">
        <h4>📋 Available Superadmin Accounts:</h4>
        <?php
        $admins = User::where('role', 'superadmin')->get();
        echo '<ul>';
        foreach ($admins as $admin) {
            echo '<li><code>' . htmlspecialchars($admin->email) . '</code> / <code>Admin@123</code></li>';
        }
        echo '</ul>';
        ?>
    </div>
</body>
</html>
