<?php

/**
 * Web Routes
 *
 * Common routes shared across all roles.
 * Role-specific routes are now in separate files:
 * - routes/admin.php
 * - routes/manager.php
 * - routes/superadmin.php
 *
 * These files are loaded via bootstrap/app.php
 */

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

// ============================================
// PUBLIC ROUTES
// ============================================

// Home route - redirect to login
Route::get('/', function () {
    return redirect()->route('login');
});

// Storage link utility (for deployment)
Route::get('/storage-link', function () {
    try {
        Artisan::call('storage:link');
        return 'Storage link created successfully. <br> output: ' . Artisan::output();
    } catch (\Exception $e) {
        return 'Error creating storage link: ' . $e->getMessage();
    }
});

// ============================================
// AUTHENTICATION ROUTES
// ============================================

Route::post('/logout', [AuthenticatedSessionController::class, 'destroy'])
    ->name('logout')
    ->middleware('auth');

// Dashboard route (redirects based on role)
Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

// ============================================
// PROFILE ROUTES
// ============================================

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// ============================================
// INCLUDE OTHER ROUTE FILES
// ============================================

require __DIR__ . '/auth.php';
