<?php

/**
 * SuperAdmin Routes
 *
 * All routes for the SuperAdmin role.
 * These routes are protected by 'auth' and 'role:superadmin' middleware.
 *
 * Note: This file was extracted from web.php during architecture refactoring.
 * SuperAdmin has additional approval/rejection workflows that Admin/Manager don't have.
 */

use App\Http\Controllers\SuperAdmin\SuperAdminDashboardController;
use App\Http\Controllers\SuperAdmin\SuperAdminUserController;
use App\Http\Controllers\Modules\MasterData\CustomerVendorController as SuperAdminCustomerVendorController;
// Unified Sales Controllers (from Modules folder)
use App\Http\Controllers\Modules\Sales\RfqController as SuperAdminRfqController;
use App\Http\Controllers\Modules\Purchase\PurchaseRfqController as SuperAdminPurchaseRFQController;
use App\Http\Controllers\Modules\Sales\SalesOrderController as SuperAdminSalesController;
// Unified Purchase Controllers (from Modules folder)
use App\Http\Controllers\Modules\Purchase\PurchaseOrderController as SuperAdminPurchaseController;
use App\Http\Controllers\Modules\Sales\QuotationController as SuperAdminQuotationController;
use App\Http\Controllers\Modules\Purchase\PurchaseQuotationController as SuperAdminPurchaseQuotationController;
use App\Http\Controllers\Modules\Purchase\GrnController as SuperAdminGRNController;
// Unified Manufacturing Controllers (from Modules folder)
use App\Http\Controllers\Modules\Manufacturing\RouteCardController as SuperAdminRouteCardController;
use App\Http\Controllers\Modules\Manufacturing\ManufacturingPlanningController as SuperAdminManufacturingPlanningController;
use App\Http\Controllers\Modules\Manufacturing\ProjectPlanningController as SuperAdminProjectPlanningController;
use App\Http\Controllers\Modules\Manufacturing\QualityController as SuperAdminQualityController;
use App\Http\Controllers\Modules\Manufacturing\SkuController as SuperAdminSKUController;
use App\Http\Controllers\Modules\Sales\InvoiceController as SuperAdminInvoiceController;
use App\Http\Controllers\Modules\MasterData\MachineController as SuperAdminMachineController;
// Unified Employee Controllers (from Modules folder)
use App\Http\Controllers\Modules\Employee\EmployeeController as SuperAdminEmployeeController;
use App\Http\Controllers\Modules\Manufacturing\ProductionController as SuperAdminProductionController;
// Unified Master Data Controllers (from Modules folder)
use App\Http\Controllers\Modules\MasterData\CompanyTypeController as SuperAdminCompanyTypeController;
use App\Http\Controllers\Modules\MasterData\AccountTypeController as SuperAdminAccountTypeController;
use App\Http\Controllers\Modules\MasterData\RfqTypeController as SuperAdminRfqTypeController;
use App\Http\Controllers\Modules\MasterData\ProductTypeController as SuperAdminProductTypeController;
use App\Http\Controllers\Modules\MasterData\ConversionProcessController as SuperAdminConversionProcessController;
use App\Http\Controllers\Modules\MasterData\ProcessController as SuperAdminProcessController;
use App\Http\Controllers\SuperAdmin\SuperAdminReportController;
use App\Http\Controllers\Modules\Employee\AttendanceController as SuperAdminEmployeeAttendanceController;
use App\Http\Controllers\Modules\Employee\EmployeeDailyReportController as SuperAdminEmployeeDailyReportController;
use App\Http\Controllers\Modules\Inventory\StockItemController as SuperAdminStockItemsController;
use App\Http\Controllers\SuperAdmin\PurchaseManagementController;
use App\Http\Controllers\SuperAdmin\SuperAdminSalesManagementController;
use App\Http\Controllers\Modules\Inventory\RawMaterialController as SuperAdminRawMaterialController;
use App\Http\Controllers\SuperAdmin\ProfileController as SuperAdminProfileController;
use App\Http\Controllers\SuperAdmin\UserActivityController;
// Unified Accounts Controllers (from Modules folder)
use App\Http\Controllers\Modules\Accounts\AccountsPayableController;
use App\Http\Controllers\Modules\Accounts\AccountsReceivableController;
use App\Http\Controllers\Modules\Accounts\FinancialReportsController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'role:superadmin'])->group(function () {

    // ============================================
    // MASTER DATA ROUTES
    // ============================================

    // Company Type routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('companytypes', [SuperAdminCompanyTypeController::class, 'companyTypes'])->name('companytype.index');
        Route::get('companytypes/list', [SuperAdminCompanyTypeController::class, 'list'])->name('companytype.list');
        Route::post('companytypes/store', [SuperAdminCompanyTypeController::class, 'store'])->name('companytype.store');
        Route::post('companytypes/update/{companytype}', [SuperAdminCompanyTypeController::class, 'update'])->name('companytype.update');
        Route::delete('companytypes/delete/{companytype}', [SuperAdminCompanyTypeController::class, 'delete'])->name('companytype.delete');
    });

    // Account Type routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('accounttypes', [SuperAdminAccountTypeController::class, 'index'])->name('accounttype.index');
        Route::get('accounttypes/list', [SuperAdminAccountTypeController::class, 'list'])->name('accounttype.list');
        Route::get('accounttypes/{accounttype}', [SuperAdminAccountTypeController::class, 'show'])->name('accounttype.single');
        Route::post('accounttypes/store', [SuperAdminAccountTypeController::class, 'store'])->name('accounttype.store');
        Route::put('accounttypes/update/{accounttype}', [SuperAdminAccountTypeController::class, 'update'])->name('accounttype.update');
        Route::delete('accounttypes/delete/{accounttype}', [SuperAdminAccountTypeController::class, 'delete'])->name('accounttype.delete');
    });

    // Rfq Type routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('rfqtypes', [SuperAdminRfqTypeController::class, 'index'])->name('rfqtype.index');
        Route::get('rfqtypes/list', [SuperAdminRfqTypeController::class, 'list'])->name('rfqtype.list');
        Route::get('rfqtypes/{rfqtype}', [SuperAdminRfqTypeController::class, 'show'])->name('rfqtype.single');
        Route::post('rfqtypes/store', [SuperAdminRfqTypeController::class, 'store'])->name('rfqtype.store');
        Route::put('rfqtypes/update/{rfqtype}', [SuperAdminRfqTypeController::class, 'update'])->name('rfqtype.update');
        Route::delete('rfqtypes/delete/{rfqtype}', [SuperAdminRfqTypeController::class, 'delete'])->name('rfqtype.delete');
    });

    // Product Type routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('producttypes', [SuperAdminProductTypeController::class, 'index'])->name('producttype.index');
        Route::get('producttypes/list', [SuperAdminProductTypeController::class, 'list'])->name('producttype.list');
        Route::get('producttypes/{producttype}', [SuperAdminProductTypeController::class, 'show'])->name('producttype.single');
        Route::post('producttypes/store', [SuperAdminProductTypeController::class, 'store'])->name('producttype.store');
        Route::put('producttypes/update/{producttype}', [SuperAdminProductTypeController::class, 'update'])->name('producttype.update');
        Route::delete('producttypes/delete/{producttype}', [SuperAdminProductTypeController::class, 'delete'])->name('producttype.delete');
    });

    // Raw Material routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('rawmaterials', [SuperAdminRawMaterialController::class, 'index'])->name('rawmaterial.index');
        Route::get('rawmaterials/list', [SuperAdminRawMaterialController::class, 'list'])->name('rawmaterial.list');
        Route::post('rawmaterials/store', [SuperAdminRawMaterialController::class, 'store'])->name('rawmaterial.store');
        Route::get('rawmaterials/{rawmaterial}', [SuperAdminRawMaterialController::class, 'show'])->name('rawmaterial.single');
        Route::put('rawmaterials/update/{rawmaterial}', [SuperAdminRawMaterialController::class, 'update'])->name('rawmaterial.update');
        Route::delete('rawmaterials/delete/{rawmaterial}', [SuperAdminRawMaterialController::class, 'delete'])->name('rawmaterial.delete');
        Route::delete('/raw-material/{id}/delete-file', [SuperAdminRawMaterialController::class, 'deleteFile'])->name('rawmaterial.deletefile');
    });

    // Conversion Process routes
    Route::prefix('superadmin/conversionprocesses')->group(function () {
        Route::get('/', [SuperAdminConversionProcessController::class, 'index'])->name('superadmin.conversionprocess.index');
        Route::get('/list', [SuperAdminConversionProcessController::class, 'list'])->name('superadmin.conversionprocess.list');
        Route::post('/store', [SuperAdminConversionProcessController::class, 'store'])->name('superadmin.conversionprocess.store');
        Route::get('/{id}', [SuperAdminConversionProcessController::class, 'show'])->name('superadmin.conversionprocesses.single');
        Route::put('/update/{id}', [SuperAdminConversionProcessController::class, 'update'])->name('superadmin.conversionprocesses.update');
        Route::delete('/delete/{id}', [SuperAdminConversionProcessController::class, 'destroy'])->name('superadmin.conversionprocesses.delete');
    });

    // Process routes
    Route::prefix('superadmin/processes')->name('superadmin.process.')->group(function () {
        Route::get('/', [SuperAdminProcessController::class, 'index'])->name('index');
        Route::get('/api', [SuperAdminProcessController::class, 'api'])->name('api');
        Route::post('/store', [SuperAdminProcessController::class, 'store'])->name('store');
        Route::get('/{id}', [SuperAdminProcessController::class, 'show'])->name('show');
        Route::put('/update/{id}', [SuperAdminProcessController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [SuperAdminProcessController::class, 'destroy'])->name('destroy');
    });
    Route::post('superadmin/processes/assign', [SuperAdminProcessController::class, 'assign'])->name('superadmin.process.assign');
    Route::get('superadmin/process/assignments', [SuperAdminProcessController::class, 'assignmentsApi'])->name('superadmin.process.assignmentsApi');
    Route::post('superadmin/machine/assignments', [SuperAdminProcessController::class, 'assignOperators'])->name('superadmin.machine.assignOperators');
    Route::get('/superadmin/process/view-machines-summary', [SuperAdminProcessController::class, 'viewMachinesSummary'])->name('superadmin.process.viewMachinesSummary');
    Route::get('/superadmin/process/view-operators-summary', [SuperAdminProcessController::class, 'viewOperatorsSummary'])->name('superadmin.process.viewOperatorsSummary');
    Route::delete('superadmin/machine/assignments/{id?}', [SuperAdminProcessController::class, 'dismissOperators'])->name('superadmin.machine.dismissAssignment');

    // Stock Items routes
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('stockitems', [SuperAdminStockItemsController::class, 'index'])->name('stockitems.index');
        Route::post('stockitems', [SuperAdminStockItemsController::class, 'store'])->name('stockitems.store');
        Route::put('stockitems/{id}', [SuperAdminStockItemsController::class, 'update'])->name('stockitems.update');
        Route::delete('stockitems/{id}', [SuperAdminStockItemsController::class, 'destroy'])->name('stockitems.destroy');
        Route::post('categories/store', [SuperAdminStockItemsController::class, 'storeCategory'])->name('categories.store');
        Route::post('stockitems/import', [SuperAdminStockItemsController::class, 'importExcel'])->name('stockitems.import');
    });

    // ============================================
    // DASHBOARD ROUTES
    // ============================================
    Route::get('superadmin/dashboard', [SuperAdminDashboardController::class, 'allDashboard'])->name('superadmin.dashboard.dashboard');
    Route::get('superadmin/employeedashboard', [SuperAdminDashboardController::class, 'employeeDashboard'])->name('superadmin.dashboard.empoyeedashboard');
    Route::get('superadmin/machinedashboard', [SuperAdminDashboardController::class, 'machineDashboard'])->name('superadmin.dashboard.machinedashboard');
    Route::get('superadmin/stockdashboard', [SuperAdminDashboardController::class, 'stockDashboard'])->name('superadmin.dashboard.stockdashboard');
    Route::get('superadmin/accountdashboard', [SuperAdminDashboardController::class, 'accountDashboard'])->name('superadmin.dashboard.accountdashboard');
    Route::get('superadmin/manufacturingdashboard', [SuperAdminDashboardController::class, 'manufacturingDashboard'])->name('superadmin.dashboard.manufacturingdashboard');

    // ============================================
    // ACCOUNTS MANAGEMENT ROUTES
    // ============================================
    Route::prefix('superadmin/accounts/payable')->name('superadmin.accounts.payable.')->group(function () {
        Route::get('/', [AccountsPayableController::class, 'index'])->name('index');
        Route::get('/aging', [AccountsPayableController::class, 'agingReport'])->name('aging');
        Route::get('/{id}', [AccountsPayableController::class, 'show'])->name('show');
        Route::post('/{id}/payment', [AccountsPayableController::class, 'recordPayment'])->name('payment');
    });
    Route::prefix('superadmin/accounts/receivable')->name('superadmin.accounts.receivable.')->group(function () {
        Route::get('/', [AccountsReceivableController::class, 'index'])->name('index');
        Route::get('/aging', [AccountsReceivableController::class, 'agingReport'])->name('aging');
        Route::get('/{id}', [AccountsReceivableController::class, 'show'])->name('show');
        Route::post('/{id}/payment', [AccountsReceivableController::class, 'recordPayment'])->name('payment');
    });
    Route::prefix('superadmin/accounts/reports')->name('superadmin.accounts.reports.')->group(function () {
        Route::get('/balance-sheet', [FinancialReportsController::class, 'balanceSheet'])->name('balance-sheet');
        Route::get('/profit-loss', [FinancialReportsController::class, 'profitLoss'])->name('profit-loss');
        Route::get('/cash-flow', [FinancialReportsController::class, 'cashFlow'])->name('cash-flow');
    });

    // ============================================
    // PROFILE ROUTES
    // ============================================
    Route::get('superadmin/profile', [SuperAdminProfileController::class, 'index'])->name('superadmin.profile.index');
    Route::put('superadmin/profile', [SuperAdminProfileController::class, 'updateProfile'])->name('superadmin.profile.update');
    Route::put('superadmin/profile/password', [SuperAdminProfileController::class, 'updatePassword'])->name('superadmin.profile.password');

    // ============================================
    // USER ACTIVITY ROUTES
    // ============================================
    Route::get('superadmin/activity', [UserActivityController::class, 'index'])->name('superadmin.activity.index');
    Route::get('superadmin/activity/list', [UserActivityController::class, 'list'])->name('superadmin.activity.list');
    Route::get('superadmin/activity/export', [UserActivityController::class, 'export'])->name('superadmin.activity.export');
    Route::get('superadmin/activity/{id}', [UserActivityController::class, 'show'])->name('superadmin.activity.show');
    Route::get('superadmin/activity/user/{userId}/timeline', [UserActivityController::class, 'userTimeline'])->name('superadmin.activity.user.timeline');
    Route::post('superadmin/activity/cleanup', [UserActivityController::class, 'cleanup'])->name('superadmin.activity.cleanup');

    // ============================================
    // SKU ROUTES
    // ============================================
    Route::get('superadmin/skuapprovals', [SuperAdminSKUController::class, 'skuApprovals'])->name('superadmin.sku.skuapproval');
    Route::get('superadmin/skumovement', [SuperAdminSKUController::class, 'skuMovement'])->name('superadmin.sku.skumovement');
    Route::get('superadmin/qualitycontrol', [SuperAdminSKUController::class, 'qualityControl'])->name('superadmin.qualitycontrol.qualitycontrol');

    // ============================================
    // USER MANAGEMENT ROUTES
    // ============================================
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('/userdetails', [SuperAdminUserController::class, 'userDetails'])->name('users.userdetails');
        Route::get('/users/list', [SuperAdminUserController::class, 'list'])->name('users.list');
        Route::get('/users/{user}', [SuperAdminUserController::class, 'show'])->name('users.show');
        Route::post('/users/store', [SuperAdminUserController::class, 'store'])->name('users.store');
        Route::post('/users/update/{user}', [SuperAdminUserController::class, 'update'])->name('users.update');
        Route::post('/users/toggle-status/{user}', [SuperAdminUserController::class, 'toggleStatus'])->name('users.toggleStatus');
        Route::delete('/users/delete/{user}', [SuperAdminUserController::class, 'delete'])->name('users.delete');
    });

    // ============================================
    // CUSTOMER/VENDOR ROUTES (Using Unified Controller)
    // ============================================
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('/customers', [SuperAdminCustomerVendorController::class, 'getAllCustomers']);
        Route::get('addcustomer', [SuperAdminCustomerVendorController::class, 'create'])->name('customer.addcustomer');
        Route::post('/customer-vendor/register', [SuperAdminCustomerVendorController::class, 'store'])->name('customer.vendor.store');
        Route::get('customerlist', [SuperAdminCustomerVendorController::class, 'index'])->name('customer.customerlist');
        Route::get('/customers/{customer}', [SuperAdminCustomerVendorController::class, 'show'])->name('customer.show');
        Route::get('/customers/{customer}/edit', [SuperAdminCustomerVendorController::class, 'edit'])->name('customer.edit');
        Route::put('/customers/{customer}', [SuperAdminCustomerVendorController::class, 'update'])->name('customer.update');
        Route::delete('/customers/{customer}', [SuperAdminCustomerVendorController::class, 'destroy'])->name('customer.destroy');
        Route::post('/import-customers', [SuperAdminCustomerVendorController::class, 'import'])->name('customer.import');
    });

    // ============================================
    // SALES RFQ ROUTES (with approval workflows)
    // ============================================
    Route::prefix('superadmin/sales')->group(function () {
        Route::get('rfq', [SuperAdminRfqController::class, 'rfq'])->name('superadmin.salesbom.rfq.rfq');
        Route::post('rfq/store', [SuperAdminRfqController::class, 'store'])->name('superadmin.salesbom.rfq.store');
        Route::get('rfqdetails', [SuperAdminRfqController::class, 'rfqDetails'])->name('superadmin.salesbom.rfq.rfqdetails');
        Route::get('rfq/{id}/view', [SuperAdminRfqController::class, 'view'])->name('superadmin.salesbom.rfq.view');
        Route::get('rfq/{id}/edit', [SuperAdminRfqController::class, 'edit'])->name('superadmin.salesbom.rfq.edit');
        Route::put('rfq/{id}/update', [SuperAdminRfqController::class, 'update'])->name('superadmin.salesbom.rfq.update');
        Route::delete('rfq/{id}', [SuperAdminRfqController::class, 'destroy'])->name('superadmin.salesbom.rfq.destroy');
        Route::get('rfq/generate-id', [SuperAdminRfqController::class, 'generateRfqId'])->name('superadmin.salesbom.rfq.generateId');
        Route::post('rfq/{id}/approve', [SuperAdminRfqController::class, 'approve'])->name('superadmin.salesbom.rfq.approve');
        Route::post('rfq/{id}/reject', [SuperAdminRfqController::class, 'reject'])->name('superadmin.salesbom.rfq.reject');
        Route::delete('rfq/file/{id}', [SuperAdminRfqController::class, 'deleteFile'])->name('superadmin.salesbom.rfq.deletefile');
        Route::get('/raw-materials', [SuperAdminRfqController::class, 'getRawMaterials'])->name('superadmin.salesbom.rawmaterials.list');
        Route::post('/raw-materials', [SuperAdminRfqController::class, 'storeRawMaterial'])->name('superadmin.salesbom.rawmaterials.store');
        Route::get('/rfq/{id}/print', [SuperAdminRfqController::class, 'printRfq'])->name('superadmin.salesbom.rfq.print');
    });

    // ============================================
    // SALES QUOTATION ROUTES
    // ============================================
    Route::prefix('superadmin/sales')->group(function () {
        Route::get('quotationorder', [SuperAdminQuotationController::class, 'quotationPage'])->name('superadmin.salesbom.quotation.quotationorder');
        Route::get('quotationdetails', [SuperAdminQuotationController::class, 'quotationDetails'])->name('superadmin.salesbom.quotation.quotationdetails');
        Route::post('quotations', [SuperAdminQuotationController::class, 'store'])->name('superadmin.salesbom.quotations.store');
        Route::get('quotations/{id}/view', [SuperAdminQuotationController::class, 'view'])->name('superadmin.salesbom.quotation.view');
        Route::get('quotations/{id}/edit', [SuperAdminQuotationController::class, 'edit'])->name('superadmin.salesbom.quotation.edit');
        Route::post('quotations/{id}/update', [SuperAdminQuotationController::class, 'update'])->name('superadmin.salesbom.quotation.update');
        Route::delete('quotations/{id}', [SuperAdminQuotationController::class, 'destroy'])->name('superadmin.salesbom.quotation.delete');
        Route::get('quotations/ajax', [SuperAdminQuotationController::class, 'quotationListAjax'])->name('superadmin.salesbom.quotation.ajax');
        Route::get('quotations/{id}/print', [SuperAdminQuotationController::class, 'print'])->name('superadmin.salesbom.quotation.print');
        Route::post('quotations/{id}/approve', [SuperAdminQuotationController::class, 'approve'])->name('superadmin.salesbom.quotation.approve');
        Route::post('quotations/{id}/reject', [SuperAdminQuotationController::class, 'reject'])->name('superadmin.salesbom.quotation.reject');
    });

    Route::get('superadmin/sales/rfq-details/{id}', [SuperAdminQuotationController::class, 'getRfqDetails']);
    Route::get('superadmin/sales/max-quotation-id', function () {
        $latest = \App\Models\Quotation::select('*')
            ->where('quotation_no', 'LIKE', 'UEPL/S/QT/%')
            ->orderByRaw("CAST(SUBSTRING_INDEX(quotation_no, '/', -1) AS UNSIGNED) DESC")
            ->first();
        if (!$latest || !$latest->quotation_no) {
            $nextNumber = 1;
        } else {
            $parts = explode('/', $latest->quotation_no);
            $nextNumber = isset($parts[3]) ? ((int)$parts[3] + 1) : 1;
        }
        $newQuotationNo = 'UEPL/S/QT/' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return response()->json(['newQuotationNo' => $newQuotationNo]);
    });
    Route::get('superadmin/sales/rfq-details/{rfq_no}', function ($rfq_no) {
        $rfq = \App\Models\Rfq::with('customerInfo')->where('id', $rfq_no)->first();
        if (!$rfq || !$rfq->customerInfo) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'rfq' => $rfq,
            'customer' => [
                'company' => $rfq->customerInfo->company,
                'id' => $rfq->customerInfo->id,
                'address' => $rfq->customerInfo->billing_Address ?: $rfq->customerInfo->shipping_Address,
                'gstno' => $rfq->customerInfo->gstno,
                'email' => $rfq->customerInfo->email,
                'mobile' => $rfq->customerInfo->mobile,
            ],
        ]);
    })->where('rfq_no', '.*');

    // ============================================
    // SALES ORDER ROUTES
    // ============================================
    Route::prefix('superadmin')->group(function () {
        Route::get('generate-so-id', [SuperAdminSalesController::class, 'generateSOId']);
        Route::get('generate-grn-id', [SuperAdminSalesController::class, 'generateGRNId']);
        Route::get('salesorder', [SuperAdminSalesController::class, 'salesPage'])->name('superadmin.sales.salesorder');
        Route::get('salesdetails', [SuperAdminSalesController::class, 'salesDetails'])->name('superadmin.sales.salesdetails');
        Route::post('/sales/order/store', [SuperAdminSalesController::class, 'store'])->name('superadmin.sales.order.store');
        Route::get('/customers', [SuperAdminSalesController::class, 'getCustomers']);
        Route::get('/customer/{id}', [SuperAdminSalesController::class, 'getCustomerById']);
        Route::get('/sales/order/{id}', [SuperAdminSalesController::class, 'show'])->name('superadmin.sales.order.show');
        Route::get('/sales/order/{id}/edit', [SuperAdminSalesController::class, 'edit'])->name('superadmin.sales.order.edit');
        Route::delete('/sales/order/{id}', [SuperAdminSalesController::class, 'destroy'])->name('superadmin.sales.order.delete');
        Route::put('/sales/update/{id}', [SuperAdminSalesController::class, 'update'])->name('superadmin.sales.order.update');
        Route::post('sales/order/{id}/approve', [SuperAdminSalesController::class, 'approve'])->name('superadmin.sales.order.approve');
        Route::post('sales/order/{id}/reject', [SuperAdminSalesController::class, 'reject'])->name('superadmin.sales.order.reject');
    });
    Route::get('superadmin/quotations', [SuperAdminSalesController::class, 'getQuotations']);
    Route::get('superadmin/quotation/{id}', [SuperAdminSalesController::class, 'getQuotationById']);
    Route::get('/superadmin/sales-order/{id}', [SuperAdminSalesController::class, 'getSalesOrderById']);
    Route::get('/superadmin/sales/order/{id}/print', [SuperAdminSalesController::class, 'print'])->name('superadmin.sales.order.print');

    // ============================================
    // PURCHASE ROUTES
    // ============================================
    Route::get('superadmin/purchase', function () {
        return redirect()->route('superadmin.purchase.purchasedetails');
    });

    // Purchase RFQ Routes
    Route::prefix('superadmin/purchase')->group(function () {
        Route::get('rfq', [SuperAdminPurchaseRFQController::class, 'rfq'])->name('superadmin.purchasebom.rfq.rfq');
        Route::post('rfq/store', [SuperAdminPurchaseRFQController::class, 'store'])->name('superadmin.purchasebom.rfq.store');
        Route::get('rfqdetails', [SuperAdminPurchaseRFQController::class, 'rfqDetails'])->name('superadmin.purchasebom.rfq.rfqdetails');
        Route::get('rfq/generate-id', [SuperAdminPurchaseRFQController::class, 'generateRfqId'])->name('superadmin.purchasebom.rfq.generateId');
        Route::delete('rfq/file/{id}', [SuperAdminPurchaseRFQController::class, 'deleteFile'])->name('superadmin.purchasebom.rfq.deletefile');
        Route::get('/raw-materials', [SuperAdminPurchaseRFQController::class, 'getRawMaterials'])->name('superadmin.purchasebom.rawmaterials.list');
        Route::post('/raw-materials', [SuperAdminPurchaseRFQController::class, 'storeRawMaterial'])->name('superadmin.purchasebom.rawmaterials.store');
        Route::get('rfq/{id}/view', [SuperAdminPurchaseRFQController::class, 'view'])->name('superadmin.purchasebom.rfq.view');
        Route::get('rfq/{id}/edit', [SuperAdminPurchaseRFQController::class, 'edit'])->name('superadmin.purchasebom.rfq.edit');
        Route::put('rfq/{id}/update', [SuperAdminPurchaseRFQController::class, 'update'])->name('superadmin.purchasebom.rfq.update');
        Route::delete('rfq/{id}', [SuperAdminPurchaseRFQController::class, 'destroy'])->name('superadmin.purchasebom.rfq.destroy');
        Route::post('rfq/{id}/approve', [SuperAdminPurchaseRFQController::class, 'approve'])->name('superadmin.purchasebom.rfq.approve');
        Route::post('rfq/{id}/reject', [SuperAdminPurchaseRFQController::class, 'reject'])->name('superadmin.purchasebom.rfq.reject');
        Route::get('rfq/{id}/print', [SuperAdminPurchaseRFQController::class, 'printRfq'])->name('superadmin.purchasebom.rfq.print');
    });

    // Purchase Quotation Routes
    Route::prefix('superadmin/purchase')->group(function () {
        Route::get('quotationorder', [SuperAdminPurchaseQuotationController::class, 'quotationPage'])->name('superadmin.purchasebom.quotation.quotationorder');
        Route::get('quotationdetails', [SuperAdminPurchaseQuotationController::class, 'quotationDetails'])->name('superadmin.purchasebom.quotation.quotationdetails');
        Route::post('quotations', [SuperAdminPurchaseQuotationController::class, 'store'])->name('superadmin.purchasebom.quotations.store');
        Route::get('quotations/{id}/view', [SuperAdminPurchaseQuotationController::class, 'view'])->name('superadmin.purchasebom.quotation.view');
        Route::get('quotations/{id}/edit', [SuperAdminPurchaseQuotationController::class, 'edit'])->name('superadmin.purchasebom.quotation.edit');
        Route::post('quotations/{id}/update', [SuperAdminPurchaseQuotationController::class, 'update'])->name('superadmin.purchasebom.quotation.update');
        Route::delete('quotations/{id}', [SuperAdminPurchaseQuotationController::class, 'destroy'])->name('superadmin.purchasebom.quotation.delete');
        Route::get('quotations/ajax', [SuperAdminPurchaseQuotationController::class, 'quotationListAjax'])->name('superadmin.purchasebom.quotation.ajax');
        Route::get('quotations/{id}/print', [SuperAdminPurchaseQuotationController::class, 'print'])->name('superadmin.purchasebom.quotation.print');
        Route::post('quotations/{id}/approve', [SuperAdminPurchaseQuotationController::class, 'approve'])->name('superadmin.purchasebom.quotation.approve');
        Route::post('quotations/{id}/reject', [SuperAdminPurchaseQuotationController::class, 'reject'])->name('superadmin.purchasebom.quotation.reject');
    });

    // Generate Purchase Quotation ID
    Route::get('superadmin/purchase/max-quotation-id', function () {
        $latest = \App\Models\PurchaseQuotation::select('*')
            ->where('quotation_no', 'LIKE', 'UEPL/P/QT/%')
            ->orderByRaw("CAST(SUBSTRING_INDEX(quotation_no, '/', -1) AS UNSIGNED) DESC")
            ->first();
        if (!$latest || !$latest->quotation_no) {
            $nextNumber = 1;
        } else {
            $parts = explode('/', $latest->quotation_no);
            $nextNumber = isset($parts[3]) ? ((int)$parts[3] + 1) : 1;
        }
        $newQuotationNo = 'UEPL/P/QT/' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return response()->json(['newQuotationNo' => $newQuotationNo]);
    });

    // Purchase Order Routes
    Route::prefix('superadmin')->group(function () {
        Route::get('generate-po-id', [SuperAdminPurchaseController::class, 'generatePOId']);
        Route::get('purchaseorder', [SuperAdminPurchaseController::class, 'purchasePage'])->name('superadmin.purchase.purchaseorder');
        Route::get('purchasedetails', [SuperAdminPurchaseController::class, 'purchaseDetails'])->name('superadmin.purchase.purchasedetails');
        Route::post('/purchase/order/store', [SuperAdminPurchaseController::class, 'store'])->name('superadmin.purchase.order.store');
        Route::get('/purchase/order/{id}', [SuperAdminPurchaseController::class, 'show'])->name('superadmin.purchase.order.show');
        Route::get('/purchase/order/{id}/edit', [SuperAdminPurchaseController::class, 'edit'])->name('superadmin.purchase.order.edit');
        Route::delete('/purchase/order/{id}', [SuperAdminPurchaseController::class, 'destroy'])->name('superadmin.purchase.order.delete');
        Route::put('/purchase/update/{id}', [SuperAdminPurchaseController::class, 'update'])->name('superadmin.purchase.order.update');
        Route::post('/purchase/order/{id}/approve', [SuperAdminPurchaseController::class, 'approve']);
        Route::post('/purchase/order/{id}/reject', [SuperAdminPurchaseController::class, 'reject']);
    });
    Route::get('superadmin/purchase/quotations', [SuperAdminPurchaseController::class, 'getQuotations']);
    Route::get('superadmin/purchase/quotation/{id}', [SuperAdminPurchaseController::class, 'getQuotationById']);
    Route::get('/superadmin/purchase-order/{id}', [SuperAdminPurchaseController::class, 'getPurchaseOrderById']);
    Route::get('/superadmin/purchase/order/{id}/print', [SuperAdminPurchaseController::class, 'print'])->name('superadmin.purchase.order.print');

    // ============================================
    // GRN ROUTES
    // ============================================
    Route::prefix('superadmin')->group(function () {
        Route::get('grnorder', [SuperAdminGRNController::class, 'grnPage'])->name('superadmin.grn.grnorder');
        Route::get('grndetails', [SuperAdminGRNController::class, 'grnDetails'])->name('superadmin.grn.grndetails');
        Route::post('grn/store', [SuperAdminGRNController::class, 'store'])->name('superadmin.grn.store');
        Route::get('grn/edit/{id}', [SuperAdminGRNController::class, 'edit'])->name('superadmin.grn.edit');
        Route::post('grn/update/{id}', [SuperAdminGRNController::class, 'update'])->name('superadmin.grn.update');
        Route::delete('grn/delete/{id}', [SuperAdminGRNController::class, 'destroy'])->name('superadmin.grn.destroy');
        Route::post('grn/import', [SuperAdminGRNController::class, 'import'])->name('superadmin.grn.import');
        Route::get('grn/view/{id}', [SuperAdminGRNController::class, 'show'])->name('superadmin.grn.view');
    });
    Route::get('superadmin/grn/available-orders', [SuperAdminGRNController::class, 'availableOrders']);
    Route::get('superadmin/grn/order-details', [SuperAdminGRNController::class, 'orderDetails']);
    Route::get('superadmin/grn/available-purchase-invoices', [SuperAdminGRNController::class, 'availablePurchaseInvoices'])->name('superadmin.grn.available-purchase-invoices');
    Route::get('superadmin/grn/purchase-invoice-details/{id}', [SuperAdminGRNController::class, 'purchaseInvoiceDetails'])->name('superadmin.grn.purchase-invoice-details');
    Route::get('superadmin/grn/search-stock-items', [SuperAdminGRNController::class, 'searchStockItems'])->name('superadmin.grn.search-stock-items');
    Route::post('superadmin/grn/approve/{id}', [SuperAdminGRNController::class, 'approve'])->name('superadmin.grn.approve');
    Route::post('superadmin/grn/reject/{id}', [SuperAdminGRNController::class, 'reject'])->name('superadmin.grn.reject');
    Route::get('superadmin/grn/download-template', [SuperAdminGRNController::class, 'downloadTemplate'])->name('superadmin.grn.download-template');

    // ============================================
    // ROUTE CARD ROUTES
    // ============================================
    Route::get('/superadmin/routecard/{id}/processes', [SuperAdminManufacturingPlanningController::class, 'rcProcesses']);
    Route::prefix('superadmin')->name('superadmin.routecard.')->group(function () {
        Route::get('routecardorder', [SuperAdminRouteCardController::class, 'routeCardPage'])->name('index');
        Route::get('routecarddetails', [SuperAdminRouteCardController::class, 'routeCardDetails'])->name('details');
        Route::post('routecardorder', [SuperAdminRouteCardController::class, 'store'])->name('store');
        Route::get('routecard/view/{id}', [SuperAdminRouteCardController::class, 'show'])->name('show');
        Route::get('routecard/edit/{id}', [SuperAdminRouteCardController::class, 'edit'])->name('edit');
        Route::put('routecard/update/{id}', [SuperAdminRouteCardController::class, 'update'])->name('update');
        Route::get('routecard/ganttchart/{id}', [SuperAdminRouteCardController::class, 'ganttChart'])->name('ganttchart');
        Route::delete('routecard/{routecard}', [SuperAdminRouteCardController::class, 'destroy'])->name('destroy');
        Route::post('routecard/{id}/approve', [SuperAdminRouteCardController::class, 'approve'])->name('approve');
        Route::post('routecard/process', [SuperAdminRouteCardController::class, 'storeProcess'])->name('process.create');
        Route::put('routecard/process/{id}', [SuperAdminRouteCardController::class, 'updateProcess']);
        Route::delete('routecard/process/{id}', [SuperAdminRouteCardController::class, 'deleteProcess'])->name('process.delete');
    });
    Route::post('superadmin/routecard/plan/{id}', [SuperAdminRouteCardController::class, 'markPlanned']);
    Route::get('superadmin/routecard/planned', [SuperAdminRouteCardController::class, 'plannedList']);
    Route::get('superadmin/routecard/get-process-list', [SuperAdminRouteCardController::class, 'getProcessList'])->name('superadmin.routecard.get-process-list');
    Route::put('superadmin/routecard/process-reschedule/{id}', [SuperAdminRouteCardController::class, 'updateProcessAndReschedule']);

    // ============================================
    // MANUFACTURING PLANNING ROUTES
    // ============================================
    Route::prefix('superadmin/manufacturing')->group(function () {
        Route::get('plans', [SuperAdminManufacturingPlanningController::class, 'index']);
        Route::get('plans/{id}', [SuperAdminManufacturingPlanningController::class, 'show']);
        Route::post('plans', [SuperAdminManufacturingPlanningController::class, 'store']);
        Route::put('plans/{id}', [SuperAdminManufacturingPlanningController::class, 'update']);
        Route::delete('plans/{id}', [SuperAdminManufacturingPlanningController::class, 'destroy']);
        Route::get('external-api', [SuperAdminManufacturingPlanningController::class, 'fetchExternalApi']);
    });
    Route::get('superadmin/manufacturing/planning', function () {
        return view('superadmin.manufacturing.planning');
    })->name('superadmin.manufacturing.planning');

    // ============================================
    // PROJECT PLANNING ROUTES
    // ============================================
    Route::get('/superadmin/projectplanning', [SuperAdminProjectPlanningController::class, 'index'])->name('superadmin.projectplanning.projectplanning');
    Route::post('superadmin/routecard/ready-production/{id}', [SuperAdminRouteCardController::class, 'markReadyProduction']);
    Route::get('/superadmin/manufacturing/plan/{id}', [SuperAdminManufacturingPlanningController::class, 'planPageWithId'])->name('superadmin.manufacturing.plan');
    Route::get('superadmin/routecard/ready-to-production-list', [SuperAdminRouteCardController::class, 'readyToProductionList']);
    Route::post('superadmin/routecard/in-production/{id}', [SuperAdminRouteCardController::class, 'markInProduction']);
    Route::get('/superadmin/ready-to-production', function () {
        return view('superadmin.manufacturing.ready_to_production');
    })->name('superadmin.readytoproduction');

    // ============================================
    // PRODUCTION ROUTES
    // ============================================
    Route::prefix('superadmin/manufacturing/production')->group(function () {
        Route::get('/in-progress', [SuperAdminProductionController::class, 'inProgressList'])->name('superadmin.production.inprogress.list');
        Route::get('/{rcId}', [SuperAdminProductionController::class, 'productionBoard'])->name('superadmin.production.board');
        Route::post('/start-process/{id}', [SuperAdminProductionController::class, 'startProcess']);
        Route::post('/end-process/{id}', [SuperAdminProductionController::class, 'endProcess']);
        Route::post('/approve-qc/{id}', [SuperAdminProductionController::class, 'approveQC']);
        Route::post('/reject-qc/{id}', [SuperAdminProductionController::class, 'rejectQC']);
        Route::post('/log-breakdown', [SuperAdminProductionController::class, 'logMachineBreakdown']);
        Route::post('/consume-material', [SuperAdminProductionController::class, 'consumeMaterial']);
    });

    // Gantt Chart Route
    Route::get('/superadmin/manufacturing/gantt', [SuperAdminManufacturingPlanningController::class, 'ganttPage'])->name('superadmin.manufacturing.gantt');
    Route::get('/superadmin/manufacturing/gantt-data', [SuperAdminManufacturingPlanningController::class, 'ganttData']);

    // ============================================
    // INVOICE ROUTES
    // ============================================
    Route::get('superadmin/invoiceorder', [SuperAdminInvoiceController::class, 'invoicePage'])->name('superadmin.invoice.invoiceorder');
    Route::get('superadmin/invoicedetails', [SuperAdminInvoiceController::class, 'invoiceDetails'])->name('superadmin.invoice.invoicedetails');
    Route::post('superadmin/tax-invoice', [SuperAdminInvoiceController::class, 'store'])->name('superadmin.tax-invoice.store');
    Route::get('superadmin/generate-invoice-id', [SuperAdminInvoiceController::class, 'generateInvoiceIdAjax'])->name('superadmin.invoice.generate');
    Route::get('superadmin/customer-vendor/{id}', function ($id) {
        $company = \App\Models\CustomerVendor::find($id);
        if (!$company) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'company' => [
                'billing_address' => $company->billing_address,
                'shipping_address' => $company->shipping_address,
                'gst' => $company->gstno,
                'email' => $company->email,
                'mobile' => $company->mobile,
            ],
        ]);
    });
    Route::get('/superadmin/invoices/{invoice}/print', [SuperAdminInvoiceController::class, 'print'])->name('superadmin.invoice.print');
    Route::get('/superadmin/invoices/{invoice}/edit', [SuperAdminInvoiceController::class, 'edit'])->name('superadmin.invoice.edit');
    Route::put('/superadmin/invoices/{invoice}', [SuperAdminInvoiceController::class, 'update'])->name('superadmin.invoice.update');
    Route::delete('/superadmin/invoices/{invoice}', [SuperAdminInvoiceController::class, 'destroy'])->name('superadmin.invoice.destroy');
    Route::post('/superadmin/invoices/{invoice}/approve', [SuperAdminInvoiceController::class, 'approve'])->name('superadmin.invoice.approve');
    Route::post('/superadmin/invoices/{invoice}/reject', [SuperAdminInvoiceController::class, 'reject'])->name('superadmin.invoice.reject');
    Route::get('/superadmin/invoices/{invoice}/view', [SuperAdminInvoiceController::class, 'show'])->name('superadmin.invoice.show');

    // ============================================
    // SALES MANAGEMENT ROUTES
    // ============================================
    Route::prefix('superadmin/salesmanagement')->name('superadmin.salesmanagement.')->group(function () {
        Route::get('/', [SuperAdminSalesManagementController::class, 'index'])->name('index');
        Route::get('/payments', [SuperAdminSalesManagementController::class, 'getPayments'])->name('payments');
        Route::get('/payments/unpaid-invoices', [SuperAdminSalesManagementController::class, 'getUnpaidInvoices'])->name('payments.unpaid');
        Route::post('/payments/store', [SuperAdminSalesManagementController::class, 'storePayment'])->name('payments.store');
        Route::get('/payments/{id}', [SuperAdminSalesManagementController::class, 'getPayment'])->name('payments.get');
        Route::put('/payments/{id}', [SuperAdminSalesManagementController::class, 'updatePayment'])->name('payments.update');
        Route::delete('/payments/{id}', [SuperAdminSalesManagementController::class, 'deletePayment'])->name('payments.delete');
        Route::get('/credit-notes', [SuperAdminSalesManagementController::class, 'getCreditNotes'])->name('creditNotes');
        Route::get('/credit-notes/next-number', [SuperAdminSalesManagementController::class, 'getNextCreditNoteNumber'])->name('creditNotes.nextNumber');
        Route::post('/credit-notes/store', [SuperAdminSalesManagementController::class, 'storeCreditNote'])->name('creditNotes.store');
        Route::get('/credit-notes/{id}', [SuperAdminSalesManagementController::class, 'getCreditNote'])->name('creditNotes.get');
        Route::put('/credit-notes/{id}', [SuperAdminSalesManagementController::class, 'updateCreditNote'])->name('creditNotes.update');
        Route::delete('/credit-notes/{id}', [SuperAdminSalesManagementController::class, 'deleteCreditNote'])->name('creditNotes.delete');
        Route::get('/aging-report', [SuperAdminSalesManagementController::class, 'getAgingReport'])->name('agingReport');
        Route::get('/aging-export', [SuperAdminSalesManagementController::class, 'exportAgingReport'])->name('agingExport');
        Route::get('/debit-notes', [SuperAdminSalesManagementController::class, 'getDebitNotes'])->name('debitNotes');
        Route::get('/debit-notes/next-number', [SuperAdminSalesManagementController::class, 'getNextDebitNoteNumber'])->name('debitNotes.nextNumber');
        Route::post('/debit-notes/store', [SuperAdminSalesManagementController::class, 'storeDebitNote'])->name('debitNotes.store');
        Route::get('/debit-notes/{id}', [SuperAdminSalesManagementController::class, 'getDebitNote'])->name('debitNotes.get');
        Route::put('/debit-notes/{id}', [SuperAdminSalesManagementController::class, 'updateDebitNote'])->name('debitNotes.update');
        Route::delete('/debit-notes/{id}', [SuperAdminSalesManagementController::class, 'deleteDebitNote'])->name('debitNotes.delete');
        Route::get('/statement-of-accounts', [SuperAdminSalesManagementController::class, 'getStatementOfAccounts'])->name('statementOfAccounts');
        Route::get('/payments/{id}/receipt', [SuperAdminSalesManagementController::class, 'downloadReceipt'])->name('payments.receipt');
        Route::get('/receipts-data', [SuperAdminSalesManagementController::class, 'getReceipts'])->name('receipts.data');
    });

    // ============================================
    // SKU MANAGEMENT ROUTES
    // ============================================
    Route::prefix('superadmin')->name('superadmin.sku.')->group(function () {
        Route::get('skumaster', [SuperAdminSKUController::class, 'skuMaster'])->name('skumaster');
        Route::get('sku/data', [SuperAdminSKUController::class, 'skuData'])->name('data');
        Route::post('sku', [SuperAdminSKUController::class, 'store'])->name('store');
        Route::get('sku/{id}/edit', [SuperAdminSKUController::class, 'edit'])->name('edit');
        Route::put('sku/{id}', [SuperAdminSKUController::class, 'update'])->name('update');
        Route::delete('sku/{id}', [SuperAdminSKUController::class, 'destroy'])->name('destroy');
    });
    Route::get('superadmin/skuapprovals', [SuperAdminSKUController::class, 'skuApproval'])->name('superadmin.sku.skuapproval');
    Route::get('superadmin/skuapproval/list', [SuperAdminSKUController::class, 'skuApprovalList'])->name('superadmin.sku-approval.list');
    Route::post('superadmin/sku-approval', [SuperAdminSKUController::class, 'skuApprovalStore'])->name('superadmin.sku-approval.store');
    Route::get('superadmin/sku-approval/{id}', [SuperAdminSKUController::class, 'skuApprovalShow'])->name('superadmin.sku-approval.show');
    Route::put('superadmin/sku-approval/{id}', [SuperAdminSKUController::class, 'skuApprovalUpdate'])->name('superadmin.sku-approval.update');
    Route::delete('superadmin/sku-approval/{id}', [SuperAdminSKUController::class, 'skuApprovalDestroy'])->name('superadmin.sku-approval.destroy');
    Route::get('superadmin/skumovement', [SuperAdminSKUController::class, 'skuMovement'])->name('superadmin.sku.skumovement');
    Route::get('superadmin/skumovement/list', [SuperAdminSKUController::class, 'skuMovementList']);
    Route::post('superadmin/skumovement/store', [SuperAdminSKUController::class, 'skuMovementStore']);
    Route::get('superadmin/skumovement/{id}', [SuperAdminSKUController::class, 'skuMovementShow']);
    Route::delete('superadmin/skumovement/{id}', [SuperAdminSKUController::class, 'skuMovementDelete']);

    // ============================================
    // QUALITY CONTROL ROUTES
    // ============================================
    Route::prefix('superadmin/quality')->group(function () {
        Route::get('qc-management', [SuperAdminQualityController::class, 'qcManagement']);
        Route::get('/qualitycontrol/{routeCard}', [SuperAdminQualityController::class, 'qualityControlBoard']);
        Route::get('/qualitycontrol-data/{routeCard}', [SuperAdminQualityController::class, 'qualityControlData']);
        Route::post('/qualitycontrol-status/{id}', [SuperAdminQualityController::class, 'updateQCStatus']);
        Route::post('/qualitycontrol', [SuperAdminQualityController::class, 'store']);
        Route::get('/qualitycontrol/{id}', [SuperAdminQualityController::class, 'show']);
        Route::put('/qualitycontrol/{id}', [SuperAdminQualityController::class, 'update']);
        Route::delete('/qualitycontrol/{id}', [SuperAdminQualityController::class, 'destroy']);
    });

    // ============================================
    // MACHINE ROUTES
    // ============================================
    Route::prefix('superadmin')->name('superadmin.machine.')->group(function () {
        Route::get('addmachine', [SuperAdminMachineController::class, 'addMachine'])->name('addmachine');
        Route::post('storemachine', [SuperAdminMachineController::class, 'storeMachine'])->name('store');
        Route::get('machinedetails', [SuperAdminMachineController::class, 'machineDetails'])->name('machinedetails');
        Route::get('editmachine/{id}', [SuperAdminMachineController::class, 'editMachine'])->name('edit');
        Route::post('updatemachine/{id}', [SuperAdminMachineController::class, 'updateMachine'])->name('update');
        Route::delete('deletemachine/{id}', [SuperAdminMachineController::class, 'deleteMachine'])->name('delete');
        Route::post('importmachines', [SuperAdminMachineController::class, 'importMachines'])->name('import');
    });

    // ============================================
    // EMPLOYEE ROUTES
    // ============================================
    Route::get('superadmin/employeedetails', [SuperAdminEmployeeController::class, 'employeeDetails'])->name('superadmin.employee.employeedetails');
    Route::post('/superadmin/employees', [SuperAdminEmployeeController::class, 'store'])->name('superadmin.employees.store');
    Route::put('/superadmin/employees/{id}', [SuperAdminEmployeeController::class, 'update'])->name('superadmin.employees.update');
    Route::delete('/superadmin/employees/{id}', [SuperAdminEmployeeController::class, 'destroy'])->name('superadmin.employees.delete');
    Route::post('superadmin/importemployees', [SuperAdminEmployeeController::class, 'importEmployees'])->name('superadmin.employee.import');
    Route::delete('/superadmin/employees/{id}/profile-picture', [SuperAdminEmployeeController::class, 'deleteProfilePicture'])->name('superadmin.employees.profilepic.delete');
    Route::get('/superadmin/employees/{id}', [SuperAdminEmployeeController::class, 'show'])->name('employees.show');
    Route::get('/superadmin/employee/{id}/name', [SuperAdminEmployeeController::class, 'getEmployeeById']);
    Route::get('/superadmin/employees/by-department', [SuperAdminEmployeeController::class, 'getEmployeesByDepartment'])->name('superadmin.employees.by-department');
    Route::get('superadmin/employee/{id}/name-dept', [SuperAdminEmployeeController::class, 'getEmployeeNameDept']);

    // NOTE: Legacy payroll routes removed - Now using unified PayrollController
    // See PAYROLL ROUTES section below for new routes
    // NOTE: Legacy salary-details routes removed - Now using unified SalaryStructureController
    // See SALARY STRUCTURE ROUTES section below for new routes
    // NOTE: Legacy employeeleave routes removed - Now using unified LeaveController
    // See LEAVE MANAGEMENT ROUTES section below for new routes

    // ============================================
    // EMPLOYEE ATTENDANCE ROUTES
    // ============================================
    Route::prefix('superadmin')->name('superadmin.')->group(function () {
        Route::get('employeeattendance', [SuperAdminEmployeeAttendanceController::class, 'index'])->name('employee.index');
        Route::post('/attendance/import', [SuperAdminEmployeeAttendanceController::class, 'import'])->name('attendance.import');
        Route::get('/attendance/edit/{id}', [SuperAdminEmployeeAttendanceController::class, 'edit'])->name('attendance.edit');
        Route::post('attendance/store', [SuperAdminEmployeeAttendanceController::class, 'store'])->name('attendance.store');
        Route::post('attendance/update/{id}', [SuperAdminEmployeeAttendanceController::class, 'update'])->name('attendance.update');
        Route::delete('/attendance/delete/{id}', [SuperAdminEmployeeAttendanceController::class, 'destroy'])->name('attendance.delete');
    });
    Route::get('superadmin/attendance-matrix', [SuperAdminEmployeeAttendanceController::class, 'attendanceMatrix'])->name('superadmin.attendance.matrix');

    // ============================================
    // EMPLOYEE DAILY REPORT ROUTES
    // ============================================
    Route::prefix('superadmin/employeedailyreports')->group(function () {
        Route::get('/', [SuperAdminEmployeeDailyReportController::class, 'index'])->name('employee.employeedailyreport');
        Route::post('/store', [SuperAdminEmployeeDailyReportController::class, 'store'])->name('employee.daily.store');
        Route::post('/update/{id}', [SuperAdminEmployeeDailyReportController::class, 'update'])->name('employee.daily.update');
        Route::delete('/delete/{id}', [SuperAdminEmployeeDailyReportController::class, 'destroy'])->name('employee.daily.delete');
        Route::post('/import', [SuperAdminEmployeeDailyReportController::class, 'import'])->name('superadmin.employee.daily.import');
        Route::get('/edit/{id}', [SuperAdminEmployeeDailyReportController::class, 'edit'])->name('employee.daily.edit');
        Route::get('/calendar/{employee_id}/{month}', [SuperAdminEmployeeDailyReportController::class, 'calendar']);
        Route::get('/calendarview', [SuperAdminEmployeeDailyReportController::class, 'calendarView'])->name('employee.daily.calendar');
    });

    // ============================================
    // PURCHASE MANAGEMENT ROUTES
    // ============================================
    Route::prefix('superadmin/purchasemanagement')->group(function () {
        Route::get('/', [PurchaseManagementController::class, 'index'])->name('superadmin.purchase.index');
        Route::get('/create', [PurchaseManagementController::class, 'create'])->name('superadmin.purchase.create');
        Route::post('/', [PurchaseManagementController::class, 'store'])->name('superadmin.purchase.store');
        Route::get('/accounts', [PurchaseManagementController::class, 'accounts'])->name('superadmin.purchase.accounts');
        Route::get('/{purchase}', [PurchaseManagementController::class, 'show'])->name('superadmin.purchase.show');
        Route::get('/{purchase}/edit', [PurchaseManagementController::class, 'edit'])->name('superadmin.purchase.edit');
        Route::post('/{purchase}/update', [PurchaseManagementController::class, 'update'])->name('superadmin.purchase.update');
        Route::delete('/{purchase}', [PurchaseManagementController::class, 'destroy'])->name('superadmin.purchase.destroy');
        Route::get('/purchase/pending-grns', [PurchaseManagementController::class, 'getPendingGRNs'])->name('superadmin.purchase.pendingGRNs');
        Route::get('/purchase/grn/{id}/details', [PurchaseManagementController::class, 'getGRNDetails'])->name('superadmin.purchase.grnDetails');
        Route::get('/purchase/debit-notes/list', [PurchaseManagementController::class, 'getDebitNotes'])->name('superadmin.purchase.debitNotes.list');
        Route::post('/purchase/debit-notes/store', [PurchaseManagementController::class, 'storeDebitNote'])->name('superadmin.purchase.debitNotes.store');
        Route::put('/purchase/debit-notes/{id}', [PurchaseManagementController::class, 'updateDebitNote'])->name('superadmin.purchase.debitNotes.update');
        Route::delete('/purchase/debit-notes/{id}', [PurchaseManagementController::class, 'deleteDebitNote'])->name('superadmin.purchase.debitNotes.delete');
        Route::get('/purchase/debit-notes/next-number', [PurchaseManagementController::class, 'getNextDebitNoteNumber'])->name('superadmin.purchase.debitNotes.nextNumber');
        Route::get('/purchase/debit-notes/{id}', [PurchaseManagementController::class, 'getDebitNote'])->name('superadmin.purchase.debitNotes.show');
        Route::delete('/purchase/{id}/delete-file', [PurchaseManagementController::class, 'deleteFile'])->name('purchase.deletefile');
    });
    Route::get('superadmin/purchasemanage/export', [PurchaseManagementController::class, 'export'])->name('superadmin.purchase.export');
    Route::get('superadmin/creditnotes/next-no', [PurchaseManagementController::class, 'getNextCreditNoteNo']);
    Route::get('superadmin/purchase/next-invoice-no', [PurchaseManagementController::class, 'getNextInvoiceNumber']);
    Route::post('superadmin/creditnotes', [PurchaseManagementController::class, 'creditNoteStore']);
    Route::get('superadmin/purchasemanage/payments', [PurchaseManagementController::class, 'payments'])->name('superadmin.purchase.payments');
    Route::get('superadmin/purchasemanage/{id}', [PurchaseManagementController::class, 'Vendorshow']);
    Route::get('superadmin/creditnotes/data', [PurchaseManagementController::class, 'creditNotesData'])->name('superadmin.creditnotes.data');
    Route::get('superadmin/creditnotes/{id}', [PurchaseManagementController::class, 'showCreditNote']);
    Route::get('superadmin/creditnotes/{id}/edit', [PurchaseManagementController::class, 'getCreditNote'])->name('superadmin.creditnotes.edit');
    Route::put('superadmin/creditnotes/{id}', [PurchaseManagementController::class, 'creditNoteUpdate'])->name('superadmin.creditnotes.update');
    Route::delete('superadmin/creditnotes/{id}', [PurchaseManagementController::class, 'creditNoteDelete'])->name('superadmin.creditnotes.delete');
    Route::get('superadmin/purchasedata/aging-report', [PurchaseManagementController::class, 'agingReport'])->name('superadmin.purchase.aging');
    Route::get('superadmin/purchasedata/aging-report/export', [PurchaseManagementController::class, 'exportAgingReport'])->name('superadmin.purchase.aging.export');

    // ============================================
    // REPORTS ROUTES
    // ============================================
    Route::any('superadmin/employeereport', [SuperAdminReportController::class, 'employeeReport'])->name('superadmin.report.employeereport');
    Route::any('superadmin/customerreport', [SuperAdminReportController::class, 'customerReport'])->name('superadmin.report.customerreport');
    Route::post('superadmin/customerreport/export', [SuperAdminReportController::class, 'exportCustomerReport'])->name('superadmin.report.customerreport.export');
    Route::post('/superadmin/employee-report/export', [SuperAdminReportController::class, 'exportEmployeeReport'])->name('superadmin.exportEmployeeReport');
    Route::any('superadmin/machinereport', [SuperAdminReportController::class, 'machineReport'])->name('superadmin.report.machinereport');
    Route::post('superadmin/machinereport/export', [SuperAdminReportController::class, 'exportMachineReport'])->name('superadmin.report.machinereport.export');
    Route::any('superadmin/billreport', [SuperAdminReportController::class, 'billReport'])->name('superadmin.report.billreport');
    Route::post('superadmin/billreport/export', [SuperAdminReportController::class, 'exportBillReport'])->name('superadmin.report.billreport.export');
    Route::get('superadmin/employeedailyreport', [SuperAdminEmployeeController::class, 'employeeDailyReport'])->name('superadmin.employee.employeedailyreport');
    Route::any('superadmin/inventoryreport', [SuperAdminReportController::class, 'inventoryReport'])->name('superadmin.report.inventoryreport');
    Route::post('superadmin/inventoryreport/export', [SuperAdminReportController::class, 'exportInventoryReport'])->name('superadmin.report.inventoryreport.export');
    Route::get('superadmin/employeecalendar', [SuperAdminEmployeeController::class, 'employeeCalendar'])->name('superadmin.employee.employeecalendar');

    // ============================================
    // SALARY STRUCTURE ROUTES (Unified Controller)
    // ============================================
    Route::post('superadmin/salary-structure/store', [App\Http\Controllers\Modules\Employee\SalaryStructureController::class, 'store'])->name('superadmin.salary-structure.store');
    Route::get('superadmin/salary-structure', [App\Http\Controllers\Modules\Employee\SalaryStructureController::class, 'index'])->name('superadmin.salary-structure.index');
    Route::get('superadmin/salary-structure/get/{employeeId}', [App\Http\Controllers\Modules\Employee\SalaryStructureController::class, 'getStructure']);
    Route::get('superadmin/salary-structure/breakdown/{employeeId}', [App\Http\Controllers\Modules\Employee\SalaryStructureController::class, 'getBreakdown']);
    Route::post('superadmin/salary-structure/deactivate/{id}', [App\Http\Controllers\Modules\Employee\SalaryStructureController::class, 'deactivate'])->name('superadmin.salary-structure.deactivate');
    Route::post('superadmin/salary-structure/import', [App\Http\Controllers\Modules\Employee\SalaryStructureController::class, 'import'])->name('superadmin.salary-structure.import');
    Route::get('superadmin/salary-structure/sample', [App\Http\Controllers\Modules\Employee\SalaryStructureController::class, 'downloadSample'])->name('superadmin.salary-structure.sample');

    // Salary Calculation & Stats API
    Route::get('superadmin/employee/monthly-stats/{employeeId}/{monthYear}', [SuperAdminEmployeeController::class, 'getMonthlyStats']);

    // ============================================
    // HOLIDAY MASTER ROUTES (Unified Controller)
    // ============================================
    Route::get('superadmin/holiday', [App\Http\Controllers\Modules\Employee\HolidayController::class, 'index'])->name('superadmin.holiday.index');
    Route::post('superadmin/holiday', [App\Http\Controllers\Modules\Employee\HolidayController::class, 'store'])->name('superadmin.holiday.store');
    Route::put('superadmin/holiday/{id}', [App\Http\Controllers\Modules\Employee\HolidayController::class, 'update'])->name('superadmin.holiday.update');
    Route::delete('superadmin/holiday/{id}', [App\Http\Controllers\Modules\Employee\HolidayController::class, 'destroy'])->name('superadmin.holiday.destroy');
    Route::post('superadmin/holiday/{id}/toggle', [App\Http\Controllers\Modules\Employee\HolidayController::class, 'toggleStatus'])->name('superadmin.holiday.toggle');
    Route::get('superadmin/holiday/upcoming', [App\Http\Controllers\Modules\Employee\HolidayController::class, 'upcoming'])->name('superadmin.holiday.upcoming');

    // ============================================
    // LEAVE MANAGEMENT ROUTES (Unified Controller)
    // ============================================
    Route::get('superadmin/leave', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'index'])->name('superadmin.leave.index');
    Route::post('superadmin/leave', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'store'])->name('superadmin.leave.store');
    Route::get('superadmin/leave/{id}/edit', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'edit'])->name('superadmin.leave.edit');
    Route::put('superadmin/leave/{id}', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'update'])->name('superadmin.leave.update');
    Route::delete('superadmin/leave/{id}', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'destroy'])->name('superadmin.leave.destroy');
    Route::post('superadmin/leave/{id}/approve', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'approve'])->name('superadmin.leave.approve');
    Route::post('superadmin/leave/{id}/reject', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'reject'])->name('superadmin.leave.reject');
    Route::post('superadmin/leave/{id}/cancel', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'cancel'])->name('superadmin.leave.cancel');
    Route::get('superadmin/leave/balance/{employeeId}', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'getBalance'])->name('superadmin.leave.balance');
    Route::get('superadmin/leave/pending', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'pending'])->name('superadmin.leave.pending');
    Route::get('superadmin/leave-balance', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'balanceIndex'])->name('superadmin.leave-balance.index');
    Route::post('superadmin/leave-balance', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'updateBalance'])->name('superadmin.leave-balance.update');

    // ============================================
    // PAYROLL ROUTES (Unified Controller)
    // ============================================
    Route::get('superadmin/payroll', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'index'])->name('superadmin.payroll.index');
    Route::get('superadmin/payroll/list', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'list'])->name('superadmin.payroll.list');
    Route::post('superadmin/payroll/generate', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'generate'])->name('superadmin.payroll.generate');
    Route::post('superadmin/payroll/bulk-generate', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'bulkGenerate'])->name('superadmin.payroll.bulk-generate');
    Route::get('superadmin/payroll/{id}/edit', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'edit'])->name('superadmin.payroll.edit');
    Route::put('superadmin/payroll/{id}', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'update'])->name('superadmin.payroll.update');
    Route::delete('superadmin/payroll/{id}', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'destroy'])->name('superadmin.payroll.destroy');
    Route::post('superadmin/payroll/{id}/submit', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'submit'])->name('superadmin.payroll.submit');
    Route::post('superadmin/payroll/{id}/approve', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'approve'])->name('superadmin.payroll.approve');
    Route::post('superadmin/payroll/bulk-approve', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'bulkApprove'])->name('superadmin.payroll.bulk-approve');
    Route::post('superadmin/payroll/{id}/mark-paid', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'markPaid'])->name('superadmin.payroll.mark-paid');
    Route::get('superadmin/payroll/{id}/payslip', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'payslip'])->name('superadmin.payroll.payslip');
    Route::get('superadmin/payroll/{id}/print', [App\Http\Controllers\Modules\Employee\PayrollController::class, 'printPayslip'])->name('superadmin.payroll.print');

    // ============================================
    // ADDITIONAL EMPLOYEE ROUTES (Missing routes fix)
    // ============================================
    // Employee Leave page - alias for leave.index
    Route::get('superadmin/employee/employeeleave', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'index'])->name('superadmin.employee.employeeleave');
    Route::get('superadmin/employeeleave', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'index'])->name('superadmin.employeeleave');
    Route::post('superadmin/employeeleave/store', [App\Http\Controllers\Modules\Employee\LeaveController::class, 'store'])->name('superadmin.employeeleave.store');

    // Employee Payroll page - uses unified PayrollController
    Route::get('superadmin/employee/employeepayroll', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'index'])->name('superadmin.employee.employeepayroll');
    Route::get('superadmin/employeepayroll', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'index'])->name('superadmin.employeepayroll');

    // Additional Payroll routes for employeepayroll view
    Route::get('superadmin/payroll/data', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'data'])->name('superadmin.payroll.data');
    Route::post('superadmin/payroll/bulk-reject', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'bulkReject'])->name('superadmin.payroll.bulk-reject');
    Route::post('superadmin/payslip/bulk-download', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'bulkDownload'])->name('superadmin.payslip.bulk-download');

    // GRN searchStockItems
    Route::get('superadmin/grn/search-stock-items', [App\Http\Controllers\Modules\Purchase\GrnController::class, 'searchStockItems'])->name('superadmin.grn.searchStockItems');

    // ============================================
    // SALARY DETAILS URL-BASED ROUTES
    // (Used by employeepayroll views with hardcoded URLs)
    // ============================================
    Route::get('superadmin/salary-details/{id}', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'show']);
    Route::post('superadmin/salary-details/store', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'store']);
    Route::put('superadmin/salary-details/{id}', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'update']);
    Route::delete('superadmin/salary-details/{id}', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'destroy']);
    Route::get('superadmin/salary-details/{id}/payslip', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'payslip']);
    Route::post('superadmin/payroll/{id}/approve', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'approve'])->name('superadmin.salary.approve');
    Route::post('superadmin/payroll/{id}/reject', [App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'reject'])->name('superadmin.salary.reject');
});
