<?php

/**
 * Manager Routes
 *
 * All routes for the Manager role.
 * These routes are protected by 'auth' and 'role:manager' middleware.
 */

use App\Http\Controllers\Manager\ManagerDashboardController;
use App\Http\Controllers\Modules\MasterData\CustomerVendorController as ManagerCustomerVendorController;
// Unified Sales Controllers (from Modules folder)
use App\Http\Controllers\Modules\Sales\RfqController as ManagerRfqController;
use App\Http\Controllers\Modules\Sales\SalesOrderController as ManagerSalesController;
// Unified Purchase Controllers (from Modules folder)
use App\Http\Controllers\Modules\Purchase\PurchaseOrderController as ManagerPurchaseController;
use App\Http\Controllers\Modules\Sales\QuotationController as ManagerQuotationController;
use App\Http\Controllers\Modules\Purchase\GrnController as ManagerGRNController;
// Unified Manufacturing Controllers (from Modules folder)
use App\Http\Controllers\Modules\Manufacturing\RouteCardController as ManagerRouteCardController;
use App\Http\Controllers\Modules\Manufacturing\ManufacturingPlanningController as ManagerManufacturingPlanningController;
use App\Http\Controllers\Modules\Manufacturing\ProjectPlanningController as ManagerProjectPlanningController;
use App\Http\Controllers\Modules\Manufacturing\QualityController as ManagerQualityController;
use App\Http\Controllers\Modules\Manufacturing\SkuController as ManagerSKUController;
use App\Http\Controllers\Modules\Sales\InvoiceController as ManagerInvoiceController;
use App\Http\Controllers\Modules\MasterData\MachineController as ManagerMachineController;
// Unified Employee Controllers (from Modules folder)
use App\Http\Controllers\Modules\Employee\EmployeeController as ManagerEmployeeController;
use App\Http\Controllers\Modules\Manufacturing\ProductionController as ManagerProductionController;
// Note: Master Data controllers removed - Manager role uses Admin/SuperAdmin controllers
// Note: ManagerRawMaterialController removed - raw materials managed via RFQ controller
use App\Http\Controllers\Manager\ManagerReportController;
use App\Http\Controllers\Modules\Employee\AttendanceController as ManagerEmployeeAttendanceController;
use App\Http\Controllers\Modules\Employee\EmployeeDailyReportController as ManagerEmployeeDailyReportController;
use App\Http\Controllers\Modules\Employee\HolidayController as ManagerHolidayController;
use App\Http\Controllers\Modules\Employee\LeaveController as ManagerLeaveController;
use App\Http\Controllers\Modules\Employee\PayrollController as ManagerPayrollController;
use App\Http\Controllers\Modules\Employee\SalaryStructureController as ManagerSalaryStructureController;
use App\Http\Controllers\Manager\ManagerPurchaseManagementController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'role:manager'])->group(function () {

    // ============================================
    // DASHBOARD ROUTES
    // ============================================
    Route::get('manager/dashboard', [ManagerDashboardController::class, 'allDashboard'])->name('manager.dashboard.alldashboard');
    Route::get('manager/employeedashboard', [ManagerDashboardController::class, 'employeeDashboard'])->name('manager.dashboard.empoyeedashboard');
    Route::get('manager/machinedashboard', [ManagerDashboardController::class, 'machineDashboard'])->name('manager.dashboard.machinedashboard');
    Route::get('manager/stockdashboard', [ManagerDashboardController::class, 'stockDashboard'])->name('manager.dashboard.stockdashboard');
    Route::get('manager/accountdashboard', [ManagerDashboardController::class, 'accountDashboard'])->name('manager.dashboard.accountdashboard');
    Route::get('manager/manufacturingdashboard', [ManagerDashboardController::class, 'manufacturingDashboard'])->name('manager.dashboard.manufacturingdashboard');

    // ============================================
    // SKU ROUTES
    // ============================================
    Route::get('manager/skuapprovals', [ManagerSKUController::class, 'skuApprovals'])->name('manager.sku.skuapproval');
    Route::get('manager/skumovement', [ManagerSKUController::class, 'skuMovement'])->name('manager.sku.skumovement');
    Route::get('manager/qualitycontrol', [ManagerSKUController::class, 'qualityControl'])->name('manager.qualitycontrol.qualitycontrol');

    // ============================================
    // CUSTOMER/VENDOR ROUTES (Using Unified Controller)
    // ============================================
    Route::prefix('manager')->name('manager.')->group(function () {
        Route::get('/customers', [ManagerCustomerVendorController::class, 'getAllCustomers']);
        Route::get('addcustomer', [ManagerCustomerVendorController::class, 'create'])->name('customer.addcustomer');
        Route::post('/customer-vendor/register', [ManagerCustomerVendorController::class, 'store'])->name('customer.vendor.store');
        Route::get('customerlist', [ManagerCustomerVendorController::class, 'index'])->name('customer.customerlist');
        Route::get('/customers/{customer}', [ManagerCustomerVendorController::class, 'show'])->name('customer.show');
        Route::get('/customers/{customer}/edit', [ManagerCustomerVendorController::class, 'edit'])->name('customer.edit');
        Route::put('/customers/{customer}', [ManagerCustomerVendorController::class, 'update'])->name('customer.update');
        Route::delete('/customers/{customer}', [ManagerCustomerVendorController::class, 'destroy'])->name('customer.destroy');
        Route::post('/import-customers', [ManagerCustomerVendorController::class, 'import'])->name('customer.import');
    });

    // ============================================
    // RFQ ROUTES
    // ============================================
    Route::prefix('manager')->group(function () {
        Route::get('rfq', [ManagerRfqController::class, 'rfq'])->name('manager.rfq.rfq');
        Route::post('rfq/store', [ManagerRfqController::class, 'store'])->name('manager.rfq.store');
        Route::get('rfqdetails', [ManagerRfqController::class, 'rfqDetails'])->name('manager.rfq.rfqdetails');
        Route::get('rfq/{id}/view', [ManagerRfqController::class, 'view'])->name('manager.rfq.view');
        Route::get('rfq/{id}/edit', [ManagerRfqController::class, 'edit'])->name('manager.rfq.edit');
        Route::put('rfq/{id}/update', [ManagerRfqController::class, 'update'])->name('manager.rfq.update');
        Route::delete('rfq/{id}', [ManagerRfqController::class, 'destroy'])->name('manager.rfq.destroy');
        Route::get('rfq/generate-id', [ManagerRfqController::class, 'generateRfqId'])->name('manager.rfq.generateId');
    });
    Route::get('manager/raw-materials', [ManagerRfqController::class, 'getRawMaterials'])->name('manager.rawmaterials.list');
    Route::post('manager/raw-materials', [ManagerRfqController::class, 'storeRawMaterial'])->name('manager.rawmaterials.store');
    Route::get('manager/rfq/{id}/print', [ManagerRfqController::class, 'printRfq'])->name('manager.rfq.print');

    // ============================================
    // QUOTATION ROUTES
    // ============================================
    Route::prefix('manager')->group(function () {
        Route::get('quotationorder', [ManagerQuotationController::class, 'quotationPage'])->name('manager.quotation.quotationorder');
        Route::get('quotationdetails', [ManagerQuotationController::class, 'quotationDetails'])->name('manager.quotation.quotationdetails');
        Route::post('quotations', [ManagerQuotationController::class, 'store'])->name('manager.quotations.store');
        Route::get('quotations/{id}/view', [ManagerQuotationController::class, 'view'])->name('manager.quotation.view');
        Route::get('quotations/{id}/edit', [ManagerQuotationController::class, 'edit'])->name('manager.quotation.edit');
        Route::post('quotations/{id}/update', [ManagerQuotationController::class, 'update'])->name('manager.quotation.update');
        Route::delete('quotations/{id}', [ManagerQuotationController::class, 'destroy'])->name('manager.quotation.delete');
        Route::get('quotations/ajax', [ManagerQuotationController::class, 'quotationListAjax'])->name('manager.quotation.ajax');
        Route::get('quotations/{id}/print', [ManagerQuotationController::class, 'print'])->name('manager.quotation.print');
    });
    Route::get('manager/rfq-details/{id}', [ManagerQuotationController::class, 'getRfqDetails']);
    Route::get('manager/max-quotation-id', function () {
        $latest = \App\Models\Quotation::orderByDesc('id')->first();
        if (!$latest || !$latest->quotation_no) {
            $nextNumber = 1;
        } else {
            $parts = explode('/', $latest->quotation_no);
            $nextNumber = isset($parts[2]) ? ((int)$parts[2] + 1) : 1;
        }
        $newQuotationNo = 'UEPL/QT/' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return response()->json([
            'newQuotationNo' => $newQuotationNo,
        ]);
    });
    Route::get('manager/rfq-details/{rfq_no}', function ($rfq_no) {
        $rfq = \App\Models\Rfq::with('customerInfo')->where('id', $rfq_no)->first();
        if (!$rfq || !$rfq->customerInfo) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'rfq' => $rfq,
            'customer' => [
                'company' => $rfq->customerInfo->company,
                'id' => $rfq->customerInfo->id,
                'address' => $rfq->customerInfo->billing_Address ?: $rfq->customerInfo->shipping_Address,
                'gstno' => $rfq->customerInfo->gstno,
                'email' => $rfq->customerInfo->email,
                'mobile' => $rfq->customerInfo->mobile,
            ],
        ]);
    })->where('rfq_no', '.*');

    // ============================================
    // SALES ROUTES
    // ============================================
    Route::prefix('manager')->group(function () {
        Route::get('generate-so-id', [ManagerSalesController::class, 'generateSOId']);
        Route::get('generate-grn-id', [ManagerSalesController::class, 'generateGRNId']);
        Route::get('salesorder', [ManagerSalesController::class, 'salesPage'])->name('manager.sales.salesorder');
        Route::get('salesdetails', [ManagerSalesController::class, 'salesDetails'])->name('manager.sales.salesdetails');
        Route::post('/sales/order/store', [ManagerSalesController::class, 'store'])->name('manager.sales.order.store');
        Route::get('/customers', [ManagerSalesController::class, 'getCustomers']);
        Route::get('/customer/{id}', [ManagerSalesController::class, 'getCustomerById']);
        Route::get('/sales/order/{id}', [ManagerSalesController::class, 'show'])->name('manager.sales.order.show');
        Route::get('/sales/order/{id}/edit', [ManagerSalesController::class, 'edit'])->name('manager.sales.order.edit');
        Route::delete('/sales/order/{id}', [ManagerSalesController::class, 'destroy'])->name('manager.sales.order.delete');
        Route::put('/sales/update/{id}', [ManagerSalesController::class, 'update'])->name('manager.sales.order.update');
    });
    Route::get('manager/quotations', [ManagerSalesController::class, 'getQuotations']);
    Route::get('manager/quotation/{id}', [ManagerSalesController::class, 'getQuotationById']);
    Route::get('/manager/sales-order/{id}', [ManagerSalesController::class, 'getSalesOrderById']);
    Route::get('/manager/sales/order/{id}/print', [ManagerSalesController::class, 'print'])->name('manager.sales.order.print');

    // ============================================
    // PURCHASE ROUTES
    // ============================================
    Route::prefix('manager')->group(function () {
        Route::get('generate-po-id', [ManagerPurchaseController::class, 'generatePOId']);
        Route::get('purchaseorder', [ManagerPurchaseController::class, 'purchasePage'])->name('manager.purchase.purchaseorder');
        Route::get('purchasedetails', [ManagerPurchaseController::class, 'purchaseDetails'])->name('manager.purchase.purchasedetails');
        Route::post('/purchase/order/store', [ManagerPurchaseController::class, 'store'])->name('manager.purchase.order.store');
        Route::get('/purchase/order/{id}', [ManagerPurchaseController::class, 'show'])->name('manager.purchase.order.show');
        Route::get('/purchase/order/{id}/edit', [ManagerPurchaseController::class, 'edit'])->name('manager.purchase.order.edit');
        Route::delete('/purchase/order/{id}', [ManagerPurchaseController::class, 'destroy'])->name('manager.purchase.order.delete');
        Route::put('/purchase/update/{id}', [ManagerPurchaseController::class, 'update'])->name('manager.purchase.order.update');
    });
    Route::get('manager/purchase/quotations', [ManagerPurchaseController::class, 'getQuotations']);
    Route::get('manager/purchase/quotation/{id}', [ManagerPurchaseController::class, 'getQuotationById']);
    Route::get('/manager/purchase-order/{id}', [ManagerPurchaseController::class, 'getPurchaseOrderById']);
    Route::get('/manager/purchase/order/{id}/print', [ManagerPurchaseController::class, 'print'])->name('manager.purchase.order.print');

    // ============================================
    // GRN ROUTES
    // ============================================
    Route::prefix('manager')->group(function () {
        Route::get('grnorder', [ManagerGRNController::class, 'grnPage'])->name('manager.grn.grnorder');
        Route::get('grndetails', [ManagerGRNController::class, 'grnDetails'])->name('manager.grn.grndetails');
        Route::post('grn/store', [ManagerGRNController::class, 'store'])->name('manager.grn.store');
        Route::get('grn/edit/{id}', [ManagerGRNController::class, 'edit'])->name('manager.grn.edit');
        Route::post('grn/update/{id}', [ManagerGRNController::class, 'update'])->name('manager.grn.update');
        Route::delete('grn/delete/{id}', [ManagerGRNController::class, 'destroy'])->name('manager.grn.destroy');
        Route::post('grn/import', [ManagerGRNController::class, 'import'])->name('manager.grn.import');
        Route::get('grn/view/{id}', [ManagerGRNController::class, 'show'])->name('manager.grn.view');
    });
    Route::get('manager/grn/available-orders', [ManagerGRNController::class, 'availableOrders']);
    Route::get('manager/grn/order-details', [ManagerGRNController::class, 'orderDetails']);

    // ============================================
    // ROUTE CARD ROUTES
    // ============================================
    Route::prefix('manager')->name('manager.routecard.')->group(function () {
        Route::get('routecardorder', [ManagerRouteCardController::class, 'routeCardPage'])->name('routecardorder');
        Route::get('routecarddetails', [ManagerRouteCardController::class, 'routeCardDetails'])->name('routecarddetails');
        Route::post('routecardorder', [ManagerRouteCardController::class, 'store'])->name('store');
        Route::get('routecard/view/{id}', [ManagerRouteCardController::class, 'show'])->name('show');
        Route::get('routecard/edit/{id}', [ManagerRouteCardController::class, 'edit'])->name('edit');
        Route::put('routecard/update/{id}', [ManagerRouteCardController::class, 'update'])->name('update');
        Route::delete('routecard/{routecard}', [ManagerRouteCardController::class, 'destroy'])->name('destroy');
    });
    Route::put('manager/routecard/process-reschedule/{id}', [ManagerRouteCardController::class, 'updateProcessAndReschedule']);
    Route::get('manager/routecard/get-process-list', [ManagerRouteCardController::class, 'getProcessList'])->name('routecard.get-process-list');
    Route::post('manager/routecard/approve/{id}', [ManagerRouteCardController::class, 'approve'])->name('manager.routecard.approve');
    Route::get('/manager/routecard/approved', [ManagerRouteCardController::class, 'approvedList']);
    Route::get('/manager/manufacturing/plan', [ManagerManufacturingPlanningController::class, 'planPage']);
    Route::get('/manager/routecard/{id}/processes', [ManagerManufacturingPlanningController::class, 'rcProcesses']);
    Route::get('/manager/manufacturing/planning', function () {
        return view('manager.manufacturing.planning');
    })->name('manager.manufacturing.planning');
    Route::prefix('manager')->name('manager.routecard.')->group(function () {
        Route::put('routecard/process/{id}', [ManagerRouteCardController::class, 'updateProcess']);
        Route::post('routecard/process', [ManagerRouteCardController::class, 'storeProcess']);
        Route::delete('routecard/process/{id}', [ManagerRouteCardController::class, 'deleteProcess']);
    });
    Route::post('manager/routecard/plan/{id}', [ManagerRouteCardController::class, 'markPlanned']);
    Route::get('manager/routecard/planned', [ManagerRouteCardController::class, 'plannedList']);
    Route::get('manufacturing/ready-to-plan', [ManagerRouteCardController::class, 'readyToPlan'])->name('manager.planning.ready');
    Route::get('manufacturing/planning-dashboard', [ManagerRouteCardController::class, 'planningDashboard'])->name('manager.planning.dashboard');
    Route::post('manufacturing/reschedule', [ManagerRouteCardController::class, 'reschedule'])->name('manager.planning.reschedule');

    // ============================================
    // MANUFACTURING PLANNING ROUTES
    // ============================================
    Route::prefix('manager/manufacturing')->group(function () {
        Route::get('plans', [ManagerManufacturingPlanningController::class, 'index']);
        Route::get('plans/{id}', [ManagerManufacturingPlanningController::class, 'show']);
        Route::post('plans', [ManagerManufacturingPlanningController::class, 'store']);
        Route::put('plans/{id}', [ManagerManufacturingPlanningController::class, 'update']);
        Route::delete('plans/{id}', [ManagerManufacturingPlanningController::class, 'destroy']);
        Route::get('external-api', [ManagerManufacturingPlanningController::class, 'fetchExternalApi']);
    });

    // ============================================
    // PROJECT PLANNING ROUTES
    // ============================================
    Route::get('/manager/projectplanning', [ManagerProjectPlanningController::class, 'index'])->name('manager.projectplanning.projectplanning');
    Route::post('manager/routecard/ready-production/{id}', [ManagerRouteCardController::class, 'markReadyProduction']);
    Route::get('/manager/manufacturing/plan/{id}', [ManagerManufacturingPlanningController::class, 'planPageWithId'])->name('manager.manufacturing.plan');
    Route::get('manager/routecard/ready-to-production-list', [ManagerRouteCardController::class, 'readyToProductionList']);
    Route::post('manager/routecard/in-production/{id}', [ManagerRouteCardController::class, 'markInProduction']);
    Route::get('/manager/ready-to-production', function () {
        return view('manager.manufacturing.ready_to_production');
    })->name('manager.readytoproduction');

    // ============================================
    // PRODUCTION ROUTES
    // ============================================
    Route::prefix('manager/manufacturing/production')->group(function () {
        Route::get('/in-progress', [ManagerProductionController::class, 'inProgressList'])->name('manager.production.inprogress.list');
        Route::get('/{rcId}', [ManagerProductionController::class, 'productionBoard'])->name('manager.production.board');
        Route::post('/start-process/{id}', [ManagerProductionController::class, 'startProcess']);
        Route::get('/route-card/{id}', [ManagerProductionController::class, 'viewRouteCard'])->name('manager.manufacturing.route-card.view');
        Route::post('/end-process/{id}', [ManagerProductionController::class, 'endProcess']);
        Route::post('/approve-qc/{id}', [ManagerProductionController::class, 'approveQC']);
        Route::post('/reject-qc/{id}', [ManagerProductionController::class, 'rejectQC']);
        Route::post('/update-resource/{id}', [ManagerProductionController::class, 'updateMachineOperator'])->name('manager.production.updateResource');
        Route::post('/report-breakdown', [ManagerProductionController::class, 'reportBreakdown'])->name('manager.production.reportBreakdown');
    });

    // ============================================
    // INVOICE ROUTES
    // ============================================
    Route::get('manager/invoiceorder', [ManagerInvoiceController::class, 'invoicePage'])->name('manager.invoice.invoiceorder');
    Route::get('manager/invoicedetails', [ManagerInvoiceController::class, 'invoiceDetails'])->name('manager.invoice.invoicedetails');
    Route::post('manager/tax-invoice', [ManagerInvoiceController::class, 'store'])->name('manager.tax-invoice.store');
    Route::get('manager/generate-invoice-id', [ManagerInvoiceController::class, 'generateInvoiceIdAjax'])->name('manager.invoice.generate');
    Route::get('manager/customer-vendor/{id}', function ($id) {
        $company = \App\Models\CustomerVendor::find($id);
        if (!$company) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'company' => [
                'address' => $company->billing_Address ?: $company->shipping_Address,
                'gst' => $company->gstno,
                'email' => $company->email,
                'mobile' => $company->mobile,
            ],
        ]);
    });
    Route::get('/manager/invoices/{invoice}/print', [ManagerInvoiceController::class, 'print'])->name('manager.invoice.print');
    Route::get('/manager/invoices/{invoice}/edit', [ManagerInvoiceController::class, 'edit'])->name('manager.invoice.edit');
    Route::put('/manager/invoices/{invoice}', [ManagerInvoiceController::class, 'update'])->name('manager.invoice.update');

    // ============================================
    // SKU MANAGEMENT ROUTES
    // ============================================
    Route::prefix('manager')->name('manager.sku.')->group(function () {
        Route::get('skumaster', [ManagerSKUController::class, 'skuMaster'])->name('skumaster');
        Route::get('sku/data', [ManagerSKUController::class, 'skuData'])->name('data');
        Route::post('sku', [ManagerSKUController::class, 'store'])->name('store');
        Route::get('sku/{id}/edit', [ManagerSKUController::class, 'edit'])->name('edit');
        Route::put('sku/{id}', [ManagerSKUController::class, 'update'])->name('update');
        Route::delete('sku/{id}', [ManagerSKUController::class, 'destroy'])->name('destroy');
    });
    Route::get('manager/skuapprovals', [ManagerSKUController::class, 'skuApproval'])->name('manager.sku.skuapproval');
    Route::get('manager/skuapproval/list', [ManagerSKUController::class, 'skuApprovalList'])->name('manager.sku-approval.list');
    Route::post('manager/sku-approval', [ManagerSKUController::class, 'skuApprovalStore'])->name('manager.sku-approval.store');
    Route::get('manager/sku-approval/{id}', [ManagerSKUController::class, 'skuApprovalShow'])->name('manager.sku-approval.show');
    Route::put('manager/sku-approval/{id}', [ManagerSKUController::class, 'skuApprovalUpdate'])->name('manager.sku-approval.update');
    Route::delete('manager/sku-approval/{id}', [ManagerSKUController::class, 'skuApprovalDestroy'])->name('manager.sku-approval.destroy');
    Route::get('manager/skumovement', [ManagerSKUController::class, 'skuMovement'])->name('manager.sku.skumovement');
    Route::get('manager/skumovement/list', [ManagerSKUController::class, 'skuMovementList']);
    Route::post('manager/skumovement/store', [ManagerSKUController::class, 'skuMovementStore']);
    Route::get('manager/skumovement/{id}', [ManagerSKUController::class, 'skuMovementShow']);
    Route::delete('manager/skumovement/{id}', [ManagerSKUController::class, 'skuMovementDelete']);

    // ============================================
    // QUALITY CONTROL ROUTES
    // ============================================
    Route::prefix('manager/quality')->group(function () {
        Route::get('qc-management', [ManagerQualityController::class, 'qcManagement']);
        Route::get('/qualitycontrol/{routeCard}', [ManagerQualityController::class, 'qualityControlBoard']);
        Route::get('/qualitycontrol-data/{routeCard}', [ManagerQualityController::class, 'qualityControlData']);
        Route::post('/qualitycontrol-status/{id}', [ManagerQualityController::class, 'updateQCStatus']);
        Route::post('/qualitycontrol', [ManagerQualityController::class, 'store']);
        Route::get('/qualitycontrol/{id}', [ManagerQualityController::class, 'show']);
        Route::put('/qualitycontrol/{id}', [ManagerQualityController::class, 'update']);
        Route::delete('/qualitycontrol/{id}', [ManagerQualityController::class, 'destroy']);
    });

    // ============================================
    // MACHINE ROUTES
    // ============================================
    Route::prefix('manager')->name('manager.machine.')->group(function () {
        Route::get('addmachine', [ManagerMachineController::class, 'addMachine'])->name('addmachine');
        Route::post('storemachine', [ManagerMachineController::class, 'storeMachine'])->name('store');
        Route::get('machinedetails', [ManagerMachineController::class, 'machineDetails'])->name('machinedetails');
        Route::get('editmachine/{id}', [ManagerMachineController::class, 'editMachine'])->name('edit');
        Route::post('updatemachine/{id}', [ManagerMachineController::class, 'updateMachine'])->name('update');
        Route::delete('deletemachine/{id}', [ManagerMachineController::class, 'deleteMachine'])->name('delete');
        Route::post('importmachines', [ManagerMachineController::class, 'importMachines'])->name('import');
    });

    // ============================================
    // EMPLOYEE ROUTES
    // ============================================
    Route::get('manager/employeedetails', [ManagerEmployeeController::class, 'employeeDetails'])->name('manager.employee.employeedetails');
    Route::post('/manager/employees', [ManagerEmployeeController::class, 'store'])->name('manager.employees.store');
    Route::put('/manager/employees/{id}', [ManagerEmployeeController::class, 'update'])->name('manager.employees.update');
    Route::delete('/manager/employees/{id}', [ManagerEmployeeController::class, 'destroy'])->name('manager.employees.delete');
    Route::post('manager/importemployees', [ManagerEmployeeController::class, 'importEmployees'])->name('manager.employee.import');
    Route::get('/manager/employees/{id}', [ManagerEmployeeController::class, 'show'])->name('employees.show');
    Route::get('/manager/employees/leave', [ManagerEmployeeController::class, 'employeeLeave'])->name('manager.employee.employeeleave');
    Route::get('manager/employeeleave', [ManagerEmployeeController::class, 'employeeLeave'])->name('manager.employee.employeeleave');
    Route::post('manager/employeeleave', [ManagerEmployeeController::class, 'storeEmployeeLeave'])->name('manager.employeeleave.store');
    Route::get('manager/employeeleave/{id}', [ManagerEmployeeController::class, 'getEmployeeLeave']);
    Route::put('manager/employeeleave/{id}', [ManagerEmployeeController::class, 'updateEmployeeLeave'])->name('manager.employeeleave.update');
    Route::delete('manager/employeeleave/{id}', [ManagerEmployeeController::class, 'destroyEmployeeLeave'])->name('manager.employeeleave.destroy');
    Route::get('manager/employee/{id}/name-dept', [ManagerEmployeeController::class, 'getEmployeeNameDept']);

    // ============================================
    // EMPLOYEE ATTENDANCE ROUTES
    // ============================================
    Route::prefix('manager')->name('manager.')->group(function () {
        Route::get('employeeattendance', [ManagerEmployeeAttendanceController::class, 'index'])->name('employee.index');
        Route::post('/attendance/import', [ManagerEmployeeAttendanceController::class, 'import'])->name('attendance.import');
        Route::get('/attendance/edit/{id}', [ManagerEmployeeAttendanceController::class, 'edit'])->name('attendance.edit');
        Route::post('attendance/store', [ManagerEmployeeAttendanceController::class, 'store'])->name('attendance.store');
        Route::post('attendance/update/{id}', [ManagerEmployeeAttendanceController::class, 'update'])->name('attendance.update');
        Route::delete('/attendance/delete/{id}', [ManagerEmployeeAttendanceController::class, 'destroy'])->name('attendance.delete');
    });

    // ============================================
    // EMPLOYEE DAILY REPORT ROUTES
    // ============================================
    Route::prefix('manager/employeedailyreports')->group(function () {
        Route::get('/', [ManagerEmployeeDailyReportController::class, 'index'])->name('employee.employeedailyreport');
        Route::post('/store', [ManagerEmployeeDailyReportController::class, 'store'])->name('employee.daily.store');
        Route::post('/update/{id}', [ManagerEmployeeDailyReportController::class, 'update'])->name('employee.daily.update');
        Route::delete('/delete/{id}', [ManagerEmployeeDailyReportController::class, 'destroy'])->name('employee.daily.delete');
        Route::post('/import', [ManagerEmployeeDailyReportController::class, 'import'])->name('employee.daily.import');
        Route::get('/edit/{id}', [ManagerEmployeeDailyReportController::class, 'edit'])->name('employee.daily.edit');
        Route::get('/calendar/{employee_id}/{month}', [ManagerEmployeeDailyReportController::class, 'calendar']);
        Route::get('/calendarview', [ManagerEmployeeDailyReportController::class, 'calendarView'])->name('employee.daily.calendar');
    });

    // ============================================
    // HOLIDAY ROUTES
    // ============================================
    Route::prefix('manager/holiday')->name('manager.holiday.')->group(function () {
        Route::get('/', [ManagerHolidayController::class, 'index'])->name('index');
        Route::get('/list', [ManagerHolidayController::class, 'list'])->name('list');
        Route::post('/store', [ManagerHolidayController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [ManagerHolidayController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [ManagerHolidayController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [ManagerHolidayController::class, 'destroy'])->name('destroy');
        Route::post('/toggle-status/{id}', [ManagerHolidayController::class, 'toggleStatus'])->name('toggle');
        Route::get('/upcoming', [ManagerHolidayController::class, 'upcoming'])->name('upcoming');
        Route::post('/import', [ManagerHolidayController::class, 'import'])->name('import');
    });

    // ============================================
    // LEAVE MANAGEMENT ROUTES
    // ============================================
    Route::prefix('manager/leave')->name('manager.leave.')->group(function () {
        Route::get('/', [ManagerLeaveController::class, 'index'])->name('index');
        Route::get('/list', [ManagerLeaveController::class, 'list'])->name('list');
        Route::post('/store', [ManagerLeaveController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [ManagerLeaveController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [ManagerLeaveController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [ManagerLeaveController::class, 'destroy'])->name('destroy');
        Route::post('/cancel/{id}', [ManagerLeaveController::class, 'cancel'])->name('cancel');
        Route::post('/approve/{id}', [ManagerLeaveController::class, 'approve'])->name('approve');
        Route::post('/reject/{id}', [ManagerLeaveController::class, 'reject'])->name('reject');
        Route::get('/pending', [ManagerLeaveController::class, 'pending'])->name('pending');
        Route::get('/balance/{employee_id}', [ManagerLeaveController::class, 'getBalance'])->name('balance');
        Route::post('/import', [ManagerLeaveController::class, 'import'])->name('import');
    });

    // ============================================
    // LEAVE BALANCE ROUTES
    // ============================================
    Route::prefix('manager/leave-balance')->name('manager.leave-balance.')->group(function () {
        Route::get('/', [ManagerLeaveController::class, 'balanceIndex'])->name('index');
    });

    // ============================================
    // SALARY STRUCTURE ROUTES (View Only)
    // ============================================
    Route::prefix('manager/salary-structure')->name('manager.salary-structure.')->group(function () {
        Route::get('/', [ManagerSalaryStructureController::class, 'index'])->name('index');
        Route::get('/list', [ManagerSalaryStructureController::class, 'list'])->name('list');
        Route::get('/edit/{id}', [ManagerSalaryStructureController::class, 'edit'])->name('edit');
        Route::get('/breakdown/{employee_id}', [ManagerSalaryStructureController::class, 'getBreakdown'])->name('breakdown');
    });

    // ============================================
    // PAYROLL ROUTES (View/Submit Only)
    // ============================================
    Route::prefix('manager/payroll')->name('manager.payroll.')->group(function () {
        Route::get('/', [ManagerPayrollController::class, 'index'])->name('index');
        Route::get('/list', [ManagerPayrollController::class, 'list'])->name('list');
        Route::post('/generate', [ManagerPayrollController::class, 'generate'])->name('generate');
        Route::get('/edit/{id}', [ManagerPayrollController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [ManagerPayrollController::class, 'update'])->name('update');
        Route::post('/submit/{id}', [ManagerPayrollController::class, 'submit'])->name('submit');
        Route::get('/payslip/{id}', [ManagerPayrollController::class, 'payslip'])->name('payslip');
        Route::get('/print-payslip/{id}', [ManagerPayrollController::class, 'printPayslip'])->name('print-payslip');
    });

    // ============================================
    // PURCHASE MANAGEMENT ROUTES
    // ============================================
    Route::prefix('manager/purchasemanagement')->group(function () {
        Route::get('/', [ManagerPurchaseManagementController::class, 'index'])->name('manager.purchase.index');
        Route::get('/create', [ManagerPurchaseManagementController::class, 'create'])->name('manager.purchase.create');
        Route::post('/', [ManagerPurchaseManagementController::class, 'store'])->name('manager.purchase.store');
        Route::get('/{purchase}', [ManagerPurchaseManagementController::class, 'show'])->name('manager.purchase.show');
        Route::get('/{purchase}/edit', [ManagerPurchaseManagementController::class, 'edit'])->name('manager.purchase.edit');
        Route::put('/{purchase}/update', [ManagerPurchaseManagementController::class, 'update'])->name('manager.purchase.update');
        Route::delete('/{purchase}', [ManagerPurchaseManagementController::class, 'destroy'])->name('manager.purchase.destroy');
    });
    Route::get('manager/purchasemanage/export', [ManagerPurchaseManagementController::class, 'export'])->name('manager.purchase.export');
    Route::get('manager/creditnotes/next-no', [ManagerPurchaseManagementController::class, 'getNextCreditNoteNo']);
    Route::get('/purchase/next-invoice-no', [ManagerPurchaseManagementController::class, 'getNextInvoiceNumber']);
    Route::post('manager/creditnotes', [ManagerPurchaseManagementController::class, 'creditNoteStore']);
    Route::get('manager/purchasemanage/payments', [ManagerPurchaseManagementController::class, 'payments'])->name('manager.purchase.payments');
    Route::get('manager/purchasemanage/{id}', [ManagerPurchaseManagementController::class, 'Vendorshow']);
    Route::get('manager/creditnotes/data', [ManagerPurchaseManagementController::class, 'creditNotesData'])->name('manager.creditnotes.data');
    Route::get('manager/creditnotes/{id}', [ManagerPurchaseManagementController::class, 'showCreditNote']);
    Route::get('manager/purchasedata/aging-report', [ManagerPurchaseManagementController::class, 'agingReport'])->name('manager.purchase.aging');

    // ============================================
    // REPORTS ROUTES
    // ============================================
    Route::any('manager/employeereport', [ManagerReportController::class, 'employeeReport'])->name('manager.report.employeereport');
    Route::any('manager/customerreport', [ManagerReportController::class, 'customerReport'])->name('manager.report.customerreport');
    Route::post('manager/customerreport/export', [ManagerReportController::class, 'exportCustomerReport'])->name('manager.report.customerreport.export');
    Route::post('/manager/employee-report/export', [ManagerReportController::class, 'exportEmployeeReport'])->name('manager.exportEmployeeReport');
    Route::any('manager/machinereport', [ManagerReportController::class, 'machineReport'])->name('manager.report.machinereport');
    Route::post('manager/machinereport/export', [ManagerReportController::class, 'exportMachineReport'])->name('manager.report.machinereport.export');
    Route::any('manager/billreport', [ManagerReportController::class, 'billReport'])->name('manager.report.billreport');
    Route::post('manager/billreport/export', [ManagerReportController::class, 'exportBillReport'])->name('manager.report.billreport.export');
    Route::get('manager/employeedailyreport', [ManagerEmployeeController::class, 'employeeDailyReport'])->name('manager.employee.employeedailyreport');
    Route::any('manager/inventoryreport', [ManagerReportController::class, 'inventoryReport'])->name('manager.report.inventoryreport');
    Route::post('manager/inventoryreport/export', [ManagerReportController::class, 'exportInventoryReport'])->name('manager.report.inventoryreport.export');
    Route::get('manager/employeecalendar', [ManagerEmployeeController::class, 'employeeCalendar'])->name('manager.employee.employeecalendar');

    // ============================================
    // PROFILE ROUTES (Using Unified Controller)
    // ============================================
    Route::get('manager/profile', [\App\Http\Controllers\Modules\Profile\ProfileController::class, 'index'])->name('manager.profile.index');
    Route::put('manager/profile', [\App\Http\Controllers\Modules\Profile\ProfileController::class, 'updateProfile'])->name('manager.profile.update');
    Route::put('manager/profile/password', [\App\Http\Controllers\Modules\Profile\ProfileController::class, 'updatePassword'])->name('manager.profile.password');

    // ============================================
    // SALARY DETAILS URL-BASED ROUTES
    // (Used by employeepayroll views with hardcoded URLs)
    // ============================================
    Route::get('manager/salary-details/{id}', [\App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'show']);
    Route::post('manager/salary-details/store', [\App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'store']);
    Route::put('manager/salary-details/{id}', [\App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'update']);
    Route::delete('manager/salary-details/{id}', [\App\Http\Controllers\Modules\Employee\SalaryDetailController::class, 'destroy']);
    Route::get('manager/employee/{id}/name', [\App\Http\Controllers\Modules\Employee\EmployeeController::class, 'getEmployeeById']);
});
