<?php

/**
 * Admin Routes
 *
 * All routes for the Admin role.
 * These routes are protected by 'auth' and 'role:admin' middleware.
 */

use App\Http\Controllers\Modules\MasterData\CustomerVendorController;
// Unified Sales Controllers (from Modules folder)
use App\Http\Controllers\Modules\Sales\RfqController;
use App\Http\Controllers\Modules\Sales\QuotationController;
use App\Http\Controllers\Modules\Sales\InvoiceController;
use App\Http\Controllers\Modules\Sales\SalesOrderController as SalesController;
// Unified Purchase Controllers (from Modules folder)
use App\Http\Controllers\Modules\Purchase\PurchaseOrderController as PurchaseController;
use App\Http\Controllers\Modules\Purchase\GrnController as GRNController;
// Unified Manufacturing Controllers (from Modules folder)
use App\Http\Controllers\Modules\Manufacturing\RouteCardController;
use App\Http\Controllers\Modules\Manufacturing\ManufacturingPlanningController;
use App\Http\Controllers\Modules\Manufacturing\ProductionController;
use App\Http\Controllers\Modules\Manufacturing\ProjectPlanningController;
use App\Http\Controllers\Modules\Manufacturing\QualityController;
use App\Http\Controllers\Modules\Manufacturing\SkuController as SKUController;
use App\Http\Controllers\Modules\MasterData\MachineController;
// Unified Employee Controllers (from Modules folder)
use App\Http\Controllers\Modules\Employee\AttendanceController as EmployeeAttendanceController;
use App\Http\Controllers\Modules\Employee\EmployeeController;
use App\Http\Controllers\Modules\Employee\EmployeeDailyReportController;
use App\Http\Controllers\Modules\Employee\HolidayController;
use App\Http\Controllers\Modules\Employee\LeaveController;
use App\Http\Controllers\Modules\Employee\PayrollController;
use App\Http\Controllers\Modules\Employee\SalaryStructureController;
use App\Http\Controllers\Admin\DashboardController;
// Unified Master Data Controllers (from Modules folder)
use App\Http\Controllers\Modules\MasterData\CompanyTypeController;
use App\Http\Controllers\Modules\MasterData\AccountTypeController;
use App\Http\Controllers\Modules\MasterData\RfqTypeController;
use App\Http\Controllers\Modules\MasterData\ProductTypeController;
use App\Http\Controllers\Modules\Inventory\RawMaterialController;
use App\Http\Controllers\Modules\MasterData\ConversionProcessController;
use App\Http\Controllers\Modules\MasterData\ProcessController;
use App\Http\Controllers\Modules\Inventory\StockItemController;
// Unified Accounts Controllers (from Modules folder)
use App\Http\Controllers\Modules\Accounts\AccountsPayableController;
use App\Http\Controllers\Modules\Accounts\AccountsReceivableController;
use App\Http\Controllers\Modules\Accounts\FinancialReportsController;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'role:admin'])->group(function () {

    // ============================================
    // DASHBOARD ROUTES
    // ============================================
    Route::get('admin/dashboard', [DashboardController::class, 'allDashboard'])->name('admin.dashboard.dashboard');
    Route::get('admin/employeedashboard', [DashboardController::class, 'employeeDashboard'])->name('admin.dashboard.employeedashboard');
    Route::get('admin/machinedashboard', [DashboardController::class, 'machineDashboard'])->name('admin.dashboard.machinedashboard');
    Route::get('admin/stockdashboard', [DashboardController::class, 'stockDashboard'])->name('admin.dashboard.stockdashboard');
    Route::get('admin/accountdashboard', [DashboardController::class, 'accountDashboard'])->name('admin.dashboard.accountdashboard');
    Route::get('admin/manufacturingdashboard', [DashboardController::class, 'manufacturingDashboard'])->name('admin.dashboard.manufacturingdashboard');

    // ============================================
    // MASTER DATA ROUTES
    // ============================================

    // Company Type routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('companytypes', [CompanyTypeController::class, 'companyTypes'])->name('companytype.index');
        Route::get('companytypes/list', [CompanyTypeController::class, 'list'])->name('companytype.list');
        Route::post('companytypes/store', [CompanyTypeController::class, 'store'])->name('companytype.store');
        Route::post('companytypes/update/{companytype}', [CompanyTypeController::class, 'update'])->name('companytype.update');
        Route::delete('companytypes/delete/{companytype}', [CompanyTypeController::class, 'delete'])->name('companytype.delete');
    });

    // Account Type routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('accounttypes', [AccountTypeController::class, 'index'])->name('accounttype.index');
        Route::get('accounttypes/list', [AccountTypeController::class, 'list'])->name('accounttype.list');
        Route::get('accounttypes/{accounttype}', [AccountTypeController::class, 'show']);
        Route::post('accounttypes/store', [AccountTypeController::class, 'store'])->name('accounttype.store');
        Route::put('accounttypes/update/{accounttype}', [AccountTypeController::class, 'update']);
        Route::delete('accounttypes/delete/{accounttype}', [AccountTypeController::class, 'delete']);
    });

    // Rfq Type routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('rfqtypes', [RfqTypeController::class, 'index'])->name('rfqtype.index');
        Route::get('rfqtypes/list', [RfqTypeController::class, 'list'])->name('rfqtype.list');
        Route::get('rfqtypes/{rfqtype}', [RfqTypeController::class, 'show']);
        Route::post('rfqtypes/store', [RfqTypeController::class, 'store'])->name('rfqtype.store');
        Route::put('rfqtypes/update/{rfqtype}', [RfqTypeController::class, 'update']);
        Route::delete('rfqtypes/delete/{rfqtype}', [RfqTypeController::class, 'delete']);
    });

    // Product Type routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('producttypes', [ProductTypeController::class, 'index'])->name('producttype.index');
        Route::get('producttypes/list', [ProductTypeController::class, 'list'])->name('producttype.list');
        Route::get('producttypes/{producttype}', [ProductTypeController::class, 'show']);
        Route::post('producttypes/store', [ProductTypeController::class, 'store'])->name('producttype.store');
        Route::put('producttypes/update/{producttype}', [ProductTypeController::class, 'update']);
        Route::delete('producttypes/delete/{producttype}', [ProductTypeController::class, 'delete']);
    });

    // Raw Material routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('rawmaterials', [RawMaterialController::class, 'index'])->name('rawmaterial.index');
        Route::get('rawmaterials/list', [RawMaterialController::class, 'list'])->name('rawmaterial.list');
        Route::post('rawmaterials/store', [RawMaterialController::class, 'store'])->name('rawmaterial.store');
        Route::get('rawmaterials/{rawmaterial}', [RawMaterialController::class, 'show']);
        Route::put('rawmaterials/update/{rawmaterial}', [RawMaterialController::class, 'update']);
        Route::delete('rawmaterials/delete/{rawmaterial}', [RawMaterialController::class, 'delete']);
    });

    // Conversion Process routes
    Route::prefix('admin/conversionprocesses')->group(function () {
        Route::get('/', [ConversionProcessController::class, 'index'])->name('admin.conversionprocess.index');
        Route::get('/list', [ConversionProcessController::class, 'list'])->name('admin.conversionprocess.list');
        Route::post('/store', [ConversionProcessController::class, 'store'])->name('admin.conversionprocess.store');
        Route::get('/{id}', [ConversionProcessController::class, 'show']);
        Route::put('/update/{id}', [ConversionProcessController::class, 'update']);
        Route::delete('/delete/{id}', [ConversionProcessController::class, 'destroy']);
    });

    // Process routes
    Route::prefix('admin/processes')->name('admin.process.')->group(function () {
        Route::get('/', [ProcessController::class, 'index'])->name('index');
        Route::get('/api', [ProcessController::class, 'api'])->name('api');
        Route::post('/store', [ProcessController::class, 'store'])->name('store');
        Route::get('/{id}', [ProcessController::class, 'show'])->name('show');
        Route::put('/update/{id}', [ProcessController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [ProcessController::class, 'destroy'])->name('destroy');
    });

    // Stock Items routes
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('stockitems', [StockItemController::class, 'index'])->name('stockitems.index');
        Route::post('stockitems', [StockItemController::class, 'store'])->name('stockitems.store');
        Route::put('stockitems/{id}', [StockItemController::class, 'update'])->name('stockitems.update');
        Route::delete('stockitems/{id}', [StockItemController::class, 'destroy'])->name('stockitems.destroy');
        Route::post('categories/store', [StockItemController::class, 'storeCategory'])->name('categories.store');
    });

    // ============================================
    // CUSTOMER/VENDOR ROUTES (Using Unified Controller)
    // ============================================
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('/customers', [CustomerVendorController::class, 'getAllCustomers']);
        Route::get('addcustomer', [CustomerVendorController::class, 'create'])->name('customer.addcustomer');
        Route::post('/customer-vendor/register', [CustomerVendorController::class, 'store'])->name('customer.vendor.store');
        Route::get('customerlist', [CustomerVendorController::class, 'index'])->name('customer.customerlist');
        Route::get('/customers/{customer}', [CustomerVendorController::class, 'show'])->name('customer.show');
        Route::get('/customers/{customer}/edit', [CustomerVendorController::class, 'edit'])->name('customer.edit');
        Route::put('/customers/{customer}', [CustomerVendorController::class, 'update'])->name('customer.update');
        Route::delete('/customers/{customer}', [CustomerVendorController::class, 'destroy'])->name('customer.destroy');
        Route::post('/import-customers', [CustomerVendorController::class, 'import'])->name('customer.import');
    });

    // ============================================
    // RFQ ROUTES
    // ============================================
    Route::prefix('admin')->group(function () {
        Route::get('rfq', [RfqController::class, 'rfq'])->name('admin.rfq.rfq');
        Route::post('rfq/store', [RfqController::class, 'store'])->name('admin.rfq.store');
        Route::get('rfqdetails', [RfqController::class, 'rfqDetails'])->name('admin.rfq.rfqdetails');
        Route::get('rfq/{id}/view', [RfqController::class, 'view'])->name('admin.rfq.view');
        Route::get('rfq/{id}/edit', [RfqController::class, 'edit'])->name('admin.rfq.edit');
        Route::put('rfq/{id}/update', [RfqController::class, 'update'])->name('admin.rfq.update');
        Route::delete('rfq/{id}', [RfqController::class, 'destroy'])->name('admin.rfq.destroy');
        Route::get('rfq/generate-id', [RfqController::class, 'generateRfqId'])->name('admin.rfq.generateId');
    });
    Route::get('admin/raw-materials', [RfqController::class, 'getRawMaterials'])->name('admin.rawmaterials.list');
    Route::post('admin/raw-materials', [RfqController::class, 'storeRawMaterial'])->name('admin.rawmaterials.store');
    Route::get('admin/rfq/{id}/print', [RfqController::class, 'printRfq'])->name('admin.rfq.print');

    // ============================================
    // QUOTATION ROUTES
    // ============================================
    Route::prefix('admin')->group(function () {
        Route::get('quotationorder', [QuotationController::class, 'quotationPage'])->name('admin.quotation.quotationorder');
        Route::get('quotationdetails', [QuotationController::class, 'quotationDetails'])->name('admin.quotation.quotationdetails');
        Route::post('quotations', [QuotationController::class, 'store'])->name('admin.quotations.store');
        Route::get('quotations/{id}/view', [QuotationController::class, 'view'])->name('admin.quotation.view');
        Route::get('quotations/{id}/edit', [QuotationController::class, 'edit'])->name('admin.quotation.edit');
        Route::post('quotations/{id}/update', [QuotationController::class, 'update'])->name('admin.quotation.update');
        Route::delete('quotations/{id}', [QuotationController::class, 'destroy'])->name('admin.quotation.delete');
        Route::get('quotations/ajax', [QuotationController::class, 'quotationListAjax'])->name('admin.quotation.ajax');
        Route::get('quotations/{id}/print', [QuotationController::class, 'print'])->name('admin.quotation.print');
    });
    Route::get('admin/rfq-details/{id}', [QuotationController::class, 'getRfqDetails']);
    Route::get('admin/max-quotation-id', function () {
        $latest = \App\Models\Quotation::orderByDesc('id')->first();
        if (!$latest || !$latest->quotation_no) {
            $nextNumber = 1;
        } else {
            $parts = explode('/', $latest->quotation_no);
            $nextNumber = isset($parts[2]) ? ((int)$parts[2] + 1) : 1;
        }
        $newQuotationNo = 'UEPL/QT/' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return response()->json([
            'newQuotationNo' => $newQuotationNo,
        ]);
    });
    Route::get('admin/rfq-details/{rfq_no}', function ($rfq_no) {
        $rfq = \App\Models\Rfq::with('customerInfo')->where('id', $rfq_no)->first();
        if (!$rfq || !$rfq->customerInfo) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'rfq' => $rfq,
            'customer' => [
                'company' => $rfq->customerInfo->company,
                'id' => $rfq->customerInfo->id,
                'address' => $rfq->customerInfo->billing_Address ?: $rfq->customerInfo->shipping_Address,
                'gstno' => $rfq->customerInfo->gstno,
                'email' => $rfq->customerInfo->email,
                'mobile' => $rfq->customerInfo->mobile,
            ],
        ]);
    })->where('rfq_no', '.*');

    // ============================================
    // INVOICE ROUTES
    // ============================================
    Route::get('admin/invoiceorder', [InvoiceController::class, 'invoicePage'])->name('admin.invoice.invoiceorder');
    Route::get('admin/invoicedetails', [InvoiceController::class, 'invoiceDetails'])->name('admin.invoice.invoicedetails');
    Route::post('admin/tax-invoice', [InvoiceController::class, 'store'])->name('admin.tax-invoice.store');
    Route::get('admin/generate-invoice-id', [InvoiceController::class, 'generateInvoiceIdAjax'])->name('admin.invoice.generate');
    Route::get('admin/customer-vendor/{id}', function ($id) {
        $company = \App\Models\CustomerVendor::find($id);
        if (!$company) return response()->json(['success' => false]);
        return response()->json([
            'success' => true,
            'company' => [
                'address' => $company->billing_Address ?: $company->shipping_Address,
                'gst' => $company->gstno,
                'email' => $company->email,
                'mobile' => $company->mobile,
            ],
        ]);
    });
    Route::get('/admin/invoices/{invoice}/print', [InvoiceController::class, 'print'])->name('admin.invoice.print');
    Route::get('/admin/invoices/{invoice}/edit', [InvoiceController::class, 'edit'])->name('admin.invoice.edit');
    Route::put('/admin/invoices/{invoice}', [InvoiceController::class, 'update'])->name('admin.invoice.update');

    // ============================================
    // SALES ROUTES
    // ============================================
    Route::prefix('admin')->group(function () {
        Route::get('generate-so-id', [SalesController::class, 'generateSOId']);
        Route::get('generate-grn-id', [SalesController::class, 'generateGRNId']);
        Route::get('salesorder', [SalesController::class, 'salesPage'])->name('admin.sales.salesorder');
        Route::get('salesdetails', [SalesController::class, 'salesDetails'])->name('admin.sales.salesdetails');
        Route::post('/sales/order/store', [SalesController::class, 'store'])->name('admin.sales.order.store');
        Route::get('/customers', [SalesController::class, 'getCustomers']);
        Route::get('/customer/{id}', [SalesController::class, 'getCustomerById']);
        Route::get('/sales/order/{id}', [SalesController::class, 'show'])->name('admin.sales.order.show');
        Route::get('/sales/order/{id}/edit', [SalesController::class, 'edit'])->name('admin.sales.order.edit');
        Route::delete('/sales/order/{id}', [SalesController::class, 'destroy'])->name('admin.sales.order.delete');
        Route::put('/sales/update/{id}', [SalesController::class, 'update'])->name('admin.sales.order.update');
    });
    Route::get('admin/quotations', [SalesController::class, 'getQuotations']);
    Route::get('admin/quotation/{id}', [SalesController::class, 'getQuotationById']);
    Route::get('/admin/sales-order/{id}', [SalesController::class, 'getSalesOrderById']);
    Route::get('/admin/sales/order/{id}/print', [SalesController::class, 'print'])->name('admin.sales.order.print');

    // ============================================
    // PURCHASE ROUTES
    // ============================================
    Route::prefix('admin')->group(function () {
        Route::get('generate-po-id', [PurchaseController::class, 'generatePOId']);
        Route::get('purchaseorder', [PurchaseController::class, 'purchasePage'])->name('admin.purchase.purchaseorder');
        Route::get('purchasedetails', [PurchaseController::class, 'purchaseDetails'])->name('admin.purchase.purchasedetails');
        Route::post('/purchase/order/store', [PurchaseController::class, 'store'])->name('admin.purchase.order.store');
        Route::get('/purchase/order/{id}', [PurchaseController::class, 'show'])->name('admin.purchase.order.show');
        Route::get('/purchase/order/{id}/edit', [PurchaseController::class, 'edit'])->name('admin.purchase.order.edit');
        Route::delete('/purchase/order/{id}', [PurchaseController::class, 'destroy'])->name('admin.purchase.order.delete');
        Route::put('/purchase/update/{id}', [PurchaseController::class, 'update'])->name('admin.purchase.order.update');
    });
    Route::get('admin/purchase/quotations', [PurchaseController::class, 'getQuotations']);
    Route::get('admin/purchase/quotation/{id}', [PurchaseController::class, 'getQuotationById']);
    Route::get('/admin/purchase-order/{id}', [PurchaseController::class, 'getPurchaseOrderById']);
    Route::get('/admin/purchase/order/{id}/print', [PurchaseController::class, 'print'])->name('admin.purchase.order.print');

    // ============================================
    // GRN ROUTES
    // ============================================
    Route::prefix('admin')->group(function () {
        Route::get('grnorder', [GRNController::class, 'grnPage'])->name('admin.grn.grnorder');
        Route::get('grndetails', [GRNController::class, 'grnDetails'])->name('admin.grn.grndetails');
        Route::post('grn/store', [GRNController::class, 'store'])->name('admin.grn.store');
        Route::get('grn/edit/{id}', [GRNController::class, 'edit'])->name('admin.grn.edit');
        Route::post('grn/update/{id}', [GRNController::class, 'update'])->name('admin.grn.update');
        Route::delete('grn/delete/{id}', [GRNController::class, 'destroy'])->name('admin.grn.destroy');
        Route::post('grn/import', [GRNController::class, 'import'])->name('admin.grn.import');
        Route::get('grn/view/{id}', [GRNController::class, 'show'])->name('admin.grn.view');
    });
    Route::get('admin/grn/available-orders', [GRNController::class, 'availableOrders']);
    Route::get('admin/grn/order-details', [GRNController::class, 'orderDetails']);

    // ============================================
    // ROUTE CARD ROUTES
    // ============================================
    Route::prefix('admin')->name('admin.routecard.')->group(function () {
        Route::get('routecardorder', [RouteCardController::class, 'routeCardPage'])->name('routecardorder');
        Route::get('routecarddetails', [RouteCardController::class, 'routeCardDetails'])->name('routecarddetails');
        Route::post('routecardorder', [RouteCardController::class, 'store'])->name('store');
        Route::get('routecard/view/{id}', [RouteCardController::class, 'show'])->name('show');
        Route::get('routecard/edit/{id}', [RouteCardController::class, 'edit'])->name('edit');
        Route::put('routecard/update/{id}', [RouteCardController::class, 'update'])->name('update');
        Route::delete('routecard/{routecard}', [RouteCardController::class, 'destroy'])->name('destroy');
    });
    Route::put('admin/routecard/process-reschedule/{id}', [RouteCardController::class, 'updateProcessAndReschedule']);
    Route::get('admin/routecard/get-process-list', [RouteCardController::class, 'getProcessList'])->name('routecard.get-process-list');
    Route::post('admin/routecard/approve/{id}', [RouteCardController::class, 'approve'])->name('admin.routecard.approve');
    Route::get('/admin/routecard/approved', [RouteCardController::class, 'approvedList']);
    Route::get('/admin/manufacturing/plan', [ManufacturingPlanningController::class, 'planPage']);
    Route::get('/admin/routecard/{id}/processes', [ManufacturingPlanningController::class, 'rcProcesses']);
    Route::get('/admin/manufacturing/planning', function () {
        return view('admin.manufacturing.planning');
    })->name('admin.manufacturing.planning');
    Route::prefix('admin')->name('admin.routecard.')->group(function () {
        Route::put('routecard/process/{id}', [RouteCardController::class, 'updateProcess']);
        Route::post('routecard/process', [RouteCardController::class, 'storeProcess']);
        Route::delete('routecard/process/{id}', [RouteCardController::class, 'deleteProcess']);
    });
    Route::post('admin/routecard/plan/{id}', [RouteCardController::class, 'markPlanned']);
    Route::get('admin/routecard/planned', [RouteCardController::class, 'plannedList']);

    // ============================================
    // MANUFACTURING PLANNING ROUTES
    // ============================================
    Route::prefix('admin/manufacturing')->group(function () {
        Route::get('plans', [ManufacturingPlanningController::class, 'index']);
        Route::get('plans/{id}', [ManufacturingPlanningController::class, 'show']);
        Route::post('plans', [ManufacturingPlanningController::class, 'store']);
        Route::put('plans/{id}', [ManufacturingPlanningController::class, 'update']);
        Route::delete('plans/{id}', [ManufacturingPlanningController::class, 'destroy']);
        Route::get('external-api', [ManufacturingPlanningController::class, 'fetchExternalApi']);
    });

    // ============================================
    // PROJECT PLANNING ROUTES
    // ============================================
    Route::get('/admin/projectplanning', [ProjectPlanningController::class, 'index'])->name('admin.projectplanning.projectplanning');
    Route::post('admin/routecard/ready-production/{id}', [RouteCardController::class, 'markReadyProduction']);
    Route::get('/admin/manufacturing/plan/{id}', [ManufacturingPlanningController::class, 'planPageWithId'])->name('superadmin.manufacturing.plan');
    Route::get('admin/routecard/ready-to-production-list', [RouteCardController::class, 'readyToProductionList']);
    Route::post('admin/routecard/in-production/{id}', [RouteCardController::class, 'markInProduction']);
    Route::get('/admin/ready-to-production', function () {
        return view('admin.manufacturing.ready_to_production');
    })->name('admin.readytoproduction');

    // ============================================
    // PRODUCTION ROUTES
    // ============================================
    Route::prefix('admin/manufacturing/production')->group(function () {
        Route::get('/in-progress', [ProductionController::class, 'inProgressList'])->name('admin.production.inprogress.list');
        Route::get('/{rcId}', [ProductionController::class, 'productionBoard'])->name('admin.production.board');
        Route::post('/start-process/{id}', [ProductionController::class, 'startProcess']);
        Route::post('/end-process/{id}', [ProductionController::class, 'endProcess']);
        Route::post('/approve-qc/{id}', [ProductionController::class, 'approveQC']);
        Route::post('/reject-qc/{id}', [ProductionController::class, 'rejectQC']);
    });

    // ============================================
    // QUALITY CONTROL ROUTES
    // ============================================
    Route::prefix('admin/quality')->group(function () {
        Route::get('qc-management', [QualityController::class, 'qcManagement']);
        Route::get('/qualitycontrol/{routeCard}', [QualityController::class, 'qualityControlBoard']);
        Route::get('/qualitycontrol-data/{routeCard}', [QualityController::class, 'qualityControlData']);
        Route::post('/qualitycontrol-status/{id}', [QualityController::class, 'updateQCStatus']);
        Route::post('/qualitycontrol', [QualityController::class, 'store']);
        Route::get('/qualitycontrol/{id}', [QualityController::class, 'show']);
        Route::put('/qualitycontrol/{id}', [QualityController::class, 'update']);
        Route::delete('/qualitycontrol/{id}', [QualityController::class, 'destroy']);
    });

    // ============================================
    // SKU ROUTES
    // ============================================
    Route::prefix('admin')->name('admin.sku.')->group(function () {
        Route::get('skumaster', [SKUController::class, 'skuMaster'])->name('skumaster');
        Route::get('sku/data', [SKUController::class, 'skuData'])->name('data');
        Route::post('sku', [SKUController::class, 'store'])->name('store');
        Route::get('sku/{id}/edit', [SKUController::class, 'edit'])->name('edit');
        Route::put('sku/{id}', [SKUController::class, 'update'])->name('update');
        Route::delete('sku/{id}', [SKUController::class, 'destroy'])->name('destroy');
    });
    Route::get('admin/skuapprovals', [SKUController::class, 'skuApproval'])->name('admin.sku.skuapproval');
    Route::get('admin/skuapproval/list', [SKUController::class, 'skuApprovalList'])->name('admin.sku-approval.list');
    Route::post('admin/sku-approval', [SKUController::class, 'skuApprovalStore'])->name('admin.sku-approval.store');
    Route::get('admin/sku-approval/{id}', [SKUController::class, 'skuApprovalShow'])->name('admin.sku-approval.show');
    Route::put('admin/sku-approval/{id}', [SKUController::class, 'skuApprovalUpdate'])->name('admin.sku-approval.update');
    Route::delete('admin/sku-approval/{id}', [SKUController::class, 'skuApprovalDestroy'])->name('admin.sku-approval.destroy');
    Route::get('admin/skumovement', [SKUController::class, 'skuMovement'])->name('admin.sku.skumovement');
    Route::get('admin/skumovement/list', [SKUController::class, 'skuMovementList']);
    Route::post('admin/skumovement/store', [SKUController::class, 'skuMovementStore']);
    Route::get('admin/skumovement/{id}', [SKUController::class, 'skuMovementShow']);
    Route::delete('admin/skumovement/{id}', [SKUController::class, 'skuMovementDelete']);

    // ============================================
    // MACHINE ROUTES
    // ============================================
    Route::prefix('admin')->name('admin.machine.')->group(function () {
        Route::get('addmachine', [MachineController::class, 'addMachine'])->name('addmachine');
        Route::post('storemachine', [MachineController::class, 'storeMachine'])->name('store');
        Route::get('machinedetails', [MachineController::class, 'machineDetails'])->name('machinedetails');
        Route::get('editmachine/{id}', [MachineController::class, 'editMachine'])->name('edit');
        Route::post('updatemachine/{id}', [MachineController::class, 'updateMachine'])->name('update');
        Route::delete('deletemachine/{id}', [MachineController::class, 'deleteMachine'])->name('delete');
        Route::post('importmachines', [MachineController::class, 'importMachines'])->name('import');
    });

    // ============================================
    // EMPLOYEE ROUTES
    // ============================================
    Route::get('admin/employeedetails', [EmployeeController::class, 'employeeDetails'])->name('admin.employee.employeedetails');
    Route::post('/admin/employees', [EmployeeController::class, 'store'])->name('admin.employees.store');
    Route::put('/admin/employees/{id}', [EmployeeController::class, 'update'])->name('admin.employees.update');
    Route::delete('/admin/employees/{id}', [EmployeeController::class, 'destroy'])->name('admin.employees.delete');
    Route::post('/admin/importemployees', [EmployeeController::class, 'importEmployees'])->name('admin.employee.import');
    Route::get('/admin/employees/{id}', [EmployeeController::class, 'show'])->name('employees.show');
    Route::get('/admin/employees/leave', [EmployeeController::class, 'employeeLeave'])->name('admin.employee.employeeleave');
    Route::get('/admin/employeedetails', [EmployeeController::class, 'employeeDetails'])->name('admin.employee.employeedetails');
    Route::get('/admin/employeeleave', [EmployeeController::class, 'employeeLeave'])->name('admin.employee.employeeleave');
    Route::post('/admin/employeeleave', [EmployeeController::class, 'storeEmployeeLeave'])->name('admin.employeeleave.store');
    Route::get('/admin/employeeleave/{id}', [EmployeeController::class, 'getEmployeeLeave']);
    Route::put('/admin/employeeleave/{id}', [EmployeeController::class, 'updateEmployeeLeave'])->name('admin.employeeleave.update');
    Route::delete('/admin/employeeleave/{id}', [EmployeeController::class, 'destroyEmployeeLeave'])->name('admin.employeeleave.destroy');
    Route::get('/admin/employee/{id}/name-dept', [EmployeeController::class, 'getEmployeeNameDept']);

    // ============================================
    // EMPLOYEE ATTENDANCE ROUTES
    // ============================================
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('employeeattendance', [EmployeeAttendanceController::class, 'index'])->name('employee.index');
        Route::post('/attendance/import', [EmployeeAttendanceController::class, 'import'])->name('attendance.import');
        Route::get('/attendance/edit/{id}', [EmployeeAttendanceController::class, 'edit'])->name('attendance.edit');
        Route::post('attendance/store', [EmployeeAttendanceController::class, 'store'])->name('attendance.store');
        Route::post('attendance/update/{id}', [EmployeeAttendanceController::class, 'update'])->name('attendance.update');
        Route::delete('/attendance/delete/{id}', [EmployeeAttendanceController::class, 'destroy'])->name('attendance.delete');
    });

    // ============================================
    // EMPLOYEE DAILY REPORT ROUTES
    // ============================================
    Route::prefix('admin/employeedailyreports')->group(function () {
        Route::get('/', [EmployeeDailyReportController::class, 'index'])->name('employee.employeedailyreport');
        Route::post('/store', [EmployeeDailyReportController::class, 'store'])->name('employee.daily.store');
        Route::post('/update/{id}', [EmployeeDailyReportController::class, 'update'])->name('employee.daily.update');
        Route::delete('/delete/{id}', [EmployeeDailyReportController::class, 'destroy'])->name('employee.daily.delete');
        Route::post('/import', [EmployeeDailyReportController::class, 'import'])->name('employee.daily.import');
        Route::get('/edit/{id}', [EmployeeDailyReportController::class, 'edit'])->name('employee.daily.edit');
        Route::get('/calendar/{employee_id}/{month}', [EmployeeDailyReportController::class, 'calendar']);
        Route::get('/calendarview', [EmployeeDailyReportController::class, 'calendarView'])->name('employee.daily.calendar');
    });

    // ============================================
    // HOLIDAY ROUTES
    // ============================================
    Route::prefix('admin/holiday')->name('admin.holiday.')->group(function () {
        Route::get('/', [HolidayController::class, 'index'])->name('index');
        Route::get('/list', [HolidayController::class, 'list'])->name('list');
        Route::post('/store', [HolidayController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [HolidayController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [HolidayController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [HolidayController::class, 'destroy'])->name('destroy');
        Route::post('/toggle-status/{id}', [HolidayController::class, 'toggleStatus'])->name('toggle');
        Route::get('/upcoming', [HolidayController::class, 'upcoming'])->name('upcoming');
        Route::post('/import', [HolidayController::class, 'import'])->name('import');
    });

    // ============================================
    // LEAVE MANAGEMENT ROUTES
    // ============================================
    Route::prefix('admin/leave')->name('admin.leave.')->group(function () {
        Route::get('/', [LeaveController::class, 'index'])->name('index');
        Route::get('/list', [LeaveController::class, 'list'])->name('list');
        Route::post('/store', [LeaveController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [LeaveController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [LeaveController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [LeaveController::class, 'destroy'])->name('destroy');
        Route::post('/cancel/{id}', [LeaveController::class, 'cancel'])->name('cancel');
        Route::get('/pending', [LeaveController::class, 'pending'])->name('pending');
        Route::get('/balance/{employee_id}', [LeaveController::class, 'getBalance'])->name('balance');
        Route::post('/import', [LeaveController::class, 'import'])->name('import');
    });

    // ============================================
    // LEAVE BALANCE ROUTES
    // ============================================
    Route::prefix('admin/leave-balance')->name('admin.leave-balance.')->group(function () {
        Route::get('/', [LeaveController::class, 'balanceIndex'])->name('index');
        Route::post('/update', [LeaveController::class, 'updateBalance'])->name('update');
    });

    // ============================================
    // SALARY STRUCTURE ROUTES
    // ============================================
    Route::prefix('admin/salary-structure')->name('admin.salary-structure.')->group(function () {
        Route::get('/', [SalaryStructureController::class, 'index'])->name('index');
        Route::get('/list', [SalaryStructureController::class, 'list'])->name('list');
        Route::post('/store', [SalaryStructureController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [SalaryStructureController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [SalaryStructureController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [SalaryStructureController::class, 'destroy'])->name('destroy');
        Route::get('/breakdown/{employee_id}', [SalaryStructureController::class, 'getBreakdown'])->name('breakdown');
        Route::post('/deactivate/{id}', [SalaryStructureController::class, 'deactivate'])->name('deactivate');
        Route::post('/import', [SalaryStructureController::class, 'import'])->name('import');
    });

    // ============================================
    // PAYROLL ROUTES
    // ============================================
    Route::prefix('admin/payroll')->name('admin.payroll.')->group(function () {
        Route::get('/', [PayrollController::class, 'index'])->name('index');
        Route::get('/list', [PayrollController::class, 'list'])->name('list');
        Route::post('/generate', [PayrollController::class, 'generate'])->name('generate');
        Route::get('/edit/{id}', [PayrollController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [PayrollController::class, 'update'])->name('update');
        Route::delete('/delete/{id}', [PayrollController::class, 'destroy'])->name('destroy');
        Route::post('/submit/{id}', [PayrollController::class, 'submit'])->name('submit');
        Route::get('/payslip/{id}', [PayrollController::class, 'payslip'])->name('payslip');
        Route::get('/print-payslip/{id}', [PayrollController::class, 'printPayslip'])->name('print-payslip');
    });

    // ============================================
    // ACCOUNTS MANAGEMENT ROUTES
    // ============================================

    // Accounts Payable Routes
    Route::prefix('admin/accounts/payable')->name('admin.accounts.payable.')->group(function () {
        Route::get('/', [AccountsPayableController::class, 'index'])->name('index');
        Route::get('/aging', [AccountsPayableController::class, 'agingReport'])->name('aging');
        Route::get('/{id}', [AccountsPayableController::class, 'show'])->name('show');
        Route::post('/{id}/payment', [AccountsPayableController::class, 'recordPayment'])->name('payment');
        Route::get('/export/pdf', [AccountsPayableController::class, 'exportPdf'])->name('export');
    });

    // Accounts Receivable Routes
    Route::prefix('admin/accounts/receivable')->name('admin.accounts.receivable.')->group(function () {
        Route::get('/', [AccountsReceivableController::class, 'index'])->name('index');
        Route::get('/aging', [AccountsReceivableController::class, 'agingReport'])->name('aging');
        Route::get('/{id}', [AccountsReceivableController::class, 'show'])->name('show');
        Route::post('/{id}/payment', [AccountsReceivableController::class, 'recordPayment'])->name('payment');
    });

    // Financial Reports Routes
    Route::prefix('admin/accounts/reports')->name('admin.accounts.reports.')->group(function () {
        Route::get('/balance-sheet', [FinancialReportsController::class, 'balanceSheet'])->name('balance-sheet');
        Route::get('/profit-loss', [FinancialReportsController::class, 'profitLoss'])->name('profit-loss');
        Route::get('/cash-flow', [FinancialReportsController::class, 'cashFlow'])->name('cash-flow');
    });

    // ============================================
    // REPORTS ROUTES (Using Unified Controller)
    // ============================================
    Route::prefix('admin')->name('admin.report.')->group(function () {
        Route::any('employeereport', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'employeeReport'])->name('employeereport');
        Route::post('employeereport/export', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'exportEmployeeReport'])->name('employeereport.export');
        Route::any('customerreport', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'customerReport'])->name('customerreport');
        Route::post('customerreport/export', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'exportCustomerReport'])->name('customerreport.export');
        Route::any('machinereport', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'machineReport'])->name('machinereport');
        Route::post('machinereport/export', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'exportMachineReport'])->name('machinereport.export');
        Route::any('billreport', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'billReport'])->name('billreport');
        Route::post('billreport/export', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'exportBillReport'])->name('billreport.export');
        Route::any('inventoryreport', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'inventoryReport'])->name('inventoryreport');
        Route::post('inventoryreport/export', [\App\Http\Controllers\Modules\Reports\ReportController::class, 'exportInventoryReport'])->name('inventoryreport.export');
    });

    // ============================================
    // PROFILE ROUTES (Using Unified Controller)
    // ============================================
    Route::get('admin/profile', [\App\Http\Controllers\Modules\Profile\ProfileController::class, 'index'])->name('admin.profile.index');
    Route::put('admin/profile', [\App\Http\Controllers\Modules\Profile\ProfileController::class, 'updateProfile'])->name('admin.profile.update');
    Route::put('admin/profile/password', [\App\Http\Controllers\Modules\Profile\ProfileController::class, 'updatePassword'])->name('admin.profile.password');
});
