<?php

use App\Http\Controllers\V1\PurchaseQuotationController;
use App\Http\Controllers\V1\PurchaseController;
use App\Http\Controllers\V1\RouteCardController;
use App\Http\Controllers\V1\PurchaseOrderController;
use App\Http\Controllers\V1\SaleOrderController;
use Illuminate\Support\Facades\Route;

Route::prefix('superadmin')->name('superadmin.')->group(function () {

     // RouteCard Group
    Route::prefix('routecard')->name('routecard.')->group(function () {
        Route::get('order', [RouteCardController::class, 'index'])->name('index');
        Route::post('order', [RouteCardController::class, 'store'])->name('store');

        Route::get('details', [RouteCardController::class, 'details'])->name('details');
        Route::get('view/{id}', [RouteCardController::class, 'show'])->name('show');
        Route::get('edit/{id}', [RouteCardController::class, 'edit'])->name('edit');
        Route::put('update/{id}', [RouteCardController::class, 'update'])->name('update');
        Route::delete('{routecard}', [RouteCardController::class, 'destroy'])
            ->name('destroy')
            ->middleware('auth'); // Use API middleware instead of web/auth
         
        Route::post('{id}/approve', [RouteCardController::class, 'approve'])->name('approve');
        Route::post('{id}/reject', [RouteCardController::class, 'reject'])->name('reject');
        Route::get('{id}/status', [RouteCardController::class, 'checkStatus']) ->name('status');
        Route::post('{id}/ready-production', [RouteCardController::class, 'markReadyProduction'])->name('ready-production');

        Route::get('ganttchart', [RouteCardController::class, 'ganttChart'])->name('ganttchart');

        // Route::get('{routecard}/status', [RouteCardController::class, 'checkStatus'])->name('status');
        // Process sub-group


        Route::prefix('process')->name('process.')->group(function () {
            Route::post('update/{id}', [RouteCardController::class, 'processCreate'])->name('create');
            Route::delete('delete/{id}', [RouteCardController::class, 'processDelete'])->name('delete');
            
        });
    });
  
    // Manufacturing Group
    Route::prefix('manufacturing')->name('manufacturing.')->group(function () {
        Route::get('planning', [SaleOrderController::class, 'planning'])->name('planning');
        // Route::get('plan/{id}', [SaleOrderController::class, 'planPageWithId'])->name('plan.view');

        // Route::get('plan', [SaleOrderController::class, 'planPage'])->name('plan');

      // Project planning routes

    });
    // Purchase Quotation Group
    Route::prefix('purchasequotation')->name('purchasequotation.')->group(function () {
        Route::get('list', [PurchaseQuotationController::class, 'list'])->name('list');
        Route::get('index/{id?}', [PurchaseQuotationController::class, 'index'])->name('index');
        Route::post('store', [PurchaseQuotationController::class, 'store'])->name('store');
        Route::put('update/{id}', [PurchaseQuotationController::class, 'update'])->name('update');
        Route::get('show/{id}', [PurchaseQuotationController::class, 'show'])->name('show');
        Route::delete('destroy/{id}', [PurchaseQuotationController::class, 'destroy'])->name('destroy');
        Route::get('print/{id}', [PurchaseQuotationController::class, 'print'])->name('print');
        Route::get('approve/{id}', [PurchaseQuotationController::class, 'approve'])->name('approve');
        Route::get('reject/{id}', [PurchaseQuotationController::class, 'reject'])->name('reject');
        Route::post('delete-file', [PurchaseQuotationController::class, 'deleteFile'])->name('delete-file');
    });

    // Purchase Order Group
    Route::prefix('purchaseorder')->name('purchaseorder.')->group(function () {
        Route::get('list', [PurchaseOrderController::class, 'index'])->name('list');
        Route::get('create', [PurchaseOrderController::class, 'create'])->name('create');
        Route::get('edit/{id}', [PurchaseOrderController::class, 'edit'])->name('edit');
        Route::get('/{id?}', [PurchaseOrderController::class, 'index'])->name('index');
        Route::post('store', [PurchaseOrderController::class, 'store'])->name('store');
        Route::post('update/{id}', [PurchaseOrderController::class, 'update'])->name('update');
        Route::get('show/{id}', [PurchaseOrderController::class, 'show'])->name('show');
        Route::delete('destroy/{id}', [PurchaseOrderController::class, 'destroy'])->name('destroy');
        Route::get('print/{id}', [PurchaseOrderController::class, 'print'])->name('print');
        Route::get('approve/{id}', [PurchaseOrderController::class, 'approve'])->name('approve');
        Route::get('reject/{id}', [PurchaseOrderController::class, 'reject'])->name('reject');
        Route::get('item-row', [PurchaseOrderController::class, 'getItemRow'])->name('item-row');
        Route::get('quotation-details/{quotationNo}', [PurchaseOrderController::class, 'getQuotationDetails'])->name('quotation-details');
        Route::post('delete-file/{id}', [PurchaseOrderController::class, 'deleteFile'])->name('delete-file');
    });

    // Purchase Management Group - DISABLED (using main web.php routes instead)
    // Route::prefix('purchase')->name('purchase.v1.')->group(function () {
    //     Route::get('list', [PurchaseController::class, 'index'])->name('list');
    //     Route::get('vendor-payments-data', [PurchaseController::class, 'vendorPayments'])->name('vendorPayments');
    //     Route::get('show/{id}', [PurchaseController::class, 'show'])->name('show');
    //     Route::get('print/{id}', [PurchaseController::class, 'print'])->name('print');
    //     Route::get('approve/{id}', [PurchaseController::class, 'approve'])->name('approve');
    //     Route::get('reject/{id}', [PurchaseController::class, 'reject'])->name('reject');
    //     Route::get('delete-file/{id}', [PurchaseController::class, 'deleteFile'])->name('deleteFile');
    //     Route::post('/store', [PurchaseController::class, 'store'])->name('store');
    //     Route::post('/update/{id}', [PurchaseController::class, 'update'])->name('update');
    //     Route::delete('/destroy/{id}', [PurchaseController::class, 'destroy'])->name('destroy');
    //     Route::get('/{id?}', [PurchaseController::class, 'index'])->name('index');
    //
    //     // Credit Note routes
    //     Route::prefix('v1')->name('v1.')->group(function () {
    //         Route::get('credit-notes', [PurchaseController::class, 'creditNotes'])->name('creditNotes');
    //         Route::post('credit-notes/store', [PurchaseController::class, 'storeCreditNote'])->name('creditNotes.store');
    //         Route::put('credit-notes/update/{id}', [PurchaseController::class, 'updateCreditNote'])->name('creditNotes.update');
    //         Route::delete('credit-notes/destroy/{id}', [PurchaseController::class, 'destroyCreditNote'])->name('creditNotes.destroy');
    //         Route::get('credit-notes/get/{id}', [PurchaseController::class, 'getCreditNote'])->name('creditNotes.get');
    //         Route::get('credit-notes/next-number', [PurchaseController::class, 'getNextCreditNoteNumber'])->name('creditNotes.nextNumber');
    //     });
    //
    //     // Aging Report routes
    //     Route::get('aging-report', [PurchaseController::class, 'agingReport'])->name('agingReport');
    //     Route::get('aging-summary', [PurchaseController::class, 'agingSummary'])->name('agingSummary');
    //     Route::get('aging-export', [PurchaseController::class, 'exportAgingReport'])->name('agingExport');
    // });
});


?>