<!-- Header -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h6 class="m-0 font-weight-bold text-primary">Statement of Accounts</h6>
    <button class="btn btn-success btn-sm" id="printStatementBtn">
        <i class="fas fa-print mr-1"></i> Print / PDF
    </button>
</div>

<!-- Filter Section -->
<div class="filter-card">
    <div class="row">
        <div class="col-md-4 mb-2">
            <label class="small font-weight-bold">Customer <span class="text-danger">*</span></label>
            <select class="form-control form-control-sm" id="soa-party">
                <option value="">Select Customer</option>
                @foreach ($customers ?? [] as $customer)
                    <option value="{{ $customer->id }}">{{ $customer->company }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">From Date <span class="text-danger">*</span></label>
            <input type="date" class="form-control form-control-sm" id="soa-from-date" value="{{ date('Y-01-01') }}">
        </div>
        <div class="col-md-3 mb-2">
            <label class="small font-weight-bold">To Date <span class="text-danger">*</span></label>
            <input type="date" class="form-control form-control-sm" id="soa-to-date" value="{{ date('Y-m-d') }}">
        </div>
        <div class="col-md-2 d-flex align-items-end mb-2">
            <button class="btn btn-primary btn-sm btn-block" id="generateSOABtn">
                <i class="fas fa-search mr-1"></i> Generate
            </button>
        </div>
    </div>
</div>

<!-- SOA Table -->
<div class="table-responsive">
    <table class="table table-bordered table-striped table-sm w-100" id="soaTable">
        <thead class="thead-light">
            <tr>
                <th>Date</th>
                <th>Type</th>
                <th>Reference No</th>
                <th>Description</th>
                <th class="text-right">Debit (₹)</th>
                <th class="text-right">Credit (₹)</th>
                <th class="text-right">Balance (₹)</th>
            </tr>
        </thead>
        <tbody id="soaTableBody">
            <tr>
                <td colspan="7" class="text-center text-muted">Select a customer and click Generate</td>
            </tr>
        </tbody>
        <tfoot class="bg-light font-weight-bold">
            <tr>
                <td colspan="4" class="text-right">Total</td>
                <td class="text-right" id="soaTotalDebit">0.00</td>
                <td class="text-right" id="soaTotalCredit">0.00</td>
                <td class="text-right" id="soaFinalBalance">0.00</td>
            </tr>
        </tfoot>
    </table>
</div>

<div id="soaPrintArea" class="d-none">
    <!-- Hidden Print Area (To be populated by JS for printing) -->
</div>
