@extends('layouts.dashboard.superadminapp')

@section('title', 'Sales Management')

@section('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap4.min.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style>
    .summary-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
    }
    .summary-card .card-body {
        padding: 1rem;
    }
    .summary-icon {
        font-size: 2rem;
        opacity: 0.3;
    }
    .section-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
    }
    .section-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.75rem 1rem;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .nav-pills .nav-link {
        color: #4e73df;
        font-weight: 500;
        border-radius: 0.35rem;
    }
    .nav-pills .nav-link.active {
        background-color: #4e73df;
        color: #fff;
    }
    .nav-pills .nav-link:hover:not(.active) {
        background-color: #eaecf4;
    }
    .filter-card {
        background: #f8f9fc;
        border-radius: 0.5rem;
        padding: 1rem;
        margin-bottom: 1rem;
    }
    .table th, .table td {
        font-size: 0.85rem;
        padding: 0.5rem !important;
        vertical-align: middle;
    }
    .table-actions .btn {
        padding: 0.2rem 0.4rem;
        font-size: 0.75rem;
        margin: 0 1px;
    }
    .badge {
        font-size: 0.75rem;
    }
    .dt-buttons {
        margin-bottom: 10px;
    }
    .dt-buttons .btn {
        font-size: 0.8rem;
        padding: 0.25rem 0.5rem;
    }
    .select2-container {
        z-index: 9999 !important;
    }
    .select2-container--default .select2-selection--single {
        height: 38px;
        padding: 5px;
        border: 1px solid #d1d3e2;
        border-radius: 0.35rem;
    }
    table input.form-control {
        text-align: right;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <x-layout.page-header title="UEPL | Sales Management" icon="chart-bar" iconColor="success" />

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Main Card -->
    <div class="card section-card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span><i class="fas fa-file-invoice-dollar mr-2"></i>Sales Management</span>
        </div>
        <div class="card-body">
            <!-- Nav Pills -->
            <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="pills-payment-tab" data-toggle="pill"
                        href="#pills-payment" role="tab" onclick="loadPaymentTableAgain()">
                        <i class="fas fa-money-check-alt mr-1"></i> Customer Payments
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="pills-credit-tab" data-toggle="pill" href="#pills-credit" role="tab">
                        <i class="fas fa-file-invoice mr-1"></i> Credit Notes
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="pills-debit-tab" data-toggle="pill" href="#pills-debit" role="tab">
                        <i class="fas fa-file-invoice-dollar mr-1"></i> Debit Notes
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="pills-soa-tab" data-toggle="pill" href="#pills-soa" role="tab">
                        <i class="fas fa-list-alt mr-1"></i> Statement of Accounts
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="pills-receipts-tab" data-toggle="pill" href="#pills-receipts" role="tab">
                        <i class="fas fa-receipt mr-1"></i> Receipts
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="pills-aging-tab" data-toggle="pill" href="#pills-aging" role="tab">
                        <i class="fas fa-chart-bar mr-1"></i> Aging Report
                    </a>
                </li>
            </ul>

            <!-- Tab Content -->
            <div class="tab-content" id="pills-tabContent">
                <!-- Customer Payments Tab -->
                <div class="tab-pane fade show active" id="pills-payment" role="tabpanel">
                    @include('superadmin.salesmanagement.partials.customer-payments-tab')
                </div>

                <!-- Credit Notes Tab -->
                <div class="tab-pane fade" id="pills-credit" role="tabpanel">
                    @include('superadmin.salesmanagement.partials.creditnotes-tab')
                </div>

                <!-- Debit Notes Tab -->
                <div class="tab-pane fade" id="pills-debit" role="tabpanel">
                    @include('superadmin.salesmanagement.partials.debit-notes-tab')
                </div>

                <!-- Statement of Accounts Tab -->
                <div class="tab-pane fade" id="pills-soa" role="tabpanel">
                    @include('superadmin.salesmanagement.partials.statement-tab')
                </div>

                <!-- Receipts Tab -->
                <div class="tab-pane fade" id="pills-receipts" role="tabpanel">
                    @include('superadmin.salesmanagement.partials.receipts-tab')
                </div>

                <!-- Aging Report Tab -->
                <div class="tab-pane fade" id="pills-aging" role="tabpanel">
                    @include('superadmin.salesmanagement.partials.age-reporting-tab')
                </div>
            </div>
        </div>
    </div>

@include('superadmin.salesmanagement.partials.scripts')
@endsection
