@extends('layouts.dashboard.superadminapp')

@section('title', 'RFQ Details')

@section('styles')
<style>
    /* ========== Page Header ========== */
    .page-header {
        background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 1rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.08);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2c3e50;
        margin: 0;
    }
    .page-header h1 i { margin-right: 0.5rem; }
    .datetime-display {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        font-size: 0.75rem;
        color: #6c757d;
    }
    .datetime-display i { margin-right: 0.25rem; color: #858796; }
    .datetime-display .time-box {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-weight: 500;
    }

    /* ========== RFQ Header ========== */
    .rfq-header {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        color: white;
        padding: 1rem 1.25rem;
        border-radius: 8px;
        margin-bottom: 1rem;
        box-shadow: 0 4px 15px rgba(17, 153, 142, 0.3);
    }
    .rfq-header h3 {
        font-size: 1.1rem;
        font-weight: 700;
        margin-bottom: 0.25rem;
    }
    .rfq-header .company-name {
        font-size: 0.85rem;
        opacity: 0.9;
        margin-bottom: 0.5rem;
    }
    .rfq-header .badge-status {
        background: rgba(255,255,255,0.2);
        color: white;
        font-size: 0.7rem;
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-weight: 500;
    }
    .rfq-header .badge-status i { margin-right: 0.25rem; }
    .rfq-header .btn {
        padding: 0.35rem 0.75rem;
        font-size: 0.75rem;
        border-radius: 5px;
        font-weight: 500;
    }

    /* ========== Quick Info Cards ========== */
    .quick-info-card {
        background: white;
        border-radius: 8px;
        padding: 0.75rem;
        box-shadow: 0 2px 8px rgba(0,0,0,0.06);
        height: 100%;
        display: flex;
        align-items: center;
        gap: 0.75rem;
        transition: all 0.2s ease;
    }
    .quick-info-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .quick-info-icon {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1rem;
        flex-shrink: 0;
    }
    .quick-info-icon.purple { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
    .quick-info-icon.cyan { background: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%); color: white; }
    .quick-info-icon.orange { background: linear-gradient(135deg, #f6d365 0%, #fda085 100%); color: #7c4a03; }
    .quick-info-icon.green { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); color: white; }
    .quick-info-content .label {
        font-size: 0.65rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        color: #858796;
        margin-bottom: 0.125rem;
    }
    .quick-info-content .value {
        font-size: 0.85rem;
        font-weight: 600;
        color: #2c3e50;
        line-height: 1.2;
    }

    /* ========== Detail Cards ========== */
    .detail-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.06);
        overflow: hidden;
        margin-bottom: 1rem;
    }
    .detail-card .card-header {
        padding: 0.625rem 1rem;
        font-size: 0.8rem;
        font-weight: 600;
        border: none;
        color: white;
    }
    .detail-card .card-header i { margin-right: 0.5rem; opacity: 0.85; }
    .detail-card .card-header.bg-primary-gradient {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }
    .detail-card .card-header.bg-info-gradient {
        background: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%);
    }
    .detail-card .card-header.bg-success-gradient {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    }
    .detail-card .card-header.bg-warning-gradient {
        background: linear-gradient(135deg, #f6d365 0%, #fda085 100%);
        color: #7c4a03;
    }
    .detail-card .card-header.bg-secondary-gradient {
        background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
    }
    .detail-card .card-body {
        padding: 0.75rem 1rem;
    }

    /* ========== Detail Grid ========== */
    .detail-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 0.5rem;
    }
    .detail-item {
        display: flex;
        padding: 0.375rem 0;
        border-bottom: 1px solid #f1f5f9;
    }
    .detail-item:last-child { border-bottom: none; }
    .detail-label {
        font-size: 0.75rem;
        font-weight: 600;
        color: #64748b;
        min-width: 120px;
        flex-shrink: 0;
    }
    .detail-value {
        font-size: 0.8rem;
        color: #334155;
        word-break: break-word;
    }
    .detail-value strong { color: #1e293b; }

    /* ========== Status Badges ========== */
    .badge-status-inline {
        padding: 0.2rem 0.5rem;
        border-radius: 4px;
        font-size: 0.65rem;
        font-weight: 600;
        text-transform: uppercase;
    }
    .badge-status-inline.approved {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        color: white;
    }
    .badge-status-inline.rejected {
        background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%);
        color: white;
    }
    .badge-status-inline.pending {
        background: linear-gradient(135deg, #f6d365 0%, #fda085 100%);
        color: #7c4a03;
    }

    /* ========== Material Badges ========== */
    .material-badge {
        display: inline-flex;
        align-items: center;
        padding: 0.35rem 0.625rem;
        background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
        border-radius: 5px;
        color: #5a5c69;
        font-size: 0.75rem;
        margin: 0.2rem;
        border: 1px solid #e3e6f0;
    }
    .material-badge i { margin-right: 0.375rem; color: #11998e; }

    /* ========== File Links ========== */
    .file-link {
        display: inline-flex;
        align-items: center;
        padding: 0.35rem 0.625rem;
        background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
        border-radius: 5px;
        color: #667eea;
        text-decoration: none;
        font-size: 0.75rem;
        margin: 0.2rem;
        transition: all 0.2s ease;
        border: 1px solid #e3e6f0;
    }
    .file-link:hover {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        text-decoration: none;
        border-color: transparent;
        transform: translateY(-1px);
    }
    .file-link i { margin-right: 0.375rem; }

    /* ========== File Section ========== */
    .file-section-title {
        font-size: 0.7rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        color: #64748b;
        margin-bottom: 0.5rem;
    }
    .file-section-title i { margin-right: 0.375rem; }

    /* ========== Action Buttons ========== */
    .btn-gradient-secondary {
        background: linear-gradient(135deg, #64748b 0%, #475569 100%);
        border: none;
        color: white;
        padding: 0.5rem 1rem;
        font-size: 0.8rem;
        border-radius: 6px;
        font-weight: 500;
        transition: all 0.2s ease;
    }
    .btn-gradient-secondary:hover {
        background: linear-gradient(135deg, #475569 0%, #334155 100%);
        color: white;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(71, 85, 105, 0.3);
    }
    .btn-gradient-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        color: white;
        padding: 0.5rem 1rem;
        font-size: 0.8rem;
        border-radius: 6px;
        font-weight: 500;
        transition: all 0.2s ease;
    }
    .btn-gradient-primary:hover {
        background: linear-gradient(135deg, #5a6fd6 0%, #6a4190 100%);
        color: white;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    }

    /* ========== Notes ========== */
    .note-text {
        font-size: 0.85rem;
        color: #5a5c69;
        line-height: 1.6;
        background: #fffbeb;
        padding: 0.75rem;
        border-radius: 6px;
        border-left: 3px solid #f6d365;
    }

    /* ========== Responsive ========== */
    @media (max-width: 768px) {
        .detail-grid { grid-template-columns: 1fr; }
        .rfq-header { padding: 0.875rem 1rem; }
        .rfq-header h3 { font-size: 1rem; }
        .datetime-display { flex-wrap: wrap; gap: 0.5rem; }
    }
</style>
@endsection

@section('content')
    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-file-alt text-info"></i>UEPL | RFQ Details</h1>
        <div class="datetime-display">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">Day</span>, <span id="daynum">00</span> <span id="month">Month</span> <span id="year">0000</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time">00:00:00</span>
            </div>
        </div>
    </div>

    <!-- RFQ Header Card -->
    <div class="rfq-header">
        <div class="d-flex justify-content-between align-items-start flex-wrap">
            <div>
                <h3>{{ $rfq->rfq_no }}</h3>
                <p class="company-name mb-2">{{ $rfq->customerInfo->company ?? 'N/A' }}</p>
                <div class="d-flex flex-wrap align-items-center gap-2">
                    @if ($rfq->status == 'approved')
                        <span class="badge-status"><i class="fas fa-check-circle"></i> Approved</span>
                    @elseif ($rfq->status == 'rejected')
                        <span class="badge-status"><i class="fas fa-times-circle"></i> Rejected</span>
                    @else
                        <span class="badge-status"><i class="fas fa-clock"></i> Pending</span>
                    @endif
                    <span class="badge-status"><i class="fas fa-calendar"></i> {{ \Carbon\Carbon::parse($rfq->rfq_date)->format('d M Y') }}</span>
                </div>
            </div>
            <div class="mt-2 mt-md-0">
                <a href="{{ route('superadmin.salesbom.rfq.edit', $rfq->id) }}" class="btn btn-light mr-1">
                    <i class="fas fa-edit mr-1"></i> Edit
                </a>
                <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="btn btn-outline-light">
                    <i class="fas fa-arrow-left mr-1"></i> Back
                </a>
            </div>
        </div>
    </div>

    <!-- Quick Info Cards -->
    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-2 mb-xl-0">
            <div class="quick-info-card">
                <div class="quick-info-icon purple">
                    <i class="fas fa-box"></i>
                </div>
                <div class="quick-info-content">
                    <div class="label">RFQ Type</div>
                    <div class="value">{{ $rfq->rfq_type ?: '-' }}</div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-2 mb-xl-0">
            <div class="quick-info-card">
                <div class="quick-info-icon cyan">
                    <i class="fas fa-cube"></i>
                </div>
                <div class="quick-info-content">
                    <div class="label">Product Type</div>
                    <div class="value">{{ $rfq->product_type ?: '-' }}</div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-2 mb-md-0">
            <div class="quick-info-card">
                <div class="quick-info-icon orange">
                    <i class="fas fa-hashtag"></i>
                </div>
                <div class="quick-info-content">
                    <div class="label">Part No</div>
                    <div class="value">{{ $rfq->part_no ?: '-' }}</div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="quick-info-card">
                <div class="quick-info-icon green">
                    <i class="fas fa-layer-group"></i>
                </div>
                <div class="quick-info-content">
                    <div class="label">Quantity</div>
                    <div class="value">{{ $rfq->quantity }} {{ $rfq->uom }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- RFQ Information Card -->
        <div class="col-lg-6">
            <div class="card detail-card">
                <div class="card-header bg-primary-gradient">
                    <i class="fas fa-file-alt"></i> RFQ Information
                </div>
                <div class="card-body">
                    <div class="detail-grid">
                        <div class="detail-item">
                            <span class="detail-label">RFQ No</span>
                            <span class="detail-value"><strong>{{ $rfq->rfq_no }}</strong></span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">RFQ Date</span>
                            <span class="detail-value">{{ \Carbon\Carbon::parse($rfq->rfq_date)->format('d-m-Y') }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Customer</span>
                            <span class="detail-value">{{ $rfq->customerInfo->company ?? '-' }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Customer Ref</span>
                            <span class="detail-value">{{ $rfq->cus_ref_no ?: '-' }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">RFQ Type</span>
                            <span class="detail-value">{{ $rfq->rfq_type ?: '-' }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Product Type</span>
                            <span class="detail-value">{{ $rfq->product_type ?: '-' }}</span>
                        </div>
                        <div class="detail-item" style="grid-column: 1 / -1;">
                            <span class="detail-label">Status</span>
                            <span class="detail-value">
                                @if ($rfq->status == 'approved')
                                    <span class="badge-status-inline approved">Approved</span>
                                @elseif ($rfq->status == 'rejected')
                                    <span class="badge-status-inline rejected">Rejected</span>
                                @else
                                    <span class="badge-status-inline pending">Pending</span>
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Product Details Card -->
        <div class="col-lg-6">
            <div class="card detail-card">
                <div class="card-header bg-info-gradient">
                    <i class="fas fa-cube"></i> Product Details
                </div>
                <div class="card-body">
                    <div class="detail-grid">
                        <div class="detail-item">
                            <span class="detail-label">Part No</span>
                            <span class="detail-value">{{ $rfq->part_no ?: '-' }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Project/Material</span>
                            <span class="detail-value">{{ $rfq->project_material_no ?: '-' }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Drawing No</span>
                            <span class="detail-value">{{ $rfq->drawing_no ?: '-' }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Drawing Rev</span>
                            <span class="detail-value">{{ $rfq->drawing_rev ?: '-' }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Quantity</span>
                            <span class="detail-value"><strong>{{ $rfq->quantity }}</strong> {{ $rfq->uom }}</span>
                        </div>
                        <div class="detail-item" style="grid-column: 1 / -1;">
                            <span class="detail-label">Description</span>
                            <span class="detail-value">{{ $rfq->description ?: '-' }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Raw Materials Card -->
    <div class="card detail-card">
        <div class="card-header bg-success-gradient">
            <i class="fas fa-layer-group"></i> Raw Materials
        </div>
        <div class="card-body">
            @php
                $rawMaterials = json_decode($rfq->raw_material, true);
            @endphp
            @if (is_array($rawMaterials) && count($rawMaterials))
                <div class="d-flex flex-wrap">
                    @foreach ($rawMaterials as $matId)
                        <span class="material-badge">
                            <i class="fas fa-check-circle"></i>
                            {{ $rawMaterialNames[$matId] ?? 'Unknown Material (ID: '.$matId.')' }}
                        </span>
                    @endforeach
                </div>
            @else
                <p class="text-muted mb-0" style="font-size: 0.85rem;"><i class="fas fa-info-circle mr-1"></i> No raw materials specified</p>
            @endif
        </div>
    </div>

    <!-- Note Card -->
    @if($rfq->note)
    <div class="card detail-card">
        <div class="card-header bg-warning-gradient">
            <i class="fas fa-sticky-note"></i> Notes
        </div>
        <div class="card-body">
            <div class="note-text">{{ $rfq->note }}</div>
        </div>
    </div>
    @endif

    <!-- Attachments Card -->
    <div class="card detail-card">
        <div class="card-header bg-secondary-gradient">
            <i class="fas fa-paperclip"></i> Attachments
        </div>
        <div class="card-body">
            @php
                $fileTypes = [
                    'drawing' => ['label' => 'Drawing Files', 'icon' => 'fa-drafting-compass'],
                    'material_spec' => ['label' => 'Material Spec', 'icon' => 'fa-file-alt'],
                    'rfq_form' => ['label' => 'RFQ Form', 'icon' => 'fa-file-invoice'],
                    'annexure' => ['label' => 'Annexure', 'icon' => 'fa-file-archive']
                ];
                $hasFiles = false;
            @endphp

            <div class="row">
                @foreach ($fileTypes as $type => $info)
                    @php
                        $files = $rfq->rfqFiles->where('file_type', $type);
                    @endphp
                    @if ($files->count())
                        @php $hasFiles = true; @endphp
                        <div class="col-md-6 col-lg-3 mb-3">
                            <div class="file-section-title">
                                <i class="fas {{ $info['icon'] }}"></i> {{ $info['label'] }}
                            </div>
                            @foreach ($files as $file)
                                <a href="{{ asset('storage/' . $file->file_path) }}"
                                   target="_blank"
                                   class="file-link"
                                   title="{{ $file->file_name }}">
                                   <i class="fas fa-external-link-alt"></i>
                                   {{ Str::limit($file->file_name, 18) }}
                                </a>
                            @endforeach
                        </div>
                    @endif
                @endforeach
            </div>

            @if(!$hasFiles)
                <p class="text-muted mb-0" style="font-size: 0.85rem;"><i class="fas fa-info-circle mr-1"></i> No attachments available</p>
            @endif
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex justify-content-between">
        <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="btn btn-gradient-secondary">
            <i class="fas fa-arrow-left mr-1"></i> Back to List
        </a>
        <a href="{{ route('superadmin.salesbom.rfq.edit', $rfq->id) }}" class="btn btn-gradient-primary">
            <i class="fas fa-edit mr-1"></i> Edit RFQ
        </a>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // DateTime Display
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        $('#day').text(days[now.getDay()]);
        $('#daynum').text(now.getDate().toString().padStart(2, '0'));
        $('#month').text(months[now.getMonth()]);
        $('#year').text(now.getFullYear());
        $('.display-time').text(now.toLocaleTimeString('en-US', { hour12: false }));
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);
});
</script>
@endsection
