@extends('layouts.dashboard.superadminapp')

@section('title', 'RFQ List')

@section('styles')
<style>
    /* ========== Page Header ========== */
    .page-header {
        background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 1rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.08);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2c3e50;
        margin: 0;
    }
    .page-header h1 i { margin-right: 0.5rem; }
    .datetime-display {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        font-size: 0.75rem;
        color: #6c757d;
    }
    .datetime-display i { margin-right: 0.25rem; color: #858796; }
    .datetime-display .time-box {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-weight: 500;
    }

    /* ========== KPI Cards ========== */
    .kpi-card {
        border-radius: 8px;
        border: none;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        overflow: hidden;
        transition: all 0.2s ease;
    }
    .kpi-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(0,0,0,0.12);
    }
    .kpi-card .card-body {
        padding: 0.875rem 1rem;
    }
    .kpi-card.total { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
    .kpi-card.pending { background: linear-gradient(135deg, #f6d365 0%, #fda085 100%); }
    .kpi-card.approved { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }
    .kpi-card.rejected { background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%); }
    .kpi-card .kpi-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(255,255,255,0.2);
        color: white;
        font-size: 1rem;
    }
    .kpi-card .kpi-label {
        font-size: 0.65rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        color: rgba(255,255,255,0.85);
        margin-bottom: 0.125rem;
    }
    .kpi-card .kpi-value {
        font-size: 1.25rem;
        font-weight: 700;
        color: white;
        line-height: 1;
    }

    /* ========== Quick Actions ========== */
    .quick-actions {
        background: linear-gradient(135deg, #f8f9fc 0%, #fff 100%);
        border-radius: 8px;
        padding: 0.75rem 1rem;
        margin-bottom: 1rem;
        border: 1px solid #e3e6f0;
    }
    .quick-actions-title {
        font-size: 0.7rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        color: #858796;
        margin-bottom: 0.5rem;
    }
    .quick-actions .btn {
        padding: 0.375rem 0.75rem;
        font-size: 0.75rem;
        border-radius: 6px;
        font-weight: 500;
        transition: all 0.2s ease;
    }
    .quick-actions .btn:hover { transform: translateY(-1px); }
    .btn-gradient-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        color: white;
    }
    .btn-gradient-primary:hover {
        background: linear-gradient(135deg, #5a6fd6 0%, #6a4190 100%);
        color: white;
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    }
    .btn-gradient-success {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        border: none;
        color: white;
    }
    .btn-gradient-success:hover {
        background: linear-gradient(135deg, #0d7d74 0%, #2ed96d 100%);
        color: white;
        box-shadow: 0 4px 12px rgba(17, 153, 142, 0.4);
    }
    .btn-gradient-info {
        background: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%);
        border: none;
        color: white;
    }
    .btn-gradient-info:hover {
        background: linear-gradient(135deg, #2bb8c4 0%, #4a75d4 100%);
        color: white;
        box-shadow: 0 4px 12px rgba(54, 209, 220, 0.4);
    }

    /* ========== Table Card ========== */
    .table-card {
        border-radius: 8px;
        border: none;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        overflow: hidden;
    }
    .table-card .card-header {
        background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
        color: white;
        padding: 0.625rem 1rem;
        border: none;
    }
    .table-card .card-header .header-title {
        font-size: 0.8rem;
        font-weight: 600;
        margin: 0;
    }
    .table-card .card-header .header-title i {
        margin-right: 0.5rem;
        opacity: 0.8;
    }
    .table-card .card-body { padding: 0.75rem; }

    /* ========== DataTable ========== */
    #rfqTable { width: 100% !important; }
    #rfqTable thead th {
        background: linear-gradient(135deg, #f8f9fc 0%, #e3e6f0 100%);
        font-size: 0.7rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        color: #5a5c69;
        padding: 0.625rem 0.5rem !important;
        border-bottom: 2px solid #dee2e6;
        white-space: nowrap;
    }
    #rfqTable tbody td {
        font-size: 0.8rem;
        padding: 0.5rem !important;
        vertical-align: middle;
        color: #5a5c69;
    }
    #rfqTable tbody tr:hover { background: #f8f9fc; }

    /* Status Badges */
    .badge-status {
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-size: 0.65rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }
    .badge-status.pending {
        background: linear-gradient(135deg, #f6d365 0%, #fda085 100%);
        color: #7c4a03;
    }
    .badge-status.approved {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        color: white;
    }
    .badge-status.rejected {
        background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%);
        color: white;
    }

    /* Action Buttons */
    .table-actions .btn {
        padding: 0.25rem 0.375rem;
        font-size: 0.7rem;
        border-radius: 4px;
        margin: 0 1px;
        transition: all 0.15s ease;
    }
    .table-actions .btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }
    .btn-action-view {
        background: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%);
        border: none;
        color: white;
    }
    .btn-action-edit {
        background: linear-gradient(135deg, #f6d365 0%, #fda085 100%);
        border: none;
        color: #7c4a03;
    }
    .btn-action-approve {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        border: none;
        color: white;
    }
    .btn-action-reject {
        background: linear-gradient(135deg, #858796 0%, #6c757d 100%);
        border: none;
        color: white;
    }
    .btn-action-delete {
        background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%);
        border: none;
        color: white;
    }

    /* DataTable Controls */
    div.dt-buttons {
        margin-bottom: 0.5rem;
    }
    .dt-buttons .btn {
        padding: 0.25rem 0.5rem !important;
        font-size: 0.7rem !important;
        border-radius: 4px !important;
        margin-right: 0.25rem !important;
        background: white !important;
        border: 1px solid #dee2e6 !important;
        color: #5a5c69 !important;
        font-weight: 500;
        transition: all 0.15s ease;
    }
    .dt-buttons .btn:hover {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        border-color: transparent !important;
        color: white !important;
    }
    .dataTables_filter input {
        border-radius: 6px !important;
        border: 1px solid #dee2e6 !important;
        padding: 0.375rem 0.75rem !important;
        font-size: 0.8rem !important;
        transition: all 0.15s ease;
    }
    .dataTables_filter input:focus {
        border-color: #667eea !important;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.15) !important;
        outline: none;
    }
    .dataTables_info { font-size: 0.75rem; color: #858796; }
    .dataTables_paginate .paginate_button {
        padding: 0.25rem 0.5rem !important;
        font-size: 0.75rem !important;
        border-radius: 4px !important;
        margin: 0 2px !important;
    }
    .dataTables_paginate .paginate_button.current {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        border-color: transparent !important;
        color: white !important;
    }
    .dataTables_paginate .paginate_button:hover:not(.current) {
        background: #f8f9fc !important;
        border-color: #dee2e6 !important;
        color: #5a5c69 !important;
    }

    /* ========== Modals ========== */
    .modal-content {
        border-radius: 10px;
        border: none;
        box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        overflow: hidden;
    }
    .modal-header {
        padding: 0.75rem 1rem;
        border: none;
    }
    .modal-header.modal-header-danger {
        background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%);
        color: white;
    }
    .modal-header.modal-header-success {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        color: white;
    }
    .modal-header.modal-header-secondary {
        background: linear-gradient(135deg, #858796 0%, #6c757d 100%);
        color: white;
    }
    .modal-header .modal-title {
        font-size: 0.85rem;
        font-weight: 600;
    }
    .modal-header .close {
        color: white;
        opacity: 0.8;
        text-shadow: none;
        font-size: 1.25rem;
        padding: 0;
        margin: 0;
    }
    .modal-header .close:hover { opacity: 1; }
    .modal-body {
        padding: 1rem;
        font-size: 0.85rem;
    }
    .modal-footer {
        padding: 0.625rem 1rem;
        border-top: 1px solid #e3e6f0;
        background: #f8f9fc;
    }
    .modal-footer .btn {
        padding: 0.375rem 0.875rem;
        font-size: 0.75rem;
        border-radius: 5px;
        font-weight: 500;
    }

    /* ========== Toast Notifications ========== */
    .toast-container {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
    }
    .custom-toast {
        min-width: 280px;
        border-radius: 8px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.15);
        animation: slideInRight 0.3s ease;
        overflow: hidden;
    }
    .custom-toast.toast-success {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    }
    .custom-toast.toast-error {
        background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%);
    }
    .custom-toast .toast-body {
        padding: 0.75rem 1rem;
        color: white;
        font-size: 0.8rem;
        font-weight: 500;
    }
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }

    /* ========== Responsive ========== */
    @media (max-width: 768px) {
        .kpi-card .card-body { padding: 0.625rem; }
        .kpi-card .kpi-value { font-size: 1rem; }
        .quick-actions { flex-wrap: wrap; }
        .datetime-display { flex-wrap: wrap; gap: 0.5rem; }
    }
</style>
@endsection

@section('content')
    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-file-alt text-info"></i>UEPL | RFQ List</h1>
        <div class="datetime-display">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">Day</span>, <span id="daynum">00</span> <span id="month">Month</span> <span id="year">0000</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time">00:00:00</span>
            </div>
        </div>
    </div>

    <!-- KPI Summary Cards -->
    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-3 mb-xl-0">
            <div class="card kpi-card total">
                <div class="card-body d-flex align-items-center justify-content-between">
                    <div>
                        <div class="kpi-label">Total RFQs</div>
                        <div class="kpi-value">{{ $rfqs->count() }}</div>
                    </div>
                    <div class="kpi-icon">
                        <i class="fas fa-file-alt"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-3 mb-xl-0">
            <div class="card kpi-card pending">
                <div class="card-body d-flex align-items-center justify-content-between">
                    <div>
                        <div class="kpi-label">Pending</div>
                        <div class="kpi-value">{{ $rfqs->where('status', 'pending')->count() }}</div>
                    </div>
                    <div class="kpi-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-3 mb-md-0">
            <div class="card kpi-card approved">
                <div class="card-body d-flex align-items-center justify-content-between">
                    <div>
                        <div class="kpi-label">Approved</div>
                        <div class="kpi-value">{{ $rfqs->where('status', 'approved')->count() }}</div>
                    </div>
                    <div class="kpi-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card kpi-card rejected">
                <div class="card-body d-flex align-items-center justify-content-between">
                    <div>
                        <div class="kpi-label">Rejected</div>
                        <div class="kpi-value">{{ $rfqs->where('status', 'rejected')->count() }}</div>
                    </div>
                    <div class="kpi-icon">
                        <i class="fas fa-times-circle"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions d-flex align-items-center justify-content-between flex-wrap">
        <div class="quick-actions-title mb-2 mb-md-0">Quick Actions</div>
        <div class="d-flex flex-wrap gap-2">
            <a href="{{ route('superadmin.salesbom.rfq.rfq') }}" class="btn btn-gradient-primary">
                <i class="fas fa-plus mr-1"></i> New RFQ
            </a>
            <a href="{{ route('superadmin.salesbom.quotation.quotationdetails') }}" class="btn btn-gradient-success">
                <i class="fas fa-file-invoice mr-1"></i> Quotations
            </a>
            <a href="{{ route('superadmin.customer.customerlist') }}" class="btn btn-gradient-info">
                <i class="fas fa-users mr-1"></i> Customers
            </a>
        </div>
    </div>

    <!-- Table Section -->
    <div class="card table-card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="header-title mb-0"><i class="fas fa-table"></i>RFQ Data</h6>
            <a href="{{ route('superadmin.salesbom.rfq.rfq') }}" class="btn btn-sm btn-light">
                <i class="fa fa-plus-square mr-1"></i> Add RFQ
            </a>
        </div>
        <div class="card-body">
            <table class="table table-hover" id="rfqTable">
                <thead>
                    <tr class="text-center">
                        <th style="width: 5%;">#</th>
                        <th style="width: 13%;">RFQ No</th>
                        <th style="width: 10%;">Date</th>
                        <th style="width: 20%;">Customer</th>
                        <th style="width: 10%;">Part No</th>
                        <th style="width: 8%;">Qty</th>
                        <th style="width: 8%;">Status</th>
                        <th style="width: 16%;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($rfqs as $index => $rfq)
                        <tr id="row-{{ $rfq->id }}" class="text-center">
                            <td>{{ $index + 1 }}</td>
                            <td><strong class="text-primary">{{ $rfq->rfq_no }}</strong></td>
                            <td>{{ \Carbon\Carbon::parse($rfq->rfq_date)->format('d-m-Y') }}</td>
                            <td class="text-left">
                                <span title="{{ $rfq->customerInfo ? $rfq->customerInfo->company : '-' }}">
                                    {{ $rfq->customerInfo ? Str::limit($rfq->customerInfo->company, 28) : '-' }}
                                </span>
                            </td>
                            <td>{{ $rfq->part_no ?: '-' }}</td>
                            <td>{{ $rfq->quantity }} {{ $rfq->uom }}</td>
                            <td>
                                @if($rfq->status == 'approved')
                                    <span class="badge-status approved">Approved</span>
                                @elseif($rfq->status == 'rejected')
                                    <span class="badge-status rejected">Rejected</span>
                                @else
                                    <span class="badge-status pending">Pending</span>
                                @endif
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="{{ route('superadmin.salesbom.rfq.view', $rfq->id) }}"
                                        class="btn btn-action-view" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a href="{{ route('superadmin.salesbom.rfq.edit', $rfq->id) }}"
                                        class="btn btn-action-edit" title="Edit">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    @if ($rfq->status === 'pending')
                                        <button class="btn btn-action-approve approve-btn"
                                            data-id="{{ $rfq->id }}" data-no="{{ $rfq->rfq_no }}" title="Approve">
                                            <i class="fa fa-check"></i>
                                        </button>
                                        <button class="btn btn-action-reject reject-btn"
                                            data-id="{{ $rfq->id }}" data-no="{{ $rfq->rfq_no }}" title="Reject">
                                            <i class="fa fa-times"></i>
                                        </button>
                                    @endif
                                    <button class="btn btn-action-delete delete-btn"
                                        data-id="{{ $rfq->id }}" data-no="{{ $rfq->rfq_no }}" title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header modal-header-danger">
                    <h6 class="modal-title mb-0"><i class="fas fa-exclamation-triangle mr-2"></i>Delete RFQ</h6>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="mb-1">Are you sure you want to delete this RFQ?</p>
                    <p class="mb-2"><strong id="deleteItemNo" class="text-primary"></strong></p>
                    <small class="text-muted">This action cannot be undone. All related files will also be deleted.</small>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">Delete</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Approve Confirmation Modal -->
    <div class="modal fade" id="approveModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header modal-header-success">
                    <h6 class="modal-title mb-0"><i class="fas fa-check-circle mr-2"></i>Approve RFQ</h6>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="mb-1">Are you sure you want to approve this RFQ?</p>
                    <p class="mb-0"><strong id="approveItemNo" class="text-success"></strong></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-success" id="confirmApproveBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">Approve</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Reject Confirmation Modal -->
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header modal-header-secondary">
                    <h6 class="modal-title mb-0"><i class="fas fa-times-circle mr-2"></i>Reject RFQ</h6>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="mb-1">Are you sure you want to reject this RFQ?</p>
                    <p class="mb-0"><strong id="rejectItemNo" class="text-danger"></strong></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmRejectBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">Reject</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Toast Container -->
    <div class="toast-container"></div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // ========== DateTime Display ==========
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        $('#day').text(days[now.getDay()]);
        $('#daynum').text(now.getDate().toString().padStart(2, '0'));
        $('#month').text(months[now.getMonth()]);
        $('#year').text(now.getFullYear());
        $('.display-time').text(now.toLocaleTimeString('en-US', { hour12: false }));
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);

    // ========== Initialize DataTable ==========
    var table = $('#rfqTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            { extend: 'copy', className: 'btn', text: '<i class="fas fa-copy"></i> Copy' },
            { extend: 'csv', className: 'btn', text: '<i class="fas fa-file-csv"></i> CSV' },
            { extend: 'excel', className: 'btn', text: '<i class="fas fa-file-excel"></i> Excel' },
            { extend: 'pdf', className: 'btn', text: '<i class="fas fa-file-pdf"></i> PDF' },
            { extend: 'print', className: 'btn', text: '<i class="fas fa-print"></i> Print' }
        ],
        pageLength: 10,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
        order: [[1, 'desc']],
        autoWidth: false,
        columnDefs: [
            { orderable: false, targets: [7] }
        ],
        language: {
            emptyTable: '<div class="text-center py-3"><i class="fas fa-inbox fa-2x text-muted mb-2"></i><br>No RFQs found</div>',
            search: '<i class="fas fa-search"></i>',
            searchPlaceholder: 'Search RFQs...'
        }
    });

    // ========== Toast Notification Helper ==========
    function showToast(type, message) {
        var toastClass = type === 'success' ? 'toast-success' : 'toast-error';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="custom-toast ${toastClass}" role="alert">
                <div class="toast-body d-flex align-items-center">
                    <i class="fas ${icon} mr-2"></i>
                    <span>${message}</span>
                    <button type="button" class="ml-auto btn btn-sm text-white" onclick="$(this).closest('.custom-toast').fadeOut(300, function(){ $(this).remove(); })">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('.toast-container').append($toast);

        setTimeout(function() {
            $toast.fadeOut(300, function() { $(this).remove(); });
        }, 4000);
    }

    // ========== Delete RFQ ==========
    var deleteId = null;
    $(document).on('click', '.delete-btn', function() {
        deleteId = $(this).data('id');
        $('#deleteItemNo').text($(this).data('no'));
        $('#deleteModal').modal('show');
    });

    $('#confirmDeleteBtn').on('click', function() {
        if (!deleteId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Deleting...');

        $.ajax({
            url: '{{ url("superadmin/sales/rfq") }}/' + deleteId,
            type: 'DELETE',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(response) {
                $('#deleteModal').modal('hide');
                table.row('#row-' + deleteId).remove().draw(false);
                showToast('success', response.message || 'RFQ deleted successfully!');
            },
            error: function(xhr) {
                showToast('error', xhr.responseJSON?.message || 'Could not delete RFQ.');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $text.text('Delete');
                deleteId = null;
            }
        });
    });

    // ========== Approve RFQ ==========
    var approveId = null;
    $(document).on('click', '.approve-btn', function() {
        approveId = $(this).data('id');
        $('#approveItemNo').text($(this).data('no'));
        $('#approveModal').modal('show');
    });

    $('#confirmApproveBtn').on('click', function() {
        if (!approveId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Approving...');

        $.post('{{ url("superadmin/sales/rfq") }}/' + approveId + '/approve', {
            _token: '{{ csrf_token() }}'
        }, function(response) {
            $('#approveModal').modal('hide');
            showToast('success', response.message || 'RFQ approved successfully!');
            setTimeout(function() { location.reload(); }, 1000);
        }).fail(function() {
            showToast('error', 'Approval failed.');
        }).always(function() {
            $btn.prop('disabled', false);
            $spinner.addClass('d-none');
            $text.text('Approve');
            approveId = null;
        });
    });

    // ========== Reject RFQ ==========
    var rejectId = null;
    $(document).on('click', '.reject-btn', function() {
        rejectId = $(this).data('id');
        $('#rejectItemNo').text($(this).data('no'));
        $('#rejectModal').modal('show');
    });

    $('#confirmRejectBtn').on('click', function() {
        if (!rejectId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Rejecting...');

        $.post('{{ url("superadmin/sales/rfq") }}/' + rejectId + '/reject', {
            _token: '{{ csrf_token() }}'
        }, function(response) {
            $('#rejectModal').modal('hide');
            showToast('success', response.message || 'RFQ rejected!');
            setTimeout(function() { location.reload(); }, 1000);
        }).fail(function() {
            showToast('error', 'Rejection failed.');
        }).always(function() {
            $btn.prop('disabled', false);
            $spinner.addClass('d-none');
            $text.text('Reject');
            rejectId = null;
        });
    });
});
</script>
@endsection
