@extends('layouts.dashboard.superadminapp')

@section('title', 'RFQ Registration')

@section('styles')
<style>
    /* Compact Page Header */
    .page-header {
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 0.75rem;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.04);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin: 0;
    }

    /* DateTime Display */
    .datetime-display { gap: 0.5rem; }
    .date-box, .time-box {
        display: flex;
        align-items: center;
        gap: 0.35rem;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 0.35rem 0.65rem;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
        font-size: 0.75rem;
        color: #475569;
        font-weight: 500;
    }
    .date-box i, .time-box i { color: #4e73df; font-size: 0.7rem; }
    .time-box {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        border: none;
        min-width: 85px;
        justify-content: center;
    }
    .time-box i { color: rgba(255,255,255,0.8); }
    .time-box .display-time {
        font-family: 'Courier New', monospace;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    /* Compact Section Cards */
    .section-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        margin-bottom: 0.75rem;
        overflow: hidden;
    }
    .section-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.6rem 1rem;
        font-size: 0.85rem;
        border-radius: 0 !important;
    }
    .section-card .card-header i { margin-right: 0.5rem; }
    .section-card .card-header.bg-info-gradient {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
    }
    .section-card .card-header.bg-success-gradient {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
    }
    .section-card .card-header.bg-warning-gradient {
        background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
    }
    .section-card .card-header.bg-secondary-gradient {
        background: linear-gradient(135deg, #858796 0%, #60616f 100%);
    }
    .section-card .card-body {
        padding: 0.75rem 1rem;
    }

    /* Compact Form Controls */
    .form-label {
        font-weight: 600;
        color: #5a5c69;
        font-size: 0.75rem;
        margin-bottom: 0.25rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }
    .required-star { color: #e74a3b; }

    .form-control {
        font-size: 0.85rem;
        padding: 0.5rem 0.75rem;
        border: 1px solid #d1d9e6;
        border-radius: 6px;
        transition: all 0.2s;
    }
    .form-control:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 3px rgba(78, 115, 223, 0.1);
    }
    .form-control[readonly] {
        background: #f8f9fc;
        color: #6c757d;
    }

    select.form-control {
        appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%234e73df' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        padding-right: 2rem;
    }

    /* Compact Row Spacing */
    .form-row-compact {
        margin-bottom: 0.5rem;
    }
    .form-row-compact .col-md-3,
    .form-row-compact .col-md-4,
    .form-row-compact .col-md-6 {
        margin-bottom: 0.5rem;
    }

    /* Material Row - Compact */
    .material-row {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        border: 1px solid #e3e6f0;
        border-radius: 6px;
        padding: 0.5rem 0.75rem;
        margin-bottom: 0.5rem;
        transition: all 0.2s;
    }
    .material-row:hover {
        border-color: #4e73df;
        box-shadow: 0 2px 8px rgba(78, 115, 223, 0.1);
    }
    .material-row .input-group { align-items: center; }
    .material-row .form-control {
        border-radius: 6px 0 0 6px !important;
    }
    .material-row .input-group-append { margin-left: -1px; }
    .material-row .input-group-append .btn {
        border-radius: 0 6px 6px 0 !important;
        height: 38px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0 0.75rem;
    }

    /* File Input & Preview */
    input[type="file"].form-control {
        padding: 0.35rem 0.5rem;
        font-size: 0.8rem;
    }
    .file-preview {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
        margin-top: 0.5rem;
    }
    .file-preview img {
        max-width: 80px;
        max-height: 60px;
        border-radius: 4px;
        border: 1px solid #e3e6f0;
    }
    .file-preview a {
        font-size: 0.75rem;
        color: #4e73df;
    }

    /* Compact Buttons */
    .btn {
        font-size: 0.8rem;
        font-weight: 600;
        padding: 0.5rem 1rem;
        border-radius: 6px;
        transition: all 0.2s;
    }
    .btn:hover { transform: translateY(-1px); }
    .btn-sm {
        padding: 0.35rem 0.75rem;
        font-size: 0.75rem;
    }
    .btn-primary {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        border: none;
    }
    .btn-primary:hover {
        box-shadow: 0 4px 12px rgba(78, 115, 223, 0.3);
    }
    .btn-success {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        border: none;
    }
    .btn-success:hover {
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
    }
    .btn-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        border: none;
    }
    .btn-secondary {
        background: linear-gradient(135deg, #6c757d 0%, #545b62 100%);
        border: none;
    }
    .btn-outline-secondary {
        border: 1px solid #6c757d;
        color: #6c757d;
        background: transparent;
    }
    .btn-outline-secondary:hover {
        background: #6c757d;
        color: #fff;
    }

    /* Footer Actions */
    .footer-actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 0.5rem 0;
        margin-bottom: 1rem;
    }

    /* Enhanced Modal */
    .modal-content {
        border: none;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }
    .modal-header.success-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: none !important;
    }
    .modal-header .close {
        opacity: 1;
        text-shadow: none;
        padding: 0;
        margin: 0;
        width: 26px;
        height: 26px;
        border-radius: 50%;
        background: rgba(255,255,255,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 1.2rem;
        line-height: 1;
        transition: all 0.2s;
    }
    .modal-header .close:hover {
        background: rgba(255,255,255,0.35);
        transform: rotate(90deg);
    }
    .modal-title {
        font-size: 0.9rem;
        font-weight: 600;
        color: #fff !important;
    }
    .modal-body { padding: 1rem !important; }
    .modal-footer {
        background: #f8f9fc;
        border-top: 1px solid #e3e6f0;
        padding: 0.6rem 1rem;
        display: flex;
        justify-content: flex-end;
        gap: 0.5rem;
    }

    /* Toast Notification */
    .custom-toast {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 280px;
        max-width: 350px;
        border-radius: 8px;
        box-shadow: 0 8px 24px rgba(0,0,0,0.2);
        border: none;
        animation: slideInRight 0.3s ease;
    }
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    .custom-toast .toast-body {
        padding: 0.65rem 1rem;
        font-size: 0.85rem;
        font-weight: 500;
        display: flex;
        align-items: center;
    }
    .custom-toast.bg-success {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%) !important;
    }
    .custom-toast.bg-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
    }

    /* Alert Styling */
    .alert {
        border: none;
        border-radius: 8px;
        padding: 0.75rem 1rem;
        font-size: 0.85rem;
        margin-bottom: 0.75rem;
    }
    .alert-success {
        background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
        color: #155724;
        border-left: 4px solid #1cc88a;
    }
    .alert-danger {
        background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
        color: #721c24;
        border-left: 4px solid #e74a3b;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .page-header { flex-direction: column; gap: 0.5rem; }
        .footer-actions { flex-direction: column; gap: 0.5rem; }
        .footer-actions > * { width: 100%; }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-file-alt mr-2 text-info"></i>UEPL | Request For Quotation</h1>
        <div class="datetime-display d-flex align-items-center">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">{{ now()->format('l') }}</span>,
                <span id="daynum">{{ now()->format('d') }}</span>
                <span id="month">{{ now()->format('F') }}</span>
                <span id="year">{{ now()->format('Y') }}</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time"></span>
            </div>
        </div>
    </div>

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong><i class="fas fa-exclamation-triangle mr-2"></i>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <form id="rfqform" action="{{ route('superadmin.salesbom.rfq.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <!-- Basic Information Card -->
        <div class="card section-card">
            <div class="card-header">
                <i class="fas fa-file-alt"></i>RFQ Basic Information
            </div>
            <div class="card-body">
                <div class="row form-row-compact">
                    <div class="col-md-3">
                        <label class="form-label">RFQ ID <span class="required-star">*</span></label>
                        <input type="text" id="rfqNo" name="rfqNo" class="form-control" required readonly>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">RFQ Date <span class="required-star">*</span></label>
                        <input type="date" id="rfqDate" name="rfqDate" class="form-control" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Customer <span class="required-star">*</span></label>
                        <select id="customer" name="customer" class="form-control" required>
                            <option value="">Select Customer</option>
                            @foreach ($customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->company }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Customer Ref. No</label>
                        <input type="text" id="cusRefNo" name="cusRefNo" class="form-control" placeholder="Reference number">
                    </div>
                </div>
                <div class="row form-row-compact">
                    <div class="col-md-3">
                        <label class="form-label">RFQ Type <span class="required-star">*</span></label>
                        <select id="rfqType" name="rfqType" class="form-control" required>
                            <option value="">Select RFQ Type</option>
                            @foreach($rfqTypes as $type)
                                <option value="{{ $type->rfqtype }}">{{ $type->rfqtype }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Product Type <span class="required-star">*</span></label>
                        <select id="productType" name="productType" class="form-control" required>
                            <option value="">Select Product</option>
                            @foreach($productTypes as $type)
                                <option value="{{ $type->name }}">{{ $type->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Part No</label>
                        <input type="text" id="partNo" name="partNo" class="form-control" placeholder="Part number">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Project/Material No</label>
                        <input type="text" id="project-materialNo" name="project_materialNo" class="form-control" placeholder="Project/Material number">
                    </div>
                </div>
                <div class="row form-row-compact">
                    <div class="col-md-6">
                        <label class="form-label">Description</label>
                        <input type="text" id="description" name="description" class="form-control" placeholder="Item description">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Quantity <span class="required-star">*</span></label>
                        <input type="number" id="quantity" name="quantity" class="form-control" required min="1" placeholder="Enter quantity">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">UOM <span class="required-star">*</span></label>
                        <input type="text" id="uom" name="uom" class="form-control" required placeholder="Unit of measure">
                    </div>
                </div>
            </div>
        </div>

        <!-- Drawing Details Card -->
        <div class="card section-card">
            <div class="card-header bg-info-gradient">
                <i class="fas fa-drafting-compass"></i>Drawing Details
            </div>
            <div class="card-body">
                <div class="row form-row-compact">
                    <div class="col-md-4">
                        <label class="form-label">Drawing No</label>
                        <input type="text" id="drawingNo" name="drawingNo" class="form-control" placeholder="Drawing number">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Drawing Revision</label>
                        <input type="text" id="drawingRev" name="drawingRev" class="form-control" placeholder="Revision">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Drawing Files</label>
                        <input type="file" id="drawingFiles" name="drawingFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="drawingFiles_preview" class="file-preview"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Attachments Card -->
        <div class="card section-card">
            <div class="card-header bg-warning-gradient">
                <i class="fas fa-paperclip"></i>Attachments
            </div>
            <div class="card-body">
                <div class="row form-row-compact">
                    <div class="col-md-4">
                        <label class="form-label">Material Specification Files</label>
                        <input type="file" id="materialSpecificationFiles" name="materialSpecificationFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="materialSpecificationFiles_preview" class="file-preview"></div>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">RFQ Form Files</label>
                        <input type="file" id="rfqFormFiles" name="rfqFormFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="rfqFormFiles_preview" class="file-preview"></div>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Annexure Files</label>
                        <input type="file" id="annexureFiles" name="annexureFiles[]" class="form-control" multiple accept=".pdf,image/*">
                        <div id="annexureFiles_preview" class="file-preview"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Raw Materials Card -->
        <div class="card section-card">
            <div class="card-header bg-success-gradient">
                <i class="fas fa-cubes"></i>Raw Materials <span class="required-star">*</span>
            </div>
            <div class="card-body">
                <div id="materials-wrapper">
                    <div class="material-row">
                        <div class="input-group">
                            <select name="rawmaterials[]" class="form-control raw-material-select" required>
                                <option value="">Select Raw Material</option>
                            </select>
                            <div class="input-group-append">
                                <button type="button" class="btn btn-danger remove-material" title="Remove">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-2">
                    <button type="button" id="add-material" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus mr-1"></i> Add Material
                    </button>
                    <button type="button" class="btn btn-outline-secondary btn-sm ml-2" data-toggle="modal" data-target="#addRawMaterialModal">
                        <i class="fas fa-plus-circle mr-1"></i> New Raw Material
                    </button>
                </div>
            </div>
        </div>

        <!-- Notes Card -->
        <div class="card section-card">
            <div class="card-header bg-secondary-gradient">
                <i class="fas fa-sticky-note"></i>Additional Notes
            </div>
            <div class="card-body">
                <textarea id="note" name="note" class="form-control" rows="2" placeholder="Any additional notes or comments..."></textarea>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="footer-actions">
            <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left mr-1"></i> Back to List
            </a>
            <div>
                <button class="btn btn-danger mr-2" type="reset" id="clearBtn">
                    <i class="fas fa-undo mr-1"></i> Clear
                </button>
                <button class="btn btn-success" type="submit" id="submitBtn">
                    <span class="spinner-border spinner-border-sm d-none" role="status" id="submitSpinner"></span>
                    <i class="fas fa-save mr-1" id="submitIcon"></i>
                    <span id="submitText">Save RFQ</span>
                </button>
            </div>
        </div>
    </form>

    <!-- Modal for Adding Raw Material -->
    <div class="modal fade" id="addRawMaterialModal" tabindex="-1" aria-labelledby="addRawMaterialLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form id="addRawMaterialForm">
                <div class="modal-content">
                    <div class="modal-header success-header">
                        <h6 class="modal-title mb-0">
                            <i class="fas fa-plus-circle mr-2"></i>Add New Raw Material
                        </h6>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group mb-3">
                            <label class="form-label">Raw Material Name <span class="required-star">*</span></label>
                            <input type="text" name="name" class="form-control" required placeholder="Enter material name">
                        </div>
                        <div class="form-group mb-3">
                            <label class="form-label">ISO Specification <span class="required-star">*</span></label>
                            <input type="text" name="iso_specification" class="form-control" required placeholder="ISO specification">
                        </div>
                        <div class="form-group mb-3">
                            <label class="form-label">Material Density</label>
                            <input type="text" name="density" class="form-control" placeholder="Density (optional)">
                        </div>
                        <div class="form-group mb-0">
                            <label class="form-label">Mechanical Properties</label>
                            <input type="text" name="mechanical_properties" class="form-control" placeholder="Mechanical properties (optional)">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">
                            <i class="fas fa-times mr-1"></i> Cancel
                        </button>
                        <button type="submit" class="btn btn-success btn-sm" id="addMaterialBtn">
                            <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                            <i class="fas fa-plus mr-1 btn-icon"></i>
                            <span class="btn-text">Add Material</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        document.getElementById('day').textContent = days[now.getDay()];
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = months[now.getMonth()];
        document.getElementById('year').textContent = now.getFullYear();

        const timeStr = now.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        document.querySelector('.display-time').textContent = timeStr;
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);

    // Set today's date
    const today = new Date();
    const formattedDate = today.toISOString().split('T')[0];
    $('#rfqDate').val(formattedDate);

    // Generate RFQ ID
    $.ajax({
        url: "{{ route('superadmin.salesbom.rfq.generateId') }}",
        method: 'GET',
        success: function(response) {
            $('#rfqNo').val(response.rfqId);
        },
        error: function() {
            showToast('error', 'Failed to generate RFQ ID.');
        }
    });

    // Load raw materials
    function loadRawMaterials(select = null, callback = null) {
        $.get('{{ route('superadmin.salesbom.rawmaterials.list') }}', function(data) {
            $('.raw-material-select').each(function() {
                var selectedVal = $(this).val();
                $(this).empty().append('<option value="">Select Raw Material</option>');
                $.each(data, function(_, mat) {
                    $(this).append(
                        `<option value="${mat.id}" ${selectedVal == mat.id ? 'selected' : ''}>${mat.rm_grade} (${mat.iso_specification})</option>`
                    );
                }.bind(this));
                if (selectedVal) $(this).val(selectedVal);
            });
            if (select) {
                $(select).empty().append('<option value="">Select Raw Material</option>');
                $.each(data, function(_, mat) {
                    $(select).append(
                        `<option value="${mat.id}">${mat.rm_grade} (${mat.iso_specification})</option>`
                    );
                });
            }
            setTimeout(disableDuplicateOptions, 100);
            if (callback) callback();
        });
    }

    function disableDuplicateOptions() {
        let selectedVals = [];
        $('.raw-material-select').each(function() {
            let val = $(this).val();
            if (val) selectedVals.push(val);
        });
        $('.raw-material-select').each(function() {
            let currentVal = $(this).val();
            $(this).find('option').each(function() {
                let optVal = $(this).val();
                if (optVal && optVal !== currentVal && selectedVals.includes(optVal)) {
                    $(this).prop('disabled', true);
                } else {
                    $(this).prop('disabled', false);
                }
            });
        });
    }

    // Initial load
    loadRawMaterials();

    // On change, re-enforce uniqueness
    $(document).on('change', '.raw-material-select', function() {
        disableDuplicateOptions();
    });

    // Add material row
    $('#add-material').click(function() {
        var $newRow = $(`
            <div class="material-row">
                <div class="input-group">
                    <select name="rawmaterials[]" class="form-control raw-material-select" required>
                        <option value="">Select Raw Material</option>
                    </select>
                    <div class="input-group-append">
                        <button type="button" class="btn btn-danger remove-material" title="Remove">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                </div>
            </div>
        `);
        $('#materials-wrapper').append($newRow);
        loadRawMaterials($newRow.find('select'), disableDuplicateOptions);
    });

    // Remove material row
    $(document).on('click', '.remove-material', function() {
        if ($('.material-row').length > 1) {
            $(this).closest('.material-row').remove();
            disableDuplicateOptions();
        } else {
            showToast('error', 'At least one raw material is required.');
        }
    });

    // Add new raw material via modal
    $('#addRawMaterialForm').submit(function(e) {
        e.preventDefault();
        var $btn = $('#addMaterialBtn');
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Adding...');

        $.ajax({
            url: '{{ route('superadmin.salesbom.rawmaterials.store') }}',
            method: 'POST',
            data: $(this).serialize(),
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            success: function(response) {
                if (response.success) {
                    var newMaterialId = response.material.id;
                    $('#addRawMaterialModal').modal('hide');
                    $('#addRawMaterialForm')[0].reset();
                    loadRawMaterials(null, function() {
                        $('.raw-material-select').last().val(newMaterialId);
                        disableDuplicateOptions();
                    });
                    showToast('success', 'Raw material added successfully!');
                }
            },
            error: function(xhr) {
                showToast('error', 'Error adding raw material.');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Add Material');
            }
        });
    });

    // Form submit validation
    $('#rfqform').on('submit', function(e) {
        let values = [];
        let duplicate = false;
        $('.raw-material-select').each(function() {
            let val = $(this).val();
            if (val) {
                if (values.includes(val)) {
                    duplicate = true;
                    return false;
                }
                values.push(val);
            }
        });
        if (duplicate) {
            showToast('error', 'Each Raw Material must be unique. Please select different materials.');
            e.preventDefault();
            return false;
        }

        // Show loading state
        $('#submitBtn').prop('disabled', true);
        $('#submitSpinner').removeClass('d-none');
        $('#submitIcon').addClass('d-none');
        $('#submitText').text('Saving...');
    });

    // Clear button
    $('#clearBtn').on('click', function() {
        $('.file-preview').empty();
        // Reload RFQ ID
        $.ajax({
            url: "{{ route('superadmin.salesbom.rfq.generateId') }}",
            method: 'GET',
            success: function(response) {
                $('#rfqNo').val(response.rfqId);
            }
        });
    });

    // File preview
    const previewFileInputs = ['drawingFiles', 'materialSpecificationFiles', 'rfqFormFiles', 'annexureFiles'];
    previewFileInputs.forEach(function(inputId) {
        const input = document.getElementById(inputId);
        if (input) {
            input.addEventListener('change', function(event) {
                const previewContainer = document.getElementById(inputId + '_preview');
                previewContainer.innerHTML = '';
                const files = event.target.files;
                if (files.length > 0) {
                    Array.from(files).forEach(file => {
                        const fileType = file.type;
                        if (fileType.startsWith('image/')) {
                            const reader = new FileReader();
                            reader.onload = function(e) {
                                const img = document.createElement('img');
                                img.src = e.target.result;
                                previewContainer.appendChild(img);
                            };
                            reader.readAsDataURL(file);
                        } else {
                            const link = document.createElement('a');
                            link.href = URL.createObjectURL(file);
                            link.target = '_blank';
                            link.innerHTML = '<i class="fas fa-file-pdf text-danger mr-1"></i>' + file.name;
                            link.classList.add('d-block', 'small');
                            previewContainer.appendChild(link);
                        }
                    });
                }
            });
        }
    });

    // Toast notification helper
    function showToast(type, message) {
        $('.custom-toast').remove();

        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast custom-toast ${bgClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3500">
                <div class="toast-body">
                    <i class="fas ${icon} mr-2"></i>
                    <span class="flex-grow-1">${message}</span>
                    <button type="button" class="close ml-2 text-white" data-dismiss="toast" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');

        $toast.on('hidden.bs.toast', function() {
            $(this).remove();
        });
    }
});
</script>
@endsection
