@extends('layouts.dashboard.superadminapp')

@section('title', 'View Quotation')

@section('styles')
<style>
    .detail-card {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
    }
    .detail-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        font-weight: 600;
        padding: 0.75rem 1rem;
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .detail-row {
        display: flex;
        padding: 0.5rem 0;
        border-bottom: 1px solid #f1f1f1;
    }
    .detail-row:last-child {
        border-bottom: none;
    }
    .detail-label {
        font-weight: 600;
        color: #5a5c69;
        min-width: 160px;
        font-size: 0.85rem;
    }
    .detail-value {
        color: #2e2e2e;
        font-size: 0.85rem;
        word-break: break-word;
    }
    .quotation-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        color: white;
        padding: 1.5rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
    }
    .info-card {
        background: #f8f9fc;
        border-radius: 0.5rem;
        padding: 1rem;
        height: 100%;
    }
    .info-card-title {
        font-size: 0.75rem;
        text-transform: uppercase;
        color: #858796;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    .info-card-value {
        font-size: 1.1rem;
        font-weight: 600;
        color: #2e2e2e;
    }
    .cost-table {
        font-size: 0.85rem;
    }
    .cost-table th {
        background-color: #f8f9fc;
        font-weight: 600;
        font-size: 0.8rem;
    }
    .cost-table td, .cost-table th {
        padding: 0.5rem;
        vertical-align: middle;
    }
    .totals-box {
        background: #f8f9fc;
        border-radius: 0.5rem;
        padding: 1rem;
    }
    .totals-box .row {
        padding: 0.35rem 0;
    }
    .totals-box .total-label {
        font-weight: 600;
        color: #5a5c69;
    }
    .totals-box .total-value {
        text-align: right;
        font-weight: 600;
    }
    .grand-total {
        font-size: 1.2rem;
        color: #1cc88a;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <x-layout.page-header title="UEPL | View Quotation" icon="file-invoice" iconColor="warning" />

    <!-- Quotation Header Card -->
    <div class="quotation-header">
        <div class="row align-items-center">
            <div class="col">
                <h3 class="mb-1">{{ $quotation->quotation_no }}</h3>
                <p class="mb-1 opacity-75">{{ $quotation->customer->company ?? $quotation->customer_name ?? 'N/A' }}</p>
                <div class="d-flex flex-wrap align-items-center mt-2">
                    @if($quotation->status == 'approved')
                        <span class="badge badge-light mr-2"><i class="fas fa-check-circle mr-1 text-success"></i> Approved</span>
                    @elseif($quotation->status == 'rejected')
                        <span class="badge badge-light mr-2"><i class="fas fa-times-circle mr-1 text-danger"></i> Rejected</span>
                    @else
                        <span class="badge badge-light mr-2"><i class="fas fa-clock mr-1 text-warning"></i> Pending</span>
                    @endif
                    <span class="badge badge-light"><i class="fas fa-calendar mr-1"></i> {{ \Carbon\Carbon::parse($quotation->quotation_date)->format('d M Y') }}</span>
                </div>
            </div>
            <div class="col-auto">
                <a href="{{ route('superadmin.salesbom.quotation.edit', $quotation->id) }}" class="btn btn-light btn-sm mr-2">
                    <i class="fas fa-edit mr-1"></i> Edit
                </a>
                <a href="{{ route('superadmin.salesbom.quotation.print', $quotation->id) }}" target="_blank" class="btn btn-light btn-sm mr-2">
                    <i class="fas fa-print mr-1"></i> Print
                </a>
                <a href="{{ route('superadmin.salesbom.quotation.quotationdetails') }}" class="btn btn-outline-light btn-sm">
                    <i class="fas fa-arrow-left mr-1"></i> Back
                </a>
            </div>
        </div>
    </div>

    <!-- Quick Info Cards -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-phone mr-1"></i> Contact</div>
                <div class="info-card-value">{{ $quotation->phone ?: '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-envelope mr-1"></i> Email</div>
                <div class="info-card-value">{{ $quotation->email ?: '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-box mr-1"></i> Product Type</div>
                <div class="info-card-value">{{ $quotation->product_type ?: '-' }}</div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="info-card">
                <div class="info-card-title"><i class="fas fa-rupee-sign mr-1"></i> Grand Total</div>
                <div class="info-card-value text-success">{{ number_format($quotation->grand_total, 2) }}</div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Customer & Quotation Details -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header">
                    <i class="fas fa-user mr-2"></i> Customer Information
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">Customer Name</span>
                        <span class="detail-value">{{ $quotation->customer->company ?? $quotation->customer_name ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Address</span>
                        <span class="detail-value">{{ $quotation->address ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">GST No</span>
                        <span class="detail-value"><code>{{ $quotation->gst ?: '-' }}</code></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Phone</span>
                        <span class="detail-value">{{ $quotation->phone ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Email</span>
                        <span class="detail-value">
                            @if($quotation->email)
                                <a href="mailto:{{ $quotation->email }}">{{ $quotation->email }}</a>
                            @else
                                -
                            @endif
                        </span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Customer Ref No</span>
                        <span class="detail-value">{{ $quotation->cust_ref_no ?: '-' }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- RFQ & Product Details -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
                    <i class="fas fa-file-alt mr-2"></i> RFQ & Product Information
                </div>
                <div class="card-body">
                    <div class="detail-row">
                        <span class="detail-label">RFQ No</span>
                        <span class="detail-value">{{ $quotation->rfq->rfq_no ?? $quotation->rfq_no ?? '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">RFQ Date</span>
                        <span class="detail-value">{{ $quotation->rfq_date ? \Carbon\Carbon::parse($quotation->rfq_date)->format('d M Y') : '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Part No</span>
                        <span class="detail-value">{{ $quotation->part_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Project/Material No</span>
                        <span class="detail-value">{{ $quotation->project_material_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Drawing No</span>
                        <span class="detail-value">{{ $quotation->drawing_no ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Drawing Revision</span>
                        <span class="detail-value">{{ $quotation->drawing_rev ?: '-' }}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Quantity</span>
                        <span class="detail-value">{{ $quotation->quantity ?: '-' }} {{ $quotation->quantity_uom }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Description -->
    @if($quotation->description)
    <div class="card detail-card mb-4">
        <div class="card-header" style="background: linear-gradient(135deg, #858796 0%, #60616f 100%);">
            <i class="fas fa-align-left mr-2"></i> Description
        </div>
        <div class="card-body">
            <p class="mb-0">{{ $quotation->description }}</p>
        </div>
    </div>
    @endif

    <!-- Raw Materials -->
    @php
        $rawMaterials = is_array($quotation->raw_materials) ? $quotation->raw_materials : json_decode($quotation->raw_materials, true);
    @endphp
    @if($rawMaterials && count($rawMaterials) > 0)
    <div class="card detail-card mb-4">
        <div class="card-header" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
            <i class="fas fa-cubes mr-2"></i> Raw Material Charges
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered cost-table">
                    <thead>
                        <tr class="text-center">
                            <th>#</th>
                            <th>Material</th>
                            <th>Type</th>
                            <th>Quantity</th>
                            <th>Rate</th>
                            <th>RM Weight</th>
                            <th>RM Cost</th>
                            <th>Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($rawMaterials as $index => $rm)
                        <tr class="text-center">
                            <td>{{ $index + 1 }}</td>
                            <td class="text-left">{{ $rm['material_id'] ?? '-' }}</td>
                            <td>{{ $rm['type'] ?? '-' }}</td>
                            <td>{{ $rm['quantity'] ?? '-' }}</td>
                            <td class="text-right">{{ isset($rm['rate']) ? number_format($rm['rate'], 2) : '-' }}</td>
                            <td class="text-right">{{ $rm['rm_weight'] ?? '-' }}</td>
                            <td class="text-right">{{ isset($rm['rm_cost']) ? number_format($rm['rm_cost'], 2) : '-' }}</td>
                            <td class="text-right"><strong>{{ isset($rm['value']) ? number_format($rm['value'], 2) : '-' }}</strong></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif

    <!-- Conversion Costs -->
    @php
        $conversionCosts = is_array($quotation->conversion_costs) ? $quotation->conversion_costs : json_decode($quotation->conversion_costs, true);
    @endphp
    @if($conversionCosts && count($conversionCosts) > 0)
    <div class="card detail-card mb-4">
        <div class="card-header" style="background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);">
            <i class="fas fa-cogs mr-2"></i> Conversion Costs
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered cost-table">
                    <thead>
                        <tr class="text-center">
                            <th>#</th>
                            <th>Description</th>
                            <th>Quantity</th>
                            <th>Unit</th>
                            <th>Rate (INR)</th>
                            <th>Value (INR)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($conversionCosts as $index => $cc)
                        <tr class="text-center">
                            <td>{{ $index + 1 }}</td>
                            <td class="text-left">{{ $cc['desc'] ?? '-' }}</td>
                            <td>{{ $cc['quantity'] ?? '-' }}</td>
                            <td>{{ $cc['unit'] ?? '-' }}</td>
                            <td class="text-right">{{ isset($cc['rate']) ? number_format($cc['rate'], 2) : '-' }}</td>
                            <td class="text-right"><strong>{{ isset($cc['value']) ? number_format($cc['value'], 2) : '-' }}</strong></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif

    <!-- Packing Charges -->
    @php
        $packingCharges = is_array($quotation->packing_charges) ? $quotation->packing_charges : json_decode($quotation->packing_charges, true);
    @endphp
    @if($packingCharges && count($packingCharges) > 0)
    <div class="card detail-card mb-4">
        <div class="card-header" style="background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%);">
            <i class="fas fa-box-open mr-2"></i> Packing Charges
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered cost-table">
                    <thead>
                        <tr class="text-center">
                            <th>#</th>
                            <th>Description</th>
                            <th>Quantity</th>
                            <th>Unit</th>
                            <th>Rate (INR)</th>
                            <th>Value (INR)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($packingCharges as $index => $pc)
                        <tr class="text-center">
                            <td>{{ $index + 1 }}</td>
                            <td class="text-left">{{ $pc['desc'] ?? '-' }}</td>
                            <td>{{ $pc['quantity'] ?? '-' }}</td>
                            <td>{{ $pc['unit'] ?? '-' }}</td>
                            <td class="text-right">{{ isset($pc['rate']) ? number_format($pc['rate'], 2) : '-' }}</td>
                            <td class="text-right"><strong>{{ isset($pc['value']) ? number_format($pc['value'], 2) : '-' }}</strong></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @endif

    <!-- Note & Totals -->
    <div class="row">
        <!-- Note -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header" style="background: linear-gradient(135deg, #858796 0%, #60616f 100%);">
                    <i class="fas fa-sticky-note mr-2"></i> Note / Remarks
                </div>
                <div class="card-body">
                    @if($quotation->note)
                        <p class="mb-0">{{ $quotation->note }}</p>
                    @else
                        <p class="text-muted mb-0"><i class="fas fa-info-circle mr-1"></i> No notes available</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Totals -->
        <div class="col-lg-6 mb-4">
            <div class="card detail-card h-100">
                <div class="card-header">
                    <i class="fas fa-rupee-sign mr-2"></i> Summary
                </div>
                <div class="card-body">
                    <div class="totals-box">
                        <div class="row">
                            <div class="col-6 total-label">Sub Total</div>
                            <div class="col-6 total-value">{{ number_format($quotation->sub_total, 2) }}</div>
                        </div>
                        <div class="row">
                            <div class="col-6 total-label">Discount (%)</div>
                            <div class="col-6 total-value">{{ $quotation->discount ?: '0' }}%</div>
                        </div>
                        <div class="row">
                            <div class="col-6 total-label">Round Up</div>
                            <div class="col-6 total-value">{{ number_format($quotation->round_up, 2) }}</div>
                        </div>
                        <hr class="my-2">
                        <div class="row">
                            <div class="col-6 total-label grand-total">Grand Total</div>
                            <div class="col-6 total-value grand-total">{{ number_format($quotation->grand_total, 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="d-flex justify-content-between mb-4">
        <a href="{{ route('superadmin.salesbom.quotation.quotationdetails') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left mr-1"></i> Back to List
        </a>
        <div>
            <a href="{{ route('superadmin.salesbom.quotation.print', $quotation->id) }}" target="_blank" class="btn btn-info mr-2">
                <i class="fas fa-print mr-1"></i> Print PDF
            </a>
            <a href="{{ route('superadmin.salesbom.quotation.edit', $quotation->id) }}" class="btn btn-primary">
                <i class="fas fa-edit mr-1"></i> Edit Quotation
            </a>
        </div>
    </div>
@endsection
