@extends('layouts.dashboard.superadminapp')

@section('title', 'Sales Quotation Details')

@section('styles')
<style>
    #quotationTable {
        width: 100% !important;
        table-layout: fixed;
    }
    #quotationTable th, #quotationTable td {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        font-size: 0.85rem;
        padding: 0.5rem !important;
    }
    #quotationTable td.text-left {
        white-space: normal;
        word-wrap: break-word;
    }
    .table-actions .btn {
        padding: 0.2rem 0.4rem;
        font-size: 0.75rem;
    }
    .badge {
        font-size: 0.7rem;
    }
    div.dt-buttons {
        float: left;
        display: flex !important;
        margin-bottom: 0.5rem;
    }
    .dt-buttons .btn {
        margin-right: 0.25rem !important;
        padding: 0.2rem 0.5rem !important;
        font-size: 0.8rem !important;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <x-layout.page-header title="UEPL | Sales Quotation Details" icon="file-invoice" iconColor="warning" />

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-triangle mr-2"></i>
            <strong>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Quotations</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $quotations->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-invoice fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pending</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $quotations->where('status', 'pending')->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Approved</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $quotations->where('status', 'approved')->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Rejected</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $quotations->where('status', 'rejected')->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Table Section -->
    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span class="font-weight-bold"><i class="fas fa-table mr-2"></i>Sales Quotation Data</span>
            <a href="{{ route('superadmin.salesbom.quotation.quotationorder') }}" class="btn btn-primary btn-sm" title="Add New">
                <i class="fa fa-plus-square mr-1"></i> Add New
            </a>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-hover text-dark" id="quotationTable">
                <thead class="table-light">
                    <tr class="text-center">
                        <th style="width: 5%;">#</th>
                        <th style="width: 12%;">Quotation No</th>
                        <th style="width: 9%;">Date</th>
                        <th style="width: 15%;">Customer</th>
                        <th style="width: 10%;">Contact</th>
                        <th style="width: 10%;">Product Type</th>
                        <th style="width: 10%;">Grand Total</th>
                        <th style="width: 8%;">Status</th>
                        <th style="width: 6%;">Print</th>
                        <th style="width: 15%;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($quotations as $index => $quotation)
                        <tr id="row-{{ $quotation->id }}" class="text-center align-middle">
                            <td>{{ $index + 1 }}</td>
                            <td><small><strong>{{ $quotation->quotation_no }}</strong></small></td>
                            <td><small>{{ \Carbon\Carbon::parse($quotation->quotation_date)->format('d-m-Y') }}</small></td>
                            <td class="text-left">
                                <small title="{{ $quotation->customer->company ?? $quotation->customer_name }}">
                                    {{ Str::limit($quotation->customer->company ?? $quotation->customer_name, 20) }}
                                </small>
                                @if($quotation->email)
                                    <br><small class="text-muted">{{ Str::limit($quotation->email, 20) }}</small>
                                @endif
                            </td>
                            <td><small>{{ $quotation->phone ?: '-' }}</small></td>
                            <td><small>{{ Str::limit($quotation->product_type, 15) ?: '-' }}</small></td>
                            <td class="text-right"><small><strong>{{ number_format($quotation->grand_total, 2) }}</strong></small></td>
                            <td>
                                @if($quotation->status == 'approved')
                                    <span class="badge badge-success">Approved</span>
                                @elseif($quotation->status == 'rejected')
                                    <span class="badge badge-danger">Rejected</span>
                                @else
                                    <span class="badge badge-warning">Pending</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('superadmin.salesbom.quotation.print', $quotation->id) }}" target="_blank"
                                    class="btn btn-info btn-sm" title="Print PDF">
                                    <i class="fas fa-print"></i>
                                </a>
                            </td>
                            <td>
                                <div class="btn-group table-actions" role="group">
                                    <a href="{{ route('superadmin.salesbom.quotation.view', $quotation->id) }}"
                                        class="btn btn-secondary btn-sm" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a href="{{ route('superadmin.salesbom.quotation.edit', $quotation->id) }}"
                                        class="btn btn-primary btn-sm" title="Edit">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    @if ($quotation->status === 'pending')
                                        <button class="btn btn-success btn-sm approve-btn"
                                            data-id="{{ $quotation->id }}" data-no="{{ $quotation->quotation_no }}" title="Approve">
                                            <i class="fa fa-check"></i>
                                        </button>
                                        <button class="btn btn-warning btn-sm reject-btn"
                                            data-id="{{ $quotation->id }}" data-no="{{ $quotation->quotation_no }}" title="Reject">
                                            <i class="fa fa-times"></i>
                                        </button>
                                    @endif
                                    <button class="btn btn-danger btn-sm delete-btn"
                                        data-id="{{ $quotation->id }}" data-no="{{ $quotation->quotation_no }}" title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white py-2">
                    <h6 class="modal-title mb-0"><i class="fas fa-exclamation-triangle mr-2"></i>Delete Quotation</h6>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="mb-1">Are you sure you want to delete this quotation?</p>
                    <p class="mb-0"><strong id="deleteItemNo"></strong></p>
                    <small class="text-muted">This action cannot be undone.</small>
                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger btn-sm" id="confirmDeleteBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">Delete</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Approve Confirmation Modal -->
    <div class="modal fade" id="approveModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-success text-white py-2">
                    <h6 class="modal-title mb-0"><i class="fas fa-check-circle mr-2"></i>Approve Quotation</h6>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="mb-1">Are you sure you want to approve this quotation?</p>
                    <p class="mb-0"><strong id="approveItemNo"></strong></p>
                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-success btn-sm" id="confirmApproveBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">Approve</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Reject Confirmation Modal -->
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-warning text-dark py-2">
                    <h6 class="modal-title mb-0"><i class="fas fa-times-circle mr-2"></i>Reject Quotation</h6>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="mb-1">Are you sure you want to reject this quotation?</p>
                    <p class="mb-0"><strong id="rejectItemNo"></strong></p>
                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-warning btn-sm" id="confirmRejectBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <span class="btn-text">Reject</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#quotationTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            { extend: 'copy', className: 'btn btn-secondary btn-sm' },
            { extend: 'csv', className: 'btn btn-secondary btn-sm' },
            { extend: 'excel', className: 'btn btn-secondary btn-sm' },
            { extend: 'pdf', className: 'btn btn-secondary btn-sm' },
            { extend: 'print', className: 'btn btn-secondary btn-sm' }
        ],
        pageLength: 10,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
        order: [[0, 'asc']],
        autoWidth: false,
        columnDefs: [
            { orderable: false, targets: [8, 9] }
        ],
        language: {
            emptyTable: "No quotations found"
        }
    });

    // Toast notification helper
    function showToast(type, message) {
        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast ${bgClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 250px;">
                <div class="toast-body d-flex align-items-center">
                    <i class="fas ${icon} mr-2"></i>
                    <span>${message}</span>
                    <button type="button" class="ml-auto close text-white" data-dismiss="toast" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');

        $toast.on('hidden.bs.toast', function() {
            $(this).remove();
        });
    }

    // Delete Quotation
    var deleteId = null;
    $(document).on('click', '.delete-btn', function() {
        deleteId = $(this).data('id');
        $('#deleteItemNo').text($(this).data('no'));
        $('#deleteModal').modal('show');
    });

    $('#confirmDeleteBtn').on('click', function() {
        if (!deleteId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Deleting...');

        $.ajax({
            url: '{{ url("superadmin/sales/quotations") }}/' + deleteId,
            type: 'DELETE',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(response) {
                $('#deleteModal').modal('hide');
                table.row('#row-' + deleteId).remove().draw(false);
                showToast('success', 'Quotation deleted successfully!');
                // Update summary counts after short delay
                setTimeout(function() { location.reload(); }, 1500);
            },
            error: function(xhr) {
                showToast('error', xhr.responseJSON?.message || 'Could not delete quotation.');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $text.text('Delete');
                deleteId = null;
            }
        });
    });

    // Approve Quotation
    var approveId = null;
    $(document).on('click', '.approve-btn', function() {
        approveId = $(this).data('id');
        $('#approveItemNo').text($(this).data('no'));
        $('#approveModal').modal('show');
    });

    $('#confirmApproveBtn').on('click', function() {
        if (!approveId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Approving...');

        $.ajax({
            url: '{{ url("superadmin/sales/quotations") }}/' + approveId + '/approve',
            type: 'POST',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(response) {
                $('#approveModal').modal('hide');
                showToast('success', response.message || 'Quotation approved successfully!');
                setTimeout(function() { location.reload(); }, 1500);
            },
            error: function(xhr) {
                showToast('error', xhr.responseJSON?.message || 'Could not approve quotation.');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $text.text('Approve');
                approveId = null;
            }
        });
    });

    // Reject Quotation
    var rejectId = null;
    $(document).on('click', '.reject-btn', function() {
        rejectId = $(this).data('id');
        $('#rejectItemNo').text($(this).data('no'));
        $('#rejectModal').modal('show');
    });

    $('#confirmRejectBtn').on('click', function() {
        if (!rejectId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $text.text('Rejecting...');

        $.ajax({
            url: '{{ url("superadmin/sales/quotations") }}/' + rejectId + '/reject',
            type: 'POST',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(response) {
                $('#rejectModal').modal('hide');
                showToast('success', response.message || 'Quotation rejected successfully!');
                setTimeout(function() { location.reload(); }, 1500);
            },
            error: function(xhr) {
                showToast('error', xhr.responseJSON?.message || 'Could not reject quotation.');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $text.text('Reject');
                rejectId = null;
            }
        });
    });
});
</script>
@endsection
