@extends('layouts.dashboard.superadminapp')

@section('title', 'Route Card - Live View')

@section('styles')
<style>
    .progress-timeline {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 20px 0;
        position: relative;
    }
    .progress-timeline::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        height: 4px;
        background: #e9ecef;
        z-index: 0;
    }
    .progress-step {
        position: relative;
        z-index: 1;
        text-align: center;
        flex: 1;
    }
    .progress-step .step-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        background: #e9ecef;
        color: #6c757d;
        font-weight: bold;
        margin-bottom: 5px;
    }
    .progress-step.completed .step-icon {
        background: #28a745;
        color: white;
    }
    .progress-step.active .step-icon {
        background: #ffc107;
        color: white;
        animation: pulse 1.5s infinite;
    }
    .progress-step.pending .step-icon {
        background: #e9ecef;
        color: #6c757d;
    }
    @keyframes pulse {
        0% { box-shadow: 0 0 0 0 rgba(255, 193, 7, 0.7); }
        70% { box-shadow: 0 0 0 10px rgba(255, 193, 7, 0); }
        100% { box-shadow: 0 0 0 0 rgba(255, 193, 7, 0); }
    }
    .step-label {
        font-size: 0.75rem;
        color: #6c757d;
    }
    .process-timeline-item {
        position: relative;
        padding-left: 30px;
        padding-bottom: 20px;
        border-left: 3px solid #e9ecef;
    }
    .process-timeline-item:last-child {
        border-left: 3px solid transparent;
    }
    .process-timeline-item.completed {
        border-left-color: #28a745;
    }
    .process-timeline-item.active {
        border-left-color: #ffc107;
    }
    .process-timeline-item::before {
        content: '';
        position: absolute;
        left: -8px;
        top: 0;
        width: 14px;
        height: 14px;
        border-radius: 50%;
        background: #e9ecef;
        border: 2px solid white;
    }
    .process-timeline-item.completed::before {
        background: #28a745;
    }
    .process-timeline-item.active::before {
        background: #ffc107;
        animation: pulse 1.5s infinite;
    }
    .status-card {
        border-radius: 10px;
        padding: 15px;
        text-align: center;
    }
    .status-card h4 {
        margin: 0;
        font-size: 1.5rem;
        font-weight: bold;
    }
    .status-card p {
        margin: 5px 0 0;
        font-size: 0.85rem;
        color: #6c757d;
    }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<x-layout.page-header title="UEPL | Route Card - Live Project View" icon="route" iconColor="warning" />

<!-- Status Overview Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="status-card bg-light border">
            <h4 class="text-primary">{{ $routeCard->route_no }}</h4>
            <p>Plan ID</p>
        </div>
    </div>
    <div class="col-md-3">
        <div class="status-card
            @if($routeCard->status == 'in_production') bg-warning text-dark
            @elseif($routeCard->status == 'approved' || $routeCard->status == 'completed') bg-success text-white
            @elseif($routeCard->status == 'rejected') bg-danger text-white
            @else bg-secondary text-white
            @endif">
            <h4>{{ ucwords(str_replace('_', ' ', $routeCard->status ?? 'Pending')) }}</h4>
            <p>Current Status</p>
        </div>
    </div>
    <div class="col-md-3">
        <div class="status-card bg-light border">
            <h4 class="text-info">{{ $routeCardProcesses->count() }}</h4>
            <p>Total Processes</p>
        </div>
    </div>
    <div class="col-md-3">
        <div class="status-card bg-light border">
            <h4 class="text-success">{{ $routeCard->project_start_date ? \Carbon\Carbon::parse($routeCard->project_start_date)->format('d M') : '-' }}</h4>
            <p>Project Start</p>
        </div>
    </div>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-map-marked-alt mr-2"></i> Route Card - {{ $routeCard->route_no }} | {{ $routeCard->company_name ?? 'Project Details' }}
        </h6>
        <div>
            <a href="{{ route('superadmin.routecard.edit', $routeCard->id) }}" class="btn btn-warning btn-sm mr-1">
                <i class="fa fa-edit mr-1"></i> Edit Plan
            </a>
            <a href="{{ route('superadmin.routecard.details') }}" class="btn btn-light btn-sm">
                <i class="fa fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">RC No</label>
                <div class="font-weight-bold">{{ $routeCard->route_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">RC Date</label>
                <div class="font-weight-bold">{{ $routeCard->route_date ? \Carbon\Carbon::parse($routeCard->route_date)->format('d M Y') : '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Order No</label>
                <div class="font-weight-bold">{{ $routeCard->order_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Order Date</label>
                <div class="font-weight-bold">{{ $routeCard->order_date ? \Carbon\Carbon::parse($routeCard->order_date)->format('d M Y') : '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GRN No</label>
                <div class="font-weight-bold">{{ $routeCard->grn_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GRN Date</label>
                <div class="font-weight-bold">{{ $routeCard->grn_date ? \Carbon\Carbon::parse($routeCard->grn_date)->format('d M Y') : '-' }}</div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="small font-weight-bold text-muted">Company Name</label>
                <div class="font-weight-bold">{{ $routeCard->company_name ?? '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="small font-weight-bold text-muted">Address</label>
                <div class="font-weight-bold">{{ $routeCard->company_address ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GST No</label>
                <div class="font-weight-bold">{{ $routeCard->company_gstn ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Phone</label>
                <div class="font-weight-bold">{{ $routeCard->company_phone ?? '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Email</label>
                <div class="font-weight-bold">{{ $routeCard->company_email ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Quotation No</label>
                <div class="font-weight-bold">{{ $routeCard->quotation_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">RFQ No</label>
                <div class="font-weight-bold">{{ $routeCard->rfq_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Part No</label>
                <div class="font-weight-bold">{{ $routeCard->part_no ?? '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Product Type</label>
                <div class="font-weight-bold">{{ $routeCard->product_type ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Project Start Date</label>
                <div class="font-weight-bold">{{ $routeCard->project_start_date ? \Carbon\Carbon::parse($routeCard->project_start_date)->format('d M Y H:i') : '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Status</label>
                <div class="font-weight-bold">
                    @if ($routeCard->status == 'approved')
                        <span class="badge badge-success">Approved</span>
                    @elseif($routeCard->status == 'rejected')
                        <span class="badge badge-danger">Rejected</span>
                    @elseif($routeCard->status == 'planned')
                        <span class="badge badge-info">Planned</span>
                    @elseif($routeCard->status == 'ready_to_production')
                        <span class="badge badge-primary">Ready</span>
                    @elseif($routeCard->status == 'in_production')
                        <span class="badge badge-warning">In Progress</span>
                    @else
                        <span class="badge badge-secondary">{{ ucfirst($routeCard->status ?? 'Pending') }}</span>
                    @endif
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Description</label>
                <div class="font-weight-bold">{{ $routeCard->description ?? '-' }}</div>
            </div>
        </div>

        <hr>

        <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-stream mr-2"></i>Process Timeline (Live Map)</h6>

        <!-- Visual Timeline -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="p-3 bg-light rounded">
                    @php
                        $now = \Carbon\Carbon::now();
                    @endphp
                    @forelse ($routeCardProcesses as $i => $proc)
                        @php
                            $startDate = $proc->start_date ? \Carbon\Carbon::parse($proc->start_date) : null;
                            $endDate = $proc->end_date ? \Carbon\Carbon::parse($proc->end_date) : null;
                            $isCompleted = $endDate && $endDate->lt($now);
                            $isActive = $startDate && $endDate && $startDate->lte($now) && $endDate->gte($now);
                            $isPending = $startDate && $startDate->gt($now);
                        @endphp
                        <div class="process-timeline-item {{ $isCompleted ? 'completed' : ($isActive ? 'active' : 'pending') }}">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <h6 class="mb-1 font-weight-bold">
                                        {{ $i + 1 }}. {{ $proc->process ?? 'Process' }}
                                        @if($isCompleted)
                                            <span class="badge badge-success ml-2">Completed</span>
                                        @elseif($isActive)
                                            <span class="badge badge-warning ml-2">In Progress</span>
                                        @else
                                            <span class="badge badge-secondary ml-2">Pending</span>
                                        @endif
                                    </h6>
                                    <p class="mb-1 small text-muted">
                                        <i class="fas fa-cog mr-1"></i> {{ $proc->attchedMachine->machine_name ?? $proc->machine ?? 'N/A' }}
                                        <span class="mx-2">|</span>
                                        <i class="fas fa-user mr-1"></i> {{ $proc->attchedOperator->name ?? $proc->operator ?? 'N/A' }}
                                        <span class="mx-2">|</span>
                                        <i class="fas fa-clock mr-1"></i> {{ str_pad($proc->cycle_hours ?? 0, 2, '0', STR_PAD_LEFT) }}:{{ str_pad($proc->cycle_minutes ?? 0, 2, '0', STR_PAD_LEFT) }}
                                    </p>
                                </div>
                                <div class="text-right">
                                    <small class="text-muted d-block">
                                        <i class="fas fa-play mr-1"></i> {{ $proc->start_date ? \Carbon\Carbon::parse($proc->start_date)->format('d M H:i') : '-' }}
                                    </small>
                                    <small class="text-muted d-block">
                                        <i class="fas fa-stop mr-1"></i> {{ $proc->end_date ? \Carbon\Carbon::parse($proc->end_date)->format('d M H:i') : '-' }}
                                    </small>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-info-circle fa-2x mb-2"></i>
                            <p>No processes scheduled for this project</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

        <hr>

        <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-table mr-2"></i>Process Details Table</h6>

        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm">
                <thead class="thead-light">
                    <tr>
                        <th width="60">Sl No</th>
                        <th>Process</th>
                        <th>Source</th>
                        <th>Machine</th>
                        <th>Operator</th>
                        <th>Cycle Time</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($routeCardProcesses as $i => $proc)
                        @php
                            $startDate = $proc->start_date ? \Carbon\Carbon::parse($proc->start_date) : null;
                            $endDate = $proc->end_date ? \Carbon\Carbon::parse($proc->end_date) : null;
                            $isCompleted = $endDate && $endDate->lt($now);
                            $isActive = $startDate && $endDate && $startDate->lte($now) && $endDate->gte($now);
                        @endphp
                        <tr class="{{ $isActive ? 'table-warning' : ($isCompleted ? 'table-success' : '') }}">
                            <td>{{ $i + 1 }}</td>
                            <td>{{ $proc->process ?? '-' }}</td>
                            <td style="text-transform: capitalize">{{ $proc->source ?? '-' }}</td>
                            <td>{{ $proc->attchedMachine->machine_name ?? $proc->machine ?? '-' }}</td>
                            <td>{{ $proc->attchedOperator->name ?? $proc->operator ?? '-' }}</td>
                            <td>{{ str_pad($proc->cycle_hours ?? 0, 2, '0', STR_PAD_LEFT) }}:{{ str_pad($proc->cycle_minutes ?? 0, 2, '0', STR_PAD_LEFT) }}</td>
                            <td>{{ $proc->start_date ? \Carbon\Carbon::parse($proc->start_date)->format('d M Y H:i') : '-' }}</td>
                            <td>{{ $proc->end_date ? \Carbon\Carbon::parse($proc->end_date)->format('d M Y H:i') : '-' }}</td>
                            <td>
                                @if($isCompleted)
                                    <span class="badge badge-success">Done</span>
                                @elseif($isActive)
                                    <span class="badge badge-warning">Active</span>
                                @else
                                    <span class="badge badge-secondary">Pending</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted">No Process Records Found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <hr>

        <div class="d-flex justify-content-end">
            <a href="{{ route('superadmin.routecard.edit', $routeCard->id) }}" class="btn btn-warning btn-sm mr-2">
                <i class="fa fa-edit mr-1"></i> Edit
            </a>
            <a href="{{ route('superadmin.routecard.details') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fa fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
    </div>
</div>
@endsection
