@extends('layouts.dashboard.superadminapp')

@section('title', 'RFQ Details')

@section('content')
    <!-- Page Heading -->
    <x-layout.page-header title="UEPL | RFQ Details" icon="file-alt" iconColor="info" />

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <h6 class="m-0 font-weight-bold text-white">
                <i class="fas fa-file-alt mr-2"></i> RFQ Details
            </h6>
            <a href="{{ route('superadmin.purchasebom.rfq.rfqdetails') }}" class="btn btn-light btn-sm">
                <i class="fa fa-arrow-left"></i> Back
            </a>
        </div>
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">RFQ No</label>
                    <p class="mb-0 font-weight-bold">{{ $rfq->rfq_no }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">RFQ Date</label>
                    <p class="mb-0">{{ $rfq->rfq_date }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Vendor</label>
                    <p class="mb-0">{{ $rfq->customerInfo->company ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Vendor Ref No</label>
                    <p class="mb-0">{{ $rfq->vendor_reference_no ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">RFQ Type</label>
                    <p class="mb-0">{{ $rfq->rfq_type ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Status</label>
                    <p class="mb-0">
                        <span class="badge {{ $rfq->status == 'approved' ? 'bg-success' : ($rfq->status == 'rejected' ? 'bg-danger' : 'bg-secondary') }}" style="color:white">
                            {{ ucfirst($rfq->status ?? 'pending') }}
                        </span>
                    </p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Delivery Terms</label>
                    <p class="mb-0">{{ $rfq->delivery_terms ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Description</label>
                    <p class="mb-0">{{ $rfq->description ?? '-' }}</p>
                </div>
                <div class="col-md-12 mb-3">
                    <label class="small font-weight-bold text-primary">Note</label>
                    <p class="mb-0">{{ $rfq->note ?? '-' }}</p>
                </div>
            </div>

            <hr>

            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-paperclip mr-2"></i>Attachments</h6>
            <div class="row mb-4">
                @php $hasFiles = false; @endphp
                @foreach (['drawing' => 'Drawing File', 'material_spec' => 'Material Specification', 'rfq_form' => 'RFQ Form', 'annexure' => 'Annexure'] as $type => $label)
                    @php $files = $rfq->rfqFiles->where('file_type', $type); @endphp
                    @if ($files->count())
                        @php $hasFiles = true; @endphp
                        <div class="col-md-3 mb-2">
                            <label class="small font-weight-bold">{{ $label }}</label>
                            @foreach ($files as $file)
                                <a href="{{ asset('storage/' . $file->file_path) }}"
                                   target="_blank"
                                   class="btn btn-info btn-sm d-block mt-1"
                                   title="{{ $file->file_name }}">
                                   <i class="fas fa-download mr-1"></i> {{ $file->file_name }}
                                </a>
                            @endforeach
                        </div>
                    @endif
                @endforeach
                @if (!$hasFiles)
                    <div class="col-12">
                        <p class="text-muted mb-0">No attachments available.</p>
                    </div>
                @endif
            </div>

            <hr>

            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-boxes mr-2"></i>RFQ Item Details</h6>
            @if ($rfq->items->count())
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-sm">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>Item</th>
                                <th>Description</th>
                                <th>Quantity</th>
                                <th>UOM</th>
                                <th>Required By</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($rfq->items as $index => $item)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $item->stockItem->item_name ?? '-' }}</td>
                                    <td>{{ $item->description ?? '-' }}</td>
                                    <td>{{ $item->quantity ?? '-' }}</td>
                                    <td>{{ $item->uom ?? '-' }}</td>
                                    <td>{{ $item->required_by ?? '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted">No items added to this RFQ.</p>
            @endif

            <div class="d-flex justify-content-end mt-4">
                <a href="{{ route('superadmin.purchasebom.rfq.print', $rfq->id) }}" class="btn btn-success btn-sm mr-2" target="_blank">
                    <i class="fa fa-print mr-1"></i> Print
                </a>
                <a href="{{ route('superadmin.purchasebom.rfq.rfqdetails') }}" class="btn btn-secondary btn-sm">
                    <i class="fa fa-arrow-left mr-1"></i> Back to List
                </a>
            </div>
        </div>
    </div>
@endsection
