@extends('layouts.dashboard.superadminapp')

@section('title', 'Quotation Details')

@section('styles')
<style>
    div.dt-buttons {
        float: left;
        display: flex !important;
        margin-bottom: 1rem;
    }

    .dataTable {
        overflow-x: auto !important;
        display: table !important;
    }

    .dt-buttons .btn {
        margin-right: 0.5rem !important;
        padding: 0.25rem 0.75rem !important;
        font-size: 0.95rem !important;
    }

    .btn-delete {
        min-width: 80px;
    }

    .page-header-icon {
        font-size: 2rem;
        color: #506690;
        vertical-align: middle;
    }

    .table-actions .btn {
        padding: 0.2rem 0.4rem;
        font-size: 0.75rem;
    }
</style>
@endsection

@section('content')
    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Page Heading -->
    <x-layout.page-header title="UEPL | Quotation Details" icon="file-invoice" iconColor="warning" />

    <!-- Card Table -->
    <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center gap-3">
            <div></div>
            <!--<span class="fw-bold"><i class="fas fa-table me-2"></i>Quotation Details</span>-->
            <a href="{{ route('superadmin.purchasebom.quotation.quotationorder') }}" class="btn btn-primary btn-sm ms-2" style="float: right" title="Add New">
                <i class="fa fa-plus-square" aria-hidden="true"></i>
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-dark w-100" id="quotationTable">
                    <thead class="table-light">
                        <tr class="text-center align-middle">
                            <th>Quotation ID</th>
                            <th>Quotation Date</th>
                            <th>Customer Ref No</th>
                            <th>Company Name</th>
                            <th>Company Email</th>
                            <th>Company Contact No.</th>
                            <th>GST No.</th>
                            <th>Address</th>
                            <th>Product Type</th>
                            <th>Note</th>
                            <th>Total Amount</th>
                            <th>Status</th>
                            <th>View PDF</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($quotations as $quotation)
                            <tr class="text-center align-middle" id="row-{{ $quotation->id }}">
                                <td>{{ $quotation->quotation_no }}</td>
                                <td>{{ $quotation->quotation_date }}</td>
                                <td>{{ $quotation->cust_ref_no ?? '-' }}</td>
                                <td>{{ $quotation->customer->company ?? $quotation->customer_name }}</td>
                                <td>{{ $quotation->email }}</td>
                                <td>{{ $quotation->phone }}</td>
                                <td>{{ $quotation->gst }}</td>
                                <td>{{ $quotation->address }}</td>
                                <td>{{ $quotation->product_type }}</td>
                                <td>{{ $quotation->note }}</td>
                                <td>{{ $quotation->grand_total }}</td>
                                <td>
                                    <span class="badge 
        {{ $quotation->status == 'approved' ? 'bg-success' : ($quotation->status == 'rejected' ? 'bg-danger' : 'bg-secondary') }}" style="color:white">
        {{ ucfirst($quotation->status ?? '-') }}
    </span>
                                </td>
                                <td>
                                    <a href="{{ route('superadmin.purchasebom.quotation.print', $quotation->id) }}" target="_blank"
                                        class="btn btn-info btn-sm mb-1 print-btn" title="Print">
                                        <i class="fas fa-print"></i> 
                                    </a>
                                </td>

                                <td>
                                    <div class="btn-group table-actions" role="group">
                                        <a href="{{ route('superadmin.purchasebom.quotation.edit', $quotation->id) }}"
                                            class="btn btn-warning btn-sm" title="Edit"><i class="fa fa-edit"></i></a>
                                        @if ($quotation->status === 'pending')
                                            <button class="btn btn-success btn-sm approve-quotation-btn" data-id="{{ $quotation->id }}" title="Approve">
                                                <i class="fa fa-check"></i>
                                            </button>
                                            <button class="btn btn-secondary btn-sm reject-quotation-btn" data-id="{{ $quotation->id }}" title="Reject">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        @endif
                                        <button class="btn btn-danger btn-sm delete-btn"
                                            data-id="{{ $quotation->id }}" title="Delete"><i class="fa fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
@section('scripts')
    <script>
    $(document).on('click', '.approve-quotation-btn', function() {
    var id = $(this).data('id');
    Swal.fire({
        title: 'Approve Quotation?',
        text: "Are you sure you want to approve this quotation?",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, Approve',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.post("{{ url('superadmin/purchase/quotations') }}/" + id + "/approve", {
                _token: "{{ csrf_token() }}"
            }, function(response) {
                Swal.fire('Approved!', response.message, 'success').then(() => location.reload());
            }).fail(function() {
                Swal.fire('Error', 'Approval failed.', 'error');
            });
        }
    });
});

$(document).on('click', '.reject-quotation-btn', function() {
    var id = $(this).data('id');
    Swal.fire({
        title: 'Reject Quotation?',
        text: "Are you sure you want to reject this quotation?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, Reject',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.post("{{ url('superadmin/purchase/quotations') }}/" + id + "/reject", {
                _token: "{{ csrf_token() }}"
            }, function(response) {
                Swal.fire('Rejected!', response.message, 'success').then(() => location.reload());
            }).fail(function() {
                Swal.fire('Error', 'Rejection failed.', 'error');
            });
        }
    });
});

        $(document).ready(function() {
            // DataTable with export buttons
            $('#quotationTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                responsive: true,
                destroy: true,
            });

            // Handle delete button
            $(document).on('click', '.delete-btn', function() {
                var id = $(this).data('id');
                if (confirm('Are you sure you want to delete this quotation?')) {
                    fetch(`{{ url('superadmin/purchase/quotations') }}/${id}`, {
                            method: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                'Accept': 'application/json',
                            },
                        })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                // Option 1: Remove row and refresh
                                $(`#row-${id}`).remove();
                                location.reload();
                            } else {
                                alert('Delete failed');
                            }
                        })
                        .catch(() => alert('Error deleting record'));
                }
            });

        });
    </script>
@endsection
