@extends('layouts.dashboard.superadminapp')

@section('title', 'Purchase Order Details')

@section('content')
    <!-- Page Heading -->
    <x-layout.page-header title="UEPL | Purchase Order Details" icon="shopping-bag" iconColor="primary" />

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <h6 class="m-0 font-weight-bold text-white">
                <i class="fas fa-file-alt mr-2"></i> Purchase Order Details
            </h6>
            <div>
                <a href="{{ route('superadmin.purchase.order.print', $po->id) }}" class="btn btn-light btn-sm mr-2" target="_blank">
                    <i class="fa fa-print mr-1"></i> Print
                </a>
                <a href="{{ route('superadmin.purchase.purchasedetails') }}" class="btn btn-light btn-sm">
                    <i class="fa fa-arrow-left mr-1"></i> Back
                </a>
            </div>
        </div>
        <div class="card-body">
            <!-- PO Header Info -->
            <div class="row mb-4">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Purchase Order No</label>
                    <p class="mb-0 font-weight-bold">{{ $po->purchase_order_no }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Date</label>
                    <p class="mb-0">{{ \Carbon\Carbon::parse($po->purchase_order_date)->format('d M Y') }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Status</label>
                    <p class="mb-0">
                        <span class="badge {{ $po->status === 'approved' ? 'bg-success' : ($po->status === 'rejected' ? 'bg-danger' : 'bg-secondary') }}" style="color:white">
                            {{ ucfirst($po->status ?? 'pending') }}
                        </span>
                    </p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold text-primary">Vendor Reference No</label>
                    <p class="mb-0">{{ $po->customer_ref_no ?? '-' }}</p>
                </div>
            </div>

            <hr>

            <!-- Vendor Info -->
            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-building mr-2"></i>Vendor Information</h6>
            <div class="row mb-4">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Vendor Name</label>
                    <p class="mb-0">{{ $po->vendor->company ?? $po->company_name }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Address</label>
                    <p class="mb-0">{{ $po->company_address ?? '-' }}</p>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="small font-weight-bold">GSTN</label>
                    <p class="mb-0">{{ $po->company_gstn ?? '-' }}</p>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="small font-weight-bold">Phone</label>
                    <p class="mb-0">{{ $po->company_phone ?? '-' }}</p>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="small font-weight-bold">Email</label>
                    <p class="mb-0">{{ $po->company_email ?? '-' }}</p>
                </div>
            </div>

            <hr>

            <!-- Quotation & RFQ Info -->
            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-file-invoice mr-2"></i>Reference Information</h6>
            <div class="row mb-4">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Quotation No</label>
                    <p class="mb-0">{{ $po->quotation_no ?? '-' }}</p>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Quotation Date</label>
                    <p class="mb-0">{{ $po->quotation_date ? \Carbon\Carbon::parse($po->quotation_date)->format('d M Y') : '-' }}</p>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">RFQ No</label>
                    <p class="mb-0">{{ $po->rfq_no ?? '-' }}</p>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">RFQ Date</label>
                    <p class="mb-0">{{ $po->rfq_date ? \Carbon\Carbon::parse($po->rfq_date)->format('d M Y') : '-' }}</p>
                </div>
            </div>

            <hr>

            <!-- Additional Details -->
            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-info-circle mr-2"></i>Additional Details</h6>
            <div class="row mb-4">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Delivery Terms</label>
                    <p class="mb-0">{{ $po->delivery_terms ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Additional Charges</label>
                    <p class="mb-0">{{ $po->additional_charges ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Note I</label>
                    <p class="mb-0">{{ $po->description ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Note II</label>
                    <p class="mb-0">{{ $po->note ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Bill To</label>
                    <p class="mb-0">{{ $po->bill_address ?? '-' }}</p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Ship To</label>
                    <p class="mb-0">{{ $po->ship_address ?? '-' }}</p>
                </div>
            </div>

            <hr>

            <!-- Product Details -->
            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-cubes mr-2"></i>Product Details</h6>
            <div class="table-responsive mb-4">
                <table class="table table-bordered table-striped table-sm">
                    <thead class="thead-light">
                        <tr>
                            <th>Sl No.</th>
                            <th>Item</th>
                            <th>Description</th>
                            <th>Req By Date</th>
                            <th class="text-right">Qty</th>
                            <th>UOM</th>
                            <th class="text-right">Unit Rate</th>
                            <th class="text-right">TDS %</th>
                            <th class="text-right">Discount %</th>
                            <th class="text-right">Value</th>
                            <th class="text-right">SGST %</th>
                            <th class="text-right">CGST %</th>
                            <th class="text-right">IGST %</th>
                            <th class="text-right">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($po->items as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->stockItem->item_name ?? $item->item }}</td>
                                <td>{{ $item->description ?? '-' }}</td>
                                <td>{{ $item->req_by_date ? \Carbon\Carbon::parse($item->req_by_date)->format('d M Y') : '-' }}</td>
                                <td class="text-right">{{ $item->quantity }}</td>
                                <td>{{ $item->uom }}</td>
                                <td class="text-right">{{ number_format($item->unit_rate, 2) }}</td>
                                <td class="text-right">{{ $item->tds ?? 0 }}%</td>
                                <td class="text-right">{{ $item->discount ?? 0 }}%</td>
                                <td class="text-right">{{ number_format($item->value, 2) }}</td>
                                <td class="text-right">{{ $item->sgst ?? 0 }}%</td>
                                <td class="text-right">{{ $item->cgst ?? 0 }}%</td>
                                <td class="text-right">{{ $item->igst ?? 0 }}%</td>
                                <td class="text-right font-weight-bold">{{ number_format($item->amount, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <hr>

            <!-- Totals -->
            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-calculator mr-2"></i>Summary</h6>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="small font-weight-bold">Grand Total in Words</label>
                        <p class="mb-0 font-weight-bold text-primary">{{ $po->inr_in_words ?? '-' }}</p>
                    </div>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td class="text-right">Sub Total:</td>
                            <td class="text-right font-weight-bold" width="150">₹{{ number_format($po->subtotal, 2) }}</td>
                        </tr>
                        <tr>
                            <td class="text-right">SGST Amount:</td>
                            <td class="text-right">₹{{ number_format($po->sgst_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td class="text-right">CGST Amount:</td>
                            <td class="text-right">₹{{ number_format($po->cgst_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td class="text-right">IGST Amount:</td>
                            <td class="text-right">₹{{ number_format($po->igst_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td class="text-right">Round Up:</td>
                            <td class="text-right">₹{{ number_format($po->round_up, 2) }}</td>
                        </tr>
                        <tr class="border-top">
                            <td class="text-right font-weight-bold text-primary">Grand Total:</td>
                            <td class="text-right font-weight-bold text-primary" style="font-size: 1.2rem;">₹{{ number_format($po->grand_total, 2) }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            <hr>

            <div class="d-flex justify-content-end mt-4">
                <a href="{{ route('superadmin.purchase.order.edit', $po->id) }}" class="btn btn-warning btn-sm mr-2">
                    <i class="fa fa-edit mr-1"></i> Edit
                </a>
                <a href="{{ route('superadmin.purchase.order.print', $po->id) }}" class="btn btn-success btn-sm mr-2" target="_blank">
                    <i class="fa fa-print mr-1"></i> Print
                </a>
                <a href="{{ route('superadmin.purchase.purchasedetails') }}" class="btn btn-secondary btn-sm">
                    <i class="fa fa-arrow-left mr-1"></i> Back to List
                </a>
            </div>
        </div>
    </div>
@endsection
