@extends('layouts.dashboard.superadminapp')

@section('title', 'Stock Items')

@section('styles')
<style>
    /* Compact KPI Cards */
    .kpi-card {
        border-radius: 8px;
        color: #fff;
        position: relative;
        overflow: hidden;
        padding: 0.75rem 1rem !important;
    }
    .kpi-card .kpi-icon {
        font-size: 2rem;
        opacity: 0.25;
        position: absolute;
        right: 0.75rem;
        top: 50%;
        transform: translateY(-50%);
    }
    .kpi-card .kpi-value {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.1rem;
        line-height: 1.2;
    }
    .kpi-card .kpi-label {
        font-size: 0.7rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        opacity: 0.9;
    }
    .kpi-card .kpi-info {
        font-size: 0.65rem;
        margin-top: 0.25rem;
        opacity: 0.8;
    }

    /* Gradient backgrounds */
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }

    /* Compact Cards */
    .compact-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        margin-bottom: 0.75rem;
    }
    .compact-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.6rem 1rem;
    }
    .compact-card .card-body { padding: 1rem; }

    /* Enhanced DataTable Styling */
    .datatable-card .card-header {
        background: linear-gradient(135deg, #1cc88a 0%, #17a673 100%);
        border-radius: 8px 8px 0 0;
        padding: 0.6rem 1rem;
    }
    .datatable-card .card-header h6 {
        color: #fff;
        font-size: 0.85rem;
        margin: 0;
    }

    /* DataTable Container - Top Controls */
    #stockItemsTable_wrapper > .row:first-child {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        padding: 1rem 1.25rem;
        margin: 0 !important;
        border-bottom: 2px solid #e3e6f0;
        display: flex;
        align-items: center;
        justify-content: space-between;
        border-radius: 0;
    }

    /* DataTable Container - Bottom Controls */
    #stockItemsTable_wrapper .row.bottom-controls {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        padding: 1rem 1.25rem;
        margin: 0 !important;
        border-top: 2px solid #e3e6f0;
        display: flex !important;
        flex-direction: row !important;
        flex-wrap: nowrap !important;
        align-items: center !important;
        justify-content: space-between !important;
    }
    #stockItemsTable_wrapper .row.bottom-controls > div {
        padding: 0 0.5rem !important;
    }
    #stockItemsTable_wrapper .row.bottom-controls > div:first-child {
        display: flex;
        align-items: center;
    }
    #stockItemsTable_wrapper .row.bottom-controls > div:last-child {
        display: flex;
        align-items: center;
        justify-content: flex-end;
    }

    /* Enhanced Length Menu */
    #stockItemsTable_wrapper .dataTables_length {
        display: flex;
        align-items: center;
    }
    #stockItemsTable_wrapper .dataTables_length label {
        display: flex;
        align-items: center;
        gap: 0.6rem;
        font-size: 0.85rem;
        color: #5a5c69;
        margin-bottom: 0;
        font-weight: 500;
    }
    #stockItemsTable_wrapper .dataTables_length select {
        border: 2px solid #d1d9e6 !important;
        border-radius: 10px !important;
        padding: 0.6rem 2.2rem 0.6rem 1rem !important;
        font-size: 0.85rem !important;
        font-weight: 600 !important;
        color: #1cc88a !important;
        background: #fff url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%231cc88a' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E") no-repeat right 0.85rem center !important;
        background-size: 10px !important;
        appearance: none !important;
        -webkit-appearance: none !important;
        -moz-appearance: none !important;
        cursor: pointer;
        transition: all 0.2s ease;
        min-width: 75px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06);
    }
    #stockItemsTable_wrapper .dataTables_length select:hover {
        border-color: #1cc88a !important;
        background-color: #f8fff8 !important;
    }
    #stockItemsTable_wrapper .dataTables_length select:focus {
        border-color: #1cc88a !important;
        box-shadow: 0 0 0 4px rgba(28, 200, 138, 0.15) !important;
        outline: none !important;
    }

    /* Enhanced Search Box */
    #stockItemsTable_wrapper .dataTables_filter {
        display: flex;
        align-items: center;
        position: relative;
    }
    #stockItemsTable_wrapper .dataTables_filter label {
        display: flex;
        align-items: center;
        gap: 0;
        font-size: 0;
        color: transparent;
        margin-bottom: 0;
        position: relative;
    }
    #stockItemsTable_wrapper .dataTables_filter label::before {
        display: none !important;
    }
    #stockItemsTable_wrapper .dataTables_filter input[type="search"] {
        border: 2px solid #d1d9e6 !important;
        border-radius: 10px !important;
        padding: 0.6rem 1rem 0.6rem 2.5rem !important;
        font-size: 0.85rem !important;
        min-width: 260px;
        transition: all 0.2s ease;
        background: #fff url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E") no-repeat left 0.85rem center !important;
        background-size: 15px !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06);
        margin-left: 0 !important;
    }
    #stockItemsTable_wrapper .dataTables_filter input[type="search"]:hover {
        border-color: #b8c2cc !important;
        background-color: #fafbfc;
    }
    #stockItemsTable_wrapper .dataTables_filter input[type="search"]:focus {
        border-color: #1cc88a !important;
        box-shadow: 0 0 0 4px rgba(28, 200, 138, 0.15) !important;
        outline: none !important;
        background-color: #fff;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%231cc88a' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E") !important;
    }
    #stockItemsTable_wrapper .dataTables_filter input::placeholder {
        color: #adb5bd;
    }
    #stockItemsTable_wrapper .dataTables_filter .fa-search,
    #stockItemsTable_wrapper .dataTables_filter i {
        display: none !important;
    }

    /* Enhanced Info Text */
    #stockItemsTable_wrapper .dataTables_info {
        font-size: 0.8rem !important;
        color: #5a6169 !important;
        padding: 0.5rem 1rem !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%) !important;
        border-radius: 10px !important;
        border: 2px solid #e3e8f0 !important;
        font-weight: 600 !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.04);
    }

    /* Enhanced Pagination */
    #stockItemsTable_wrapper .dataTables_paginate {
        display: flex !important;
        align-items: center !important;
        gap: 0.35rem !important;
    }
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button {
        padding: 0.5rem 0.85rem !important;
        margin: 0 !important;
        border-radius: 10px !important;
        border: 2px solid #e3e8f0 !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%) !important;
        color: #5a5c69 !important;
        font-size: 0.8rem !important;
        font-weight: 600 !important;
        transition: all 0.2s ease !important;
        cursor: pointer !important;
        min-width: 40px !important;
        text-align: center !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06) !important;
        line-height: 1.2 !important;
    }
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button:hover:not(.disabled):not(.current) {
        background: linear-gradient(135deg, #1cc88a 0%, #17a673 100%) !important;
        border-color: #1cc88a !important;
        color: #fff !important;
        transform: translateY(-2px) !important;
        box-shadow: 0 6px 15px rgba(28, 200, 138, 0.4) !important;
    }
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button.current,
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button.current:hover {
        background: linear-gradient(135deg, #1cc88a 0%, #17a673 100%) !important;
        border-color: #1cc88a !important;
        color: #fff !important;
        box-shadow: 0 6px 15px rgba(28, 200, 138, 0.4) !important;
        transform: translateY(-1px) !important;
    }
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button.disabled,
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button.disabled:hover {
        opacity: 0.5 !important;
        cursor: not-allowed !important;
        background: #f1f3f8 !important;
        color: #adb5bd !important;
        box-shadow: none !important;
        border-color: #e3e8f0 !important;
        transform: none !important;
    }
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button.previous,
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button.next {
        background: linear-gradient(135deg, #f0f3f8 0%, #e8ecf4 100%) !important;
        border: 2px solid #d1d9e6 !important;
        font-weight: 700 !important;
    }
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button.previous:hover:not(.disabled),
    #stockItemsTable_wrapper .dataTables_paginate .paginate_button.next:hover:not(.disabled) {
        background: linear-gradient(135deg, #1cc88a 0%, #17a673 100%) !important;
        border-color: #1cc88a !important;
        color: #fff !important;
    }

    /* Pagination Ellipsis */
    #stockItemsTable_wrapper .dataTables_paginate .ellipsis {
        padding: 0.5rem 0.5rem !important;
        color: #6c757d;
        font-weight: 700;
    }

    /* Table Styling */
    #stockItemsTable {
        border-collapse: separate;
        border-spacing: 0;
        width: 100% !important;
    }
    #stockItemsTable thead th {
        background: linear-gradient(135deg, #f8f9fc 0%, #eaecf4 100%);
        border: none;
        border-bottom: 2px solid #e3e6f0;
        padding: 0.85rem 0.75rem;
        font-size: 0.75rem;
        font-weight: 700;
        color: #1cc88a;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        position: relative;
        cursor: pointer;
        transition: all 0.2s ease;
        white-space: nowrap;
    }
    #stockItemsTable thead th:hover {
        background: linear-gradient(135deg, #eef1f8 0%, #e3e8f4 100%);
        color: #17a673;
    }

    /* Enhanced Sort Indicators */
    #stockItemsTable thead th.sorting,
    #stockItemsTable thead th.sorting_asc,
    #stockItemsTable thead th.sorting_desc {
        padding-right: 2rem !important;
        position: relative;
    }

    #stockItemsTable thead th.sorting::before,
    #stockItemsTable thead th.sorting::after,
    #stockItemsTable thead th.sorting_asc::before,
    #stockItemsTable thead th.sorting_asc::after,
    #stockItemsTable thead th.sorting_desc::before,
    #stockItemsTable thead th.sorting_desc::after {
        display: none !important;
    }

    #stockItemsTable thead th.sorting::after,
    #stockItemsTable thead th.sorting_asc::after,
    #stockItemsTable thead th.sorting_desc::after {
        display: flex !important;
        position: absolute;
        right: 0.6rem;
        top: 50%;
        transform: translateY(-50%);
        width: 20px;
        height: 20px;
        align-items: center;
        justify-content: center;
        border-radius: 4px;
        font-family: 'Font Awesome 5 Free';
        font-weight: 900;
        font-size: 0.65rem;
        transition: all 0.2s ease;
    }

    #stockItemsTable thead th.sorting::after {
        content: '\f0dc' !important;
        color: #b8c2d0;
        background: transparent;
    }
    #stockItemsTable thead th.sorting:hover::after {
        color: #1cc88a;
        background: rgba(28, 200, 138, 0.1);
    }

    #stockItemsTable thead th.sorting_asc::after {
        content: '\f0de' !important;
        color: #fff;
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        font-size: 0.7rem;
        box-shadow: 0 2px 6px rgba(28, 200, 138, 0.4);
    }

    #stockItemsTable thead th.sorting_desc::after {
        content: '\f0dd' !important;
        color: #fff;
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        font-size: 0.7rem;
        box-shadow: 0 2px 6px rgba(231, 74, 59, 0.4);
    }

    #stockItemsTable thead th.sorting_asc {
        background: linear-gradient(135deg, #e8f8f0 0%, #d4f0e4 100%) !important;
        border-bottom-color: #1cc88a !important;
    }
    #stockItemsTable thead th.sorting_desc {
        background: linear-gradient(135deg, #fef0ee 0%, #fce4e1 100%) !important;
        border-bottom-color: #e74a3b !important;
    }

    #stockItemsTable tbody td {
        padding: 0.7rem 0.75rem;
        font-size: 0.8rem;
        border: none;
        border-bottom: 1px solid #e9ecef;
        vertical-align: middle;
    }
    #stockItemsTable tbody tr {
        transition: all 0.15s ease;
    }
    #stockItemsTable tbody tr:hover {
        background-color: #f0fff4 !important;
        transform: scale(1.002);
        box-shadow: 0 2px 8px rgba(28, 200, 138, 0.1);
    }
    #stockItemsTable tbody tr:nth-child(even) {
        background-color: #fafbfc;
    }

    /* Action Buttons */
    .action-btn {
        width: 30px;
        height: 30px;
        padding: 0;
        border-radius: 6px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
        transition: all 0.2s;
        border: none;
        margin: 0 2px;
    }
    .action-btn:hover { transform: scale(1.1); }
    .action-btn.edit-btn { background: #fff3cd; color: #856404; }
    .action-btn.edit-btn:hover { background: #f6c23e; color: #fff; }
    .action-btn.delete-btn { background: #ffebee; color: #c62828; }
    .action-btn.delete-btn:hover { background: #e74a3b; color: #fff; }

    /* Add Button */
    .add-btn {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        border: none;
        padding: 0.4rem 1rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 600;
        color: #fff;
        transition: all 0.2s;
    }
    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
    }

    .category-btn {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        border: none;
        padding: 0.4rem 1rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 600;
        color: #fff;
        transition: all 0.2s;
    }
    .category-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(54, 185, 204, 0.3);
        color: #fff;
    }

    .import-btn {
        background: linear-gradient(135deg, #5a5c69 0%, #3a3b45 100%);
        border: none;
        padding: 0.4rem 1rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 600;
        color: #fff;
        transition: all 0.2s;
    }
    .import-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(90, 92, 105, 0.3);
        color: #fff;
    }

    /* Quick Actions */
    .quick-link-card {
        background: #fff;
        border-radius: 8px;
        padding: 0.75rem;
        text-align: center;
        transition: all 0.2s;
        border: 1px solid rgba(0, 0, 0, 0.05);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
    }
    .quick-link-card:hover {
        border-color: #1cc88a;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.15);
    }
    .quick-link-card i { font-size: 1.25rem; margin-bottom: 0.25rem; }
    .quick-link-card .link-title { font-weight: 600; color: #333; font-size: 0.7rem; }

    /* Enhanced Modal Styling */
    #itemModal .modal-content,
    #categoryModal .modal-content,
    #deleteModal .modal-content {
        border: none;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }
    #itemModal .modal-header.primary-header,
    #categoryModal .modal-header.info-header {
        display: flex !important;
        align-items: center;
        justify-content: space-between;
        min-height: 45px;
    }
    #itemModal .modal-header.primary-header {
        background: linear-gradient(135deg, #1cc88a 0%, #17a673 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    #categoryModal .modal-header.info-header {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    #deleteModal .modal-header.danger-header {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    #itemModal .modal-header .close,
    #categoryModal .modal-header .close,
    #deleteModal .modal-header .close {
        opacity: 1;
        text-shadow: none;
        padding: 0;
        margin: 0;
        width: 26px;
        height: 26px;
        border-radius: 50%;
        background: rgba(255,255,255,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 1.2rem;
        line-height: 1;
        transition: all 0.2s;
    }
    #itemModal .modal-header .close:hover,
    #categoryModal .modal-header .close:hover,
    #deleteModal .modal-header .close:hover {
        background: rgba(255,255,255,0.35);
        transform: rotate(90deg);
    }
    #itemModal .modal-title,
    #categoryModal .modal-title,
    #deleteModal .modal-title {
        font-size: 0.9rem;
        font-weight: 600;
        color: #fff !important;
    }
    #itemModal .modal-body,
    #categoryModal .modal-body {
        padding: 1rem !important;
        background: #fff;
    }
    #deleteModal .modal-body {
        padding: 1rem !important;
        background: #fff;
    }
    #itemModal .modal-footer,
    #categoryModal .modal-footer,
    #deleteModal .modal-footer {
        background: #f8f9fc;
        border-top: 1px solid #e3e6f0;
        padding: 0.6rem 1rem;
        display: flex;
        justify-content: flex-end;
        gap: 0.5rem;
    }
    #deleteModal .modal-footer {
        justify-content: center;
    }
    #itemModal .modal-footer .btn,
    #categoryModal .modal-footer .btn,
    #deleteModal .modal-footer .btn {
        border-radius: 5px;
        padding: 0.45rem 1rem;
        font-weight: 600;
        font-size: 0.8rem;
        min-width: 95px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.3rem;
        height: 34px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        transition: all 0.2s;
    }
    #itemModal .modal-footer .btn:hover,
    #categoryModal .modal-footer .btn:hover,
    #deleteModal .modal-footer .btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 3px 8px rgba(0,0,0,0.15);
    }
    #itemModal .modal-footer .btn-secondary,
    #categoryModal .modal-footer .btn-secondary,
    #deleteModal .modal-footer .btn-secondary {
        background: linear-gradient(135deg, #6c757d 0%, #545b62 100%);
        border: none;
        color: #fff;
    }
    #itemModal .modal-footer .btn-primary {
        background: linear-gradient(135deg, #1cc88a 0%, #17a673 100%);
        border: none;
        color: #fff;
    }
    #categoryModal .modal-footer .btn-info {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        border: none;
        color: #fff;
    }
    #deleteModal .modal-footer .btn-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        border: none;
        color: #fff;
    }

    /* Compact Form Styling */
    #itemModal .form-label,
    #categoryModal .form-label {
        font-size: 0.8rem;
        font-weight: 600;
        color: #495057;
        margin-bottom: 0.3rem;
        display: flex;
        align-items: center;
        gap: 0.25rem;
    }
    #itemModal .form-label i,
    #categoryModal .form-label i {
        font-size: 0.75rem;
    }
    #itemModal .form-control-modern,
    #categoryModal .form-control-modern,
    #itemModal .form-select-modern,
    #categoryModal .form-select-modern {
        border: 1px solid #d1d3e2;
        border-radius: 5px;
        padding: 0.5rem 0.75rem;
        font-size: 0.85rem;
        height: 38px;
        transition: all 0.2s;
        background: #fff;
    }
    #itemModal .form-control-modern:hover,
    #categoryModal .form-control-modern:hover,
    #itemModal .form-select-modern:hover,
    #categoryModal .form-select-modern:hover {
        border-color: #b8bcc5;
    }
    #itemModal .form-control-modern:focus,
    #categoryModal .form-control-modern:focus,
    #itemModal .form-select-modern:focus,
    #categoryModal .form-select-modern:focus {
        border-color: #1cc88a;
        box-shadow: 0 0 0 2px rgba(28, 200, 138, 0.15);
        background: #fff;
    }
    #itemModal .form-control-modern::placeholder,
    #categoryModal .form-control-modern::placeholder {
        color: #adb5bd;
        font-size: 0.82rem;
    }

    /* Form Error Alert */
    #formErrors {
        border-radius: 5px;
        border: none;
        background: #fff5f5;
        border-left: 3px solid #e74a3b;
        padding: 0.5rem 0.75rem;
        margin-bottom: 0.75rem;
    }
    #formErrors ul { margin-bottom: 0; font-size: 0.8rem; }

    /* Delete Modal Enhancement */
    .delete-modal-icon {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background: linear-gradient(135deg, #fff5f5 0%, #fee8e7 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 0.6rem;
        border: 2px solid #f8d7da;
    }
    .delete-modal-icon i {
        font-size: 1.3rem;
        color: #e74a3b;
    }
    .delete-item-name {
        background: #f8f9fc;
        padding: 0.4rem 0.8rem;
        border-radius: 5px;
        border: 1px dashed #d1d3e2;
        display: inline-block;
        font-size: 0.85rem;
    }

    /* Enhanced Toast Notification */
    .custom-toast {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 280px;
        max-width: 350px;
        border-radius: 8px;
        box-shadow: 0 8px 24px rgba(0,0,0,0.2);
        border: none;
        animation: slideInRight 0.3s ease;
    }
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    .custom-toast .toast-body {
        padding: 0.65rem 1rem;
        font-size: 0.85rem;
        font-weight: 500;
        display: flex;
        align-items: center;
    }
    .custom-toast .close {
        color: rgba(255,255,255,0.8);
        opacity: 1;
        text-shadow: none;
    }
    .custom-toast.bg-success {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%) !important;
    }
    .custom-toast.bg-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
    }

    /* Modal Animation */
    .modal.fade .modal-dialog {
        transform: scale(0.9) translateY(-20px);
        transition: transform 0.2s ease;
    }
    .modal.show .modal-dialog {
        transform: scale(1) translateY(0);
    }

    /* Empty state styling */
    #stockItemsTable tbody .dataTables_empty {
        padding: 2rem !important;
        color: #6c757d;
    }

    /* Loading state */
    .dataTables_processing {
        background: linear-gradient(135deg, rgba(28, 200, 138, 0.95) 0%, rgba(23, 166, 115, 0.95) 100%) !important;
        color: #fff !important;
        border-radius: 8px !important;
        padding: 0.75rem 1.5rem !important;
        font-weight: 600 !important;
        box-shadow: 0 4px 15px rgba(28, 200, 138, 0.4) !important;
    }

    /* Import Form Styling */
    .import-file-input {
        border: 2px solid #d1d3e2 !important;
        border-radius: 6px !important;
        padding: 0.3rem 0.5rem !important;
        font-size: 0.75rem !important;
        max-width: 160px;
        transition: all 0.2s;
    }
    .import-file-input:focus {
        border-color: #5a5c69 !important;
        box-shadow: 0 0 0 2px rgba(90, 92, 105, 0.15) !important;
    }

    /* Responsive */
    @media (max-width: 992px) {
        #stockItemsTable_wrapper > .row:first-child {
            flex-direction: column;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
        }
        #stockItemsTable_wrapper .dataTables_length,
        #stockItemsTable_wrapper .dataTables_filter {
            justify-content: center !important;
            width: 100%;
            text-align: center;
        }
        #stockItemsTable_wrapper .dataTables_filter input[type="search"] {
            min-width: 100% !important;
            width: 100% !important;
        }
    }
    @media (max-width: 768px) {
        .kpi-card .kpi-value { font-size: 1.25rem; }
        .page-header { flex-direction: column; gap: 0.5rem; }
        #stockItemsTable_wrapper .dataTables_filter input[type="search"] {
            min-width: 200px !important;
        }
        #stockItemsTable_wrapper .dataTables_paginate .paginate_button {
            padding: 0.4rem 0.65rem !important;
            min-width: 34px !important;
            font-size: 0.75rem !important;
        }
        #stockItemsTable_wrapper .dataTables_info {
            font-size: 0.75rem !important;
            padding: 0.4rem 0.75rem !important;
        }
    }
    @media (max-width: 576px) {
        #stockItemsTable_wrapper .row.bottom-controls {
            flex-direction: column !important;
            gap: 0.75rem;
        }
        #stockItemsTable_wrapper .row.bottom-controls > div {
            width: 100% !important;
            justify-content: center !important;
            max-width: 100% !important;
            flex: 0 0 100% !important;
        }
        #stockItemsTable_wrapper .dataTables_info,
        #stockItemsTable_wrapper .dataTables_paginate {
            justify-content: center !important;
            width: 100% !important;
        }
        #stockItemsTable_wrapper .dataTables_paginate {
            flex-wrap: wrap !important;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">

    <!-- Page Header Component -->
    <x-layout.page-header title="UEPL | Stock Items" icon="boxes" iconColor="success" />

    <!-- KPI Cards Row -->
    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-success shadow">
                <i class="fas fa-boxes kpi-icon"></i>
                <div class="kpi-value" id="totalCount">{{ count($stockItems) }}</div>
                <div class="kpi-label">Total Stock Items</div>
                <div class="kpi-info"><i class="fas fa-database mr-1"></i> Inventory items</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-info shadow">
                <i class="fas fa-folder-open kpi-icon"></i>
                <div class="kpi-value" id="categoryCount">{{ count($categories) }}</div>
                <div class="kpi-label">Categories</div>
                <div class="kpi-info"><i class="fas fa-list mr-1"></i> Item groups</div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="compact-card card shadow mb-3">
        <div class="card-header d-flex align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-info" style="font-size: 0.85rem;">
                <i class="fas fa-bolt mr-2"></i>Quick Actions
            </h6>
        </div>
        <div class="card-body py-2">
            <div class="row">
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="javascript:void(0)" class="text-decoration-none" id="quickAddItemBtn">
                        <div class="quick-link-card">
                            <i class="fas fa-plus-circle text-success"></i>
                            <div class="link-title">Add Item</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="javascript:void(0)" class="text-decoration-none" id="quickAddCategoryBtn">
                        <div class="quick-link-card">
                            <i class="fas fa-folder-plus text-info"></i>
                            <div class="link-title">Add Category</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.rawmaterial.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-cubes text-primary"></i>
                            <div class="link-title">Raw Materials</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.producttype.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-box text-warning"></i>
                            <div class="link-title">Product Types</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.dashboard.dashboard') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-tachometer-alt text-secondary"></i>
                            <div class="link-title">Dashboard</div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- DataTable Card -->
    <div class="compact-card card datatable-card shadow">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-table mr-2"></i> Stock Items Directory
            </h6>
            <div class="d-flex flex-wrap align-items-center" style="gap: 0.5rem;">
                <button class="category-btn" id="addCategoryBtn" title="Add Category">
                    <i class="fas fa-folder-plus mr-1"></i> Category
                </button>
                <button class="add-btn" id="addItemBtn" title="Add Stock Item">
                    <i class="fas fa-plus mr-1"></i> Add Item
                </button>
                <form action="{{ route('superadmin.stockitems.import') }}" method="POST" enctype="multipart/form-data" class="d-flex align-items-center" style="gap: 0.35rem;" id="importForm">
                    @csrf
                    <input type="file" name="excel_file" class="form-control import-file-input" required>
                    <button type="submit" class="import-btn">
                        <i class="fas fa-file-import mr-1"></i> Import
                    </button>
                </form>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0" id="stockItemsTable">
                    <thead>
                        <tr class="text-center">
                            <th width="8%">Sl.No</th>
                            <th width="30%">Item Name</th>
                            <th width="18%">Category</th>
                            <th width="10%">UOM</th>
                            <th width="8%">SGST</th>
                            <th width="8%">CGST</th>
                            <th width="8%">IGST</th>
                            <th width="10%">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stockItems as $item)
                        <tr class="text-center">
                            <td class="font-weight-bold text-muted">{{ $loop->iteration }}</td>
                            <td class="text-left">
                                <i class="fas fa-box text-success mr-2"></i>
                                <span class="font-weight-500">{{ $item->item_name }}</span>
                            </td>
                            <td>
                                <span class="badge badge-light text-dark">
                                    <i class="fas fa-folder mr-1"></i>{{ $item->category->name ?? 'N/A' }}
                                </span>
                            </td>
                            <td>{{ $item->uom ?? '-' }}</td>
                            <td>{{ $item->sgst ?? '0' }}%</td>
                            <td>{{ $item->cgst ?? '0' }}%</td>
                            <td>{{ $item->igst ?? '0' }}%</td>
                            <td>
                                <button class="action-btn edit-btn editItemBtn" title="Edit"
                                    data-id="{{ $item->id }}"
                                    data-item_name="{{ $item->item_name }}"
                                    data-category_id="{{ $item->category_id }}"
                                    data-uom="{{ $item->uom }}"
                                    data-sgst="{{ $item->sgst }}"
                                    data-cgst="{{ $item->cgst }}"
                                    data-igst="{{ $item->igst }}">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="action-btn delete-btn deleteItemBtn" title="Delete"
                                    data-id="{{ $item->id }}"
                                    data-name="{{ $item->item_name }}">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- Add Category Modal -->
<div class="modal fade" id="categoryModal" tabindex="-1" aria-labelledby="categoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header info-header">
                <h6 class="modal-title mb-0" id="categoryModalLabel">
                    <i class="fas fa-folder-plus mr-2"></i>Add Category
                </h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <form id="categoryForm">
                @csrf
                <div class="modal-body">
                    <div id="categoryFormErrors" class="alert alert-danger d-none" role="alert">
                        <small><i class="fas fa-exclamation-triangle mr-1"></i><strong>Error:</strong></small>
                        <ul class="mb-0 pl-3 small" id="categoryErrorList"></ul>
                    </div>
                    <div class="form-group mb-0">
                        <label class="form-label"><i class="fas fa-folder text-info"></i> Category Name <span class="text-danger">*</span></label>
                        <input name="name" id="categoryName" class="form-control form-control-modern" placeholder="Enter category name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times"></i>
                        <span>Cancel</span>
                    </button>
                    <button type="submit" class="btn btn-info" id="saveCategoryBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <i class="fas fa-check btn-icon"></i>
                        <span class="btn-text">Save</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add/Edit Item Modal -->
<div class="modal fade" id="itemModal" tabindex="-1" aria-labelledby="itemModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header primary-header">
                <h6 class="modal-title mb-0" id="itemModalLabel">
                    <i class="fas fa-plus-circle mr-2" id="itemModalIcon"></i>Add Stock Item
                </h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <form id="itemForm">
                @csrf
                <input type="hidden" name="item_id" id="item_id">
                <div class="modal-body">
                    <div id="itemFormErrors" class="alert alert-danger d-none" role="alert">
                        <small><i class="fas fa-exclamation-triangle mr-1"></i><strong>Error:</strong></small>
                        <ul class="mb-0 pl-3 small" id="itemErrorList"></ul>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><i class="fas fa-folder text-info"></i> Category <span class="text-danger">*</span></label>
                            <select name="category_id" id="category_id" class="form-control form-select-modern" required>
                                <option value="">Select Category</option>
                                @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><i class="fas fa-box text-success"></i> Item Name <span class="text-danger">*</span></label>
                            <input type="text" name="item_name" id="item_name" class="form-control form-control-modern" placeholder="Enter item name" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><i class="fas fa-ruler text-primary"></i> UOM (Unit of Measure)</label>
                            <input type="text" name="uom" id="uom" class="form-control form-control-modern" placeholder="e.g., kg, pcs, mtrs">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><i class="fas fa-percent text-warning"></i> SGST (%)</label>
                            <input type="number" step="0.01" name="sgst" id="sgst" class="form-control form-control-modern" placeholder="0.00">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><i class="fas fa-percent text-warning"></i> CGST (%)</label>
                            <input type="number" step="0.01" name="cgst" id="cgst" class="form-control form-control-modern" placeholder="0.00">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label"><i class="fas fa-percent text-warning"></i> IGST (%)</label>
                            <input type="number" step="0.01" name="igst" id="igst" class="form-control form-control-modern" placeholder="0.00">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times"></i>
                        <span>Cancel</span>
                    </button>
                    <button type="submit" class="btn btn-primary" id="saveItemBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <i class="fas fa-check btn-icon"></i>
                        <span class="btn-text">Save</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header danger-header">
                <h6 class="modal-title mb-0" id="deleteModalLabel">
                    <i class="fas fa-exclamation-triangle mr-2"></i>Confirm Delete
                </h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <div class="delete-modal-icon">
                    <i class="fas fa-box"></i>
                </div>
                <p class="text-dark mb-2">Are you sure you want to delete?</p>
                <div class="delete-item-name">
                    <i class="fas fa-box mr-1 text-muted"></i>
                    <span class="font-weight-bold" id="deleteItemName"></span>
                </div>
                <p class="text-muted mt-2 mb-0"><small><i class="fas fa-exclamation-circle mr-1"></i>This action cannot be undone.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i>
                    <span>Cancel</span>
                </button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                    <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                    <i class="fas fa-trash-alt btn-icon"></i>
                    <span class="btn-text">Delete</span>
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    var deleteId = null;

    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        document.getElementById('day').textContent = days[now.getDay()];
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = months[now.getMonth()];
        document.getElementById('year').textContent = now.getFullYear();

        const timeStr = now.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        document.querySelector('.display-time').textContent = timeStr;
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);

    // Initialize DataTable
    $('#stockItemsTable').DataTable({
        pageLength: 10,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
        order: [[0, 'asc']],
        columnDefs: [
            { orderable: false, targets: [7] },
            { className: 'align-middle', targets: '_all' }
        ],
        language: {
            search: '',
            searchPlaceholder: 'Search stock items...',
            lengthMenu: 'Show _MENU_',
            info: 'Showing _START_ to _END_ of _TOTAL_',
            infoEmpty: 'No entries found',
            infoFiltered: '(filtered from _MAX_)',
            paginate: {
                first: '<i class="fas fa-angle-double-left"></i>',
                last: '<i class="fas fa-angle-double-right"></i>',
                next: '<i class="fas fa-chevron-right"></i>',
                previous: '<i class="fas fa-chevron-left"></i>'
            },
            emptyTable: '<div class="text-center py-4"><i class="fas fa-boxes fa-3x text-muted mb-3"></i><p class="text-muted">No stock items found</p></div>'
        },
        dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rt<"row bottom-controls"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7 d-flex justify-content-end"p>>'
    });

    // Toast notification helper
    function showToast(type, message) {
        $('.custom-toast').remove();

        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast custom-toast ${bgClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3500">
                <div class="toast-body">
                    <i class="fas ${icon} mr-2"></i>
                    <span class="flex-grow-1">${message}</span>
                    <button type="button" class="close ml-2" data-dismiss="toast" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');

        $toast.on('hidden.bs.toast', function() {
            $(this).remove();
        });
    }

    // Show flash messages from session
    @if(session('success'))
        showToast('success', "{{ session('success') }}");
    @endif
    @if(session('error'))
        showToast('error', "{{ session('error') }}");
    @endif
    @if(session('warning'))
        showToast('error', "{{ session('warning') }}");
    @endif

    // Open Add Category Modal
    function openCategoryModal() {
        $('#categoryForm')[0].reset();
        $('#categoryFormErrors').addClass('d-none');
        $('#categoryModal').modal('show');
    }

    $('#addCategoryBtn').on('click', openCategoryModal);
    $('#quickAddCategoryBtn').on('click', openCategoryModal);

    // Open Add Item Modal
    function openAddItemModal() {
        $('#itemForm')[0].reset();
        $('#item_id').val('');
        $('#itemFormErrors').addClass('d-none');
        $('#itemModalIcon').removeClass('fa-edit').addClass('fa-plus-circle');
        $('#itemModalLabel').html('<i class="fas fa-plus-circle mr-2" id="itemModalIcon"></i>Add Stock Item');
        $('#itemModal').modal('show');
    }

    $('#addItemBtn').on('click', openAddItemModal);
    $('#quickAddItemBtn').on('click', openAddItemModal);

    // Edit Item button click
    $(document).on('click', '.editItemBtn', function() {
        $('#itemForm')[0].reset();
        $('#itemFormErrors').addClass('d-none');

        $('#item_id').val($(this).data('id'));
        $('#item_name').val($(this).data('item_name'));
        $('#category_id').val($(this).data('category_id'));
        $('#uom').val($(this).data('uom'));
        $('#sgst').val($(this).data('sgst'));
        $('#cgst').val($(this).data('cgst'));
        $('#igst').val($(this).data('igst'));

        $('#itemModalIcon').removeClass('fa-plus-circle').addClass('fa-edit');
        $('#itemModalLabel').html('<i class="fas fa-edit mr-2" id="itemModalIcon"></i>Edit Stock Item');
        $('#itemModal').modal('show');
    });

    // Category form submission
    $('#categoryForm').submit(function(e) {
        e.preventDefault();

        var $btn = $('#saveCategoryBtn');
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Saving...');

        $.ajax({
            url: "{{ route('superadmin.categories.store') }}",
            type: 'POST',
            data: $(this).serialize(),
            success: function(res) {
                $('#categoryModal').modal('hide');
                showToast('success', res.message || 'Category added successfully!');
                setTimeout(function() { location.reload(); }, 1000);
            },
            error: function(err) {
                var errors = err.responseJSON?.errors || {};
                var message = err.responseJSON?.message || 'An error occurred';

                if (Object.keys(errors).length > 0) {
                    var errorHtml = '';
                    $.each(errors, function(field, messages) {
                        $.each(messages, function(i, msg) {
                            errorHtml += '<li>' + msg + '</li>';
                        });
                    });
                    $('#categoryErrorList').html(errorHtml);
                    $('#categoryFormErrors').removeClass('d-none');
                } else {
                    showToast('error', message);
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Save');
            }
        });
    });

    // Item form submission
    $('#itemForm').submit(function(e) {
        e.preventDefault();

        var $btn = $('#saveItemBtn');
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Saving...');

        var id = $('#item_id').val();
        var url = id
            ? "{{ url('superadmin/stockitems') }}/" + id
            : "{{ route('superadmin.stockitems.store') }}";

        $.ajax({
            url: url,
            type: 'POST',
            data: $(this).serialize() + (id ? '&_method=PUT' : ''),
            success: function(res) {
                $('#itemModal').modal('hide');
                showToast('success', res.message || (id ? 'Item updated successfully!' : 'Item added successfully!'));
                setTimeout(function() { location.reload(); }, 1000);
            },
            error: function(err) {
                var errors = err.responseJSON?.errors || {};
                var message = err.responseJSON?.message || 'An error occurred';

                if (Object.keys(errors).length > 0) {
                    var errorHtml = '';
                    $.each(errors, function(field, messages) {
                        $.each(messages, function(i, msg) {
                            errorHtml += '<li>' + msg + '</li>';
                        });
                    });
                    $('#itemErrorList').html(errorHtml);
                    $('#itemFormErrors').removeClass('d-none');
                } else {
                    showToast('error', message);
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Save');
            }
        });
    });

    // Delete button click
    $(document).on('click', '.deleteItemBtn', function() {
        deleteId = $(this).data('id');
        $('#deleteItemName').text($(this).data('name'));
        $('#deleteModal').modal('show');
    });

    // Confirm delete
    $('#confirmDeleteBtn').on('click', function() {
        if (!deleteId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Deleting...');

        $.ajax({
            url: "{{ url('superadmin/stockitems') }}/" + deleteId,
            type: 'DELETE',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(res) {
                $('#deleteModal').modal('hide');
                showToast('success', res.message || 'Item deleted successfully!');
                setTimeout(function() { location.reload(); }, 1000);
            },
            error: function(err) {
                showToast('error', err.responseJSON?.message || 'Failed to delete');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Delete');
                deleteId = null;
            }
        });
    });
});
</script>
@endsection
