@extends('layouts.dashboard.superadminapp')

@section('title', 'RFQ Types')

@section('styles')
<style>
    /* Compact Page Header */
    .page-header {
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 0.75rem;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.04);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin: 0;
    }

    /* DateTime Display */
    .datetime-display { gap: 0.5rem; }
    .date-box, .time-box {
        display: flex;
        align-items: center;
        gap: 0.35rem;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 0.35rem 0.65rem;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
        font-size: 0.75rem;
        color: #475569;
        font-weight: 500;
    }
    .date-box i, .time-box i { color: #4e73df; font-size: 0.7rem; }
    .time-box {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        border: none;
        min-width: 85px;
        justify-content: center;
    }
    .time-box i { color: rgba(255,255,255,0.8); }
    .time-box .display-time {
        font-family: 'Courier New', monospace;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    /* Compact KPI Cards */
    .kpi-card {
        border-radius: 8px;
        color: #fff;
        position: relative;
        overflow: hidden;
        padding: 0.75rem 1rem !important;
    }
    .kpi-card .kpi-icon {
        font-size: 2rem;
        opacity: 0.25;
        position: absolute;
        right: 0.75rem;
        top: 50%;
        transform: translateY(-50%);
    }
    .kpi-card .kpi-value {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.1rem;
        line-height: 1.2;
    }
    .kpi-card .kpi-label {
        font-size: 0.7rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        opacity: 0.9;
    }
    .kpi-card .kpi-info {
        font-size: 0.65rem;
        margin-top: 0.25rem;
        opacity: 0.8;
    }

    /* Gradient backgrounds */
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }

    /* Compact Cards */
    .compact-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        margin-bottom: 0.75rem;
    }
    .compact-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.6rem 1rem;
    }
    .compact-card .card-body { padding: 1rem; }

    /* Enhanced DataTable Styling */
    .datatable-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        border-radius: 8px 8px 0 0;
        padding: 0.6rem 1rem;
    }
    .datatable-card .card-header h6 {
        color: #fff;
        font-size: 0.85rem;
        margin: 0;
    }

    /* DataTable Container - Top Controls */
    #rfqTypeTable_wrapper > .row:first-child {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        padding: 1rem 1.25rem;
        margin: 0 !important;
        border-bottom: 2px solid #e3e6f0;
        display: flex;
        align-items: center;
        justify-content: space-between;
        border-radius: 0;
    }

    /* DataTable Container - Bottom Controls */
    #rfqTypeTable_wrapper .row.bottom-controls {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        padding: 1rem 1.25rem;
        margin: 0 !important;
        border-top: 2px solid #e3e6f0;
        display: flex !important;
        flex-direction: row !important;
        flex-wrap: nowrap !important;
        align-items: center !important;
        justify-content: space-between !important;
    }
    #rfqTypeTable_wrapper .row.bottom-controls > div {
        padding: 0 0.5rem !important;
    }
    #rfqTypeTable_wrapper .row.bottom-controls > div:first-child {
        display: flex;
        align-items: center;
    }
    #rfqTypeTable_wrapper .row.bottom-controls > div:last-child {
        display: flex;
        align-items: center;
        justify-content: flex-end;
    }

    /* Enhanced Length Menu */
    #rfqTypeTable_wrapper .dataTables_length {
        display: flex;
        align-items: center;
    }
    #rfqTypeTable_wrapper .dataTables_length label {
        display: flex;
        align-items: center;
        gap: 0.6rem;
        font-size: 0.85rem;
        color: #5a5c69;
        margin-bottom: 0;
        font-weight: 500;
    }
    #rfqTypeTable_wrapper .dataTables_length select {
        border: 2px solid #d1d9e6 !important;
        border-radius: 10px !important;
        padding: 0.6rem 2.2rem 0.6rem 1rem !important;
        font-size: 0.85rem !important;
        font-weight: 600 !important;
        color: #4e73df !important;
        background: #fff url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%234e73df' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E") no-repeat right 0.85rem center !important;
        background-size: 10px !important;
        appearance: none !important;
        -webkit-appearance: none !important;
        -moz-appearance: none !important;
        cursor: pointer;
        transition: all 0.2s ease;
        min-width: 75px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06);
    }
    #rfqTypeTable_wrapper .dataTables_length select:hover {
        border-color: #4e73df !important;
        background-color: #f8f9ff !important;
    }
    #rfqTypeTable_wrapper .dataTables_length select:focus {
        border-color: #4e73df !important;
        box-shadow: 0 0 0 4px rgba(78, 115, 223, 0.15) !important;
        outline: none !important;
    }

    /* Enhanced Search Box */
    #rfqTypeTable_wrapper .dataTables_filter {
        display: flex;
        align-items: center;
        position: relative;
    }
    #rfqTypeTable_wrapper .dataTables_filter label {
        display: flex;
        align-items: center;
        gap: 0;
        font-size: 0;
        color: transparent;
        margin-bottom: 0;
        position: relative;
    }
    #rfqTypeTable_wrapper .dataTables_filter label::before {
        display: none !important;
    }
    #rfqTypeTable_wrapper .dataTables_filter input[type="search"] {
        border: 2px solid #d1d9e6 !important;
        border-radius: 10px !important;
        padding: 0.6rem 1rem 0.6rem 2.5rem !important;
        font-size: 0.85rem !important;
        min-width: 260px;
        transition: all 0.2s ease;
        background: #fff url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E") no-repeat left 0.85rem center !important;
        background-size: 15px !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06);
        margin-left: 0 !important;
    }
    #rfqTypeTable_wrapper .dataTables_filter input[type="search"]:hover {
        border-color: #b8c2cc !important;
        background-color: #fafbfc;
    }
    #rfqTypeTable_wrapper .dataTables_filter input[type="search"]:focus {
        border-color: #4e73df !important;
        box-shadow: 0 0 0 4px rgba(78, 115, 223, 0.15) !important;
        outline: none !important;
        background-color: #fff;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%234e73df' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E") !important;
    }
    #rfqTypeTable_wrapper .dataTables_filter input::placeholder {
        color: #adb5bd;
    }
    #rfqTypeTable_wrapper .dataTables_filter .fa-search,
    #rfqTypeTable_wrapper .dataTables_filter i {
        display: none !important;
    }

    /* Enhanced Info Text */
    #rfqTypeTable_wrapper .dataTables_info {
        font-size: 0.8rem !important;
        color: #5a6169 !important;
        padding: 0.5rem 1rem !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%) !important;
        border-radius: 10px !important;
        border: 2px solid #e3e8f0 !important;
        font-weight: 600 !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.04);
    }

    /* Enhanced Pagination */
    #rfqTypeTable_wrapper .dataTables_paginate {
        display: flex !important;
        align-items: center !important;
        gap: 0.35rem !important;
    }
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button {
        padding: 0.5rem 0.85rem !important;
        margin: 0 !important;
        border-radius: 10px !important;
        border: 2px solid #e3e8f0 !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%) !important;
        color: #5a5c69 !important;
        font-size: 0.8rem !important;
        font-weight: 600 !important;
        transition: all 0.2s ease !important;
        cursor: pointer !important;
        min-width: 40px !important;
        text-align: center !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06) !important;
        line-height: 1.2 !important;
    }
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button:hover:not(.disabled):not(.current) {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%) !important;
        border-color: #4e73df !important;
        color: #fff !important;
        transform: translateY(-2px) !important;
        box-shadow: 0 6px 15px rgba(78, 115, 223, 0.4) !important;
    }
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button.current,
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button.current:hover {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%) !important;
        border-color: #4e73df !important;
        color: #fff !important;
        box-shadow: 0 6px 15px rgba(78, 115, 223, 0.4) !important;
        transform: translateY(-1px) !important;
    }
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button.disabled,
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button.disabled:hover {
        opacity: 0.5 !important;
        cursor: not-allowed !important;
        background: #f1f3f8 !important;
        color: #adb5bd !important;
        box-shadow: none !important;
        border-color: #e3e8f0 !important;
        transform: none !important;
    }
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button.previous,
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button.next {
        background: linear-gradient(135deg, #f0f3f8 0%, #e8ecf4 100%) !important;
        border: 2px solid #d1d9e6 !important;
        font-weight: 700 !important;
    }
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button.previous:hover:not(.disabled),
    #rfqTypeTable_wrapper .dataTables_paginate .paginate_button.next:hover:not(.disabled) {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%) !important;
        border-color: #4e73df !important;
        color: #fff !important;
    }

    /* Pagination Ellipsis */
    #rfqTypeTable_wrapper .dataTables_paginate .ellipsis {
        padding: 0.5rem 0.5rem !important;
        color: #6c757d;
        font-weight: 700;
    }

    /* Table Styling */
    #rfqTypeTable {
        border-collapse: separate;
        border-spacing: 0;
        width: 100% !important;
    }
    #rfqTypeTable thead th {
        background: linear-gradient(135deg, #f8f9fc 0%, #eaecf4 100%);
        border: none;
        border-bottom: 2px solid #e3e6f0;
        padding: 0.85rem 0.75rem;
        font-size: 0.75rem;
        font-weight: 700;
        color: #4e73df;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        position: relative;
        cursor: pointer;
        transition: all 0.2s ease;
        white-space: nowrap;
    }
    #rfqTypeTable thead th:hover {
        background: linear-gradient(135deg, #eef1f8 0%, #e3e8f4 100%);
        color: #224abe;
    }

    /* Enhanced Sort Indicators */
    #rfqTypeTable thead th.sorting,
    #rfqTypeTable thead th.sorting_asc,
    #rfqTypeTable thead th.sorting_desc {
        padding-right: 2rem !important;
        position: relative;
    }

    #rfqTypeTable thead th.sorting::before,
    #rfqTypeTable thead th.sorting::after,
    #rfqTypeTable thead th.sorting_asc::before,
    #rfqTypeTable thead th.sorting_asc::after,
    #rfqTypeTable thead th.sorting_desc::before,
    #rfqTypeTable thead th.sorting_desc::after {
        display: none !important;
    }

    #rfqTypeTable thead th.sorting::after,
    #rfqTypeTable thead th.sorting_asc::after,
    #rfqTypeTable thead th.sorting_desc::after {
        display: flex !important;
        position: absolute;
        right: 0.6rem;
        top: 50%;
        transform: translateY(-50%);
        width: 20px;
        height: 20px;
        align-items: center;
        justify-content: center;
        border-radius: 4px;
        font-family: 'Font Awesome 5 Free';
        font-weight: 900;
        font-size: 0.65rem;
        transition: all 0.2s ease;
    }

    #rfqTypeTable thead th.sorting::after {
        content: '\f0dc' !important;
        color: #b8c2d0;
        background: transparent;
    }
    #rfqTypeTable thead th.sorting:hover::after {
        color: #4e73df;
        background: rgba(78, 115, 223, 0.1);
    }

    #rfqTypeTable thead th.sorting_asc::after {
        content: '\f0de' !important;
        color: #fff;
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        font-size: 0.7rem;
        box-shadow: 0 2px 6px rgba(28, 200, 138, 0.4);
    }

    #rfqTypeTable thead th.sorting_desc::after {
        content: '\f0dd' !important;
        color: #fff;
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        font-size: 0.7rem;
        box-shadow: 0 2px 6px rgba(231, 74, 59, 0.4);
    }

    #rfqTypeTable thead th.sorting_asc {
        background: linear-gradient(135deg, #e8f8f0 0%, #d4f0e4 100%) !important;
        border-bottom-color: #1cc88a !important;
    }
    #rfqTypeTable thead th.sorting_desc {
        background: linear-gradient(135deg, #fef0ee 0%, #fce4e1 100%) !important;
        border-bottom-color: #e74a3b !important;
    }

    #rfqTypeTable tbody td {
        padding: 0.7rem 0.75rem;
        font-size: 0.8rem;
        border: none;
        border-bottom: 1px solid #e9ecef;
        vertical-align: middle;
    }
    #rfqTypeTable tbody tr {
        transition: all 0.15s ease;
    }
    #rfqTypeTable tbody tr:hover {
        background-color: #f0f4ff !important;
        transform: scale(1.002);
        box-shadow: 0 2px 8px rgba(78, 115, 223, 0.1);
    }
    #rfqTypeTable tbody tr:nth-child(even) {
        background-color: #fafbfc;
    }

    /* Action Buttons */
    .action-btn {
        width: 30px;
        height: 30px;
        padding: 0;
        border-radius: 6px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
        transition: all 0.2s;
        border: none;
        margin: 0 2px;
    }
    .action-btn:hover { transform: scale(1.1); }
    .action-btn.edit-btn { background: #fff3cd; color: #856404; }
    .action-btn.edit-btn:hover { background: #f6c23e; color: #fff; }
    .action-btn.delete-btn { background: #ffebee; color: #c62828; }
    .action-btn.delete-btn:hover { background: #e74a3b; color: #fff; }

    /* Add Button */
    .add-btn {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        border: none;
        padding: 0.4rem 1rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 600;
        color: #fff;
        transition: all 0.2s;
    }
    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
    }

    /* Quick Actions */
    .quick-link-card {
        background: #fff;
        border-radius: 8px;
        padding: 0.75rem;
        text-align: center;
        transition: all 0.2s;
        border: 1px solid rgba(0, 0, 0, 0.05);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
    }
    .quick-link-card:hover {
        border-color: #4e73df;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(78, 115, 223, 0.15);
    }
    .quick-link-card i { font-size: 1.25rem; margin-bottom: 0.25rem; }
    .quick-link-card .link-title { font-weight: 600; color: #333; font-size: 0.7rem; }

    /* Enhanced Modal Styling */
    #rfqTypeModal .modal-content,
    #deleteRfqTypeModal .modal-content {
        border: none;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }
    #rfqTypeModal .modal-header.primary-header,
    #deleteRfqTypeModal .modal-header.danger-header {
        display: flex !important;
        align-items: center;
        justify-content: space-between;
        min-height: 45px;
    }
    #rfqTypeModal .modal-header.primary-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    #deleteRfqTypeModal .modal-header.danger-header {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    #rfqTypeModal .modal-header .close,
    #deleteRfqTypeModal .modal-header .close {
        opacity: 1;
        text-shadow: none;
        padding: 0;
        margin: 0;
        width: 26px;
        height: 26px;
        border-radius: 50%;
        background: rgba(255,255,255,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 1.2rem;
        line-height: 1;
        transition: all 0.2s;
    }
    #rfqTypeModal .modal-header .close:hover,
    #deleteRfqTypeModal .modal-header .close:hover {
        background: rgba(255,255,255,0.35);
        transform: rotate(90deg);
    }
    #rfqTypeModal .modal-title,
    #deleteRfqTypeModal .modal-title {
        font-size: 0.9rem;
        font-weight: 600;
        color: #fff !important;
    }
    #rfqTypeModal .modal-body {
        padding: 1rem !important;
        background: #fff;
    }
    #deleteRfqTypeModal .modal-body {
        padding: 1rem !important;
        background: #fff;
    }
    #rfqTypeModal .modal-footer,
    #deleteRfqTypeModal .modal-footer {
        background: #f8f9fc;
        border-top: 1px solid #e3e6f0;
        padding: 0.6rem 1rem;
        display: flex;
        justify-content: flex-end;
        gap: 0.5rem;
    }
    #deleteRfqTypeModal .modal-footer {
        justify-content: center;
    }
    #rfqTypeModal .modal-footer .btn,
    #deleteRfqTypeModal .modal-footer .btn {
        border-radius: 5px;
        padding: 0.45rem 1rem;
        font-weight: 600;
        font-size: 0.8rem;
        min-width: 95px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.3rem;
        height: 34px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        transition: all 0.2s;
    }
    #rfqTypeModal .modal-footer .btn:hover,
    #deleteRfqTypeModal .modal-footer .btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 3px 8px rgba(0,0,0,0.15);
    }
    #rfqTypeModal .modal-footer .btn-secondary,
    #deleteRfqTypeModal .modal-footer .btn-secondary {
        background: linear-gradient(135deg, #6c757d 0%, #545b62 100%);
        border: none;
        color: #fff;
    }
    #rfqTypeModal .modal-footer .btn-primary {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        border: none;
        color: #fff;
    }
    #deleteRfqTypeModal .modal-footer .btn-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        border: none;
        color: #fff;
    }

    /* Compact Form Styling */
    #rfqTypeModal .form-label {
        font-size: 0.8rem;
        font-weight: 600;
        color: #495057;
        margin-bottom: 0.3rem;
        display: flex;
        align-items: center;
        gap: 0.25rem;
    }
    #rfqTypeModal .form-label i {
        font-size: 0.75rem;
    }
    #rfqTypeModal .form-control-modern {
        border: 1px solid #d1d3e2;
        border-radius: 5px;
        padding: 0.5rem 0.75rem;
        font-size: 0.85rem;
        height: 38px;
        transition: all 0.2s;
        background: #fff;
    }
    #rfqTypeModal .form-control-modern:hover {
        border-color: #b8bcc5;
    }
    #rfqTypeModal .form-control-modern:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 2px rgba(78, 115, 223, 0.15);
        background: #fff;
    }
    #rfqTypeModal .form-control-modern::placeholder {
        color: #adb5bd;
        font-size: 0.82rem;
    }

    /* Form Error Alert */
    #formErrors {
        border-radius: 5px;
        border: none;
        background: #fff5f5;
        border-left: 3px solid #e74a3b;
        padding: 0.5rem 0.75rem;
        margin-bottom: 0.75rem;
    }
    #formErrors ul { margin-bottom: 0; font-size: 0.8rem; }

    /* Delete Modal Enhancement */
    .delete-modal-icon {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background: linear-gradient(135deg, #fff5f5 0%, #fee8e7 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 0.6rem;
        border: 2px solid #f8d7da;
    }
    .delete-modal-icon i {
        font-size: 1.3rem;
        color: #e74a3b;
    }
    .delete-item-name {
        background: #f8f9fc;
        padding: 0.4rem 0.8rem;
        border-radius: 5px;
        border: 1px dashed #d1d3e2;
        display: inline-block;
        font-size: 0.85rem;
    }

    /* Enhanced Toast Notification */
    .custom-toast {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 280px;
        max-width: 350px;
        border-radius: 8px;
        box-shadow: 0 8px 24px rgba(0,0,0,0.2);
        border: none;
        animation: slideInRight 0.3s ease;
    }
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    .custom-toast .toast-body {
        padding: 0.65rem 1rem;
        font-size: 0.85rem;
        font-weight: 500;
        display: flex;
        align-items: center;
    }
    .custom-toast .close {
        color: rgba(255,255,255,0.8);
        opacity: 1;
        text-shadow: none;
    }
    .custom-toast.bg-success {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%) !important;
    }
    .custom-toast.bg-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
    }

    /* Modal Animation */
    .modal.fade .modal-dialog {
        transform: scale(0.9) translateY(-20px);
        transition: transform 0.2s ease;
    }
    .modal.show .modal-dialog {
        transform: scale(1) translateY(0);
    }

    /* Empty state styling */
    #rfqTypeTable tbody .dataTables_empty {
        padding: 2rem !important;
        color: #6c757d;
    }

    /* Loading state */
    .dataTables_processing {
        background: linear-gradient(135deg, rgba(78, 115, 223, 0.95) 0%, rgba(34, 74, 190, 0.95) 100%) !important;
        color: #fff !important;
        border-radius: 8px !important;
        padding: 0.75rem 1.5rem !important;
        font-weight: 600 !important;
        box-shadow: 0 4px 15px rgba(78, 115, 223, 0.4) !important;
    }

    /* Responsive */
    @media (max-width: 992px) {
        #rfqTypeTable_wrapper > .row:first-child {
            flex-direction: column;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
        }
        #rfqTypeTable_wrapper .dataTables_length,
        #rfqTypeTable_wrapper .dataTables_filter {
            justify-content: center !important;
            width: 100%;
            text-align: center;
        }
        #rfqTypeTable_wrapper .dataTables_filter input[type="search"] {
            min-width: 100% !important;
            width: 100% !important;
        }
    }
    @media (max-width: 768px) {
        .kpi-card .kpi-value { font-size: 1.25rem; }
        .page-header { flex-direction: column; gap: 0.5rem; }
        #rfqTypeTable_wrapper .dataTables_filter input[type="search"] {
            min-width: 200px !important;
        }
        #rfqTypeTable_wrapper .dataTables_paginate .paginate_button {
            padding: 0.4rem 0.65rem !important;
            min-width: 34px !important;
            font-size: 0.75rem !important;
        }
        #rfqTypeTable_wrapper .dataTables_info {
            font-size: 0.75rem !important;
            padding: 0.4rem 0.75rem !important;
        }
    }
    @media (max-width: 576px) {
        #rfqTypeTable_wrapper .row.bottom-controls {
            flex-direction: column !important;
            gap: 0.75rem;
        }
        #rfqTypeTable_wrapper .row.bottom-controls > div {
            width: 100% !important;
            justify-content: center !important;
            max-width: 100% !important;
            flex: 0 0 100% !important;
        }
        #rfqTypeTable_wrapper .dataTables_info,
        #rfqTypeTable_wrapper .dataTables_paginate {
            justify-content: center !important;
            width: 100% !important;
        }
        #rfqTypeTable_wrapper .dataTables_paginate {
            flex-wrap: wrap !important;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-clipboard-list mr-2 text-primary"></i>UEPL | RFQ Types</h1>
        <div class="datetime-display d-flex align-items-center">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">{{ now()->format('l') }}</span>,
                <span id="daynum">{{ now()->format('d') }}</span>
                <span id="month">{{ now()->format('F') }}</span>
                <span id="year">{{ now()->format('Y') }}</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time"></span>
            </div>
        </div>
    </div>

    <!-- KPI Cards Row -->
    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-primary shadow">
                <i class="fas fa-clipboard-list kpi-icon"></i>
                <div class="kpi-value" id="totalCount">0</div>
                <div class="kpi-label">Total RFQ Types</div>
                <div class="kpi-info"><i class="fas fa-database mr-1"></i> Master data entries</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-success shadow">
                <i class="fas fa-check-circle kpi-icon"></i>
                <div class="kpi-value" id="activeCount">0</div>
                <div class="kpi-label">Active Records</div>
                <div class="kpi-info"><i class="fas fa-list mr-1"></i> In use</div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="compact-card card shadow mb-3">
        <div class="card-header d-flex align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-info" style="font-size: 0.85rem;">
                <i class="fas fa-bolt mr-2"></i>Quick Actions
            </h6>
        </div>
        <div class="card-body py-2">
            <div class="row">
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="javascript:void(0)" class="text-decoration-none" id="quickAddBtn">
                        <div class="quick-link-card">
                            <i class="fas fa-plus-circle text-success"></i>
                            <div class="link-title">Add New</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.companytype.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-building text-primary"></i>
                            <div class="link-title">Company Types</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.accounttype.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-file-invoice text-info"></i>
                            <div class="link-title">Account Types</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.producttype.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-boxes text-warning"></i>
                            <div class="link-title">Product Types</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.dashboard.dashboard') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-tachometer-alt text-secondary"></i>
                            <div class="link-title">Dashboard</div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- DataTable Card -->
    <div class="compact-card card datatable-card shadow">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-table mr-2"></i> RFQ Types Directory
            </h6>
            <button class="add-btn" id="addRfqTypeBtn" title="Add RFQ Type">
                <i class="fas fa-plus mr-1"></i> Add Type
            </button>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0" id="rfqTypeTable">
                    <thead>
                        <tr class="text-center">
                            <th width="10%">Sl.No</th>
                            <th width="60%">RFQ Type</th>
                            <th width="30%">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Loaded by AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- Add/Edit Modal -->
<div class="modal fade" id="rfqTypeModal" tabindex="-1" aria-labelledby="rfqTypeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <!-- Header -->
            <div class="modal-header primary-header">
                <h6 class="modal-title mb-0" id="rfqTypeModalLabel">
                    <i class="fas fa-plus-circle mr-2" id="modalIcon"></i>Add RFQ Type
                </h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>

            <form id="rfqTypeForm">
                @csrf
                <input type="hidden" name="rfqtype_id" id="rfqtype_id">
                <div class="modal-body">
                    <!-- Error Alert -->
                    <div id="formErrors" class="alert alert-danger d-none" role="alert">
                        <small><i class="fas fa-exclamation-triangle mr-1"></i><strong>Error:</strong></small>
                        <ul class="mb-0 pl-3 small" id="errorList"></ul>
                    </div>

                    <div class="form-group mb-0">
                        <label class="form-label"><i class="fas fa-clipboard-list text-primary"></i> RFQ Type <span class="text-danger">*</span></label>
                        <input name="rfq_type" id="rfq_type" class="form-control form-control-modern" placeholder="Enter RFQ type name" required>
                    </div>
                </div>

                <!-- Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times"></i>
                        <span>Cancel</span>
                    </button>
                    <button type="submit" class="btn btn-primary" id="saveBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <i class="fas fa-check btn-icon"></i>
                        <span class="btn-text">Save</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteRfqTypeModal" tabindex="-1" aria-labelledby="deleteRfqTypeLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header danger-header">
                <h6 class="modal-title mb-0" id="deleteRfqTypeLabel">
                    <i class="fas fa-exclamation-triangle mr-2"></i>Confirm Delete
                </h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <div class="delete-modal-icon">
                    <i class="fas fa-clipboard-list"></i>
                </div>
                <p class="text-dark mb-2">Are you sure you want to delete?</p>
                <div class="delete-item-name">
                    <i class="fas fa-clipboard-list mr-1 text-muted"></i>
                    <span class="font-weight-bold" id="deleteItemName"></span>
                </div>
                <p class="text-muted mt-2 mb-0"><small><i class="fas fa-exclamation-circle mr-1"></i>This action cannot be undone.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i>
                    <span>Cancel</span>
                </button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                    <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                    <i class="fas fa-trash-alt btn-icon"></i>
                    <span class="btn-text">Delete</span>
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    var rfqTypesData = [];

    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        document.getElementById('day').textContent = days[now.getDay()];
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = months[now.getMonth()];
        document.getElementById('year').textContent = now.getFullYear();

        const timeStr = now.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        document.querySelector('.display-time').textContent = timeStr;
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);

    // Load RFQ types function
    function loadRfqTypes() {
        if ($.fn.DataTable.isDataTable('#rfqTypeTable')) {
            $('#rfqTypeTable').DataTable().clear().destroy();
        }
        $('#rfqTypeTable tbody').empty();

        $.get('{{ route('superadmin.rfqtype.list') }}', function(res) {
            rfqTypesData = res.data;
            let rows = '';

            $.each(res.data, function(i, item) {
                rows += `<tr class="text-center">
                    <td class="font-weight-bold text-muted">${i + 1}</td>
                    <td class="text-left">
                        <i class="fas fa-clipboard-list text-primary mr-2"></i>
                        <span class="font-weight-500">${item.rfqtype}</span>
                    </td>
                    <td>
                        <button class="action-btn edit-btn editBtn" title="Edit"
                            data-id="${item.id}"
                            data-rfqtype="${item.rfqtype}">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="action-btn delete-btn deleteBtn" title="Delete"
                            data-id="${item.id}"
                            data-rfqtype="${item.rfqtype}">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </td>
                </tr>`;
            });

            $('#rfqTypeTable tbody').html(rows);
            updateSummaryCards();

            // Initialize DataTable
            $('#rfqTypeTable').DataTable({
                pageLength: 10,
                lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                order: [[0, 'asc']],
                columnDefs: [
                    { orderable: false, targets: [2] },
                    { className: 'align-middle', targets: '_all' }
                ],
                language: {
                    search: '',
                    searchPlaceholder: 'Search RFQ types...',
                    lengthMenu: 'Show _MENU_',
                    info: 'Showing _START_ to _END_ of _TOTAL_',
                    infoEmpty: 'No entries found',
                    infoFiltered: '(filtered from _MAX_)',
                    paginate: {
                        first: '<i class="fas fa-angle-double-left"></i>',
                        last: '<i class="fas fa-angle-double-right"></i>',
                        next: '<i class="fas fa-chevron-right"></i>',
                        previous: '<i class="fas fa-chevron-left"></i>'
                    },
                    emptyTable: '<div class="text-center py-4"><i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i><p class="text-muted">No RFQ types found</p></div>'
                },
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rt<"row bottom-controls"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7 d-flex justify-content-end"p>>'
            });
        }).fail(function(err) {
            console.error('Failed to load RFQ types:', err);
            showToast('error', 'Failed to load data. Please refresh the page.');
        });
    }

    // Initial load
    loadRfqTypes();

    // Update summary cards
    function updateSummaryCards() {
        $('#totalCount').text(rfqTypesData.length);
        $('#activeCount').text(rfqTypesData.length);
    }

    // Open Add Modal
    function openAddModal() {
        $('#rfqTypeForm')[0].reset();
        $('#rfqtype_id').val('');
        $('#formErrors').addClass('d-none');
        $('#modalIcon').removeClass('fa-edit').addClass('fa-plus-circle');
        $('#rfqTypeModalLabel').html('<i class="fas fa-plus-circle mr-2" id="modalIcon"></i>Add RFQ Type');
        $('#rfqTypeModal').modal('show');
    }

    $('#addRfqTypeBtn').on('click', openAddModal);
    $('#quickAddBtn').on('click', openAddModal);

    // Edit button click
    $('#rfqTypeTable').on('click', '.editBtn', function() {
        $('#rfqTypeForm')[0].reset();
        $('#formErrors').addClass('d-none');

        $('#rfqtype_id').val($(this).data('id'));
        $('#rfq_type').val($(this).data('rfqtype'));

        $('#modalIcon').removeClass('fa-plus-circle').addClass('fa-edit');
        $('#rfqTypeModalLabel').html('<i class="fas fa-edit mr-2" id="modalIcon"></i>Edit RFQ Type');
        $('#rfqTypeModal').modal('show');
    });

    // Form submission
    $('#rfqTypeForm').submit(function(e) {
        e.preventDefault();

        var $btn = $('#saveBtn');
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Saving...');

        var id = $('#rfqtype_id').val();
        var url = id
            ? "{{ url('superadmin/rfqtypes/update') }}/" + id
            : "{{ route('superadmin.rfqtype.store') }}";

        $.ajax({
            url: url,
            type: 'POST',
            data: $(this).serialize() + (id ? '&_method=PUT' : ''),
            success: function(res) {
                $('#rfqTypeModal').modal('hide');
                loadRfqTypes();
                showToast('success', res.message || 'RFQ Type saved successfully!');
            },
            error: function(err) {
                var errors = err.responseJSON?.errors || {};
                var message = err.responseJSON?.message || 'An error occurred';

                if (Object.keys(errors).length > 0) {
                    var errorHtml = '';
                    $.each(errors, function(field, messages) {
                        $.each(messages, function(i, msg) {
                            errorHtml += '<li>' + msg + '</li>';
                        });
                    });
                    $('#errorList').html(errorHtml);
                    $('#formErrors').removeClass('d-none');
                } else {
                    showToast('error', message);
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Save');
            }
        });
    });

    // Delete button click
    var deleteId = null;
    $('#rfqTypeTable').on('click', '.deleteBtn', function() {
        deleteId = $(this).data('id');
        $('#deleteItemName').text($(this).data('rfqtype'));
        $('#deleteRfqTypeModal').modal('show');
    });

    // Confirm delete
    $('#confirmDeleteBtn').on('click', function() {
        if (!deleteId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Deleting...');

        $.ajax({
            url: "{{ url('superadmin/rfqtypes/delete') }}/" + deleteId,
            type: 'DELETE',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(res) {
                $('#deleteRfqTypeModal').modal('hide');
                loadRfqTypes();
                showToast('success', res.message || 'RFQ Type deleted successfully!');
            },
            error: function(err) {
                showToast('error', err.responseJSON?.message || 'Failed to delete');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Delete');
                deleteId = null;
            }
        });
    });

    // Toast notification helper
    function showToast(type, message) {
        $('.custom-toast').remove();

        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast custom-toast ${bgClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3500">
                <div class="toast-body">
                    <i class="fas ${icon} mr-2"></i>
                    <span class="flex-grow-1">${message}</span>
                    <button type="button" class="close ml-2" data-dismiss="toast" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');

        $toast.on('hidden.bs.toast', function() {
            $(this).remove();
        });
    }
});
</script>
@endsection
