@extends('layouts.dashboard.superadminapp')

@section('title', 'Conversion Processes')

@section('styles')
<style>
    /* Compact Page Header */
    .page-header {
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 0.75rem;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.04);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin: 0;
    }

    /* DateTime Display */
    .datetime-display { gap: 0.5rem; }
    .date-box, .time-box {
        display: flex;
        align-items: center;
        gap: 0.35rem;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 0.35rem 0.65rem;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
        font-size: 0.75rem;
        color: #475569;
        font-weight: 500;
    }
    .date-box i, .time-box i { color: #6f42c1; font-size: 0.7rem; }
    .time-box {
        background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%);
        color: #fff;
        border: none;
        min-width: 85px;
        justify-content: center;
    }
    .time-box i { color: rgba(255,255,255,0.8); }
    .time-box .display-time {
        font-family: 'Courier New', monospace;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    /* Compact KPI Cards */
    .kpi-card {
        border-radius: 8px;
        color: #fff;
        position: relative;
        overflow: hidden;
        padding: 0.75rem 1rem !important;
    }
    .kpi-card .kpi-icon {
        font-size: 2rem;
        opacity: 0.25;
        position: absolute;
        right: 0.75rem;
        top: 50%;
        transform: translateY(-50%);
    }
    .kpi-card .kpi-value {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.1rem;
        line-height: 1.2;
    }
    .kpi-card .kpi-label {
        font-size: 0.7rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        opacity: 0.9;
    }
    .kpi-card .kpi-info {
        font-size: 0.65rem;
        margin-top: 0.25rem;
        opacity: 0.8;
    }

    /* Gradient backgrounds */
    .bg-gradient-purple { background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); }
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }

    /* Compact Cards */
    .compact-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        margin-bottom: 0.75rem;
    }
    .compact-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.6rem 1rem;
    }
    .compact-card .card-body { padding: 1rem; }

    /* Enhanced DataTable Styling */
    .datatable-card .card-header {
        background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%);
        border-radius: 8px 8px 0 0;
        padding: 0.6rem 1rem;
    }
    .datatable-card .card-header h6 {
        color: #fff;
        font-size: 0.85rem;
        margin: 0;
    }

    /* DataTable Container - Top Controls */
    #processTable_wrapper > .row:first-child {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        padding: 1rem 1.25rem;
        margin: 0 !important;
        border-bottom: 2px solid #e3e6f0;
        display: flex;
        align-items: center;
        justify-content: space-between;
        border-radius: 0;
    }

    /* DataTable Container - Bottom Controls */
    #processTable_wrapper .row.bottom-controls {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        padding: 1rem 1.25rem;
        margin: 0 !important;
        border-top: 2px solid #e3e6f0;
        display: flex !important;
        flex-direction: row !important;
        flex-wrap: nowrap !important;
        align-items: center !important;
        justify-content: space-between !important;
    }
    #processTable_wrapper .row.bottom-controls > div {
        padding: 0 0.5rem !important;
    }

    /* Enhanced Length Menu */
    #processTable_wrapper .dataTables_length {
        display: flex;
        align-items: center;
    }
    #processTable_wrapper .dataTables_length label {
        display: flex;
        align-items: center;
        gap: 0.6rem;
        font-size: 0.85rem;
        color: #5a5c69;
        margin-bottom: 0;
        font-weight: 500;
    }
    #processTable_wrapper .dataTables_length select {
        border: 2px solid #d1d9e6 !important;
        border-radius: 10px !important;
        padding: 0.6rem 2.2rem 0.6rem 1rem !important;
        font-size: 0.85rem !important;
        font-weight: 600 !important;
        color: #6f42c1 !important;
        background: #fff url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%236f42c1' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E") no-repeat right 0.85rem center !important;
        background-size: 10px !important;
        appearance: none !important;
        cursor: pointer;
        transition: all 0.2s ease;
        min-width: 75px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06);
    }
    #processTable_wrapper .dataTables_length select:hover {
        border-color: #6f42c1 !important;
    }
    #processTable_wrapper .dataTables_length select:focus {
        border-color: #6f42c1 !important;
        box-shadow: 0 0 0 4px rgba(111, 66, 193, 0.15) !important;
        outline: none !important;
    }

    /* Enhanced Search Box */
    #processTable_wrapper .dataTables_filter {
        display: flex;
        align-items: center;
        position: relative;
    }
    #processTable_wrapper .dataTables_filter label {
        display: flex;
        align-items: center;
        gap: 0;
        font-size: 0;
        color: transparent;
        margin-bottom: 0;
        position: relative;
    }
    #processTable_wrapper .dataTables_filter input[type="search"] {
        border: 2px solid #d1d9e6 !important;
        border-radius: 10px !important;
        padding: 0.6rem 1rem 0.6rem 2.5rem !important;
        font-size: 0.85rem !important;
        min-width: 260px;
        transition: all 0.2s ease;
        background: #fff url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E") no-repeat left 0.85rem center !important;
        background-size: 15px !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06);
        margin-left: 0 !important;
    }
    #processTable_wrapper .dataTables_filter input[type="search"]:focus {
        border-color: #6f42c1 !important;
        box-shadow: 0 0 0 4px rgba(111, 66, 193, 0.15) !important;
        outline: none !important;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%236f42c1' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E") !important;
    }

    /* Enhanced Info Text */
    #processTable_wrapper .dataTables_info {
        font-size: 0.8rem !important;
        color: #5a6169 !important;
        padding: 0.5rem 1rem !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%) !important;
        border-radius: 10px !important;
        border: 2px solid #e3e8f0 !important;
        font-weight: 600 !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.04);
    }

    /* Enhanced Pagination */
    #processTable_wrapper .dataTables_paginate {
        display: flex !important;
        align-items: center !important;
        gap: 0.35rem !important;
    }
    #processTable_wrapper .dataTables_paginate .paginate_button {
        padding: 0.5rem 0.85rem !important;
        margin: 0 !important;
        border-radius: 10px !important;
        border: 2px solid #e3e8f0 !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%) !important;
        color: #5a5c69 !important;
        font-size: 0.8rem !important;
        font-weight: 600 !important;
        transition: all 0.2s ease !important;
        cursor: pointer !important;
        min-width: 40px !important;
        text-align: center !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06) !important;
    }
    #processTable_wrapper .dataTables_paginate .paginate_button:hover:not(.disabled):not(.current) {
        background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%) !important;
        border-color: #6f42c1 !important;
        color: #fff !important;
        transform: translateY(-2px) !important;
        box-shadow: 0 6px 15px rgba(111, 66, 193, 0.4) !important;
    }
    #processTable_wrapper .dataTables_paginate .paginate_button.current {
        background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%) !important;
        border-color: #6f42c1 !important;
        color: #fff !important;
        box-shadow: 0 6px 15px rgba(111, 66, 193, 0.4) !important;
    }
    #processTable_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5 !important;
        cursor: not-allowed !important;
        background: #f1f3f8 !important;
        color: #adb5bd !important;
        box-shadow: none !important;
    }

    /* Table Styling */
    #processTable {
        border-collapse: separate;
        border-spacing: 0;
        width: 100% !important;
    }
    #processTable thead th {
        background: linear-gradient(135deg, #f8f9fc 0%, #eaecf4 100%);
        border: none;
        border-bottom: 2px solid #e3e6f0;
        padding: 0.75rem 0.5rem;
        font-size: 0.7rem;
        font-weight: 700;
        color: #6f42c1;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        cursor: pointer;
        transition: all 0.2s ease;
        white-space: nowrap;
    }
    #processTable thead th:hover {
        background: linear-gradient(135deg, #eef1f8 0%, #e3e8f4 100%);
        color: #5a32a3;
    }

    /* Sort Indicators */
    #processTable thead th.sorting::after,
    #processTable thead th.sorting_asc::after,
    #processTable thead th.sorting_desc::after {
        font-family: 'Font Awesome 5 Free';
        font-weight: 900;
        font-size: 0.6rem;
        margin-left: 0.3rem;
    }
    #processTable thead th.sorting::after { content: '\f0dc'; color: #b8c2d0; }
    #processTable thead th.sorting_asc::after { content: '\f0de'; color: #1cc88a; }
    #processTable thead th.sorting_desc::after { content: '\f0dd'; color: #e74a3b; }

    #processTable tbody td {
        padding: 0.6rem 0.5rem;
        font-size: 0.78rem;
        border: none;
        border-bottom: 1px solid #e9ecef;
        vertical-align: middle;
    }
    #processTable tbody tr {
        transition: all 0.15s ease;
    }
    #processTable tbody tr:hover {
        background-color: rgba(111, 66, 193, 0.05) !important;
        transform: scale(1.002);
        box-shadow: 0 2px 8px rgba(111, 66, 193, 0.1);
    }
    #processTable tbody tr:nth-child(even) {
        background-color: #fafbfc;
    }

    /* Action Buttons */
    .action-btn {
        width: 28px;
        height: 28px;
        padding: 0;
        border-radius: 6px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 0.7rem;
        transition: all 0.2s;
        border: none;
        margin: 0 1px;
    }
    .action-btn:hover { transform: scale(1.1); }
    .action-btn.edit-btn { background: #fff3cd; color: #856404; }
    .action-btn.edit-btn:hover { background: #f6c23e; color: #fff; }
    .action-btn.delete-btn { background: #ffebee; color: #c62828; }
    .action-btn.delete-btn:hover { background: #e74a3b; color: #fff; }

    /* Add Button */
    .add-btn {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        border: none;
        padding: 0.4rem 1rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 600;
        color: #fff;
        transition: all 0.2s;
    }
    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
    }

    /* Quick Actions */
    .quick-link-card {
        background: #fff;
        border-radius: 8px;
        padding: 0.75rem;
        text-align: center;
        transition: all 0.2s;
        border: 1px solid rgba(0, 0, 0, 0.05);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
    }
    .quick-link-card:hover {
        border-color: #6f42c1;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(111, 66, 193, 0.15);
    }
    .quick-link-card i { font-size: 1.25rem; margin-bottom: 0.25rem; }
    .quick-link-card .link-title { font-weight: 600; color: #333; font-size: 0.7rem; }

    /* Enhanced Modal Styling */
    #processModal .modal-content,
    #deleteProcessModal .modal-content {
        border: none;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }
    #processModal .modal-header.primary-header {
        background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    #deleteProcessModal .modal-header.danger-header {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    #processModal .modal-header .close,
    #deleteProcessModal .modal-header .close {
        opacity: 1;
        text-shadow: none;
        padding: 0;
        margin: 0;
        width: 26px;
        height: 26px;
        border-radius: 50%;
        background: rgba(255,255,255,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 1.2rem;
        line-height: 1;
        transition: all 0.2s;
    }
    #processModal .modal-header .close:hover,
    #deleteProcessModal .modal-header .close:hover {
        background: rgba(255,255,255,0.35);
        transform: rotate(90deg);
    }
    #processModal .modal-title,
    #deleteProcessModal .modal-title {
        font-size: 0.9rem;
        font-weight: 600;
        color: #fff !important;
    }
    #processModal .modal-body {
        padding: 1rem !important;
        background: #fff;
    }
    #deleteProcessModal .modal-body {
        padding: 1rem !important;
        background: #fff;
    }
    #processModal .modal-footer,
    #deleteProcessModal .modal-footer {
        background: #f8f9fc;
        border-top: 1px solid #e3e6f0;
        padding: 0.6rem 1rem;
        display: flex;
        justify-content: flex-end;
        gap: 0.5rem;
    }
    #deleteProcessModal .modal-footer {
        justify-content: center;
    }
    #processModal .modal-footer .btn,
    #deleteProcessModal .modal-footer .btn {
        border-radius: 5px;
        padding: 0.45rem 1rem;
        font-weight: 600;
        font-size: 0.8rem;
        min-width: 95px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.3rem;
        height: 34px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        transition: all 0.2s;
    }
    #processModal .modal-footer .btn-secondary,
    #deleteProcessModal .modal-footer .btn-secondary {
        background: linear-gradient(135deg, #6c757d 0%, #545b62 100%);
        border: none;
        color: #fff;
    }
    #processModal .modal-footer .btn-primary {
        background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%);
        border: none;
        color: #fff;
    }
    #deleteProcessModal .modal-footer .btn-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        border: none;
        color: #fff;
    }

    /* Compact Form Styling */
    #processModal .form-label {
        font-size: 0.78rem;
        font-weight: 600;
        color: #495057;
        margin-bottom: 0.25rem;
        display: flex;
        align-items: center;
        gap: 0.25rem;
    }
    #processModal .form-label i {
        font-size: 0.7rem;
    }
    #processModal .form-control-modern {
        border: 1px solid #d1d3e2;
        border-radius: 5px;
        padding: 0.45rem 0.7rem;
        font-size: 0.82rem;
        height: 36px;
        transition: all 0.2s;
        background: #fff;
    }
    #processModal .form-control-modern:hover {
        border-color: #b8bcc5;
    }
    #processModal .form-control-modern:focus {
        border-color: #6f42c1;
        box-shadow: 0 0 0 2px rgba(111, 66, 193, 0.15);
        background: #fff;
    }

    /* Delete Modal Enhancement */
    .delete-modal-icon {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background: linear-gradient(135deg, #fff5f5 0%, #fee8e7 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 0.6rem;
        border: 2px solid #f8d7da;
    }
    .delete-modal-icon i {
        font-size: 1.3rem;
        color: #e74a3b;
    }
    .delete-item-name {
        background: #f8f9fc;
        padding: 0.4rem 0.8rem;
        border-radius: 5px;
        border: 1px dashed #d1d3e2;
        display: inline-block;
        font-size: 0.85rem;
    }

    /* Enhanced Toast */
    .custom-toast {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 280px;
        max-width: 350px;
        border-radius: 8px;
        box-shadow: 0 8px 24px rgba(0,0,0,0.2);
        border: none;
        animation: slideInRight 0.3s ease;
    }
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    .custom-toast .toast-body {
        padding: 0.65rem 1rem;
        font-size: 0.85rem;
        font-weight: 500;
        display: flex;
        align-items: center;
    }
    .custom-toast.bg-success {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%) !important;
    }
    .custom-toast.bg-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .kpi-card .kpi-value { font-size: 1.25rem; }
        .page-header { flex-direction: column; gap: 0.5rem; }
        #processTable_wrapper .dataTables_filter input[type="search"] {
            min-width: 180px !important;
        }
    }
    @media (max-width: 576px) {
        #processTable_wrapper .row.bottom-controls {
            flex-direction: column !important;
            gap: 0.75rem;
        }
        #processTable_wrapper .row.bottom-controls > div {
            width: 100% !important;
            justify-content: center !important;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-cogs mr-2" style="color: #6f42c1;"></i>UEPL | Conversion Processes</h1>
        <div class="datetime-display d-flex align-items-center">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">{{ now()->format('l') }}</span>,
                <span id="daynum">{{ now()->format('d') }}</span>
                <span id="month">{{ now()->format('F') }}</span>
                <span id="year">{{ now()->format('Y') }}</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time"></span>
            </div>
        </div>
    </div>

    <!-- KPI Cards Row -->
    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-purple shadow">
                <i class="fas fa-cogs kpi-icon"></i>
                <div class="kpi-value" id="totalCount">0</div>
                <div class="kpi-label">Total Processes</div>
                <div class="kpi-info"><i class="fas fa-database mr-1"></i> All records</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-success shadow">
                <i class="fas fa-check-circle kpi-icon"></i>
                <div class="kpi-value" id="activeCount">0</div>
                <div class="kpi-label">Active Records</div>
                <div class="kpi-info"><i class="fas fa-list mr-1"></i> In use</div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="compact-card card shadow mb-3">
        <div class="card-header d-flex align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold" style="font-size: 0.85rem; color: #6f42c1;">
                <i class="fas fa-bolt mr-2"></i>Quick Actions
            </h6>
        </div>
        <div class="card-body py-2">
            <div class="row">
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="javascript:void(0)" class="text-decoration-none" id="quickAddBtn">
                        <div class="quick-link-card">
                            <i class="fas fa-plus-circle text-success"></i>
                            <div class="link-title">Add New</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.process.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-tasks text-primary"></i>
                            <div class="link-title">Processes</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.rawmaterial.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-cubes text-info"></i>
                            <div class="link-title">Raw Materials</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.dashboard.dashboard') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-tachometer-alt text-secondary"></i>
                            <div class="link-title">Dashboard</div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- DataTable Card -->
    <div class="compact-card card datatable-card shadow">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-table mr-2"></i> Conversion Processes Directory
            </h6>
            <button class="add-btn" id="addProcessBtn" title="Add Process">
                <i class="fas fa-plus mr-1"></i> Add Process
            </button>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0" id="processTable">
                    <thead>
                        <tr class="text-center">
                            <th width="10%">Sl.No</th>
                            <th width="70%">Process Name</th>
                            <th width="20%">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Loaded by AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- Add/Edit Modal -->
<div class="modal fade" id="processModal" tabindex="-1" aria-labelledby="processModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header primary-header">
                <h6 class="modal-title mb-0" id="processModalLabel">
                    <i class="fas fa-plus-circle mr-2" id="modalIcon"></i>Add Conversion Process
                </h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>

            <form id="processForm">
                @csrf
                <input type="hidden" name="process_id" id="process_id">
                <div class="modal-body">
                    <div class="mb-2">
                        <label class="form-label"><i class="fas fa-cogs" style="color: #6f42c1;"></i> Process Name <span class="text-danger">*</span></label>
                        <input name="process_name" id="process_name" class="form-control form-control-modern" placeholder="Enter process name" required>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times"></i>
                        <span>Cancel</span>
                    </button>
                    <button type="submit" class="btn btn-primary" id="saveBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <i class="fas fa-check btn-icon"></i>
                        <span class="btn-text">Save</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteProcessModal" tabindex="-1" aria-labelledby="deleteProcessLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header danger-header">
                <h6 class="modal-title mb-0" id="deleteProcessLabel">
                    <i class="fas fa-exclamation-triangle mr-2"></i>Confirm Delete
                </h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <div class="delete-modal-icon">
                    <i class="fas fa-cogs"></i>
                </div>
                <p class="text-dark mb-2">Are you sure you want to delete?</p>
                <div class="delete-item-name">
                    <i class="fas fa-cogs mr-1 text-muted"></i>
                    <span class="font-weight-bold" id="deleteItemName"></span>
                </div>
                <p class="text-muted mt-2 mb-0"><small><i class="fas fa-exclamation-circle mr-1"></i>This action cannot be undone.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i>
                    <span>Cancel</span>
                </button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                    <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                    <i class="fas fa-trash-alt btn-icon"></i>
                    <span class="btn-text">Delete</span>
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    var processData = [];
    var deleteId = null;

    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        $('#day').text(days[now.getDay()]);
        $('#daynum').text(now.getDate());
        $('#month').text(months[now.getMonth()]);
        $('#year').text(now.getFullYear());

        const timeStr = now.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        $('.display-time').text(timeStr);
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);

    // Load Processes
    function loadProcesses() {
        if ($.fn.DataTable.isDataTable('#processTable')) {
            $('#processTable').DataTable().clear().destroy();
        }
        $('#processTable tbody').empty();

        $.get('{{ route('superadmin.conversionprocess.list') }}', function(res) {
            processData = res.data;
            let rows = '';

            $.each(res.data, function(i, item) {
                rows += `<tr class="text-center">
                    <td class="font-weight-bold text-muted">${i + 1}</td>
                    <td class="text-left">
                        <i class="fas fa-cogs mr-1" style="color: #6f42c1;"></i>
                        <span class="font-weight-500">${item.process_name || '-'}</span>
                    </td>
                    <td>
                        <button class="action-btn edit-btn editBtn" title="Edit"
                            data-id="${item.id}">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="action-btn delete-btn deleteBtn" title="Delete"
                            data-id="${item.id}"
                            data-name="${item.process_name}">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </td>
                </tr>`;
            });

            $('#processTable tbody').html(rows);
            updateSummaryCards();

            // Initialize DataTable
            $('#processTable').DataTable({
                pageLength: 10,
                lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                order: [[0, 'asc']],
                columnDefs: [
                    { orderable: false, targets: [2] },
                    { className: 'align-middle', targets: '_all' }
                ],
                language: {
                    search: '',
                    searchPlaceholder: 'Search processes...',
                    lengthMenu: 'Show _MENU_',
                    info: 'Showing _START_ to _END_ of _TOTAL_',
                    infoEmpty: 'No entries found',
                    infoFiltered: '(filtered from _MAX_)',
                    paginate: {
                        first: '<i class="fas fa-angle-double-left"></i>',
                        last: '<i class="fas fa-angle-double-right"></i>',
                        next: '<i class="fas fa-chevron-right"></i>',
                        previous: '<i class="fas fa-chevron-left"></i>'
                    },
                    emptyTable: '<div class="text-center py-4"><i class="fas fa-cogs fa-3x text-muted mb-3"></i><p class="text-muted">No conversion processes found</p></div>'
                },
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rt<"row bottom-controls"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7 d-flex justify-content-end"p>>'
            });
        }).fail(function(err) {
            console.error('Failed to load processes:', err);
            showToast('error', 'Failed to load data. Please refresh the page.');
        });
    }

    loadProcesses();

    function updateSummaryCards() {
        $('#totalCount').text(processData.length);
        $('#activeCount').text(processData.length);
    }

    // Reset Form
    function resetForm() {
        $('#processForm')[0].reset();
        $('#process_id').val('');
    }

    // Open Add Modal
    function openAddModal() {
        resetForm();
        $('#modalIcon').removeClass('fa-edit').addClass('fa-plus-circle');
        $('#processModalLabel').html('<i class="fas fa-plus-circle mr-2" id="modalIcon"></i>Add Conversion Process');
        $('#processModal').modal('show');
    }

    $('#addProcessBtn').on('click', openAddModal);
    $('#quickAddBtn').on('click', openAddModal);

    // Edit button click
    $('#processTable').on('click', '.editBtn', function() {
        resetForm();
        var id = $(this).data('id');

        $.get("{{ url('superadmin/conversionprocesses') }}/" + id, function(data) {
            $('#process_id').val(data.id);
            $('#process_name').val(data.process_name || '');

            $('#modalIcon').removeClass('fa-plus-circle').addClass('fa-edit');
            $('#processModalLabel').html('<i class="fas fa-edit mr-2" id="modalIcon"></i>Edit Conversion Process');
            $('#processModal').modal('show');
        }).fail(function() {
            showToast('error', 'Failed to load process data.');
        });
    });

    // Form submission
    $('#processForm').submit(function(e) {
        e.preventDefault();

        var $btn = $('#saveBtn');
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Saving...');

        var id = $('#process_id').val();
        var url = id
            ? "{{ url('superadmin/conversionprocesses/update') }}/" + id
            : "{{ route('superadmin.conversionprocess.store') }}";

        $.ajax({
            url: url,
            type: 'POST',
            data: $(this).serialize() + (id ? '&_method=PUT' : ''),
            success: function(res) {
                if (res.success) {
                    $('#processModal').modal('hide');
                    loadProcesses();
                    showToast('success', res.message || 'Process saved successfully!');
                } else {
                    showToast('error', res.message || 'Something went wrong.');
                }
            },
            error: function(err) {
                showToast('error', err.responseJSON?.message || 'An error occurred');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Save');
            }
        });
    });

    // Delete button click
    $('#processTable').on('click', '.deleteBtn', function() {
        deleteId = $(this).data('id');
        $('#deleteItemName').text($(this).data('name'));
        $('#deleteProcessModal').modal('show');
    });

    // Confirm delete
    $('#confirmDeleteBtn').on('click', function() {
        if (!deleteId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Deleting...');

        $.ajax({
            url: "{{ url('superadmin/conversionprocesses/delete') }}/" + deleteId,
            type: 'DELETE',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(res) {
                $('#deleteProcessModal').modal('hide');
                loadProcesses();
                showToast('success', res.message || 'Process deleted successfully!');
            },
            error: function(err) {
                showToast('error', err.responseJSON?.message || 'Failed to delete');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Delete');
                deleteId = null;
            }
        });
    });

    // Toast notification
    function showToast(type, message) {
        $('.custom-toast').remove();
        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast custom-toast ${bgClass} text-white" role="alert" data-delay="3500">
                <div class="toast-body">
                    <i class="fas ${icon} mr-2"></i>
                    <span class="flex-grow-1">${message}</span>
                    <button type="button" class="close ml-2" data-dismiss="toast">
                        <span>&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');
        $toast.on('hidden.bs.toast', function() { $(this).remove(); });
    }

    window.showToast = showToast;
});
</script>
@endsection
