@extends('layouts.dashboard.superadminapp')

@section('title', 'Create Tax Invoice')

@section('styles')
<style>
    #invoiceTable input.form-control { padding: 0.25rem 0.5rem; font-size: 0.875rem; }
    #invoiceTable textarea.form-control { padding: 0.25rem 0.5rem; font-size: 0.875rem; }
    .company-info-box {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 1rem;
        border-radius: 0.35rem;
    }
    .bank-info-box {
        background: #f8f9fc;
        border-radius: 0.35rem;
        padding: 1rem;
    }
</style>
@endsection

@section('content')
    <!-- Page Heading -->
    <x-layout.page-header title="UEPL | Create Tax Invoice" icon="file-invoice-dollar" iconColor="success" />

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-triangle mr-2"></i><strong>Validation Errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Content Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <h6 class="m-0 font-weight-bold text-white">
                <i class="fas fa-file-invoice-dollar mr-2"></i> Create Tax Invoice
            </h6>
            <a href="{{ route('superadmin.invoice.invoicedetails') }}" class="btn btn-light btn-sm">
                <i class="fa fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
        <div class="card-body">
            <form id="invoiceForm" action="{{ route('superadmin.tax-invoice.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="company-info-box">
                            <h6 class="font-weight-bold mb-2"><i class="fas fa-building mr-2"></i>UMBREY ENGINEERING PVT LTD</h6>
                            <small>No. 31, 2nd Phase, Peenya Industrial Area</small><br>
                            <small>Bengaluru 560 058, Karnataka, India</small><br>
                            <small><strong>GSTN:</strong> 29AAACU2461N1ZY | <strong>PAN:</strong> AAACU2461N</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-bold">Invoice No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="invoiceNo" name="invoice_no" readonly required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-bold">Invoice Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="invoiceDate" name="invoice_date" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-bold">Delivery Note</label>
                                <input type="text" class="form-control" id="deliveryNote" name="delivery_note" placeholder="Delivery Note">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-bold">Mode/Terms of Payment</label>
                                <input type="text" class="form-control" id="termsPayment" name="terms_payment" placeholder="Payment Terms">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-bold">Reference Number</label>
                                <input type="text" class="form-control" id="ReferenceNo" name="reference_no" placeholder="Reference No">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="small font-weight-bold">Other Reference</label>
                                <input type="text" class="form-control" id="otherreference" name="other_reference" placeholder="Other Reference">
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-user mr-2"></i>Buyer Information (Bill To)</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Customer <span class="text-danger">*</span></label>
                        <select class="form-control selectpicker" id="companyNameSelect" name="company" data-live-search="true" required>
                            <option value="">Select Customer</option>
                            @foreach ($companies as $company)
                                <option value="{{ $company->id }}">{{ $company->company }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Address</label>
                        <textarea class="form-control" id="cCompanyAddress" name="address" rows="2" placeholder="Customer Address"></textarea>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="small font-weight-bold">GST No</label>
                        <input type="text" class="form-control" id="cCompanyGst" name="gst" placeholder="GSTIN">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="small font-weight-bold">Phone</label>
                        <input type="tel" class="form-control" id="cCompanyPhone" name="phone" placeholder="Contact Number">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="small font-weight-bold">Email</label>
                        <input type="email" class="form-control" id="cCompanyEmail" name="email" placeholder="Email Address">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="small font-weight-bold">Sales Order No</label>
                        <select class="form-control selectpicker" id="orderNoSelect" name="order_no" data-live-search="true">
                            <option value="">Select Order</option>
                            @foreach($sales_orders as $order)
                                <option value="{{ $order->id }}">{{ $order->sales_order_no }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="small font-weight-bold">Order Date</label>
                        <input type="date" class="form-control" id="referenceDate" name="reference_date">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="small font-weight-bold">Dispatched Through</label>
                        <input type="text" class="form-control" id="dispatchthrough" name="dispatch_through" placeholder="Dispatch Method">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="small font-weight-bold">Destination</label>
                        <input type="text" class="form-control" id="destination" name="destination" placeholder="Destination">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="small font-weight-bold">Vehicle Number</label>
                        <input type="text" class="form-control" id="vehicleNo" name="vehicle_no" placeholder="Vehicle No">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Terms of Delivery</label>
                        <input type="text" class="form-control" id="termsDelivery" name="terms_of_delivery" placeholder="Delivery Terms">
                    </div>
                </div>

                <hr>

                <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-list mr-2"></i>Invoice Items</h6>
                <div class="table-responsive">
                    <table id="invoiceTable" class="table table-bordered table-sm">
                        <thead class="thead-light">
                            <tr>
                                <th width="40">#</th>
                                <th>Description of Goods</th>
                                <th width="90">HSN/SAC</th>
                                <th width="80">Quantity</th>
                                <th width="90">Rate</th>
                                <th width="70">Per</th>
                                <th width="70">SGST %</th>
                                <th width="70">CGST %</th>
                                <th width="70">IGST %</th>
                                <th width="100">Amount</th>
                                <th width="40"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="text-center">1</td>
                                <td><textarea class="form-control description" name="description[]" rows="1"></textarea></td>
                                <td><input type="text" class="form-control hsn" name="hsn[]"></td>
                                <td><input type="number" class="form-control quantity" name="quantity[]" min="0" oninput="calculateRow(this)"></td>
                                <td><input type="number" class="form-control rate" name="rate[]" min="0" step="0.01" oninput="calculateRow(this)"></td>
                                <td><input type="text" class="form-control per" name="per[]"></td>
                                <td><input type="number" class="form-control sgst" name="sgst[]" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
                                <td><input type="number" class="form-control cgst" name="cgst[]" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
                                <td><input type="number" class="form-control igst" name="igst[]" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
                                <td><input type="text" class="form-control amount" name="amount[]" readonly></td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="mb-3">
                    <button type="button" class="btn btn-primary btn-sm" onclick="addRow()">
                        <i class="fas fa-plus mr-1"></i> Add Item
                    </button>
                </div>

                <hr>

                <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-calculator mr-2"></i>Tax Calculation & Totals</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="small font-weight-bold">Grand Total in Words (INR)</label>
                        <textarea class="form-control" id="amountInWords" name="amount_in_words" rows="2" readonly></textarea>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm table-borderless">
                            <tr>
                                <td class="text-right small font-weight-bold">Taxable Value:</td>
                                <td width="150"><input type="text" id="totalAmount" name="taxable_value" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr>
                                <td class="text-right small">SGST:</td>
                                <td><input type="number" id="sgst" name="sgst_total" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr>
                                <td class="text-right small">CGST:</td>
                                <td><input type="number" id="cgst" name="cgst_total" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr>
                                <td class="text-right small">IGST:</td>
                                <td><input type="number" id="igst" name="igst_total" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr>
                                <td class="text-right small">Total Tax:</td>
                                <td><input type="number" id="totalTax" name="total_tax_amount" readonly class="form-control form-control-sm text-right"></td>
                            </tr>
                            <tr class="border-top">
                                <td class="text-right small font-weight-bold text-primary">Grand Total:</td>
                                <td><input type="text" id="grandTotal" name="total_amount" readonly class="form-control form-control-sm text-right font-weight-bold"></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <hr>

                <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-university mr-2"></i>Bank Details & Declaration</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="bank-info-box">
                            <h6 class="text-primary font-weight-bold mb-2"><i class="fas fa-landmark mr-2"></i>Company's Bank Details</h6>
                            <small><strong>A/c Holder:</strong> UMBREY ENGINEERING PVT LTD</small><br>
                            <small><strong>Bank Name:</strong> ICICI BANK C/A</small><br>
                            <small><strong>A/c No:</strong> 193505000015</small><br>
                            <small><strong>Branch & IFS Code:</strong> PEENYA BRANCH & ICIC0001935</small><br>
                            <small class="mt-2 d-block"><strong>Company's PAN:</strong> AAACU2461N</small>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="border rounded p-3 h-100">
                            <h6 class="font-weight-bold text-muted mb-2"><i class="fas fa-file-signature mr-2"></i>Declaration</h6>
                            <small class="text-muted">
                                We declare that this invoice shows the actual price of the goods described and that all particulars are true and correct.
                            </small>
                            <hr>
                            <div class="text-right mt-3">
                                <small class="font-weight-bold">For Umbrey Engineering PVT LTD</small><br>
                                <br><br>
                                <small class="text-muted">Authorised Signatory</small>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-success btn-sm mr-2" id="submitBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <i class="fas fa-save mr-1"></i> Save Invoice
                    </button>
                    <button type="button" class="btn btn-secondary btn-sm mr-2" onclick="resetForm()">
                        <i class="fas fa-times mr-1"></i> Clear
                    </button>
                    <a href="{{ route('superadmin.invoice.invoicedetails') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="fa fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    // Initialize selectpicker
    $('.selectpicker').selectpicker();

    // Set today's date
    document.getElementById('invoiceDate').value = new Date().toISOString().split('T')[0];

    // Generate Invoice Number
    $.ajax({
        url: '{{ route('superadmin.invoice.generate') }}',
        type: 'GET',
        success: function(response) {
            $('#invoiceNo').val(response.invoice_no);
        },
        error: function() {
            Swal.fire('Error', 'Failed to generate Invoice ID', 'error');
        }
    });

    // Company select change
    $('#companyNameSelect').on('change', function() {
        let companyId = $(this).val();
        if (!companyId) {
            $('#cCompanyAddress').val('');
            $('#cCompanyGst').val('');
            $('#cCompanyEmail').val('');
            $('#cCompanyPhone').val('');
            return;
        }
        $.get("{{ url('superadmin/customer-vendor') }}/" + companyId, function(data) {
            if (data.success) {
                $('#cCompanyAddress').val(data.company.billing_address || '');
                $('#cCompanyGst').val(data.company.gst || '');
                $('#cCompanyEmail').val(data.company.email || '');
                $('#cCompanyPhone').val(data.company.mobile || '');
            }
        });
    });

    // Sales Order select change
    const salesOrders = @json($sales_orders);
    $('#orderNoSelect').on('change', function() {
        const selectedOrderId = $(this).val();
        const order = salesOrders.find(o => o.id == selectedOrderId);
        if (!order) return;

        $('#referenceDate').val(order.sales_order_date);
        $('#companyNameSelect').val(order.company_name);
        $('.selectpicker').selectpicker('refresh');
        $('#companyNameSelect').trigger('change');

        const tbody = $('#invoiceTable tbody');
        tbody.empty();

        (order.items || []).forEach((item, index) => {
            const row = `
                <tr>
                    <td class="text-center">${index + 1}</td>
                    <td><textarea class="form-control description" name="description[]" rows="1">${item.material_code ? item.material_code + '-' : ''}${item.material_description || ''}</textarea></td>
                    <td><input type="text" class="form-control hsn" name="hsn[]" value="${item.hsn_code || ''}"></td>
                    <td><input type="number" class="form-control quantity" name="quantity[]" value="${item.quantity || 0}" min="0" oninput="calculateRow(this)"></td>
                    <td><input type="number" class="form-control rate" name="rate[]" value="${item.unit_rate || 0}" min="0" step="0.01" oninput="calculateRow(this)"></td>
                    <td><input type="text" class="form-control per" name="per[]" value="${item.uom || ''}"></td>
                    <td><input type="number" class="form-control sgst" name="sgst[]" value="${item.sgst || 0}" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
                    <td><input type="number" class="form-control cgst" name="cgst[]" value="${item.cgst || 0}" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
                    <td><input type="number" class="form-control igst" name="igst[]" value="${item.igst || 0}" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
                    <td><input type="text" class="form-control amount" name="amount[]" readonly></td>
                    <td class="text-center">
                        <button type="button" class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                </tr>`;
            tbody.append(row);
        });

        // Calculate all rows
        $('#invoiceTable tbody tr').each(function() {
            const qtyInput = $(this).find('input.quantity')[0];
            if (qtyInput) calculateRow(qtyInput);
        });

        updateTotal();
    });

    // Form submit with loading
    $('#invoiceForm').on('submit', function() {
        const $btn = $('#submitBtn');
        $btn.prop('disabled', true);
        $btn.find('.spinner-border').removeClass('d-none');
    });
});

// Add Row
function addRow() {
    const table = document.getElementById("invoiceTable").getElementsByTagName("tbody")[0];
    const rowCount = table.rows.length;
    const newRow = table.insertRow(rowCount);

    newRow.innerHTML = `
        <td class="text-center">${rowCount + 1}</td>
        <td><textarea class="form-control description" name="description[]" rows="1"></textarea></td>
        <td><input type="text" class="form-control hsn" name="hsn[]"></td>
        <td><input type="number" class="form-control quantity" name="quantity[]" min="0" oninput="calculateRow(this)"></td>
        <td><input type="number" class="form-control rate" name="rate[]" min="0" step="0.01" oninput="calculateRow(this)"></td>
        <td><input type="text" class="form-control per" name="per[]"></td>
        <td><input type="number" class="form-control sgst" name="sgst[]" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
        <td><input type="number" class="form-control cgst" name="cgst[]" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
        <td><input type="number" class="form-control igst" name="igst[]" min="0" max="100" step="0.01" oninput="calculateRow(this)"></td>
        <td><input type="text" class="form-control amount" name="amount[]" readonly></td>
        <td class="text-center">
            <button type="button" class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                <i class="fa fa-trash"></i>
            </button>
        </td>
    `;
}

// Delete Row
function deleteRow(button) {
    const row = button.closest("tr");
    row.parentNode.removeChild(row);
    updateRowNumbers();
    updateTotal();
}

// Update Row Numbers
function updateRowNumbers() {
    const rows = document.querySelectorAll("#invoiceTable tbody tr");
    rows.forEach((row, i) => row.cells[0].textContent = i + 1);
}

// Calculate Row
function calculateRow(element) {
    const row = element.closest("tr");
    const quantity = parseFloat(row.querySelector(".quantity").value) || 0;
    const rate = parseFloat(row.querySelector(".rate").value) || 0;
    const sgst = parseFloat(row.querySelector(".sgst").value) || 0;
    const cgst = parseFloat(row.querySelector(".cgst").value) || 0;
    const igst = parseFloat(row.querySelector(".igst").value) || 0;

    const baseAmount = quantity * rate;
    const totalTax = baseAmount * (sgst + cgst + igst) / 100;
    const amount = baseAmount + totalTax;
    row.querySelector(".amount").value = amount.toFixed(2);

    updateTotal();
}

// Update Totals
function updateTotal() {
    let taxableTotal = 0, totalAmount = 0, totalSgst = 0, totalCgst = 0, totalIgst = 0, totalTax = 0;

    document.querySelectorAll("#invoiceTable tbody tr").forEach(row => {
        const quantity = parseFloat(row.querySelector(".quantity").value) || 0;
        const rate = parseFloat(row.querySelector(".rate").value) || 0;
        const sgst = parseFloat(row.querySelector(".sgst").value) || 0;
        const cgst = parseFloat(row.querySelector(".cgst").value) || 0;
        const igst = parseFloat(row.querySelector(".igst").value) || 0;

        const baseAmount = quantity * rate;
        taxableTotal += baseAmount;
        totalAmount += baseAmount + (baseAmount * (sgst + cgst + igst) / 100);
        totalSgst += baseAmount * (sgst / 100);
        totalCgst += baseAmount * (cgst / 100);
        totalIgst += baseAmount * (igst / 100);
        totalTax += (baseAmount * (sgst + cgst + igst) / 100);
    });

    document.getElementById("totalAmount").value = taxableTotal.toFixed(2);
    document.getElementById("sgst").value = totalSgst.toFixed(2);
    document.getElementById("cgst").value = totalCgst.toFixed(2);
    document.getElementById("igst").value = totalIgst.toFixed(2);
    document.getElementById("totalTax").value = totalTax.toFixed(2);

    const roundUpAmount = Math.ceil(totalAmount) - totalAmount;
    const grandTotal = totalAmount + roundUpAmount;
    document.getElementById('grandTotal').value = grandTotal.toFixed(2);
    document.getElementById('amountInWords').value = numberToWords(Math.round(grandTotal)) + ' Rupees Only';
}

// Reset Form
function resetForm() {
    Swal.fire({
        title: 'Clear Form?',
        text: 'Are you sure you want to clear all fields?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#e74a3b',
        cancelButtonColor: '#858796',
        confirmButtonText: 'Yes, clear it!'
    }).then((result) => {
        if (result.isConfirmed) {
            location.reload();
        }
    });
}

// Number to Words (Indian Format)
function numberToWords(num) {
    if (num === 0) return 'Zero';

    const ones = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine',
                  'Ten', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen',
                  'Seventeen', 'Eighteen', 'Nineteen'];
    const tens = ['', '', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];

    function convertLessThanHundred(n) {
        if (n < 20) return ones[n];
        return tens[Math.floor(n / 10)] + (n % 10 ? ' ' + ones[n % 10] : '');
    }

    function convertLessThanThousand(n) {
        if (n < 100) return convertLessThanHundred(n);
        return ones[Math.floor(n / 100)] + ' Hundred' + (n % 100 ? ' ' + convertLessThanHundred(n % 100) : '');
    }

    if (num < 0) return 'Negative ' + numberToWords(-num);
    if (num < 1000) return convertLessThanThousand(num);
    if (num < 100000) {
        return convertLessThanHundred(Math.floor(num / 1000)) + ' Thousand' +
               (num % 1000 ? ' ' + convertLessThanThousand(num % 1000) : '');
    }
    if (num < 10000000) {
        return convertLessThanHundred(Math.floor(num / 100000)) + ' Lakh' +
               (num % 100000 ? ' ' + numberToWords(num % 100000) : '');
    }
    return convertLessThanHundred(Math.floor(num / 10000000)) + ' Crore' +
           (num % 10000000 ? ' ' + numberToWords(num % 10000000) : '');
}
</script>
@endsection
