@extends('layouts.dashboard.superadminapp')

@section('title', 'Edit Tax Invoice')

@section('content')

    <style>
        #invoiceTable th,#invoiceTable td {
            min-width :150px;
            text-align:center;
        }
        #invoiceTable th:nth-child(1),#invoiceTable td:nth-child(1),#invoiceTable th:nth-child(11),#invoiceTable td:nth-child(11){
            min-width :50px;
        }
        #invoiceTable th:nth-child(2),#invoiceTable td:nth-child(2){
            min-width :250px;
        }
        #invoiceTable input{
            text-align:center;
        }
    </style>

    <!-- Page Heading -->
    <x-layout.page-header title="UEPL / Edit Tax Invoice - {{ $invoice->invoice_no }}" icon="file-invoice-dollar" iconColor="success" />
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
        </div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>There were some issues with your submission:</strong>
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>

        </div>
    @endif

    <!-- Content Row -->
    <div class="row quotation-page-content">
        <div class="col-lg-12">

            <!-- Project Planning Start -->
            <form id="Tax-Invoice-form" action="{{ route('superadmin.invoice.update', $invoice->id) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="tax-invoice-container p-3">
                    <h1>Tax Invoice</h1><br>
                    <!-- Invoice Info Section -->
                    <div class="info-section">
                        <div class="row hidden">
                            <div class="col-md-6">
                                <div class="col-sm-3">
                                    <label for="irnNo">IRN Number <span class="required"
                                            title="required">*</span></label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="irnNo">
                                </div>
                                <div class="col-sm-3">
                                    <label for="ackNo">Ack Number <span class="required"
                                            title="required">*</span></label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="ackNo">
                                </div>
                                <div class="col-sm-3">
                                    <label for="ackDate">Ack Date <span class="required" title="required">*</span></label>
                                </div>
                                <div class="col-sm-6">
                                    <input type="date" id="ackDate">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <br><br>
                                <label for="qrCode">E-Invoice QR Code :</label>
                                <div id="qrCode"></div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <br>
                                <h3>UMBREY ENGINEERING PVT LTD</h3>
                                <p>No. 31, 2nd Phase, Peenya Industrial Area <br>
                                    Bengaluru 560 058, Karnataka, India<br>
                                    GSTN: 29AAACU2461N1ZY<br>
                                    PAN: AAACU2461N<br>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label for="invoiceNo">Invoice ID <span class="required"
                                                title="required">*</span></label>
                                        <input type="text" id="invoiceNo" name="invoice_no" value="{{ $invoice->invoice_no }}" required readonly>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="invoiceDate">Invoice Date <span class="required"
                                                title="required">*</span></label>
                                        <input type="date" id="invoiceDate" name="invoice_date" value="{{ $invoice->invoice_date }}" required>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label for="deliveryNote">Delivery Note</label>
                                        <input type="text" id="deliveryNote" name="delivery_note" value="{{ $invoice->delivery_note }}">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="termsPayment">Mode/Terms of Payment</label>
                                        <input type="text" id="termsPayment" name="terms_payment" value="{{ $invoice->terms_payment }}">
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label for="ReferenceNo">Reference Number</label>
                                        <input type="text" id="ReferenceNo" name="reference_no" value="{{ $invoice->reference_no }}">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="otherreference">Other Reference</label>
                                        <input type="text" id="otherreference" name="other_reference" value="{{ $invoice->other_reference }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Buyer Info Section -->
                    <div class="address-section">
                        <div class="row mb-2">
                            <div class="col-md-6 c-address-section">
                                <h5>Buyer (Bill to)</h5>
                                <label for="companyNameSelect">Customer Details <span class="required"
                                        title="required">*</span></label>

                                <select id="companyNameSelect" name="company" required>
                                    <option value="">Select Company</option>
                                    @foreach ($companies as $company)
                                        <option value="{{ $company->id }}" {{ $invoice->company_id == $company->id ? 'selected' : '' }}>{{ $company->company }}</option>
                                    @endforeach
                                </select>
                                <br/>
                                <textarea id="cCompanyAddress" name="address" rows="2" placeholder="Address">{{ $invoice->address }}</textarea>
                                <br/>
                                <input type="text" id="cCompanyGst" name="gst" value="{{ $invoice->gst }}"
                                    placeholder="Enter valid GST number">
                                    <br/>
                                <input type="tel" id="cCompanyPhone" name="phone" value="{{ $invoice->phone }}"
                                    placeholder="Enter 10-digit number">
                                <input type="email" id="cCompanyEmail" name="email" value="{{ $invoice->email }}" placeholder="Email">
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="buyersOrderNo">Buyer's Order Number</label>
                                        <select id="orderNoSelect" name="order_no" class="form-control">
                                            <option value="">Select Order</option>
                                            @foreach($sales_orders as $order)
                                                <option value="{{ $order->id }}" {{ $invoice->buyer_order_no == $order->sales_order_no ? 'selected' : '' }}>{{ $order->sales_order_no }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="referenceDate">Date</label>
                                        <input type="date" id="referenceDate" name="reference_date" value="{{ $invoice->reference_date }}">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="dispatchthrough">Dispatched Through</label>
                                        <input type="text" id="dispatchthrough" name="dispatch_through" value="{{ $invoice->dispatch_through }}">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="destination">Destination</label>
                                        <input type="text" id="destination" name="destination" value="{{ $invoice->destination }}">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="vehicleNo">Motor Vehicle Number</label>
                                        <input type="text" id="vehicleNo" name="vehicle_no" value="{{ $invoice->vehicle_no }}">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="termsDelivery">Terms of Delivery</label>
                                        <input type="text" id="termsDelivery" name="terms_of_delivery" value="{{ $invoice->terms_of_delivery }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br><br>

                        <!-- Item Table Section -->
                        <div class="invoice_table" style="overflow-x:auto;">
                            <table id="invoiceTable">
                                <thead>
                                    <tr>
                                        <th>Sl. No</th>
                                        <th>Description of Goods</th>
                                        <th>HSN/SAC</th>
                                        <th>Quantity</th>
                                        <th>Rate</th>
                                        <th>Per</th>
                                        <th>SGST (%)</th>
                                        <th>CGST (%)</th>
                                        <th>IGST (%)</th>
                                        <th>Amount</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($invoice->items as $index => $item)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            <textarea id="description" name="description[]" cols="30" rows="1" class="description">{{ $item->description }}</textarea>
                                        </td>
                                        <td><input type="text" class="hsn" name="hsn[]" value="{{ $item->hsn }}"></td>
                                        <td><input type="number" class="quantity" name="quantity[]" value="{{ $item->quantity }}"
                                                oninput="calculateRow(this)"></td>
                                        <td><input type="number" class="rate" name="rate[]" value="{{ $item->rate }}"
                                                oninput="calculateRow(this)"></td>
                                        <td><input type="text" class="per" name="per[]" value="{{ $item->per }}"></td>
                                        <td><input type="number" class="sgst" name="sgst[]" value="{{ $item->sgst }}"
                                                oninput="calculateRow(this)"></td>
                                        <td><input type="number" class="cgst" name="cgst[]" value="{{ $item->cgst }}"
                                                oninput="calculateRow(this)"></td>
                                        <td><input type="number" class="igst" name="igst[]" value="{{ $item->igst }}"
                                                oninput="calculateRow(this)"></td>
                                        <td><input type="text" class="amount" name="amount[]" value="{{ $item->amount }}" readonly></td>
                                        <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i
                                                    class="fa fa-trash"></i></button></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-2">
                                <button type="button" class="add-btn" onclick="addRow()">Add Item</button>
                            </div>
                        </div>

                        <!-- Total Calculation Section -->
                        <div class="row total-fields">
                            <div class="col-md-6">
                                <br><br>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="grandTotal">Grand Total</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="text" id="grandTotal" name="total_amount" value="{{ $invoice->total_amount }}" readonly>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="amountInWords">Grand Total in Words in INR</label>
                                    </div>
                                    <div class="col-md-9">
                                        <textarea type="text" id="amountInWords" name="amount_in_words" readonly>{{ $invoice->amount_in_words }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h3>Total Tax Calculation</h3>
                                <br>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="totalAmount">Taxable Value</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" id="totalAmount" name="taxable_value" value="{{ $invoice->taxable_value }}" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="sgst">SGST</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="number" id="sgst" name="sgst" value="{{ $invoice->sgst }}" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="cgst">CGST</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="number" id="cgst" name="cgst" value="{{ $invoice->cgst }}" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="igst">IGST</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="number" id="igst" name="igst" value="{{ $invoice->igst }}" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <h5 for="totalTax">Total Tax Amount</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="number" id="totalTax" name="total_tax_amount" value="{{ $invoice->total_tax_amount }}" readonly>
                                    </div>
                                </div><br><br>
                            </div>
                        </div>

                        <!-- Bank Details Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <br><br><br><br><br><br><br><br>
                                <p><b>Company's PAN : AAACU2461N</b></p>
                            </div>
                            <div class="col-md-6">
                                <br>
                                <h6><b>Company's Bank Details</b></h6>
                                <p><b>A/c Holder:</b> UMBREY ENGINEERING PVT LTD</p>
                                <p><b>Bank Name:</b> ICICI BANK C/A</p>
                                <p><b>A/c:</b> 193505000015</p>
                                <p><b>Branch & IFS Code:</b> PEENYA BRANCH & ICIC0001935</p>
                                <p><b>SWIFT Code:</b></p>
                            </div>
                        </div>

                        <!-- Declaration Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Declaration:</h6>
                                <p>We declare that this invoice shows the actual price of the <br>
                                    goods described and that all particulars are true and correct.</p>
                            </div>
                            <div class="col-md-6 mt-4">
                                <h5><b>For Umbrey Engineering PVT LTD,</b></h5>
                                <br><br>
                                <p>Authorised Signatory</p>
                            </div>
                        </div>

                        <!-- Print and Save Buttons -->
                        <div class="row">
                            <div class="col-md-2">
                                <a href="{{ route('superadmin.invoice.invoicedetails') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="save-btn">Update Invoice</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        // Add a new row in the invoice table
        function addRow() {
            const table = document.getElementById("invoiceTable").getElementsByTagName("tbody")[0];
            const rowCount = table.rows.length;
            const newRow = table.insertRow(rowCount);

            newRow.innerHTML = `
                <td>${rowCount + 1}</td>
                <td><textarea id="description" cols="30" rows="1" class="description" name="description[]" ></textarea></td>
                <td><input type="text" class="hsn" name="hsn[]" ></td>
                <td><input type="number" class="quantity" name="quantity[]"  min="0" oninput="calculateRow(this)"></td>
                <td><input type="number" class="rate" name="rate[]"  min="0" oninput="calculateRow(this)"></td>
                <td><input type="text" class="per" name="per[]" ></td>
                <td><input type="number" class="sgst" min="0" max="100" name="sgst[]" oninput="calculateRow(this)"></td>
                <td><input type="number" class="cgst" min="0" max="100" name="cgst[]" oninput="calculateRow(this)"></td>
                <td><input type="number" class="igst" min="0" max="100" name="igst[]" oninput="calculateRow(this)"></td>
                <td><input type="text" class="amount" name="amount[]" readonly></td>
                <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
            `;
        }

        // Delete a row in the invoice table
        function deleteRow(button) {
            const row = button.parentNode.parentNode;
            row.parentNode.removeChild(row);
            updateTotal();
        }

        // Calculate row-wise total and update total calculations
        function calculateRow(element) {
            const row = element.closest("tr");
            const quantity = parseFloat(row.querySelector(".quantity").value) || 0;
            const rate = parseFloat(row.querySelector(".rate").value) || 0;
            const sgst = parseFloat(row.querySelector(".sgst").value) || 0;
            const cgst = parseFloat(row.querySelector(".cgst").value) || 0;
            const igst = parseFloat(row.querySelector(".igst").value) || 0;

            const baseAmount = quantity * rate;
            const totalTax = baseAmount * (sgst + cgst + igst) / 100;
            const amount = baseAmount + totalTax;
            row.querySelector(".amount").value = amount.toFixed(2);

            updateTotal();
        }

        // Update total calculation based on all rows
        function updateTotal() {
            let taxableTotal = 0,
                totalAmount = 0,
                totalSgst = 0,
                totalCgst = 0,
                totalIgst = 0,
                totalTax = 0;

            document.querySelectorAll("#invoiceTable tbody tr").forEach(row => {
                const quantity = parseFloat(row.querySelector(".quantity").value) || 0;
                const rate = parseFloat(row.querySelector(".rate").value) || 0;
                const sgst = parseFloat(row.querySelector(".sgst").value) || 0;
                const cgst = parseFloat(row.querySelector(".cgst").value) || 0;
                const igst = parseFloat(row.querySelector(".igst").value) || 0;

                const baseAmount = quantity * rate;
                taxableTotal += baseAmount
                totalAmount += baseAmount + (baseAmount * (sgst + cgst + igst) / 100);
                totalSgst += baseAmount * (sgst / 100);
                totalCgst += baseAmount * (cgst / 100);
                totalIgst += baseAmount * (igst / 100);
                totalTax += (baseAmount * (sgst + cgst + igst) / 100);
            });

            document.getElementById("totalAmount").value = taxableTotal.toFixed(2);
            document.getElementById("sgst").value = totalSgst.toFixed(2);
            document.getElementById("cgst").value = totalCgst.toFixed(2);
            document.getElementById("igst").value = totalIgst.toFixed(2);
            document.getElementById("totalTax").value = totalTax.toFixed(2);
            const roundUpAmount = Math.ceil(totalAmount) - totalAmount;
            const grandTotal = totalAmount + roundUpAmount;
            document.getElementById('grandTotal').value = grandTotal.toFixed(2);
            updateGrandTotalInWords();
        }

        // Convert number to words (simplified version for demo)
        function convertNumberToWords(num) {
            const ones = ["", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"];
            const teens = ["", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen",
                "Nineteen"
            ];
            const tens = ["", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"];
            const higherUnits = ["", "Thousand", "Lakh", "Crore"];

            if (isNaN(num) || num === 0) return 'Zero';

            let word = '';

            function processHundred(number) {
                let result = '';
                if (number > 99) {
                    result += ones[Math.floor(number / 100)] + ' Hundred ';
                    number %= 100;
                }
                if (number > 10 && number < 20) {
                    result += teens[number - 10] + ' ';
                } else {
                    result += tens[Math.floor(number / 10)] + ' ';
                    result += ones[number % 10] + ' ';
                }
                return result.trim();
            }

            const crorePart = Math.floor(num / 10000000);
            const lakhPart = Math.floor((num % 10000000) / 100000);
            const thousandPart = Math.floor((num % 100000) / 1000);
            const hundredPart = num % 1000;

            if (crorePart > 0) {
                word += processHundred(crorePart) + ' Crore ';
            }
            if (lakhPart > 0) {
                word += processHundred(lakhPart) + ' Lakh ';
            }
            if (thousandPart > 0) {
                word += processHundred(thousandPart) + ' Thousand ';
            }
            if (hundredPart > 0) {
                word += processHundred(hundredPart) + ' Only';
            }

            return word.trim();
        }

        // Function to update the 'GT-in-letters' field
        function updateGrandTotalInWords() {
            const grandTotal = parseFloat(document.getElementById('grandTotal').value) || 0;
            document.getElementById('amountInWords').value = convertNumberToWords(grandTotal);
        }
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(function() {
            $('#companyNameSelect').on('change', function() {
                let companyId = $(this).val();
                if (!companyId) {
                    $('#cCompanyAddress').val('');
                    $('#cCompanyGst').val('');
                    $('#cCompanyEmail').val('');
                    $('#cCompanyPhone').val('');
                    return;
                }
                $.get("{{ url('superadmin/customer-vendor') }}/" + companyId, function(data) {
                    if (data.success) {
                        $('#cCompanyAddress').val(data.company.billing_address || '');
                        $('#cCompanyGst').val(data.company.gst || '');
                        $('#cCompanyEmail').val(data.company.email || '');
                        $('#cCompanyPhone').val(data.company.mobile || '');
                    } else {
                        $('#cCompanyAddress').val('');
                        $('#cCompanyGst').val('');
                        $('#cCompanyEmail').val('');
                        $('#cCompanyPhone').val('');
                    }
                });
            });
        });
    </script>

@endsection
