@extends('layouts.dashboard.superadminapp')

@section('title', 'GRN Details')

@section('content')

<!-- Page Heading -->
<x-layout.page-header title="UEPL | GRN Details" icon="truck-loading" iconColor="info" />

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-file-invoice mr-2"></i> GRN Details - {{ $grn->grn_no }}
        </h6>
        <div>
            <a href="{{ route('superadmin.grn.edit', $grn->id) }}" class="btn btn-warning btn-sm mr-1">
                <i class="fa fa-edit mr-1"></i> Edit
            </a>
            <a href="{{ route('superadmin.grn.grndetails') }}" class="btn btn-light btn-sm">
                <i class="fa fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GRN No</label>
                <div class="font-weight-bold">{{ $grn->grn_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GRN Date</label>
                <div class="font-weight-bold">{{ $grn->grn_date ? \Carbon\Carbon::parse($grn->grn_date)->format('d M Y') : '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Order No</label>
                <div class="font-weight-bold">{{ $grn->order_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Order Date</label>
                <div class="font-weight-bold">{{ $grn->order_date ? \Carbon\Carbon::parse($grn->order_date)->format('d M Y') : '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Reference No</label>
                <div class="font-weight-bold">{{ $grn->order_ref_no ?? '-' }}</div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="small font-weight-bold text-muted">Company</label>
                <div class="font-weight-bold">{{ $grn->company_name ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">GST No</label>
                <div class="font-weight-bold">{{ $grn->company_gst ?? '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="small font-weight-bold text-muted">Address</label>
                <div class="font-weight-bold">{{ $grn->company_address ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Phone</label>
                <div class="font-weight-bold">{{ $grn->company_phone ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Email</label>
                <div class="font-weight-bold">{{ $grn->company_email ?? '-' }}</div>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Quotation No</label>
                <div class="font-weight-bold">{{ $grn->quotation_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Quotation Date</label>
                <div class="font-weight-bold">{{ $grn->quotation_date ? \Carbon\Carbon::parse($grn->quotation_date)->format('d M Y') : '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">RFQ No</label>
                <div class="font-weight-bold">{{ $grn->rfq_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">RFQ Date</label>
                <div class="font-weight-bold">{{ $grn->rfq_date ? \Carbon\Carbon::parse($grn->rfq_date)->format('d M Y') : '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Part No</label>
                <div class="font-weight-bold">{{ $grn->part_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Project Material No</label>
                <div class="font-weight-bold">{{ $grn->project_material_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Drawing No</label>
                <div class="font-weight-bold">{{ $grn->drawing_no ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Drawing Rev</label>
                <div class="font-weight-bold">{{ $grn->drawing_rev ?? '-' }}</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Product Type</label>
                <div class="font-weight-bold">{{ $grn->product_type ?? '-' }}</div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="small font-weight-bold text-muted">Challan</label>
                <div class="font-weight-bold">
                    @if ($grn->challan_file)
                        <a href="{{ asset('storage/' . $grn->challan_file) }}" target="_blank" class="btn btn-info btn-sm">
                            <i class="fa fa-file-pdf mr-1"></i> View Challan
                        </a>
                    @else
                        -
                    @endif
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="small font-weight-bold text-muted">Description</label>
                <div class="font-weight-bold">{{ $grn->description ?? '-' }}</div>
            </div>
        </div>

        <hr>

        <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-boxes mr-2"></i>Product Details</h6>

        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm">
                <thead class="thead-light">
                    <tr>
                        <th width="60">Sl No</th>
                        <th>Description</th>
                        <th width="100">Qty</th>
                        <th width="80">Unit</th>
                        <th width="120">Date</th>
                        <th>Supplier</th>
                        <th>Remarks</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($grn->products as $product)
                        <tr>
                            <td>{{ $product->sl_no }}</td>
                            <td>{{ $product->description ?? '-' }}</td>
                            <td>{{ number_format($product->quantity, 2) }}</td>
                            <td>{{ $product->unit ?? '-' }}</td>
                            <td>{{ $product->date ? \Carbon\Carbon::parse($product->date)->format('d M Y') : '-' }}</td>
                            <td>{{ $product->supplier ?? '-' }}</td>
                            <td>{{ $product->remarks ?? '-' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">No Product Rows Found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <hr>

        <div class="d-flex justify-content-end">
            <a href="{{ route('superadmin.grn.edit', $grn->id) }}" class="btn btn-warning btn-sm mr-2">
                <i class="fa fa-edit mr-1"></i> Edit
            </a>
            <a href="{{ route('superadmin.grn.grndetails') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fa fa-arrow-left mr-1"></i> Back to List
            </a>
        </div>
    </div>
</div>
@endsection
