@extends('layouts.dashboard.superadminapp')

@section('title', 'Leave Balance Management')

@section('styles')
<style>
    .balance-card {
        border-left: 4px solid;
    }
    .balance-cl { border-left-color: #36b9cc; }
    .balance-sl { border-left-color: #f6c23e; }
    .balance-pl { border-left-color: #4e73df; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Leave Balance Management</h1>
    <div>
        <a href="{{ route('superadmin.leave.index') }}" class="btn btn-outline-primary btn-sm">
            <i class="fas fa-arrow-left mr-1"></i> Back to Leave Requests
        </a>
    </div>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
    </div>
@endif

<!-- Year Filter -->
<div class="card shadow mb-4">
    <div class="card-header py-2" style="background: linear-gradient(135deg, #36b9cc 0%, #1e90a6 100%);">
        <h6 class="m-0 font-weight-bold text-white"><i class="fas fa-filter mr-2"></i> Filter</h6>
    </div>
    <div class="card-body py-3">
        <form method="GET" action="{{ route('superadmin.leave-balance.index') }}" class="form-inline">
            <label class="mr-2 font-weight-bold">Year:</label>
            <select class="form-control form-control-sm mr-2" name="year" onchange="this.form.submit()">
                @for($y = now()->year; $y >= now()->year - 5; $y--)
                    <option value="{{ $y }}" {{ $year == $y ? 'selected' : '' }}>{{ $y }}</option>
                @endfor
            </select>
            <button type="submit" class="btn btn-primary btn-sm"><i class="fas fa-search mr-1"></i> Filter</button>
        </form>
    </div>
</div>

<!-- Leave Balance Card -->
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-balance-scale mr-2"></i> Leave Balance - {{ $year }}
        </h6>
        <button class="btn btn-light btn-sm" id="addBalanceBtn">
            <i class="fas fa-plus mr-1"></i> Set Balance
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm" id="balanceTable" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>Employee ID</th>
                        <th>Employee Name</th>
                        <th>Department</th>
                        <th class="text-center">CL Balance</th>
                        <th class="text-center">SL Balance</th>
                        <th class="text-center">PL Balance</th>
                        <th class="text-center">CL Used</th>
                        <th class="text-center">SL Used</th>
                        <th class="text-center">PL Used</th>
                        <th width="80" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($balances as $balance)
                        <tr id="row-{{ $balance->id }}">
                            <td>{{ $balance->employee->employee_id ?? '-' }}</td>
                            <td>{{ $balance->employee->name ?? '-' }}</td>
                            <td>{{ $balance->employee->department ?? '-' }}</td>
                            <td class="text-center">
                                <span class="badge badge-info">{{ $balance->cl_balance ?? 0 }}</span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-warning">{{ $balance->sl_balance ?? 0 }}</span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-primary">{{ $balance->pl_balance ?? 0 }}</span>
                            </td>
                            <td class="text-center">{{ $balance->cl_used ?? 0 }}</td>
                            <td class="text-center">{{ $balance->sl_used ?? 0 }}</td>
                            <td class="text-center">{{ $balance->pl_used ?? 0 }}</td>
                            <td class="text-center">
                                <button class="btn btn-warning btn-sm edit-btn"
                                    data-id="{{ $balance->id }}"
                                    data-employee="{{ $balance->employee_id }}"
                                    data-cl="{{ $balance->cl_balance }}"
                                    data-sl="{{ $balance->sl_balance }}"
                                    data-pl="{{ $balance->pl_balance }}"
                                    title="Edit">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add/Edit Balance Modal -->
<div class="modal fade" id="balanceModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form id="balanceForm">
                @csrf
                <input type="hidden" id="balance_year" name="year" value="{{ $year }}">
                <div class="modal-header" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                    <h5 class="modal-title text-white" id="balanceModalLabel">
                        <i class="fas fa-plus-circle mr-2"></i> Set Leave Balance
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="font-weight-bold">Employee <span class="text-danger">*</span></label>
                        <select class="form-control" id="bal_employee_id" name="employee_id" required>
                            <option value="">Select Employee</option>
                            @foreach($employees as $emp)
                                <option value="{{ $emp->id }}">{{ $emp->employee_id }} - {{ $emp->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="font-weight-bold">CL Balance</label>
                                <input type="number" step="0.5" class="form-control" id="cl_balance" name="cl_balance" value="12" min="0">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="font-weight-bold">SL Balance</label>
                                <input type="number" step="0.5" class="form-control" id="sl_balance" name="sl_balance" value="6" min="0">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="font-weight-bold">PL Balance</label>
                                <input type="number" step="0.5" class="form-control" id="pl_balance" name="pl_balance" value="15" min="0">
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-info small mb-0">
                        <i class="fas fa-info-circle mr-1"></i> Default values: CL = 12 days/year, SL = 6 days/year, PL = 15 days/year
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-save mr-1"></i> Save Balance</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    $('#balanceTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        order: [[1, 'asc']]
    });

    $('#addBalanceBtn').on('click', function() {
        $('#balanceForm')[0].reset();
        $('#balance_year').val('{{ $year }}');
        $('#cl_balance').val(12);
        $('#sl_balance').val(6);
        $('#pl_balance').val(15);
        $('#balanceModalLabel').html('<i class="fas fa-plus-circle mr-2"></i> Set Leave Balance');
        $('#balanceModal').modal('show');
    });

    $(document).on('click', '.edit-btn', function() {
        const empId = $(this).data('employee');
        const cl = $(this).data('cl');
        const sl = $(this).data('sl');
        const pl = $(this).data('pl');

        $('#bal_employee_id').val(empId);
        $('#cl_balance').val(cl);
        $('#sl_balance').val(sl);
        $('#pl_balance').val(pl);
        $('#balanceModalLabel').html('<i class="fas fa-edit mr-2"></i> Edit Leave Balance');
        $('#balanceModal').modal('show');
    });

    $('#balanceForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '{{ route("superadmin.leave-balance.update") }}',
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response.success) {
                    Swal.fire('Success', response.message, 'success').then(() => location.reload());
                }
            },
            error: function(xhr) {
                Swal.fire('Error', xhr.responseJSON?.message || 'Failed to save balance', 'error');
            }
        });
    });
});
</script>
@endsection
