@extends('layouts.dashboard.superadminapp')

@section('title', 'Employee Dashboard')

@section('styles')
<style>
    /* Compact Dashboard Styles */
    .dashboard-card {
        border: none;
        border-radius: 8px;
        transition: all 0.2s ease;
        overflow: hidden;
        cursor: pointer;
        text-decoration: none;
        display: block;
    }
    .dashboard-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12) !important;
        text-decoration: none;
    }

    /* Compact KPI Cards */
    .kpi-card {
        border-radius: 8px;
        color: #fff;
        position: relative;
        overflow: hidden;
        padding: 0.75rem 1rem !important;
    }
    .kpi-card .kpi-icon {
        font-size: 2rem;
        opacity: 0.25;
        position: absolute;
        right: 0.75rem;
        top: 50%;
        transform: translateY(-50%);
    }
    .kpi-card .kpi-value {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.1rem;
        line-height: 1.2;
    }
    .kpi-card .kpi-label {
        font-size: 0.7rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        opacity: 0.9;
    }
    .kpi-card .kpi-info {
        font-size: 0.65rem;
        margin-top: 0.25rem;
        opacity: 0.8;
    }

    /* Gradient backgrounds */
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-warning { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }
    .bg-gradient-danger { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }

    /* Compact Cards */
    .compact-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    }
    .compact-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.5rem 0.75rem;
    }
    .compact-card .card-body {
        padding: 0.5rem 0.75rem;
    }
    .compact-card .card-header h6 {
        font-size: 0.8rem;
        margin: 0;
    }

    /* Compact Chart Cards */
    .chart-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    }
    .chart-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.5rem 0.75rem;
    }
    .chart-card .card-body {
        padding: 0.5rem 0.75rem;
    }

    /* Compact Quick Links */
    .quick-link-card {
        background: #fff;
        border-radius: 8px;
        padding: 0.75rem;
        text-align: center;
        transition: all 0.2s;
        border: 1px solid rgba(0, 0, 0, 0.05);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
    }
    .quick-link-card:hover {
        border-color: #4e73df;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(78, 115, 223, 0.15);
    }
    .quick-link-card i {
        font-size: 1.5rem;
        margin-bottom: 0.35rem;
    }
    .quick-link-card .link-title {
        font-weight: 600;
        color: #333;
        font-size: 0.75rem;
    }

    /* Progress Stats */
    .progress-stat {
        margin-bottom: 0.75rem;
    }
    .progress-stat .progress-label {
        display: flex;
        justify-content: space-between;
        margin-bottom: 0.25rem;
        font-weight: 500;
        font-size: 0.75rem;
    }
    .progress {
        height: 6px !important;
        border-radius: 3px;
    }

    /* Compact Page Header */
    .page-header {
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 0.75rem;
        box-shadow: 0 1px 5px rgba(0, 0, 0, 0.04);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin: 0;
    }

    /* DateTime Display */
    .datetime-display {
        gap: 0.5rem;
    }
    .date-box, .time-box {
        display: flex;
        align-items: center;
        gap: 0.35rem;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 0.35rem 0.65rem;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
        font-size: 0.75rem;
        color: #475569;
        font-weight: 500;
    }
    .date-box i, .time-box i {
        color: #4e73df;
        font-size: 0.7rem;
    }
    .time-box {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        border: none;
        min-width: 85px;
        justify-content: center;
    }
    .time-box i {
        color: rgba(255,255,255,0.8);
    }
    .time-box .display-time {
        font-family: 'Courier New', monospace;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    /* Compact row margins */
    .row.mb-4 { margin-bottom: 0.75rem !important; }
    .row.mb-3 { margin-bottom: 0.5rem !important; }
    .col-xl-3.mb-3, .col-md-6.mb-3, .col-xl-6.mb-3, .col-lg-4.mb-3, .col-lg-8.mb-3 {
        margin-bottom: 0.5rem !important;
    }

    /* Compact table */
    .table-sm td, .table-sm th {
        padding: 0.3rem 0.5rem;
        font-size: 0.8rem;
    }

    /* Attendance Rate Display */
    .attendance-rate-display {
        text-align: center;
        padding: 0.5rem;
    }
    .attendance-rate-display .rate-value {
        font-size: 2rem;
        font-weight: 700;
        line-height: 1;
    }
    .attendance-rate-display .rate-label {
        font-size: 0.7rem;
        color: #6c757d;
        margin-top: 0.25rem;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .kpi-card .kpi-value { font-size: 1.25rem; }
        .quick-link-card i { font-size: 1.25rem; }
    }
</style>
@endsection

@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-users mr-2 text-primary"></i>Employee Dashboard</h1>
        <div class="datetime-display d-flex align-items-center">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">{{ now()->format('l') }}</span>,
                <span id="daynum">{{ now()->format('d') }}</span>
                <span id="month">{{ now()->format('F') }}</span>
                <span id="year">{{ now()->format('Y') }}</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time"></span>
            </div>
        </div>
    </div>

    @php
        $attendanceRate = $totalEmployees ? round(($presentToday / $totalEmployees) * 100, 1) : 0;
        $absenceRate = $totalEmployees ? round(($absentToday / $totalEmployees) * 100, 1) : 0;
        $leaveRate = $totalEmployees ? round(($onLeaveToday / $totalEmployees) * 100, 1) : 0;
    @endphp

    <!-- KPI Cards Row -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-3">
            <a href="{{ route('superadmin.employee.employeedetails') }}" class="dashboard-card">
                <div class="kpi-card bg-gradient-primary shadow">
                    <i class="fas fa-users kpi-icon"></i>
                    <div class="kpi-value">{{ $totalEmployees }}</div>
                    <div class="kpi-label">Total Employees</div>
                    <div class="kpi-info">
                        <i class="fas fa-building mr-1"></i> Across all departments
                    </div>
                </div>
            </a>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <a href="{{ route('superadmin.employee.index') }}" class="dashboard-card">
                <div class="kpi-card bg-gradient-success shadow">
                    <i class="fas fa-user-check kpi-icon"></i>
                    <div class="kpi-value">{{ $presentToday }}</div>
                    <div class="kpi-label">Present Today</div>
                    <div class="kpi-info">
                        <i class="fas fa-chart-line mr-1"></i> {{ $attendanceRate }}% attendance rate
                    </div>
                </div>
            </a>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <a href="{{ route('superadmin.employee.index') }}" class="dashboard-card">
                <div class="kpi-card bg-gradient-danger shadow">
                    <i class="fas fa-user-times kpi-icon"></i>
                    <div class="kpi-value">{{ $absentToday }}</div>
                    <div class="kpi-label">Absent Today</div>
                    <div class="kpi-info">
                        <i class="fas fa-exclamation-triangle mr-1"></i> {{ $absenceRate }}% absence rate
                    </div>
                </div>
            </a>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <a href="{{ route('superadmin.employee.employeeleave') }}" class="dashboard-card">
                <div class="kpi-card bg-gradient-warning shadow">
                    <i class="fas fa-umbrella-beach kpi-icon"></i>
                    <div class="kpi-value">{{ $onLeaveToday }}</div>
                    <div class="kpi-label">On Leave</div>
                    <div class="kpi-info">
                        <i class="fas fa-calendar-check mr-1"></i> {{ $leaveRate }}% on approved leave
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- Attendance Overview Bar -->
    <div class="compact-card card shadow mb-3">
        <div class="card-header d-flex align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-chart-pie mr-2"></i>Today's Attendance Overview
            </h6>
            <a href="{{ route('superadmin.employee.index') }}" class="btn btn-sm btn-outline-primary">View Details</a>
        </div>
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <div class="progress-stat">
                        <div class="progress-label">
                            <span><i class="fas fa-circle text-success mr-1"></i> Present</span>
                            <span>{{ $presentToday }} ({{ $attendanceRate }}%)</span>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-success" style="width: {{ $attendanceRate }}%"></div>
                        </div>
                    </div>
                    <div class="progress-stat">
                        <div class="progress-label">
                            <span><i class="fas fa-circle text-danger mr-1"></i> Absent</span>
                            <span>{{ $absentToday }} ({{ $absenceRate }}%)</span>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-danger" style="width: {{ $absenceRate }}%"></div>
                        </div>
                    </div>
                    <div class="progress-stat mb-0">
                        <div class="progress-label">
                            <span><i class="fas fa-circle text-warning mr-1"></i> On Leave</span>
                            <span>{{ $onLeaveToday }} ({{ $leaveRate }}%)</span>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-warning" style="width: {{ $leaveRate }}%"></div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="attendance-rate-display">
                        <div class="rate-value {{ $attendanceRate >= 80 ? 'text-success' : ($attendanceRate >= 60 ? 'text-warning' : 'text-danger') }}">
                            {{ $attendanceRate }}%
                        </div>
                        <div class="rate-label">Overall Attendance Rate</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <!-- Monthly Attendance Chart -->
        <div class="col-lg-8 mb-3">
            <div class="chart-card card shadow h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-chart-bar mr-2"></i>Monthly Attendance Trend ({{ date('Y') }})
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="attendanceChart" height="100"></canvas>
                </div>
            </div>
        </div>

        <!-- Department Distribution Chart -->
        <div class="col-lg-4 mb-3">
            <div class="chart-card card shadow h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-success">
                        <i class="fas fa-sitemap mr-2"></i>Department Distribution
                    </h6>
                </div>
                <div class="card-body d-flex align-items-center justify-content-center">
                    <canvas id="departmentChart" height="180"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Links -->
    <div class="compact-card card shadow mb-3">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-info">
                <i class="fas fa-bolt mr-2"></i>Quick Actions
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.employee.employeedetails') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-users text-primary"></i>
                            <div class="link-title">Employees</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.employee.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-clipboard-check text-success"></i>
                            <div class="link-title">Attendance</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.employee.employeeleave') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-calendar-minus text-warning"></i>
                            <div class="link-title">Leave</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.employee.employeepayroll') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-money-bill-wave text-info"></i>
                            <div class="link-title">Payroll</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.employee.employeedailyreport') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-file-alt text-danger"></i>
                            <div class="link-title">Daily Report</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.report.employeereport') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-chart-line text-secondary"></i>
                            <div class="link-title">Reports</div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Department Breakdown Table -->
    <div class="compact-card card shadow mb-3">
        <div class="card-header d-flex align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-warning">
                <i class="fas fa-building mr-2"></i>Department Breakdown
            </h6>
            <a href="{{ route('superadmin.employee.employeedetails') }}" class="btn btn-sm btn-outline-warning">View All</a>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm table-hover mb-0">
                    <thead class="thead-light">
                        <tr>
                            <th class="pl-3">Department</th>
                            <th class="text-center">Employees</th>
                            <th class="text-center">Percentage</th>
                            <th class="pr-3">Distribution</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($departmentDist as $dept => $count)
                            @php
                                $percentage = $totalEmployees > 0 ? round(($count / $totalEmployees) * 100, 1) : 0;
                            @endphp
                            <tr>
                                <td class="font-weight-bold pl-3">{{ $dept ?: 'Unassigned' }}</td>
                                <td class="text-center">
                                    <span class="badge badge-primary">{{ $count }}</span>
                                </td>
                                <td class="text-center">{{ $percentage }}%</td>
                                <td class="pr-3">
                                    <div class="progress" style="height: 6px;">
                                        <div class="progress-bar bg-info" style="width: {{ $percentage }}%"></div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted py-3">No department data available</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Pass PHP data to JS
    const attendanceMonthly = @json($attendanceMonthly);
    const departmentDist = @json($departmentDist);

    // Monthly Attendance Chart
    const attendanceLabels = [];
    const attendanceData = [];
    const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

    for (let i = 1; i <= 12; i++) {
        attendanceLabels.push(months[i - 1]);
        attendanceData.push(attendanceMonthly[i] || 0);
    }

    const attendanceCtx = document.getElementById('attendanceChart').getContext('2d');
    new Chart(attendanceCtx, {
        type: 'bar',
        data: {
            labels: attendanceLabels,
            datasets: [{
                label: 'Present Employees',
                data: attendanceData,
                backgroundColor: 'rgba(78, 115, 223, 0.8)',
                borderColor: 'rgba(78, 115, 223, 1)',
                borderWidth: 1,
                borderRadius: 4,
                barThickness: 20
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { color: 'rgba(0,0,0,0.05)' }
                },
                x: {
                    grid: { display: false }
                }
            }
        }
    });

    // Department Distribution Doughnut Chart
    const depLabels = Object.keys(departmentDist).map(d => d || 'Unassigned');
    const depData = Object.values(departmentDist);

    const departmentCtx = document.getElementById('departmentChart').getContext('2d');
    new Chart(departmentCtx, {
        type: 'doughnut',
        data: {
            labels: depLabels,
            datasets: [{
                data: depData,
                backgroundColor: [
                    '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b',
                    '#858796', '#5a5c69', '#6f42c1', '#fd7e14', '#20c9a6'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 10,
                        usePointStyle: true,
                        font: { size: 10 }
                    }
                }
            },
            cutout: '60%'
        }
    });

    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        document.getElementById('day').textContent = days[now.getDay()];
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = months[now.getMonth()];
        document.getElementById('year').textContent = now.getFullYear();

        const timeStr = now.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        document.querySelector('.display-time').textContent = timeStr;
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);
});
</script>
@endsection
