@extends('layouts.dashboard.superadminapp')

@section('title', 'Dashboard')

@section('styles')
<style>
    /* Compact Dashboard Styles */
    .dashboard-card {
        border: none;
        border-radius: 8px;
        transition: all 0.2s ease;
        overflow: hidden;
        cursor: pointer;
        text-decoration: none;
        display: block;
    }
    .dashboard-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12) !important;
        text-decoration: none;
    }

    /* Compact KPI Cards */
    .kpi-card {
        border-radius: 8px;
        color: #fff;
        position: relative;
        overflow: hidden;
        padding: 0.75rem 1rem !important;
    }
    .kpi-card .kpi-icon {
        font-size: 2rem;
        opacity: 0.25;
        position: absolute;
        right: 0.75rem;
        top: 50%;
        transform: translateY(-50%);
    }
    .kpi-card .kpi-value {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.1rem;
        line-height: 1.2;
    }
    .kpi-card .kpi-label {
        font-size: 0.7rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        opacity: 0.9;
    }

    /* Gradient backgrounds */
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-warning { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }
    .bg-gradient-danger { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .bg-gradient-purple { background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); }

    /* Compact Pipeline Cards */
    .pipeline-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    }
    .pipeline-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.5rem 0.75rem;
    }
    .pipeline-card .card-body {
        padding: 0.5rem;
    }
    .pipeline-item {
        padding: 0.5rem;
        text-align: center;
        border-radius: 6px;
        transition: all 0.2s ease;
        cursor: pointer;
        text-decoration: none;
        display: block;
        color: inherit;
    }
    .pipeline-item:hover {
        background: rgba(78, 115, 223, 0.08);
        text-decoration: none;
        color: inherit;
    }
    .pipeline-item .count {
        font-size: 1.5rem;
        font-weight: 700;
        line-height: 1;
        margin-bottom: 0.25rem;
    }
    .pipeline-item .label {
        font-size: 0.65rem;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.2px;
    }
    .pipeline-item .badge {
        margin-top: 0.25rem;
        font-size: 0.6rem;
        padding: 0.2rem 0.4rem;
    }

    /* Compact Status Cards */
    .status-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        height: 100%;
    }
    .status-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.5rem 0.75rem;
    }
    .status-card .card-body {
        padding: 0.5rem;
    }
    .status-item {
        text-align: center;
        padding: 0.4rem;
        border-radius: 6px;
        transition: all 0.2s ease;
        cursor: pointer;
    }
    .status-item:hover {
        background: rgba(0, 0, 0, 0.03);
    }
    .status-item .value {
        font-size: 1.25rem;
        font-weight: 700;
        line-height: 1.1;
    }
    .status-item .label {
        font-size: 0.6rem;
        color: #6c757d;
        text-transform: uppercase;
    }

    /* Compact Chart Cards */
    .chart-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
    }
    .chart-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.5rem 0.75rem;
    }
    .chart-card .card-body {
        padding: 0.5rem 0.75rem;
    }

    /* Compact Quick Actions */
    .quick-action-btn {
        border-radius: 6px;
        padding: 0.4rem 0.75rem;
        font-weight: 500;
        transition: all 0.2s ease;
        border-width: 1px;
    }
    .quick-action-btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.12);
    }
    .quick-action-btn i {
        margin-right: 0.35rem;
    }

    /* Compact Activity Timeline */
    .activity-item {
        padding: 0.4rem 0;
        border-bottom: 1px solid rgba(0, 0, 0, 0.04);
        transition: background 0.2s;
    }
    .activity-item:last-child {
        border-bottom: none;
    }
    .activity-item:hover {
        background: rgba(0, 0, 0, 0.02);
    }
    .activity-icon {
        width: 28px;
        height: 28px;
        border-radius: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
    }

    /* Compact Page Header */
    .page-header {
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 0.75rem;
        box-shadow: 0 1px 5px rgba(0, 0, 0, 0.04);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin: 0;
    }

    /* DateTime Display */
    .datetime-display {
        gap: 0.5rem;
    }
    .date-box, .time-box {
        display: flex;
        align-items: center;
        gap: 0.35rem;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 0.35rem 0.65rem;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
        font-size: 0.75rem;
        color: #475569;
        font-weight: 500;
    }
    .date-box i, .time-box i {
        color: #4e73df;
        font-size: 0.7rem;
    }
    .time-box {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        border: none;
        min-width: 85px;
        justify-content: center;
    }
    .time-box i {
        color: rgba(255,255,255,0.8);
    }
    .time-box .display-time {
        font-family: 'Courier New', monospace;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    /* Compact row margins */
    .row.mb-4 { margin-bottom: 0.75rem !important; }
    .row.mb-3 { margin-bottom: 0.5rem !important; }
    .col-xl-3.mb-3, .col-md-6.mb-3, .col-xl-6.mb-3, .col-xl-4.mb-3, .col-lg-6.mb-3, .col-lg-4.mb-3 {
        margin-bottom: 0.5rem !important;
    }

    /* Compact card headers */
    .card-header h6 {
        font-size: 0.8rem;
        margin: 0;
    }
    .card-header .btn-sm {
        padding: 0.2rem 0.5rem;
        font-size: 0.7rem;
    }

    /* Compact progress bar */
    .progress {
        height: 6px !important;
        border-radius: 3px;
    }

    /* Compact table */
    .table-sm td, .table-sm th {
        padding: 0.3rem 0.5rem;
    }

    /* Compact hr */
    hr.my-2 { margin: 0.35rem 0 !important; }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .kpi-card .kpi-value { font-size: 1.25rem; }
        .pipeline-item .count { font-size: 1.1rem; }
    }
</style>
@endsection

@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-tachometer-alt mr-2 text-primary"></i>Dashboard Overview</h1>
        <div class="datetime-display d-flex align-items-center">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">{{ now()->format('l') }}</span>,
                <span id="daynum">{{ now()->format('d') }}</span>
                <span id="month">{{ now()->format('F') }}</span>
                <span id="year">{{ now()->format('Y') }}</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time"></span>
            </div>
        </div>
    </div>

    <!-- KPI Cards Row -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-3">
            <a href="{{ route('superadmin.invoice.invoicedetails') }}" class="dashboard-card">
                <div class="kpi-card bg-gradient-success ">
                    <i class="fas fa-rupee-sign kpi-icon"></i>
                    <div class="kpi-value">{{ number_format($monthlyRevenue, 0) }}</div>
                    <div class="kpi-label">Monthly Revenue</div>
                </div>
            </a>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <a href="{{ route('superadmin.invoice.invoicedetails') }}" class="dashboard-card">
                <div class="kpi-card bg-gradient-primary ">
                    <i class="fas fa-chart-line kpi-icon"></i>
                    <div class="kpi-value">{{ number_format($annualRevenue, 0) }}</div>
                    <div class="kpi-label">Annual Revenue</div>
                </div>
            </a>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="dashboard-card">
                <div class="kpi-card bg-gradient-warning ">
                    <i class="fas fa-clock kpi-icon"></i>
                    <div class="kpi-value">{{ $totalPendingApprovals }}</div>
                    <div class="kpi-label">Pending Approvals</div>
                </div>
            </a>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <a href="{{ route('superadmin.sku.skumaster') }}" class="dashboard-card">
                <div class="kpi-card bg-gradient-info ">
                    <i class="fas fa-warehouse kpi-icon"></i>
                    <div class="kpi-value">{{ number_format($totalStockValue, 0) }}</div>
                    <div class="kpi-label">Stock Value</div>
                </div>
            </a>
        </div>
    </div>

    <!-- Sales & Purchase Pipeline -->
    <div class="row mb-4">
        <!-- Sales Pipeline -->
        <div class="col-xl-6 col-lg-6 mb-3">
            <div class="pipeline-card card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-funnel-dollar mr-2"></i>Sales Pipeline
                    </h6>
                    <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="btn btn-sm btn-primary">
                        View All <i class="fas fa-arrow-right ml-1"></i>
                    </a>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-3">
                            <a href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}" class="pipeline-item">
                                <div class="count text-primary">{{ $totalRfqs }}</div>
                                <div class="label">RFQs</div>
                                <span class="badge badge-warning">{{ $pendingRfqs }} Pending</span>
                            </a>
                        </div>
                        <div class="col-3">
                            <a href="{{ route('superadmin.salesbom.quotation.quotationdetails') }}" class="pipeline-item">
                                <div class="count text-success">{{ $totalQuotations }}</div>
                                <div class="label">Quotations</div>
                                <span class="badge badge-warning">{{ $pendingQuotations }} Pending</span>
                            </a>
                        </div>
                        <div class="col-3">
                            <a href="{{ route('superadmin.sales.salesdetails') }}" class="pipeline-item">
                                <div class="count text-info">{{ $totalSalesOrders }}</div>
                                <div class="label">Sales Orders</div>
                                <span class="badge badge-warning">{{ $pendingSalesOrders }} Pending</span>
                            </a>
                        </div>
                        <div class="col-3">
                            <a href="{{ route('superadmin.invoice.invoicedetails') }}" class="pipeline-item">
                                <div class="count text-danger">{{ $totalInvoices }}</div>
                                <div class="label">Invoices</div>
                                <span class="badge badge-success">Active</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Purchase Pipeline -->
        <div class="col-xl-6 col-lg-6 mb-3">
            <div class="pipeline-card card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-success">
                        <i class="fas fa-shopping-basket mr-2"></i>Purchase Pipeline
                    </h6>
                    <a href="{{ route('superadmin.purchasebom.rfq.rfqdetails') }}" class="btn btn-sm btn-success">
                        View All <i class="fas fa-arrow-right ml-1"></i>
                    </a>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-3">
                            <a href="{{ route('superadmin.purchasebom.rfq.rfqdetails') }}" class="pipeline-item">
                                <div class="count text-primary">{{ $totalPurchaseRfqs }}</div>
                                <div class="label">Purchase RFQs</div>
                                <span class="badge badge-warning">{{ $pendingPurchaseRfqs }} Pending</span>
                            </a>
                        </div>
                        <div class="col-3">
                            <a href="{{ route('superadmin.purchasebom.quotation.quotationdetails') }}" class="pipeline-item">
                                <div class="count text-success">{{ $totalPurchaseQuotations }}</div>
                                <div class="label">Quotations</div>
                            </a>
                        </div>
                        <div class="col-3">
                            <a href="{{ route('superadmin.purchase.purchasedetails') }}" class="pipeline-item">
                                <div class="count text-info">{{ $totalPurchaseOrders }}</div>
                                <div class="label">Purchase Orders</div>
                                <span class="badge badge-warning">{{ $pendingPurchaseOrders }} Pending</span>
                            </a>
                        </div>
                        <div class="col-3">
                            <a href="{{ route('superadmin.grn.grndetails') }}" class="pipeline-item">
                                <div class="count text-danger">{{ $totalGrns }}</div>
                                <div class="label">GRNs</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Operations Row -->
    <div class="row mb-4">
        <!-- Manufacturing Status -->
        <div class="col-xl-4 col-lg-4 mb-3">
            <div class="status-card card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-industry mr-2"></i>Manufacturing
                    </h6>
                    <a href="{{ route('superadmin.routecard.index') }}" class="btn btn-sm btn-outline-primary">View</a>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-6">
                            <a href="{{ route('superadmin.routecard.index') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-primary">{{ $totalRouteCards }}</div>
                                <div class="label">Route Cards</div>
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{ route('superadmin.production.inprogress.list') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-warning">{{ $runningProjects }}</div>
                                <div class="label">In Production</div>
                            </a>
                        </div>
                    </div>
                    <div class="mt-3">
                        <div class="d-flex justify-content-between mb-1">
                            <small class="font-weight-bold">Task Completion</small>
                            <small class="font-weight-bold">{{ $dayTasksPercent }}%</small>
                        </div>
                        <div class="progress" style="height: 8px; border-radius: 4px;">
                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $dayTasksPercent }}%; border-radius: 4px;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Inventory Status -->
        <div class="col-xl-4 col-lg-4 mb-3">
            <div class="status-card card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-boxes mr-2"></i>Inventory
                    </h6>
                    <a href="{{ route('superadmin.sku.skumaster') }}" class="btn btn-sm btn-outline-info">View</a>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-4">
                            <a href="{{ route('superadmin.sku.skumaster') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-success">{{ $totalSkus }}</div>
                                <div class="label">Total SKUs</div>
                            </a>
                        </div>
                        <div class="col-4">
                            <a href="{{ route('superadmin.sku.skumaster') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-warning">{{ $lowStockItems }}</div>
                                <div class="label">Low Stock</div>
                            </a>
                        </div>
                        <div class="col-4">
                            <a href="{{ route('superadmin.sku.skumaster') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-danger">{{ $outOfStockItems }}</div>
                                <div class="label">Out of Stock</div>
                            </a>
                        </div>
                    </div>
                    <hr class="my-2">
                    <div class="row">
                        <div class="col-6">
                            <a href="{{ route('superadmin.machine.machinedetails') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-primary" style="font-size: 1.25rem;">{{ $totalMachines }}</div>
                                <div class="label">Machines</div>
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{ route('superadmin.grn.grndetails') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-info" style="font-size: 1.25rem;">{{ $totalGrns }}</div>
                                <div class="label">GRN Received</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Employee Status -->
        <div class="col-xl-4 col-lg-4 mb-3">
            <div class="status-card card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-warning">
                        <i class="fas fa-users mr-2"></i>HR & CRM
                    </h6>
                    <a href="{{ route('superadmin.employee.employeedetails') }}" class="btn btn-sm btn-outline-warning">View</a>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-4">
                            <a href="{{ route('superadmin.employee.employeedetails') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-primary">{{ $totalEmployees }}</div>
                                <div class="label">Employees</div>
                            </a>
                        </div>
                        <div class="col-4">
                            <a href="{{ route('superadmin.employee.index') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-success">{{ $employeePresent }}</div>
                                <div class="label">Present</div>
                            </a>
                        </div>
                        <div class="col-4">
                            <a href="{{ route('superadmin.employeeleave') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-danger">{{ $employeeLeave }}</div>
                                <div class="label">On Leave</div>
                            </a>
                        </div>
                    </div>
                    <hr class="my-2">
                    <div class="row">
                        <div class="col-6">
                            <a href="{{ route('superadmin.customer.customerlist') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-info" style="font-size: 1.25rem;">{{ $totalCustomers }}</div>
                                <div class="label">Customers</div>
                            </a>
                        </div>
                        <div class="col-6">
                            <a href="{{ route('superadmin.customer.customerlist') }}" class="status-item d-block text-decoration-none">
                                <div class="value text-purple" style="font-size: 1.25rem; color: #8b5cf6;">{{ $totalVendors }}</div>
                                <div class="label">Vendors</div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <!-- Sales Trend Chart -->
        <div class="col-xl-8 col-lg-7 mb-3">
            <div class="chart-card card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-chart-area mr-2"></i>Revenue Trend (Last 6 Months)
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="salesTrendChart" height="100"></canvas>
                </div>
            </div>
        </div>

        <!-- Production Status Pie -->
        <div class="col-xl-4 col-lg-5 mb-3">
            <div class="chart-card card h-100">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-chart-pie mr-2"></i>Production Status
                    </h6>
                </div>
                <div class="card-body d-flex align-items-center justify-content-center">
                    <canvas id="productionStatusChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activities & Top Customers -->
    <div class="row mb-4">
        <!-- Recent Activities -->
        <div class="col-xl-6 col-lg-6 mb-3">
            <div class="chart-card card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-history mr-2"></i>Recent Activities
                    </h6>
                    <a href="{{ route('superadmin.activity.index') }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="card-body p-0" style="max-height: 320px; overflow-y: auto;">
                    @forelse($recentActivities as $activity)
                    <div class="activity-item d-flex align-items-center px-3">
                        <div class="activity-icon bg-{{ $activity['color'] }} text-white mr-3">
                            <i class="fas {{ $activity['icon'] }}"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <small class="text-muted text-uppercase" style="font-size: 0.65rem;">{{ $activity['type'] }}</small>
                                    <div class="font-weight-bold" style="font-size: 0.875rem;">{{ $activity['title'] }}</div>
                                </div>
                                <div class="text-right">
                                    <span class="badge badge-{{ $activity['status'] == 'approved' ? 'success' : ($activity['status'] == 'pending' ? 'warning' : 'secondary') }}">
                                        {{ ucfirst($activity['status']) }}
                                    </span>
                                    <div class="text-muted" style="font-size: 0.7rem;">{{ \Carbon\Carbon::parse($activity['date'])->diffForHumans() }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="text-center text-muted py-4">
                        <i class="fas fa-inbox fa-2x mb-2"></i>
                        <p class="mb-0">No recent activities</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Top Customers -->
        <div class="col-xl-6 col-lg-6 mb-3">
            <div class="chart-card card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-trophy mr-2"></i>Top Customers by Revenue
                    </h6>
                    <a href="{{ route('superadmin.customer.customerlist') }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th class="border-0 pl-3">#</th>
                                    <th class="border-0">Customer</th>
                                    <th class="border-0 text-right pr-3">Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($topCustomers as $index => $customer)
                                <tr>
                                    <td class="pl-3">
                                        <span class="badge badge-{{ $index == 0 ? 'warning' : ($index == 1 ? 'secondary' : 'light') }}" style="width: 24px;">
                                            {{ $index + 1 }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="font-weight-bold">{{ $customer->company->company ?? 'N/A' }}</span>
                                    </td>
                                    <td class="text-right pr-3">
                                        <span class="font-weight-bold text-success">
                                            <i class="fas fa-rupee-sign" style="font-size: 0.75rem;"></i>
                                            {{ number_format($customer->total_revenue, 2) }}
                                        </span>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted py-4">
                                        <i class="fas fa-chart-bar fa-2x mb-2 d-block"></i>
                                        No data available
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row">
        <div class="col-12">
            <div class="chart-card card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-bolt mr-2"></i>Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <a href="{{ route('superadmin.salesbom.rfq.rfq') }}" class="btn quick-action-btn btn-outline-primary btn-block">
                                <i class="fas fa-plus-circle"></i> New RFQ
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <a href="{{ route('superadmin.salesbom.quotation.quotationorder') }}" class="btn quick-action-btn btn-outline-success btn-block">
                                <i class="fas fa-file-invoice"></i> New Quotation
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <a href="{{ route('superadmin.sales.salesorder') }}" class="btn quick-action-btn btn-outline-info btn-block">
                                <i class="fas fa-shopping-cart"></i> Sales Order
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <a href="{{ route('superadmin.invoice.invoiceorder') }}" class="btn quick-action-btn btn-outline-danger btn-block">
                                <i class="fas fa-file-invoice-dollar"></i> New Invoice
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <a href="{{ route('superadmin.routecard.index') }}" class="btn quick-action-btn btn-outline-warning btn-block">
                                <i class="fas fa-industry"></i> Route Card
                            </a>
                        </div>
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <a href="{{ route('superadmin.sku.skumovement') }}" class="btn quick-action-btn btn-outline-secondary btn-block">
                                <i class="fas fa-exchange-alt"></i> SKU Movement
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sales Trend Chart
    const salesTrendCtx = document.getElementById('salesTrendChart').getContext('2d');
    new Chart(salesTrendCtx, {
        type: 'line',
        data: {
            labels: {!! json_encode($salesTrend->pluck('month')) !!},
            datasets: [{
                label: 'Revenue',
                data: {!! json_encode($salesTrend->pluck('revenue')) !!},
                borderColor: 'rgb(78, 115, 223)',
                backgroundColor: 'rgba(78, 115, 223, 0.1)',
                fill: true,
                tension: 0.4,
                borderWidth: 3,
                pointBackgroundColor: '#fff',
                pointBorderColor: 'rgb(78, 115, 223)',
                pointBorderWidth: 2,
                pointRadius: 5,
                pointHoverRadius: 7
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    padding: 12,
                    titleFont: { size: 14 },
                    bodyFont: { size: 13 },
                    callbacks: {
                        label: function(context) {
                            return 'Revenue: ₹' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    },
                    ticks: {
                        callback: function(value) {
                            return '₹' + value.toLocaleString();
                        }
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Production Status Pie Chart
    const productionCtx = document.getElementById('productionStatusChart').getContext('2d');
    new Chart(productionCtx, {
        type: 'doughnut',
        data: {
            labels: {!! json_encode(array_keys($productionStatus)) !!},
            datasets: [{
                data: {!! json_encode(array_values($productionStatus)) !!},
                backgroundColor: ['#f6c23e', '#36b9cc', '#1cc88a'],
                borderWidth: 0,
                hoverOffset: 8
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            cutout: '65%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 15,
                        usePointStyle: true,
                        pointStyle: 'circle'
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    padding: 12
                }
            }
        }
    });
});
</script>
@endsection
