@extends('layouts.dashboard.superadminapp')

@section('title', 'Customer/Vendor Details')

@section('styles')
<style>
    /* Compact Page Header */
    .page-header {
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 0.75rem;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.04);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin: 0;
    }

    /* DateTime Display */
    .datetime-display { gap: 0.5rem; }
    .date-box, .time-box {
        display: flex;
        align-items: center;
        gap: 0.35rem;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 0.35rem 0.65rem;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
        font-size: 0.75rem;
        color: #475569;
        font-weight: 500;
    }
    .date-box i, .time-box i { color: #4e73df; font-size: 0.7rem; }
    .time-box {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        border: none;
        min-width: 85px;
        justify-content: center;
    }
    .time-box i { color: rgba(255,255,255,0.8); }
    .time-box .display-time {
        font-family: 'Courier New', monospace;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    /* Company Header - Compact */
    .company-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        color: white;
        padding: 1rem 1.25rem;
        border-radius: 8px;
        margin-bottom: 0.75rem;
        box-shadow: 0 4px 15px rgba(28, 200, 138, 0.3);
    }
    .company-logo {
        width: 55px;
        height: 55px;
        border-radius: 10px;
        object-fit: cover;
        border: 2px solid rgba(255,255,255,0.3);
        background: white;
    }
    .company-logo-placeholder {
        width: 55px;
        height: 55px;
        border-radius: 10px;
        background: rgba(255,255,255,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        border: 2px solid rgba(255,255,255,0.3);
    }
    .company-logo-placeholder i {
        font-size: 1.5rem;
        color: rgba(255,255,255,0.8);
    }
    .company-name {
        font-size: 1.1rem;
        font-weight: 700;
        margin-bottom: 0.15rem;
    }
    .company-nickname {
        font-size: 0.8rem;
        opacity: 0.85;
    }
    .role-badge-header {
        padding: 0.25rem 0.6rem;
        border-radius: 20px;
        font-size: 0.7rem;
        font-weight: 600;
        background: rgba(255,255,255,0.2);
        color: #fff;
        margin-right: 0.5rem;
    }
    .status-badge-header {
        padding: 0.25rem 0.6rem;
        border-radius: 20px;
        font-size: 0.7rem;
        font-weight: 600;
    }
    .status-badge-header.active { background: rgba(255,255,255,0.95); color: #1cc88a; }
    .status-badge-header.inactive { background: rgba(255,255,255,0.95); color: #e74a3b; }

    /* Action Buttons in Header */
    .header-actions .btn {
        padding: 0.35rem 0.75rem;
        font-size: 0.75rem;
        font-weight: 600;
        border-radius: 6px;
    }
    .header-actions .btn-light {
        background: rgba(255,255,255,0.95);
        border: none;
        color: #1cc88a;
    }
    .header-actions .btn-light:hover {
        background: #fff;
        transform: translateY(-1px);
    }
    .header-actions .btn-outline-light {
        border-color: rgba(255,255,255,0.5);
    }
    .header-actions .btn-outline-light:hover {
        background: rgba(255,255,255,0.15);
    }

    /* Quick Info Cards */
    .info-card {
        background: #fff;
        border-radius: 8px;
        padding: 0.75rem 1rem;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
        border: 1px solid #e3e6f0;
        height: 100%;
        transition: all 0.2s;
    }
    .info-card:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        transform: translateY(-2px);
    }
    .info-card-icon {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.9rem;
    }
    .info-card-icon.primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); color: #fff; }
    .info-card-icon.success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); color: #fff; }
    .info-card-icon.info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); color: #fff; }
    .info-card-icon.warning { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); color: #fff; }
    .info-card-label {
        font-size: 0.65rem;
        text-transform: uppercase;
        color: #858796;
        font-weight: 700;
        letter-spacing: 0.3px;
    }
    .info-card-value {
        font-size: 0.85rem;
        font-weight: 600;
        color: #2e2e2e;
        word-break: break-all;
    }

    /* Compact Detail Cards */
    .detail-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        margin-bottom: 0.75rem;
        overflow: hidden;
    }
    .detail-card .card-header {
        padding: 0.6rem 1rem;
        font-size: 0.8rem;
        font-weight: 600;
        color: #fff;
        display: flex;
        align-items: center;
    }
    .detail-card .card-header i { margin-right: 0.5rem; font-size: 0.85rem; }
    .detail-card .card-header.bg-primary-gradient { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .detail-card .card-header.bg-info-gradient { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }
    .detail-card .card-header.bg-warning-gradient { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .detail-card .card-header.bg-danger-gradient { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .detail-card .card-header.bg-secondary-gradient { background: linear-gradient(135deg, #858796 0%, #60616f 100%); }
    .detail-card .card-body { padding: 0.75rem 1rem; }

    /* Detail Row - Compact */
    .detail-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 0.5rem;
    }
    .detail-item {
        padding: 0.4rem 0;
        border-bottom: 1px solid #f1f3f8;
    }
    .detail-item:nth-last-child(-n+2) { border-bottom: none; }
    .detail-label {
        font-size: 0.7rem;
        text-transform: uppercase;
        color: #858796;
        font-weight: 600;
        letter-spacing: 0.3px;
        margin-bottom: 0.15rem;
    }
    .detail-value {
        font-size: 0.8rem;
        color: #2e2e2e;
        font-weight: 500;
        word-break: break-word;
    }
    .detail-value code {
        background: #f8f9fc;
        padding: 0.15rem 0.4rem;
        border-radius: 4px;
        font-size: 0.75rem;
        color: #4e73df;
    }
    .detail-value a {
        color: #4e73df;
        text-decoration: none;
    }
    .detail-value a:hover { text-decoration: underline; }

    /* Full Width Detail Item */
    .detail-item-full {
        grid-column: 1 / -1;
        padding: 0.4rem 0;
        border-bottom: 1px solid #f1f3f8;
    }
    .detail-item-full:last-child { border-bottom: none; }

    /* Address Cards */
    .address-content {
        font-size: 0.8rem;
        color: #5a5c69;
        line-height: 1.5;
        min-height: 50px;
    }
    .no-data {
        color: #adb5bd;
        font-style: italic;
        font-size: 0.8rem;
    }

    /* Contact Person Cards - Compact */
    .contact-card {
        background: #fff;
        border: 1px solid #e3e6f0;
        border-radius: 8px;
        padding: 0.75rem;
        transition: all 0.2s;
    }
    .contact-card:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        transform: translateY(-2px);
        border-color: #4e73df;
    }
    .contact-avatar {
        width: 38px;
        height: 38px;
        border-radius: 8px;
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 700;
        font-size: 0.9rem;
    }
    .contact-name {
        font-size: 0.85rem;
        font-weight: 600;
        color: #2e2e2e;
        margin-bottom: 0;
    }
    .contact-designation {
        font-size: 0.7rem;
        color: #858796;
    }
    .contact-info {
        font-size: 0.75rem;
        color: #5a5c69;
    }
    .contact-info i {
        width: 14px;
        color: #858796;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 1.5rem;
        color: #adb5bd;
    }
    .empty-state i {
        font-size: 2rem;
        margin-bottom: 0.5rem;
        opacity: 0.5;
    }
    .empty-state p {
        font-size: 0.8rem;
        margin-bottom: 0;
    }

    /* Footer Actions */
    .footer-actions {
        display: flex;
        justify-content: space-between;
        padding-top: 0.5rem;
    }
    .footer-actions .btn {
        padding: 0.5rem 1.25rem;
        font-size: 0.8rem;
        font-weight: 600;
        border-radius: 6px;
        transition: all 0.2s;
    }
    .footer-actions .btn:hover { transform: translateY(-2px); }
    .footer-actions .btn-secondary {
        background: linear-gradient(135deg, #6c757d 0%, #545b62 100%);
        border: none;
    }
    .footer-actions .btn-primary {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        border: none;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .detail-grid { grid-template-columns: 1fr; }
        .detail-item:nth-last-child(-n+2) { border-bottom: 1px solid #f1f3f8; }
        .detail-item:last-child { border-bottom: none; }
        .company-header { flex-direction: column; text-align: center; }
        .header-actions { margin-top: 0.75rem; }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-user mr-2 text-primary"></i>UEPL | Customer/Vendor Details</h1>
        <div class="datetime-display d-flex align-items-center">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">{{ now()->format('l') }}</span>,
                <span id="daynum">{{ now()->format('d') }}</span>
                <span id="month">{{ now()->format('F') }}</span>
                <span id="year">{{ now()->format('Y') }}</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time"></span>
            </div>
        </div>
    </div>

    <!-- Company Header Card -->
    <div class="company-header d-flex align-items-center justify-content-between flex-wrap">
        <div class="d-flex align-items-center">
            @if ($customer->image)
                <img src="{{ asset('storage/' . $customer->image) }}" alt="Logo" class="company-logo mr-3">
            @else
                <div class="company-logo-placeholder mr-3">
                    <i class="fas fa-building"></i>
                </div>
            @endif
            <div>
                <div class="company-name">{{ $customer->company }}</div>
                @if($customer->company_nickname)
                    <div class="company-nickname">{{ $customer->company_nickname }}</div>
                @endif
                <div class="d-flex align-items-center mt-2">
                    @if($customer->company_role == 'Customer')
                        <span class="role-badge-header"><i class="fas fa-user mr-1"></i>Customer</span>
                    @elseif($customer->company_role == 'Vendor')
                        <span class="role-badge-header"><i class="fas fa-truck mr-1"></i>Vendor</span>
                    @else
                        <span class="role-badge-header"><i class="fas fa-handshake mr-1"></i>Both</span>
                    @endif
                    @if ($customer->status == 1)
                        <span class="status-badge-header active"><i class="fas fa-check-circle mr-1"></i>Active</span>
                    @else
                        <span class="status-badge-header inactive"><i class="fas fa-times-circle mr-1"></i>Inactive</span>
                    @endif
                </div>
            </div>
        </div>
        <div class="header-actions">
            <a href="{{ route('superadmin.customer.edit', $customer->id) }}" class="btn btn-light mr-1">
                <i class="fas fa-edit mr-1"></i>Edit
            </a>
            <a href="{{ route('superadmin.customer.customerlist') }}" class="btn btn-outline-light">
                <i class="fas fa-arrow-left mr-1"></i>Back
            </a>
        </div>
    </div>

    <!-- Quick Info Cards -->
    <div class="row mb-3">
        <div class="col-lg-3 col-md-6 mb-2">
            <div class="info-card d-flex align-items-center">
                <div class="info-card-icon primary mr-3"><i class="fas fa-envelope"></i></div>
                <div class="flex-grow-1">
                    <div class="info-card-label">Email</div>
                    <div class="info-card-value">{{ $customer->email }}</div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-2">
            <div class="info-card d-flex align-items-center">
                <div class="info-card-icon success mr-3"><i class="fas fa-phone"></i></div>
                <div class="flex-grow-1">
                    <div class="info-card-label">Mobile</div>
                    <div class="info-card-value">{{ $customer->mobile }}</div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-2">
            <div class="info-card d-flex align-items-center">
                <div class="info-card-icon info mr-3"><i class="fas fa-id-card"></i></div>
                <div class="flex-grow-1">
                    <div class="info-card-label">GST No</div>
                    <div class="info-card-value">{{ $customer->gstno }}</div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-2">
            <div class="info-card d-flex align-items-center">
                <div class="info-card-icon warning mr-3"><i class="fas fa-building"></i></div>
                <div class="flex-grow-1">
                    <div class="info-card-label">Company Type</div>
                    <div class="info-card-value">{{ $customer->company_type }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Company Details Card -->
        <div class="col-lg-6">
            <div class="card detail-card">
                <div class="card-header bg-primary-gradient">
                    <i class="fas fa-building"></i> Company Information
                </div>
                <div class="card-body">
                    <div class="detail-grid">
                        <div class="detail-item">
                            <div class="detail-label">Company Name</div>
                            <div class="detail-value">{{ $customer->company }}</div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Acronym</div>
                            <div class="detail-value">{{ $customer->company_nickname ?: '-' }}</div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Email</div>
                            <div class="detail-value"><a href="mailto:{{ $customer->email }}">{{ $customer->email }}</a></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Mobile</div>
                            <div class="detail-value">{{ $customer->mobile }}</div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Secondary Mobile</div>
                            <div class="detail-value">{{ $customer->secondary_mobile ?: '-' }}</div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Company Type</div>
                            <div class="detail-value">{{ $customer->company_type }}</div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">GST No</div>
                            <div class="detail-value"><code>{{ $customer->gstno }}</code></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">PAN No</div>
                            <div class="detail-value"><code>{{ $customer->panno }}</code></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">MSME/Udyam</div>
                            <div class="detail-value">{{ $customer->msmeno ?: '-' }}</div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">IEC</div>
                            <div class="detail-value">{{ $customer->iecno ?: '-' }}</div>
                        </div>
                        <div class="detail-item-full">
                            <div class="detail-label">Website</div>
                            <div class="detail-value">
                                @if ($customer->url)
                                    <a href="{{ $customer->url }}" target="_blank">{{ $customer->url }} <i class="fas fa-external-link-alt fa-xs"></i></a>
                                @else
                                    -
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bank Details Card -->
        <div class="col-lg-6">
            <div class="card detail-card">
                <div class="card-header bg-info-gradient">
                    <i class="fas fa-university"></i> Bank Account Details
                </div>
                <div class="card-body">
                    @if($customer->bank_name)
                        <div class="detail-grid">
                            <div class="detail-item">
                                <div class="detail-label">Bank Name</div>
                                <div class="detail-value">{{ $customer->bank_name }}</div>
                            </div>
                            <div class="detail-item">
                                <div class="detail-label">Branch</div>
                                <div class="detail-value">{{ $customer->branch_name ?: '-' }}</div>
                            </div>
                            <div class="detail-item">
                                <div class="detail-label">Account Number</div>
                                <div class="detail-value"><code>{{ $customer->account_number }}</code></div>
                            </div>
                            <div class="detail-item">
                                <div class="detail-label">Account Type</div>
                                <div class="detail-value">{{ $customer->account_type ?: '-' }}</div>
                            </div>
                            <div class="detail-item">
                                <div class="detail-label">Account Holder</div>
                                <div class="detail-value">{{ $customer->account_holder_name ?: '-' }}</div>
                            </div>
                            <div class="detail-item">
                                <div class="detail-label">Currency</div>
                                <div class="detail-value">{{ $customer->account_currency ?? 'INR' }}</div>
                            </div>
                            <div class="detail-item">
                                <div class="detail-label">IFSC Code</div>
                                <div class="detail-value"><code>{{ $customer->ifsc_code ?: '-' }}</code></div>
                            </div>
                            <div class="detail-item">
                                <div class="detail-label">SWIFT/BIC</div>
                                <div class="detail-value">{{ $customer->swift_code ?: '-' }}</div>
                            </div>
                        </div>
                    @else
                        <div class="empty-state">
                            <i class="fas fa-university"></i>
                            <p>No bank details available</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Address Section -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card detail-card">
                <div class="card-header bg-warning-gradient">
                    <i class="fas fa-file-invoice"></i> Billing Address
                </div>
                <div class="card-body">
                    @if($customer->billing_address)
                        <div class="address-content">{{ $customer->billing_address }}</div>
                    @else
                        <div class="no-data"><i class="fas fa-info-circle mr-1"></i>No billing address provided</div>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card detail-card">
                <div class="card-header bg-danger-gradient">
                    <i class="fas fa-shipping-fast"></i> Shipping Address
                </div>
                <div class="card-body">
                    @if($customer->shipping_address)
                        <div class="address-content">{{ $customer->shipping_address }}</div>
                    @else
                        <div class="no-data"><i class="fas fa-info-circle mr-1"></i>No shipping address provided</div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Contact Persons Section -->
    <div class="card detail-card">
        <div class="card-header bg-secondary-gradient">
            <i class="fas fa-users"></i> Contact Persons
            @if ($customer->contactPersons->count())
                <span class="badge badge-light ml-2" style="font-size: 0.7rem;">{{ $customer->contactPersons->count() }}</span>
            @endif
        </div>
        <div class="card-body">
            @if ($customer->contactPersons->count())
                <div class="row">
                    @foreach ($customer->contactPersons as $contact)
                        <div class="col-lg-4 col-md-6 mb-2">
                            <div class="contact-card">
                                <div class="d-flex align-items-center mb-2">
                                    <div class="contact-avatar mr-2">
                                        {{ strtoupper(substr($contact->name ?? 'C', 0, 1)) }}
                                    </div>
                                    <div>
                                        <div class="contact-name">{{ $contact->name ?: '-' }}</div>
                                        <div class="contact-designation">{{ $contact->designation ?: 'Contact Person' }}</div>
                                    </div>
                                </div>
                                <div class="contact-info">
                                    @if($contact->email)
                                        <div class="mb-1">
                                            <i class="fas fa-envelope"></i>
                                            <a href="mailto:{{ $contact->email }}">{{ $contact->email }}</a>
                                        </div>
                                    @endif
                                    @if($contact->mobile)
                                        <div>
                                            <i class="fas fa-phone"></i>
                                            {{ $contact->mobile }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="empty-state">
                    <i class="fas fa-users"></i>
                    <p>No contact persons available</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Footer Actions -->
    <div class="footer-actions">
        <a href="{{ route('superadmin.customer.customerlist') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left mr-1"></i> Back to List
        </a>
        <a href="{{ route('superadmin.customer.edit', $customer->id) }}" class="btn btn-primary">
            <i class="fas fa-edit mr-1"></i> Edit Customer
        </a>
    </div>

</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        document.getElementById('day').textContent = days[now.getDay()];
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = months[now.getMonth()];
        document.getElementById('year').textContent = now.getFullYear();

        const timeStr = now.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        document.querySelector('.display-time').textContent = timeStr;
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);
});
</script>
@endsection
