@extends('layouts.dashboard.superadminapp')

@section('title', 'Customer/Vendor List')

@section('styles')
<style>
    /* Compact Page Header */
    .page-header {
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%);
        border-radius: 8px;
        padding: 0.5rem 1rem;
        margin-bottom: 0.75rem;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.04);
    }
    .page-header h1 {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin: 0;
    }

    /* DateTime Display */
    .datetime-display { gap: 0.5rem; }
    .date-box, .time-box {
        display: flex;
        align-items: center;
        gap: 0.35rem;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 0.35rem 0.65rem;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
        font-size: 0.75rem;
        color: #475569;
        font-weight: 500;
    }
    .date-box i, .time-box i { color: #4e73df; font-size: 0.7rem; }
    .time-box {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        border: none;
        min-width: 85px;
        justify-content: center;
    }
    .time-box i { color: rgba(255,255,255,0.8); }
    .time-box .display-time {
        font-family: 'Courier New', monospace;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    /* Compact KPI Cards */
    .kpi-card {
        border-radius: 8px;
        color: #fff;
        position: relative;
        overflow: hidden;
        padding: 0.75rem 1rem !important;
    }
    .kpi-card .kpi-icon {
        font-size: 2rem;
        opacity: 0.25;
        position: absolute;
        right: 0.75rem;
        top: 50%;
        transform: translateY(-50%);
    }
    .kpi-card .kpi-value {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.1rem;
        line-height: 1.2;
    }
    .kpi-card .kpi-label {
        font-size: 0.7rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        opacity: 0.9;
    }
    .kpi-card .kpi-info {
        font-size: 0.65rem;
        margin-top: 0.25rem;
        opacity: 0.8;
    }

    /* Gradient backgrounds */
    .bg-gradient-primary { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-gradient-success { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-gradient-info { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); }
    .bg-gradient-warning { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }

    /* Compact Cards */
    .compact-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        margin-bottom: 0.75rem;
    }
    .compact-card .card-header {
        background: transparent;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 0.6rem 1rem;
    }
    .compact-card .card-body { padding: 1rem; }

    /* Enhanced DataTable Styling */
    .datatable-card .card-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        border-radius: 8px 8px 0 0;
        padding: 0.6rem 1rem;
    }
    .datatable-card .card-header h6 {
        color: #fff;
        font-size: 0.85rem;
        margin: 0;
    }

    /* DataTable Container - Top Controls */
    #customerTable_wrapper > .row:first-child {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        padding: 1rem 1.25rem;
        margin: 0 !important;
        border-bottom: 2px solid #e3e6f0;
        display: flex;
        align-items: center;
        justify-content: space-between;
        border-radius: 0;
    }

    /* DataTable Container - Bottom Controls */
    #customerTable_wrapper .row.bottom-controls {
        background: linear-gradient(135deg, #f8f9fc 0%, #eef1f8 100%);
        padding: 1rem 1.25rem;
        margin: 0 !important;
        border-top: 2px solid #e3e6f0;
        display: flex !important;
        flex-direction: row !important;
        flex-wrap: nowrap !important;
        align-items: center !important;
        justify-content: space-between !important;
    }
    #customerTable_wrapper .row.bottom-controls > div {
        padding: 0 0.5rem !important;
    }
    #customerTable_wrapper .row.bottom-controls > div:first-child {
        display: flex;
        align-items: center;
    }
    #customerTable_wrapper .row.bottom-controls > div:last-child {
        display: flex;
        align-items: center;
        justify-content: flex-end;
    }

    /* Enhanced Length Menu */
    #customerTable_wrapper .dataTables_length {
        display: flex;
        align-items: center;
    }
    #customerTable_wrapper .dataTables_length label {
        display: flex;
        align-items: center;
        gap: 0.6rem;
        font-size: 0.85rem;
        color: #5a5c69;
        margin-bottom: 0;
        font-weight: 500;
    }
    #customerTable_wrapper .dataTables_length select {
        border: 2px solid #d1d9e6 !important;
        border-radius: 10px !important;
        padding: 0.6rem 2.2rem 0.6rem 1rem !important;
        font-size: 0.85rem !important;
        font-weight: 600 !important;
        color: #4e73df !important;
        background: #fff url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%234e73df' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14L2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E") no-repeat right 0.85rem center !important;
        background-size: 10px !important;
        appearance: none !important;
        -webkit-appearance: none !important;
        -moz-appearance: none !important;
        cursor: pointer;
        transition: all 0.2s ease;
        min-width: 75px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06);
    }
    #customerTable_wrapper .dataTables_length select:hover {
        border-color: #4e73df !important;
        background-color: #f8f9ff !important;
    }
    #customerTable_wrapper .dataTables_length select:focus {
        border-color: #4e73df !important;
        box-shadow: 0 0 0 4px rgba(78, 115, 223, 0.15) !important;
        outline: none !important;
    }

    /* Enhanced Search Box */
    #customerTable_wrapper .dataTables_filter {
        display: flex;
        align-items: center;
        position: relative;
    }
    #customerTable_wrapper .dataTables_filter label {
        display: flex;
        align-items: center;
        gap: 0;
        font-size: 0;
        color: transparent;
        margin-bottom: 0;
        position: relative;
    }
    #customerTable_wrapper .dataTables_filter input[type="search"] {
        border: 2px solid #d1d9e6 !important;
        border-radius: 10px !important;
        padding: 0.6rem 1rem 0.6rem 2.5rem !important;
        font-size: 0.85rem !important;
        min-width: 280px;
        transition: all 0.2s ease;
        background: #fff url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E") no-repeat left 0.85rem center !important;
        background-size: 15px !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06);
        margin-left: 0 !important;
    }
    #customerTable_wrapper .dataTables_filter input[type="search"]:hover {
        border-color: #b8c2cc !important;
        background-color: #fafbfc;
    }
    #customerTable_wrapper .dataTables_filter input[type="search"]:focus {
        border-color: #4e73df !important;
        box-shadow: 0 0 0 4px rgba(78, 115, 223, 0.15) !important;
        outline: none !important;
        background-color: #fff;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%234e73df' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E") !important;
    }

    /* Enhanced Info Text */
    #customerTable_wrapper .dataTables_info {
        font-size: 0.8rem !important;
        color: #5a6169 !important;
        padding: 0.5rem 1rem !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%) !important;
        border-radius: 10px !important;
        border: 2px solid #e3e8f0 !important;
        font-weight: 600 !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.04);
    }

    /* Enhanced Pagination */
    #customerTable_wrapper .dataTables_paginate {
        display: flex !important;
        align-items: center !important;
        gap: 0.35rem !important;
    }
    #customerTable_wrapper .dataTables_paginate .paginate_button {
        padding: 0.5rem 0.85rem !important;
        margin: 0 !important;
        border-radius: 10px !important;
        border: 2px solid #e3e8f0 !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9fc 100%) !important;
        color: #5a5c69 !important;
        font-size: 0.8rem !important;
        font-weight: 600 !important;
        transition: all 0.2s ease !important;
        cursor: pointer !important;
        min-width: 40px !important;
        text-align: center !important;
        box-shadow: 0 2px 6px rgba(0,0,0,0.06) !important;
        line-height: 1.2 !important;
    }
    #customerTable_wrapper .dataTables_paginate .paginate_button:hover:not(.disabled):not(.current) {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%) !important;
        border-color: #4e73df !important;
        color: #fff !important;
        transform: translateY(-2px) !important;
        box-shadow: 0 6px 15px rgba(78, 115, 223, 0.4) !important;
    }
    #customerTable_wrapper .dataTables_paginate .paginate_button.current,
    #customerTable_wrapper .dataTables_paginate .paginate_button.current:hover {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%) !important;
        border-color: #4e73df !important;
        color: #fff !important;
        box-shadow: 0 6px 15px rgba(78, 115, 223, 0.4) !important;
        transform: translateY(-1px) !important;
    }
    #customerTable_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5 !important;
        cursor: not-allowed !important;
        background: #f1f3f8 !important;
        color: #adb5bd !important;
        box-shadow: none !important;
        border-color: #e3e8f0 !important;
        transform: none !important;
    }
    #customerTable_wrapper .dataTables_paginate .paginate_button.previous,
    #customerTable_wrapper .dataTables_paginate .paginate_button.next {
        background: linear-gradient(135deg, #f0f3f8 0%, #e8ecf4 100%) !important;
        border: 2px solid #d1d9e6 !important;
        font-weight: 700 !important;
    }

    /* Table Styling */
    #customerTable {
        border-collapse: separate;
        border-spacing: 0;
        width: 100% !important;
    }
    #customerTable thead th {
        background: linear-gradient(135deg, #f8f9fc 0%, #eaecf4 100%);
        border: none;
        border-bottom: 2px solid #e3e6f0;
        padding: 0.85rem 0.75rem;
        font-size: 0.75rem;
        font-weight: 700;
        color: #4e73df;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        position: relative;
        cursor: pointer;
        transition: all 0.2s ease;
        white-space: nowrap;
    }
    #customerTable thead th:hover {
        background: linear-gradient(135deg, #eef1f8 0%, #e3e8f4 100%);
        color: #224abe;
    }

    /* Enhanced Sort Indicators */
    #customerTable thead th.sorting::after,
    #customerTable thead th.sorting_asc::after,
    #customerTable thead th.sorting_desc::after {
        display: flex !important;
        position: absolute;
        right: 0.6rem;
        top: 50%;
        transform: translateY(-50%);
        width: 20px;
        height: 20px;
        align-items: center;
        justify-content: center;
        border-radius: 4px;
        font-family: 'Font Awesome 5 Free';
        font-weight: 900;
        font-size: 0.65rem;
        transition: all 0.2s ease;
    }
    #customerTable thead th.sorting::after {
        content: '\f0dc' !important;
        color: #b8c2d0;
        background: transparent;
    }
    #customerTable thead th.sorting_asc::after {
        content: '\f0de' !important;
        color: #fff;
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        box-shadow: 0 2px 6px rgba(28, 200, 138, 0.4);
    }
    #customerTable thead th.sorting_desc::after {
        content: '\f0dd' !important;
        color: #fff;
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        box-shadow: 0 2px 6px rgba(231, 74, 59, 0.4);
    }
    #customerTable thead th.sorting_asc {
        background: linear-gradient(135deg, #e8f8f0 0%, #d4f0e4 100%) !important;
        border-bottom-color: #1cc88a !important;
    }
    #customerTable thead th.sorting_desc {
        background: linear-gradient(135deg, #fef0ee 0%, #fce4e1 100%) !important;
        border-bottom-color: #e74a3b !important;
    }

    #customerTable tbody td {
        padding: 0.7rem 0.75rem;
        font-size: 0.8rem;
        border: none;
        border-bottom: 1px solid #e9ecef;
        vertical-align: middle;
    }
    #customerTable tbody tr {
        transition: all 0.15s ease;
    }
    #customerTable tbody tr:hover {
        background-color: #f0f4ff !important;
        transform: scale(1.002);
        box-shadow: 0 2px 8px rgba(78, 115, 223, 0.1);
    }
    #customerTable tbody tr:nth-child(even) {
        background-color: #fafbfc;
    }

    /* Action Buttons */
    .action-btn {
        width: 30px;
        height: 30px;
        padding: 0;
        border-radius: 6px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
        transition: all 0.2s;
        border: none;
        margin: 0 2px;
    }
    .action-btn:hover { transform: scale(1.1); }
    .action-btn.view-btn { background: #e3f2fd; color: #1565c0; }
    .action-btn.view-btn:hover { background: #36b9cc; color: #fff; }
    .action-btn.edit-btn { background: #fff3cd; color: #856404; }
    .action-btn.edit-btn:hover { background: #f6c23e; color: #fff; }
    .action-btn.delete-btn { background: #ffebee; color: #c62828; }
    .action-btn.delete-btn:hover { background: #e74a3b; color: #fff; }

    /* Add Button */
    .add-btn {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        border: none;
        padding: 0.4rem 1rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 600;
        color: #fff;
        transition: all 0.2s;
    }
    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(28, 200, 138, 0.3);
        color: #fff;
    }
    .import-btn {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        border: none;
        padding: 0.4rem 1rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 600;
        color: #fff;
        transition: all 0.2s;
    }
    .import-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(54, 185, 204, 0.3);
        color: #fff;
    }

    /* Quick Actions */
    .quick-link-card {
        background: #fff;
        border-radius: 8px;
        padding: 0.75rem;
        text-align: center;
        transition: all 0.2s;
        border: 1px solid rgba(0, 0, 0, 0.05);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
    }
    .quick-link-card:hover {
        border-color: #4e73df;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(78, 115, 223, 0.15);
    }
    .quick-link-card i { font-size: 1.25rem; margin-bottom: 0.25rem; }
    .quick-link-card .link-title { font-weight: 600; color: #333; font-size: 0.7rem; }

    /* Enhanced Modal Styling */
    .modal-content {
        border: none;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }
    .modal-header.primary-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    .modal-header.success-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    .modal-header.danger-header {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
        padding: 0.6rem 1rem !important;
        border-bottom: 2px solid rgba(255,255,255,0.2) !important;
    }
    .modal-header .close {
        opacity: 1;
        text-shadow: none;
        padding: 0;
        margin: 0;
        width: 26px;
        height: 26px;
        border-radius: 50%;
        background: rgba(255,255,255,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 1.2rem;
        line-height: 1;
        transition: all 0.2s;
    }
    .modal-header .close:hover {
        background: rgba(255,255,255,0.35);
        transform: rotate(90deg);
    }
    .modal-title {
        font-size: 0.9rem;
        font-weight: 600;
        color: #fff !important;
    }
    .modal-body { padding: 1rem !important; background: #fff; }
    .modal-footer {
        background: #f8f9fc;
        border-top: 1px solid #e3e6f0;
        padding: 0.6rem 1rem;
        display: flex;
        justify-content: center;
        gap: 0.5rem;
    }
    .modal-footer .btn {
        border-radius: 5px;
        padding: 0.45rem 1rem;
        font-weight: 600;
        font-size: 0.8rem;
        min-width: 95px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.3rem;
        height: 34px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        transition: all 0.2s;
    }
    .modal-footer .btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 3px 8px rgba(0,0,0,0.15);
    }
    .modal-footer .btn-secondary {
        background: linear-gradient(135deg, #6c757d 0%, #545b62 100%);
        border: none;
        color: #fff;
    }
    .modal-footer .btn-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        border: none;
        color: #fff;
    }
    .modal-footer .btn-success {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        border: none;
        color: #fff;
    }

    /* Delete Modal Enhancement */
    .delete-modal-icon {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background: linear-gradient(135deg, #fff5f5 0%, #fee8e7 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 0.6rem;
        border: 2px solid #f8d7da;
    }
    .delete-modal-icon i {
        font-size: 1.3rem;
        color: #e74a3b;
    }
    .delete-item-name {
        background: #f8f9fc;
        padding: 0.4rem 0.8rem;
        border-radius: 5px;
        border: 1px dashed #d1d3e2;
        display: inline-block;
        font-size: 0.85rem;
    }

    /* Badge Styling */
    .role-badge {
        padding: 0.35rem 0.65rem;
        border-radius: 20px;
        font-size: 0.7rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }
    .role-badge.customer { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); color: #fff; }
    .role-badge.vendor { background: linear-gradient(135deg, #36b9cc 0%, #258391 100%); color: #fff; }
    .role-badge.both { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); color: #fff; }

    .status-badge {
        padding: 0.3rem 0.6rem;
        border-radius: 20px;
        font-size: 0.68rem;
        font-weight: 600;
    }
    .status-badge.active { background: #d4edda; color: #155724; }
    .status-badge.inactive { background: #e2e3e5; color: #6c757d; }

    /* Status Dot Indicator */
    .status-dot {
        font-size: 0.5rem;
        vertical-align: middle;
    }
    .status-dot.active { color: #1cc88a; }
    .status-dot.inactive { color: #e74a3b; }

    /* Enhanced Toast Notification */
    .custom-toast {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 280px;
        max-width: 350px;
        border-radius: 8px;
        box-shadow: 0 8px 24px rgba(0,0,0,0.2);
        border: none;
        animation: slideInRight 0.3s ease;
    }
    @keyframes slideInRight {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    .custom-toast .toast-body {
        padding: 0.65rem 1rem;
        font-size: 0.85rem;
        font-weight: 500;
        display: flex;
        align-items: center;
    }
    .custom-toast.bg-success {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%) !important;
    }
    .custom-toast.bg-danger {
        background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%) !important;
    }

    /* Responsive */
    @media (max-width: 992px) {
        #customerTable_wrapper > .row:first-child {
            flex-direction: column;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
        }
        #customerTable_wrapper .dataTables_filter input[type="search"] {
            min-width: 100% !important;
            width: 100% !important;
        }
    }
    @media (max-width: 768px) {
        .kpi-card .kpi-value { font-size: 1.25rem; }
        .page-header { flex-direction: column; gap: 0.5rem; }
    }
    @media (max-width: 576px) {
        #customerTable_wrapper .row.bottom-controls {
            flex-direction: column !important;
            gap: 0.75rem;
        }
        #customerTable_wrapper .row.bottom-controls > div {
            width: 100% !important;
            justify-content: center !important;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex align-items-center justify-content-between flex-wrap">
        <h1><i class="fas fa-users mr-2 text-primary"></i>UEPL | Customer & Vendor List</h1>
        <div class="datetime-display d-flex align-items-center">
            <div class="date-box">
                <i class="far fa-calendar-alt"></i>
                <span id="day">{{ now()->format('l') }}</span>,
                <span id="daynum">{{ now()->format('d') }}</span>
                <span id="month">{{ now()->format('F') }}</span>
                <span id="year">{{ now()->format('Y') }}</span>
            </div>
            <div class="time-box">
                <i class="far fa-clock"></i>
                <span class="display-time"></span>
            </div>
        </div>
    </div>

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('errorRows'))
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <strong><i class="fas fa-exclamation-triangle mr-2"></i>Import Errors:</strong>
            <ul class="mb-0 mt-2">
                @foreach (session('errorRows') as $errorRow)
                    <li>{{ $errorRow }}</li>
                @endforeach
            </ul>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- KPI Cards Row -->
    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-primary shadow">
                <i class="fas fa-building kpi-icon"></i>
                <div class="kpi-value">{{ $customers->count() }}</div>
                <div class="kpi-label">Total Records</div>
                <div class="kpi-info"><i class="fas fa-database mr-1"></i> All entries</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-success shadow">
                <i class="fas fa-users kpi-icon"></i>
                <div class="kpi-value">{{ $customers->where('company_role', 'Customer')->count() }}</div>
                <div class="kpi-label">Customers</div>
                <div class="kpi-info"><i class="fas fa-user-check mr-1"></i> Active customers</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-info shadow">
                <i class="fas fa-truck kpi-icon"></i>
                <div class="kpi-value">{{ $customers->where('company_role', 'Vendor')->count() }}</div>
                <div class="kpi-label">Vendors</div>
                <div class="kpi-info"><i class="fas fa-boxes mr-1"></i> Suppliers</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-2">
            <div class="kpi-card bg-gradient-warning shadow">
                <i class="fas fa-handshake kpi-icon"></i>
                <div class="kpi-value">{{ $customers->where('company_role', 'Both')->count() }}</div>
                <div class="kpi-label">Both</div>
                <div class="kpi-info"><i class="fas fa-exchange-alt mr-1"></i> Customer & Vendor</div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="compact-card card shadow mb-3">
        <div class="card-header d-flex align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-info" style="font-size: 0.85rem;">
                <i class="fas fa-bolt mr-2"></i>Quick Actions
            </h6>
        </div>
        <div class="card-body py-2">
            <div class="row">
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.customer.addcustomer') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-user-plus text-success"></i>
                            <div class="link-title">Add New</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="javascript:void(0)" class="text-decoration-none" data-toggle="modal" data-target="#bulkImportModal">
                        <div class="quick-link-card">
                            <i class="fas fa-upload text-info"></i>
                            <div class="link-title">Bulk Import</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.companytype.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-building text-primary"></i>
                            <div class="link-title">Company Types</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.accounttype.index') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-file-invoice text-warning"></i>
                            <div class="link-title">Account Types</div>
                        </div>
                    </a>
                </div>
                <div class="col-xl-2 col-md-4 col-6 mb-2">
                    <a href="{{ route('superadmin.dashboard.dashboard') }}" class="text-decoration-none">
                        <div class="quick-link-card">
                            <i class="fas fa-tachometer-alt text-secondary"></i>
                            <div class="link-title">Dashboard</div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- DataTable Card -->
    <div class="compact-card card datatable-card shadow">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-table mr-2"></i> Customer & Vendor Directory
            </h6>
            <div class="d-flex gap-2">
                <button class="import-btn mr-2" data-toggle="modal" data-target="#bulkImportModal" title="Bulk Import">
                    <i class="fas fa-upload mr-1"></i> Import
                </button>
                <a href="{{ route('superadmin.customer.addcustomer') }}" class="add-btn" title="Add New">
                    <i class="fas fa-plus mr-1"></i> Add New
                </a>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0" id="customerTable">
                    <thead>
                        <tr class="text-center">
                            <th width="5%">#</th>
                            <th width="8%">Role</th>
                            <th width="28%">Company</th>
                            <th width="20%">Contact</th>
                            <th width="12%">Type</th>
                            <th width="14%">GST</th>
                            <th width="13%">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($customers as $index => $customer)
                            <tr id="row-{{ $customer->id }}" class="text-center align-middle">
                                <td class="font-weight-bold text-muted">{{ $index + 1 }}</td>
                                <td>
                                    @if($customer->company_role == 'Customer')
                                        <span class="role-badge customer">Customer</span>
                                    @elseif($customer->company_role == 'Vendor')
                                        <span class="role-badge vendor">Vendor</span>
                                    @else
                                        <span class="role-badge both">Both</span>
                                    @endif
                                </td>
                                <td class="text-left">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-building text-primary mr-2"></i>
                                        <div>
                                            <strong title="{{ $customer->company }}">{{ Str::limit($customer->company, 25) }}</strong>
                                            @if ($customer->status == 1)
                                                <span class="status-dot active ml-2" title="Active"><i class="fas fa-circle"></i></span>
                                            @else
                                                <span class="status-dot inactive ml-2" title="Inactive"><i class="fas fa-circle"></i></span>
                                            @endif
                                            @if($customer->company_nickname)
                                                <br><small class="text-muted">{{ $customer->company_nickname }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td class="text-left">
                                    <small>
                                        <i class="fas fa-envelope text-muted mr-1"></i>{{ Str::limit($customer->email, 20) }}<br>
                                        <i class="fas fa-phone text-muted mr-1"></i><span class="text-muted">{{ $customer->mobile }}</span>
                                    </small>
                                </td>
                                <td><small class="font-weight-500">{{ $customer->company_type }}</small></td>
                                <td><small class="font-weight-500">{{ $customer->gstno }}</small></td>
                                <td>
                                    <a href="{{ route('superadmin.customer.show', $customer->id) }}"
                                       class="action-btn view-btn" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a href="{{ route('superadmin.customer.edit', $customer->id) }}"
                                       class="action-btn edit-btn" title="Edit">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    <button class="action-btn delete-btn deleteBtn"
                                            data-id="{{ $customer->id }}"
                                            data-name="{{ $customer->company }}"
                                            title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- Bulk Import Modal -->
<div class="modal fade" id="bulkImportModal" tabindex="-1" aria-labelledby="bulkImportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="{{ route('superadmin.customer.import') }}" enctype="multipart/form-data" id="importForm">
            @csrf
            <div class="modal-content">
                <div class="modal-header success-header">
                    <h6 class="modal-title mb-0">
                        <i class="fas fa-upload mr-2"></i>Bulk Upload Customers/Vendors
                    </h6>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="excel_file" class="small font-weight-bold">
                            <i class="fas fa-file-excel text-success mr-1"></i>Upload Excel File (.xlsx)
                        </label>
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="excel_file" name="excel_file" accept=".xlsx" required>
                            <label class="custom-file-label" for="excel_file">Choose file...</label>
                        </div>
                    </div>
                    <div class="alert alert-info py-2 mb-0" style="border-radius: 6px; border: none; background: linear-gradient(135deg, #e8f4f8 0%, #d1ecf1 100%);">
                        <small>
                            <i class="fas fa-info-circle mr-1"></i>
                            <strong>Note:</strong> Only XLSX format allowed.
                            <a href="{{ asset('templates/customer_vendor_import_template.xlsx') }}" download class="alert-link">
                                <i class="fas fa-download"></i> Download Template
                            </a>
                        </small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-success" id="importBtn">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        <i class="fas fa-upload btn-icon"></i>
                        <span class="btn-text">Import</span>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header danger-header">
                <h6 class="modal-title mb-0">
                    <i class="fas fa-exclamation-triangle mr-2"></i>Confirm Delete
                </h6>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <div class="delete-modal-icon">
                    <i class="fas fa-building"></i>
                </div>
                <p class="text-dark mb-2">Are you sure you want to delete?</p>
                <div class="delete-item-name">
                    <i class="fas fa-building mr-1 text-muted"></i>
                    <span class="font-weight-bold" id="deleteItemName"></span>
                </div>
                <p class="text-muted mt-2 mb-0"><small><i class="fas fa-exclamation-circle mr-1"></i>This action cannot be undone. All related contact persons will also be deleted.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i> Cancel
                </button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                    <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                    <i class="fas fa-trash-alt btn-icon"></i>
                    <span class="btn-text">Delete</span>
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Dynamic Date/Time
    function updateDateTime() {
        const now = new Date();
        const days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

        document.getElementById('day').textContent = days[now.getDay()];
        document.getElementById('daynum').textContent = now.getDate();
        document.getElementById('month').textContent = months[now.getMonth()];
        document.getElementById('year').textContent = now.getFullYear();

        const timeStr = now.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        document.querySelector('.display-time').textContent = timeStr;
    }
    updateDateTime();
    setInterval(updateDateTime, 1000);

    // Initialize DataTable
    var table = $('#customerTable').DataTable({
        pageLength: 10,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
        order: [[0, 'asc']],
        columnDefs: [
            { orderable: false, targets: [6] },
            { className: 'align-middle', targets: '_all' }
        ],
        language: {
            search: '',
            searchPlaceholder: 'Search customers/vendors...',
            lengthMenu: 'Show _MENU_',
            info: 'Showing _START_ to _END_ of _TOTAL_',
            infoEmpty: 'No entries found',
            infoFiltered: '(filtered from _MAX_)',
            paginate: {
                first: '<i class="fas fa-angle-double-left"></i>',
                last: '<i class="fas fa-angle-double-right"></i>',
                next: '<i class="fas fa-chevron-right"></i>',
                previous: '<i class="fas fa-chevron-left"></i>'
            },
            emptyTable: '<div class="text-center py-4"><i class="fas fa-users fa-3x text-muted mb-3"></i><p class="text-muted">No customers/vendors found</p></div>'
        },
        dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rt<"row bottom-controls"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7 d-flex justify-content-end"p>>'
    });

    // Custom file input label update
    $('.custom-file-input').on('change', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName || 'Choose file...');
    });

    // Import form submit
    $('#importForm').on('submit', function() {
        var $btn = $('#importBtn');
        $btn.prop('disabled', true);
        $btn.find('.spinner-border').removeClass('d-none');
        $btn.find('.btn-icon').addClass('d-none');
        $btn.find('.btn-text').text('Importing...');
    });

    // Delete button click - show confirmation modal
    var deleteId = null;
    $(document).on('click', '.deleteBtn', function() {
        deleteId = $(this).data('id');
        $('#deleteItemName').text($(this).data('name'));
        $('#deleteModal').modal('show');
    });

    // Confirm delete
    $('#confirmDeleteBtn').on('click', function() {
        if (!deleteId) return;

        var $btn = $(this);
        var $spinner = $btn.find('.spinner-border');
        var $text = $btn.find('.btn-text');
        var $icon = $btn.find('.btn-icon');

        $btn.prop('disabled', true);
        $spinner.removeClass('d-none');
        $icon.addClass('d-none');
        $text.text('Deleting...');

        $.ajax({
            url: '{{ url("superadmin/customers") }}/' + deleteId,
            type: 'DELETE',
            data: { '_token': '{{ csrf_token() }}' },
            success: function(response) {
                $('#deleteModal').modal('hide');
                table.row('#row-' + deleteId).remove().draw(false);
                showToast('success', response.message || 'Customer/Vendor deleted successfully!');
                // Update KPI cards would require page reload
                setTimeout(function() {
                    location.reload();
                }, 1500);
            },
            error: function(xhr) {
                showToast('error', xhr.responseJSON?.message || 'Could not delete customer/vendor.');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.addClass('d-none');
                $icon.removeClass('d-none');
                $text.text('Delete');
                deleteId = null;
            }
        });
    });

    // Toast notification helper
    function showToast(type, message) {
        $('.custom-toast').remove();

        var bgClass = type === 'success' ? 'bg-success' : 'bg-danger';
        var icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';

        var toastHtml = `
            <div class="toast custom-toast ${bgClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3500">
                <div class="toast-body">
                    <i class="fas ${icon} mr-2"></i>
                    <span class="flex-grow-1">${message}</span>
                    <button type="button" class="close ml-2 text-white" data-dismiss="toast" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        `;

        var $toast = $(toastHtml);
        $('body').append($toast);
        $toast.toast('show');

        $toast.on('hidden.bs.toast', function() {
            $(this).remove();
        });
    }
});
</script>
@endsection
