@extends('layouts.dashboard.superadminapp')

@section('title', 'Profit & Loss - ' . $fy['label'])

@section('styles')
<style>
    .report-header {
        background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        color: #fff;
        padding: 20px;
        border-radius: 10px;
        text-align: center;
        margin-bottom: 20px;
    }
    .stat-card { border-radius: 10px; padding: 15px; text-align: center; color: #fff; }
    .bg-revenue { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-expense { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .bg-profit { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .bg-margin { background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%); }
    .total-row { background-color: #f8f9fc; font-weight: bold; }
    .profit-row { background-color: #d4edda; font-weight: bold; }
    .loss-row { background-color: #f8d7da; font-weight: bold; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Profit & Loss Statement</h1>
    <div class="d-flex gap-2">
        <form method="GET" class="d-inline-flex align-items-center">
            <select name="year" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                @foreach($years as $year)
                    <option value="{{ $year['value'] }}" {{ $fy['year'] == $year['value'] ? 'selected' : '' }}>
                        {{ $year['label'] }}
                    </option>
                @endforeach
            </select>
        </form>
        <button onclick="window.print()" class="btn btn-secondary btn-sm">
            <i class="fas fa-print mr-1"></i> Print
        </button>
    </div>
</div>

<!-- Report Header -->
<div class="report-header">
    <h4 class="mb-1">UMBREY ENGINEERING PVT LTD</h4>
    <h5 class="mb-1">Profit & Loss Statement</h5>
    <div>For the period {{ $fy['start']->format('d M Y') }} to {{ $fy['end']->format('d M Y') }}</div>
</div>

<!-- Summary Cards -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="stat-card bg-revenue">
            <div class="h4 mb-0">₹{{ number_format($data['total_revenue'], 0) }}</div>
            <div class="small">Total Revenue</div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stat-card bg-expense">
            <div class="h4 mb-0">₹{{ number_format($data['total_expenses'], 0) }}</div>
            <div class="small">Total Expenses</div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stat-card bg-profit">
            <div class="h4 mb-0">₹{{ number_format($data['net_profit'], 0) }}</div>
            <div class="small">Net {{ $data['net_profit'] >= 0 ? 'Profit' : 'Loss' }}</div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stat-card bg-margin">
            <div class="h4 mb-0">{{ number_format($data['net_margin'], 1) }}%</div>
            <div class="small">Net Margin</div>
        </div>
    </div>
</div>

<div class="row">
    <!-- P&L Statement -->
    <div class="col-lg-7 mb-4">
        <div class="card shadow">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-line mr-2"></i> Statement Details
                </h6>
            </div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <tbody>
                        <!-- Revenue -->
                        <tr class="bg-light">
                            <td colspan="2" class="font-weight-bold">REVENUE</td>
                        </tr>
                        @foreach($data['revenue'] as $item)
                            <tr>
                                <td class="pl-4">{{ $item['name'] }}</td>
                                <td class="text-right">₹{{ number_format($item['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                        <tr class="total-row text-success">
                            <td>Total Revenue</td>
                            <td class="text-right">₹{{ number_format($data['total_revenue'], 2) }}</td>
                        </tr>
                        
                        <!-- Cost of Goods -->
                        <tr class="bg-light">
                            <td colspan="2" class="font-weight-bold">COST OF GOODS SOLD</td>
                        </tr>
                        @foreach($data['cost_of_goods'] as $item)
                            <tr>
                                <td class="pl-4">{{ $item['name'] }}</td>
                                <td class="text-right">₹{{ number_format($item['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                        <tr class="total-row">
                            <td>Total COGS</td>
                            <td class="text-right">₹{{ number_format($data['total_cogs'], 2) }}</td>
                        </tr>
                        
                        <!-- Gross Profit -->
                        <tr class="{{ $data['gross_profit'] >= 0 ? 'profit-row' : 'loss-row' }}">
                            <td>Gross Profit ({{ number_format($data['gross_margin'], 1) }}%)</td>
                            <td class="text-right">₹{{ number_format($data['gross_profit'], 2) }}</td>
                        </tr>
                        
                        <!-- Expenses -->
                        <tr class="bg-light">
                            <td colspan="2" class="font-weight-bold">OPERATING EXPENSES</td>
                        </tr>
                        @foreach($data['expenses'] as $item)
                            <tr>
                                <td class="pl-4">{{ $item['name'] }}</td>
                                <td class="text-right">₹{{ number_format($item['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                        
                        <!-- Net Profit -->
                        <tr class="{{ $data['net_profit'] >= 0 ? 'profit-row' : 'loss-row' }}" style="font-size: 1.1rem;">
                            <td>Net {{ $data['net_profit'] >= 0 ? 'Profit' : 'Loss' }} ({{ number_format($data['net_margin'], 1) }}%)</td>
                            <td class="text-right">₹{{ number_format(abs($data['net_profit']), 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- Charts & Tax Summary -->
    <div class="col-lg-5 mb-4">
        <!-- Monthly Trend -->
        <div class="card shadow mb-4">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-bar mr-2"></i> Monthly Trend
                </h6>
            </div>
            <div class="card-body">
                <canvas id="monthlyChart" height="200"></canvas>
            </div>
        </div>
        
        <!-- Tax Summary -->
        <div class="card shadow">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-file-invoice-dollar mr-2"></i> GST Summary
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-sm mb-0">
                    <tr>
                        <td>GST Collected (Output)</td>
                        <td class="text-right text-success">₹{{ number_format($data['tax_summary']['collected'], 2) }}</td>
                    </tr>
                    <tr>
                        <td>GST Paid (Input)</td>
                        <td class="text-right text-danger">₹{{ number_format($data['tax_summary']['paid'], 2) }}</td>
                    </tr>
                    <tr class="font-weight-bold">
                        <td>Net GST {{ $data['tax_summary']['net_payable'] >= 0 ? 'Payable' : 'Refund' }}</td>
                        <td class="text-right">₹{{ number_format(abs($data['tax_summary']['net_payable']), 2) }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const monthlyData = @json($data['monthly']);
    
    new Chart(document.getElementById('monthlyChart'), {
        type: 'bar',
        data: {
            labels: monthlyData.map(m => m.month),
            datasets: [
                {
                    label: 'Revenue',
                    data: monthlyData.map(m => m.revenue),
                    backgroundColor: 'rgba(28, 200, 138, 0.8)',
                },
                {
                    label: 'Expense',
                    data: monthlyData.map(m => m.expense),
                    backgroundColor: 'rgba(231, 74, 59, 0.8)',
                }
            ]
        },
        options: {
            responsive: true,
            scales: {
                y: { beginAtZero: true }
            },
            plugins: {
                legend: { position: 'bottom' }
            }
        }
    });
</script>
@endsection
