@extends('layouts.dashboard.superadminapp')

@section('title', 'Cash Flow - ' . $fy['label'])

@section('styles')
<style>
    .report-header {
        background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        color: #fff;
        padding: 20px;
        border-radius: 10px;
        text-align: center;
        margin-bottom: 20px;
    }
    .stat-card { border-radius: 10px; padding: 15px; text-align: center; color: #fff; }
    .bg-inflow { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .bg-outflow { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .bg-net { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .section-header { font-weight: bold; background-color: #f8f9fc; }
    .net-row-positive { background-color: #d4edda; font-weight: bold; }
    .net-row-negative { background-color: #f8d7da; font-weight: bold; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Cash Flow Statement</h1>
    <div class="d-flex gap-2">
        <form method="GET" class="d-inline-flex align-items-center">
            <select name="year" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                @foreach($years as $year)
                    <option value="{{ $year['value'] }}" {{ $fy['year'] == $year['value'] ? 'selected' : '' }}>
                        {{ $year['label'] }}
                    </option>
                @endforeach
            </select>
        </form>
        <button onclick="window.print()" class="btn btn-secondary btn-sm">
            <i class="fas fa-print mr-1"></i> Print
        </button>
    </div>
</div>

<!-- Report Header -->
<div class="report-header">
    <h4 class="mb-1">UMBREY ENGINEERING PVT LTD</h4>
    <h5 class="mb-1">Cash Flow Statement</h5>
    <div>For the period {{ $fy['start']->format('d M Y') }} to {{ $fy['end']->format('d M Y') }}</div>
</div>

<!-- Summary Cards -->
<div class="row mb-4">
    <div class="col-md-4 mb-3">
        <div class="stat-card bg-inflow">
            <div class="h4 mb-0">₹{{ number_format(array_sum(array_column($data['operating']['inflows'], 'amount')), 0) }}</div>
            <div class="small">Cash Inflows</div>
        </div>
    </div>
    <div class="col-md-4 mb-3">
        <div class="stat-card bg-outflow">
            <div class="h4 mb-0">₹{{ number_format(array_sum(array_column($data['operating']['outflows'], 'amount')), 0) }}</div>
            <div class="small">Cash Outflows</div>
        </div>
    </div>
    <div class="col-md-4 mb-3">
        <div class="stat-card bg-net">
            <div class="h4 mb-0">₹{{ number_format($data['net_cash_flow'], 0) }}</div>
            <div class="small">Net Cash Flow</div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Cash Flow Statement -->
    <div class="col-lg-7 mb-4">
        <div class="card shadow">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-exchange-alt mr-2"></i> Cash Flow Details
                </h6>
            </div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <tbody>
                        <!-- Operating Activities -->
                        <tr class="section-header">
                            <td colspan="2"><i class="fas fa-cogs mr-2"></i>OPERATING ACTIVITIES</td>
                        </tr>
                        <tr>
                            <td class="pl-4 font-italic">Cash Inflows:</td>
                            <td></td>
                        </tr>
                        @foreach($data['operating']['inflows'] as $item)
                            <tr>
                                <td class="pl-5">{{ $item['name'] }}</td>
                                <td class="text-right text-success">₹{{ number_format($item['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                        <tr>
                            <td class="pl-4 font-italic">Cash Outflows:</td>
                            <td></td>
                        </tr>
                        @foreach($data['operating']['outflows'] as $item)
                            <tr>
                                <td class="pl-5">{{ $item['name'] }}</td>
                                <td class="text-right text-danger">(₹{{ number_format($item['amount'], 2) }})</td>
                            </tr>
                        @endforeach
                        <tr class="{{ $data['operating']['net'] >= 0 ? 'net-row-positive' : 'net-row-negative' }}">
                            <td>Net Cash from Operating Activities</td>
                            <td class="text-right">₹{{ number_format($data['operating']['net'], 2) }}</td>
                        </tr>
                        
                        <!-- Investing Activities -->
                        <tr class="section-header">
                            <td colspan="2"><i class="fas fa-chart-line mr-2"></i>INVESTING ACTIVITIES</td>
                        </tr>
                        <tr>
                            <td class="pl-4 text-muted">No investing activities recorded</td>
                            <td class="text-right">₹0.00</td>
                        </tr>
                        
                        <!-- Financing Activities -->
                        <tr class="section-header">
                            <td colspan="2"><i class="fas fa-university mr-2"></i>FINANCING ACTIVITIES</td>
                        </tr>
                        <tr>
                            <td class="pl-4 text-muted">No financing activities recorded</td>
                            <td class="text-right">₹0.00</td>
                        </tr>
                        
                        <!-- Net Cash Flow -->
                        <tr class="{{ $data['net_cash_flow'] >= 0 ? 'net-row-positive' : 'net-row-negative' }}" style="font-size: 1.1rem;">
                            <td><i class="fas fa-coins mr-2"></i>Net Change in Cash</td>
                            <td class="text-right">₹{{ number_format($data['net_cash_flow'], 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- Monthly Cash Flow Chart -->
    <div class="col-lg-5 mb-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-chart-area mr-2"></i> Monthly Cash Flow
                </h6>
            </div>
            <div class="card-body">
                <canvas id="cashFlowChart" height="200"></canvas>
            </div>
        </div>
        
        <!-- Recent Inflows -->
        <div class="card shadow">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-arrow-down mr-2"></i> Recent Payments Received
                </h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>Date</th>
                                <th>Party</th>
                                <th class="text-right">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($data['recent_inflows'] as $payment)
                                <tr>
                                    <td>{{ \Carbon\Carbon::parse($payment->payment_date)->format('d M') }}</td>
                                    <td>{{ Str::limit($payment->party->company_name ?? 'N/A', 20) }}</td>
                                    <td class="text-right text-success">₹{{ number_format($payment->payment_amount, 0) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted">No recent payments</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const monthlyData = @json($data['monthly']);
    
    new Chart(document.getElementById('cashFlowChart'), {
        type: 'line',
        data: {
            labels: monthlyData.map(m => m.month),
            datasets: [
                {
                    label: 'Inflow',
                    data: monthlyData.map(m => m.inflow),
                    borderColor: 'rgba(28, 200, 138, 1)',
                    backgroundColor: 'rgba(28, 200, 138, 0.1)',
                    fill: true,
                    tension: 0.4
                },
                {
                    label: 'Outflow',
                    data: monthlyData.map(m => m.outflow),
                    borderColor: 'rgba(231, 74, 59, 1)',
                    backgroundColor: 'rgba(231, 74, 59, 0.1)',
                    fill: true,
                    tension: 0.4
                }
            ]
        },
        options: {
            responsive: true,
            scales: {
                y: { beginAtZero: true }
            },
            plugins: {
                legend: { position: 'bottom' }
            }
        }
    });
</script>
@endsection
