@extends('layouts.dashboard.superadminapp')

@section('title', 'Balance Sheet - ' . $fy['label'])

@section('styles')
<style>
    .report-header {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: #fff;
        padding: 20px;
        border-radius: 10px;
        text-align: center;
        margin-bottom: 20px;
    }
    .section-card { border-radius: 10px; overflow: hidden; }
    .section-header-assets { background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%); }
    .section-header-liabilities { background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%); }
    .section-header-equity { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); }
    .total-row { background-color: #f8f9fc; font-weight: bold; }
    .grand-total-row { background-color: #e3e6f0; font-weight: bold; font-size: 1.1rem; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Balance Sheet</h1>
    <div class="d-flex gap-2">
        <form method="GET" class="d-inline-flex align-items-center">
            <select name="year" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                @foreach($years as $year)
                    <option value="{{ $year['value'] }}" {{ $fy['year'] == $year['value'] ? 'selected' : '' }}>
                        {{ $year['label'] }}
                    </option>
                @endforeach
            </select>
        </form>
        <button onclick="window.print()" class="btn btn-secondary btn-sm">
            <i class="fas fa-print mr-1"></i> Print
        </button>
    </div>
</div>

<!-- Report Header -->
<div class="report-header">
    <h4 class="mb-1">UMBREY ENGINEERING PVT LTD</h4>
    <h5 class="mb-1">Balance Sheet</h5>
    <div>As on {{ $fy['end']->format('d M Y') }} ({{ $fy['label'] }})</div>
</div>

<div class="row">
    <!-- ASSETS -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow section-card">
            <div class="card-header py-3 section-header-assets">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-arrow-up mr-2"></i> ASSETS
                </h6>
            </div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="thead-light">
                        <tr>
                            <th>Particulars</th>
                            <th class="text-right">Amount (₹)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td colspan="2" class="font-weight-bold bg-light">Current Assets</td>
                        </tr>
                        @foreach($data['assets']['current_assets'] as $item)
                            <tr>
                                <td class="pl-4">{{ $item['name'] }}</td>
                                <td class="text-right">{{ number_format($item['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                        <tr class="grand-total-row">
                            <td>Total Assets</td>
                            <td class="text-right text-success">₹{{ number_format($data['assets']['total'], 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- LIABILITIES & EQUITY -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow section-card mb-4">
            <div class="card-header py-3 section-header-liabilities">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-arrow-down mr-2"></i> LIABILITIES
                </h6>
            </div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="thead-light">
                        <tr>
                            <th>Particulars</th>
                            <th class="text-right">Amount (₹)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td colspan="2" class="font-weight-bold bg-light">Current Liabilities</td>
                        </tr>
                        @foreach($data['liabilities']['current_liabilities'] as $item)
                            <tr>
                                <td class="pl-4">{{ $item['name'] }}</td>
                                <td class="text-right">{{ number_format($item['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                        <tr class="total-row">
                            <td>Total Liabilities</td>
                            <td class="text-right text-danger">₹{{ number_format($data['liabilities']['total'], 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="card shadow section-card">
            <div class="card-header py-3 section-header-equity">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-balance-scale mr-2"></i> EQUITY
                </h6>
            </div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <tbody>
                        @foreach($data['equity']['items'] as $item)
                            <tr>
                                <td>{{ $item['name'] }}</td>
                                <td class="text-right">{{ number_format($item['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                        <tr class="total-row">
                            <td>Total Equity</td>
                            <td class="text-right">₹{{ number_format($data['equity']['total'], 2) }}</td>
                        </tr>
                        <tr class="grand-total-row">
                            <td>Liabilities + Equity</td>
                            <td class="text-right">₹{{ number_format($data['total_liabilities_equity'], 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Verification -->
<div class="card shadow">
    <div class="card-body text-center">
        @if(abs($data['assets']['total'] - $data['total_liabilities_equity']) < 0.01)
            <span class="text-success font-weight-bold">
                <i class="fas fa-check-circle mr-2"></i> Balance Sheet is Balanced
            </span>
        @else
            <span class="text-danger font-weight-bold">
                <i class="fas fa-exclamation-triangle mr-2"></i> 
                Difference: ₹{{ number_format(abs($data['assets']['total'] - $data['total_liabilities_equity']), 2) }}
            </span>
        @endif
    </div>
</div>

@endsection
