<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Payslip - {{ $payroll->employee->name ?? 'Employee' }} - {{ $payroll->month_year }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
        }
        .container {
            padding: 20px;
            max-width: 800px;
            margin: 0 auto;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #4e73df;
            padding-bottom: 10px;
        }
        .company-name {
            font-size: 20px;
            font-weight: bold;
            color: #4e73df;
        }
        .company-address {
            font-size: 10px;
            color: #666;
            margin-top: 5px;
        }
        .payslip-title {
            font-size: 14px;
            font-weight: bold;
            margin-top: 10px;
            background: #4e73df;
            color: white;
            padding: 5px;
        }
        .info-section {
            margin-bottom: 15px;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
        }
        .info-table td {
            padding: 5px 10px;
            border: 1px solid #ddd;
        }
        .info-table .label {
            background: #f8f9fc;
            font-weight: bold;
            width: 25%;
        }
        .earnings-deductions {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }
        .earnings, .deductions {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }
        .section-title {
            background: #4e73df;
            color: white;
            padding: 5px 10px;
            font-weight: bold;
        }
        .section-title.deduction {
            background: #e74a3b;
        }
        .amount-table {
            width: 100%;
            border-collapse: collapse;
        }
        .amount-table td, .amount-table th {
            padding: 8px 10px;
            border: 1px solid #ddd;
        }
        .amount-table .amount {
            text-align: right;
            font-family: monospace;
        }
        .total-row {
            background: #f8f9fc;
            font-weight: bold;
        }
        .net-salary {
            margin-top: 15px;
            background: #1cc88a;
            color: white;
            padding: 10px;
            text-align: center;
            font-size: 14px;
        }
        .net-salary .amount {
            font-size: 18px;
            font-weight: bold;
        }
        .words {
            font-style: italic;
            font-size: 10px;
            margin-top: 5px;
        }
        .footer {
            margin-top: 30px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .signature-section {
            margin-top: 40px;
            display: table;
            width: 100%;
        }
        .signature-box {
            display: table-cell;
            width: 33%;
            text-align: center;
        }
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 40px;
            padding-top: 5px;
        }
        .note {
            font-size: 9px;
            color: #666;
            margin-top: 20px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="company-name">UEPL - ULTRA ENGINEERING PVT LTD</div>
            <div class="company-address">
                Industrial Area, Manufacturing Hub, India | Phone: +91-XXX-XXXXXXX | Email: hr@uepl.com
            </div>
            <div class="payslip-title">
                SALARY SLIP FOR {{ strtoupper(\Carbon\Carbon::parse($payroll->month_year)->format('F Y')) }}
            </div>
        </div>

        <!-- Employee Information -->
        <div class="info-section">
            <table class="info-table">
                <tr>
                    <td class="label">Employee ID</td>
                    <td>{{ $payroll->employee->employee_id ?? '-' }}</td>
                    <td class="label">Employee Name</td>
                    <td>{{ $payroll->employee->name ?? '-' }}</td>
                </tr>
                <tr>
                    <td class="label">Department</td>
                    <td>{{ $payroll->employee->department ?? '-' }}</td>
                    <td class="label">Designation</td>
                    <td>{{ $payroll->employee->designation ?? '-' }}</td>
                </tr>
                <tr>
                    <td class="label">Bank Name</td>
                    <td>{{ $payroll->employee->bank_name ?? '-' }}</td>
                    <td class="label">Bank A/C No.</td>
                    <td>{{ $payroll->employee->bank_account_no ?? '-' }}</td>
                </tr>
                <tr>
                    <td class="label">PAN No.</td>
                    <td>{{ $payroll->employee->pan_number ?? '-' }}</td>
                    <td class="label">UAN/PF No.</td>
                    <td>{{ $payroll->employee->pf_number ?? '-' }}</td>
                </tr>
                <tr>
                    <td class="label">Days Worked</td>
                    <td>{{ $payroll->days_worked }} / {{ $payroll->total_days }}</td>
                    <td class="label">OT Hours</td>
                    <td>{{ $payroll->ot_hours ?? 0 }}</td>
                </tr>
            </table>
        </div>

        <!-- Earnings and Deductions -->
        <div class="earnings-deductions">
            <div class="earnings">
                <div class="section-title">EARNINGS</div>
                <table class="amount-table">
                    <tr>
                        <td>Basic + DA</td>
                        <td class="amount">{{ number_format($payroll->basic_da, 2) }}</td>
                    </tr>
                    <tr>
                        <td>House Rent Allowance (HRA)</td>
                        <td class="amount">{{ number_format($payroll->hra, 2) }}</td>
                    </tr>
                    <tr>
                        <td>Conveyance Allowance</td>
                        <td class="amount">{{ number_format($payroll->conveyance, 2) }}</td>
                    </tr>
                    <tr>
                        <td>Washing Allowance</td>
                        <td class="amount">{{ number_format($payroll->washing_allowance, 2) }}</td>
                    </tr>
                    @if($payroll->ot_amount > 0)
                    <tr>
                        <td>Overtime Amount</td>
                        <td class="amount">{{ number_format($payroll->ot_amount, 2) }}</td>
                    </tr>
                    @endif
                    @if($payroll->bonus > 0)
                    <tr>
                        <td>Bonus/Incentive</td>
                        <td class="amount">{{ number_format($payroll->bonus, 2) }}</td>
                    </tr>
                    @endif
                    <tr class="total-row">
                        <td><strong>Gross Earnings</strong></td>
                        <td class="amount"><strong>{{ number_format($payroll->gross_salary, 2) }}</strong></td>
                    </tr>
                </table>
            </div>
            <div class="deductions">
                <div class="section-title deduction">DEDUCTIONS</div>
                <table class="amount-table">
                    <tr>
                        <td>Provident Fund (PF)</td>
                        <td class="amount">{{ number_format($payroll->pf_deduction, 2) }}</td>
                    </tr>
                    <tr>
                        <td>ESI</td>
                        <td class="amount">{{ number_format($payroll->esi_deduction, 2) }}</td>
                    </tr>
                    <tr>
                        <td>Professional Tax (PT)</td>
                        <td class="amount">{{ number_format($payroll->pt_deduction, 2) }}</td>
                    </tr>
                    @if($payroll->other_deductions > 0)
                    <tr>
                        <td>Other Deductions</td>
                        <td class="amount">{{ number_format($payroll->other_deductions, 2) }}</td>
                    </tr>
                    @endif
                    <tr class="total-row">
                        <td><strong>Total Deductions</strong></td>
                        <td class="amount"><strong>{{ number_format($payroll->total_deductions, 2) }}</strong></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Net Salary -->
        <div class="net-salary">
            <div>NET SALARY PAYABLE</div>
            <div class="amount">&#8377; {{ number_format($payroll->net_salary, 2) }}</div>
            <div class="words">({{ numberToWords($payroll->net_salary) }} Only)</div>
        </div>

        <!-- Payment Information -->
        @if($payroll->status == 'Paid')
        <div class="info-section" style="margin-top: 15px;">
            <table class="info-table">
                <tr>
                    <td class="label">Payment Status</td>
                    <td><span style="color: #1cc88a; font-weight: bold;">PAID</span></td>
                    <td class="label">Payment Date</td>
                    <td>{{ $payroll->payment_date ? \Carbon\Carbon::parse($payroll->payment_date)->format('d-m-Y') : '-' }}</td>
                </tr>
                <tr>
                    <td class="label">Payment Mode</td>
                    <td>{{ $payroll->payment_mode ?? '-' }}</td>
                    <td class="label">Reference No.</td>
                    <td>{{ $payroll->reference_number ?? '-' }}</td>
                </tr>
            </table>
        </div>
        @endif

        <!-- Signature Section -->
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line">Prepared By</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Verified By</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Employee Signature</div>
            </div>
        </div>

        <!-- Note -->
        <div class="note">
            This is a computer-generated payslip and does not require a signature.<br>
            For any queries, please contact the HR department.
        </div>
    </div>
</body>
</html>
