@php
    // Helper function to check if current route matches any of the given patterns
    $isActiveMenu = function($patterns) {
        foreach ((array)$patterns as $pattern) {
            if (request()->routeIs($pattern) || request()->is($pattern)) {
                return true;
            }
        }
        return false;
    };

    // Define menu active states
    $dashboardActive = $isActiveMenu([
        'superadmin.dashboard.*',
        'superadmin/dashboard',
        'superadmin/employeedashboard',
        'superadmin/machinedashboard',
        'superadmin/stockdashboard',
        'superadmin/accountdashboard',
        'superadmin/manufactingdashboard'
    ]);

    $userActive = $isActiveMenu([
        'superadmin.users.*',
        'superadmin/users/*'
    ]);

    $masterActive = $isActiveMenu([
        'superadmin.companytype.*',
        'superadmin.accounttype.*',
        'superadmin.rfqtype.*',
        'superadmin.producttype.*',
        'superadmin.rawmaterial.*',
        'superadmin.conversionprocess.*',
        'superadmin.process.*',
        'superadmin.stockitems.*'
    ]);

    $crmActive = $isActiveMenu([
        'superadmin.customer.*',
        'superadmin/customer/*'
    ]);

    $salesActive = $isActiveMenu([
        'superadmin.salesbom.*',
        'superadmin.sales.*',
        'superadmin.invoice.*',
        'superadmin.salesmanagement.*',
        'superadmin/sales/*',
        'superadmin/invoice/*'
    ]);

    $purchaseActive = $isActiveMenu([
        'superadmin.purchasebom.*',
        'superadmin.purchase.*',
        'superadmin.purchaseorder.*',
        'superadmin/purchase/*'
    ]);

    $operationActive = $isActiveMenu([
        'superadmin.grn.*',
        'superadmin.routecard.*',
        'superadmin/grn/*',
        'superadmin/routecard/*'
    ]);

    $planningActive = $isActiveMenu([
        'superadmin.manufacturing.*',
        'superadmin.production.*',
        'superadmin/ready-to-production*',
        'superadmin/quality/*',
        'superadmin/manufacturing/*'
    ]);

    $skuMachinesActive = $isActiveMenu([
        'superadmin.sku.*',
        'superadmin.machine.*',
        'superadmin/skuapprovals*',
        'superadmin/sku/*',
        'superadmin/machine/*'
    ]);

    $hrmActive = $isActiveMenu([
        'superadmin.employee.*',
        'superadmin.salary-structure.*',
        'superadmin.holiday.*',
        'superadmin.leave.*',
        'superadmin.leave-balance.*',
        'superadmin.payroll.*',
        'superadmin.employeeleave',
        'superadmin.employeepayroll',
        'superadmin/employee*',
        'superadmin/employeepayroll*',
        'superadmin/employeeleave*',
        'superadmin/employeeattendance*',
        'superadmin/employeedailyreport*',
        'superadmin/salary-structure*',
        'superadmin/holiday*',
        'superadmin/leave*',
        'superadmin/payroll*'
    ]);

    $reportsActive = $isActiveMenu([
        'superadmin.report.*',
        'superadmin/report/*'
    ]);

    $activityActive = $isActiveMenu([
        'superadmin.activity.*',
        'superadmin/activity*'
    ]);

    $accountsActive = $isActiveMenu([
        'superadmin.accounts.*',
        'superadmin/accounts/*'
    ]);
@endphp

<ul class="navbar-nav sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="{{ route('superadmin.dashboard.dashboard') }}">
        <div class="sidebar-brand-icon">
            <img src="{{ asset('img/logo-sm.png') }}" alt="Logo" style="max-height: 32px;">
        </div>
        <div class="sidebar-brand-text mx-2">Indus Pro</div>
    </a>

    <hr class="sidebar-divider my-0">

    <!-- Dashboard -->
    <li class="nav-item {{ $dashboardActive ? 'active' : '' }}">
        <a class="nav-link {{ $dashboardActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseDashboard"
            aria-expanded="{{ $dashboardActive ? 'true' : 'false' }}" aria-controls="collapseDashboard">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span>
        </a>
        <div id="collapseDashboard" class="collapse {{ $dashboardActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.dashboard.dashboard') ? 'active' : '' }}" href="{{ route('superadmin.dashboard.dashboard') }}">Main Dashboard</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.dashboard.empoyeedashboard') ? 'active' : '' }}" href="{{ route('superadmin.dashboard.empoyeedashboard') }}">Employee</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.dashboard.machinedashboard') ? 'active' : '' }}" href="{{ route('superadmin.dashboard.machinedashboard') }}">Machine</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.dashboard.stockdashboard') ? 'active' : '' }}" href="{{ route('superadmin.dashboard.stockdashboard') }}">Stock</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.dashboard.accountdashboard') ? 'active' : '' }}" href="{{ route('superadmin.dashboard.accountdashboard') }}">Account</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.dashboard.manufacturingdashboard') ? 'active' : '' }}" href="{{ route('superadmin.dashboard.manufacturingdashboard') }}">Manufacturing</a>
            </div>
        </div>
    </li>

    <!-- Section: Administration -->
    <div class="sidebar-heading">Administration</div>

    <!-- User Management -->
    <li class="nav-item {{ $userActive ? 'active' : '' }}">
        <a class="nav-link {{ $userActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseUser"
            aria-expanded="{{ $userActive ? 'true' : 'false' }}" aria-controls="collapseUser">
            <i class="fas fa-fw fa-users-cog"></i>
            <span>Users</span>
        </a>
        <div id="collapseUser" class="collapse {{ $userActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.users.userdetails') ? 'active' : '' }}" href="{{ route('superadmin.users.userdetails') }}">User Details</a>
            </div>
        </div>
    </li>

    <!-- Master Management -->
    <li class="nav-item {{ $masterActive ? 'active' : '' }}">
        <a class="nav-link {{ $masterActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseMaster"
            aria-expanded="{{ $masterActive ? 'true' : 'false' }}" aria-controls="collapseMaster">
            <i class="fas fa-fw fa-database"></i>
            <span>Master Data</span>
        </a>
        <div id="collapseMaster" class="collapse {{ $masterActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.companytype.*') ? 'active' : '' }}" href="{{ route('superadmin.companytype.index') }}">Company Types</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.accounttype.*') ? 'active' : '' }}" href="{{ route('superadmin.accounttype.index') }}">Account Types</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.rfqtype.*') ? 'active' : '' }}" href="{{ route('superadmin.rfqtype.index') }}">RFQ Types</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.producttype.*') ? 'active' : '' }}" href="{{ route('superadmin.producttype.index') }}">Product Types</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.rawmaterial.*') ? 'active' : '' }}" href="{{ route('superadmin.rawmaterial.index') }}">Raw Materials</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.conversionprocess.*') ? 'active' : '' }}" href="{{ route('superadmin.conversionprocess.index') }}">Conversion Costs</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.process.*') ? 'active' : '' }}" href="{{ route('superadmin.process.index') }}">Processes</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.stockitems.*') ? 'active' : '' }}" href="{{ route('superadmin.stockitems.index') }}">Stock Items</a>
            </div>
        </div>
    </li>

    <!-- Section: Business -->
    <div class="sidebar-heading">Business</div>

    <!-- CRM -->
    <li class="nav-item {{ $crmActive ? 'active' : '' }}">
        <a class="nav-link {{ $crmActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseCRM"
            aria-expanded="{{ $crmActive ? 'true' : 'false' }}" aria-controls="collapseCRM">
            <i class="fas fa-fw fa-address-book"></i>
            <span>CRM</span>
        </a>
        <div id="collapseCRM" class="collapse {{ $crmActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.customer.addcustomer') || request()->routeIs('superadmin.customer.vendor.store') ? 'active' : '' }}" href="{{ route('superadmin.customer.addcustomer') }}">Add Customer/Vendor</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.customer.customerlist') || request()->routeIs('superadmin.customer.show') || request()->routeIs('superadmin.customer.edit') || request()->is('superadmin/customers/*') ? 'active' : '' }}" href="{{ route('superadmin.customer.customerlist') }}">Customer List</a>
            </div>
        </div>
    </li>

    <!-- Sales -->
    <li class="nav-item {{ $salesActive ? 'active' : '' }}">
        <a class="nav-link {{ $salesActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseSales"
            aria-expanded="{{ $salesActive ? 'true' : 'false' }}" aria-controls="collapseSales">
            <i class="fas fa-fw fa-chart-line"></i>
            <span>Sales</span>
        </a>
        <div id="collapseSales" class="collapse {{ $salesActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.salesbom.rfq.rfq') || request()->routeIs('superadmin.salesbom.rfq.store') ? 'active' : '' }}" href="{{ route('superadmin.salesbom.rfq.rfq') }}">RFQ</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.salesbom.rfq.rfqdetails') || request()->routeIs('superadmin.salesbom.rfq.view') || request()->routeIs('superadmin.salesbom.rfq.edit') || request()->is('superadmin/sales/rfq/*') ? 'active' : '' }}" href="{{ route('superadmin.salesbom.rfq.rfqdetails') }}">RFQ Management</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.salesbom.quotation.quotationorder') || request()->routeIs('superadmin.salesbom.quotations.store') ? 'active' : '' }}" href="{{ route('superadmin.salesbom.quotation.quotationorder') }}">Quotation</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.salesbom.quotation.quotationdetails') || request()->routeIs('superadmin.salesbom.quotation.view') || request()->routeIs('superadmin.salesbom.quotation.edit') || request()->is('superadmin/sales/quotations/*') ? 'active' : '' }}" href="{{ route('superadmin.salesbom.quotation.quotationdetails') }}">Quotation Management</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.sales.salesorder') || request()->routeIs('superadmin.sales.order.store') ? 'active' : '' }}" href="{{ route('superadmin.sales.salesorder') }}">Sales Order</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.sales.salesdetails') || request()->routeIs('superadmin.sales.order.show') || request()->routeIs('superadmin.sales.order.edit') || request()->routeIs('superadmin.salesmanagement.*') || request()->is('superadmin/sales/order/*') ? 'active' : '' }}" href="{{ route('superadmin.sales.salesdetails') }}">Sales Management</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.invoice.invoiceorder') || request()->routeIs('superadmin.tax-invoice.store') ? 'active' : '' }}" href="{{ route('superadmin.invoice.invoiceorder') }}">Invoice</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.invoice.invoicedetails') || request()->routeIs('superadmin.invoice.show') || request()->routeIs('superadmin.invoice.edit') || request()->is('superadmin/invoices/*') ? 'active' : '' }}" href="{{ route('superadmin.invoice.invoicedetails') }}">Invoice Management</a>
            </div>
        </div>
    </li>

    <!-- Purchase -->
    <li class="nav-item {{ $purchaseActive ? 'active' : '' }}">
        <a class="nav-link {{ $purchaseActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapsePurchase"
            aria-expanded="{{ $purchaseActive ? 'true' : 'false' }}" aria-controls="collapsePurchase">
            <i class="fas fa-fw fa-shopping-cart"></i>
            <span>Purchase</span>
        </a>
        <div id="collapsePurchase" class="collapse {{ $purchaseActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.purchasebom.rfq.rfq') || request()->routeIs('superadmin.purchasebom.rfq.store') ? 'active' : '' }}" href="{{ route('superadmin.purchasebom.rfq.rfq') }}">Purchase RFQ</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.purchasebom.rfq.rfqdetails') || request()->routeIs('superadmin.purchasebom.rfq.view') || request()->routeIs('superadmin.purchasebom.rfq.edit') || request()->is('superadmin/purchase/rfq/*') ? 'active' : '' }}" href="{{ route('superadmin.purchasebom.rfq.rfqdetails') }}">RFQ Management</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.purchasebom.quotation.quotationorder') || request()->routeIs('superadmin.purchasebom.quotation.store') ? 'active' : '' }}" href="{{ route('superadmin.purchasebom.quotation.quotationorder') }}">Purchase Quotation</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.purchasebom.quotation.quotationdetails') || request()->routeIs('superadmin.purchasebom.quotation.view') || request()->routeIs('superadmin.purchasebom.quotation.edit') || request()->is('superadmin/purchase/quotation/*') ? 'active' : '' }}" href="{{ route('superadmin.purchasebom.quotation.quotationdetails') }}">Quotation Management</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.purchase.purchaseorder') || request()->routeIs('superadmin.purchase.store') ? 'active' : '' }}" href="{{ route('superadmin.purchase.purchaseorder') }}">Purchase Order</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.purchase.purchasedetails') || request()->routeIs('superadmin.purchase.show') || request()->routeIs('superadmin.purchase.edit') || request()->is('superadmin/purchasemanagement/*') ? 'active' : '' }}" href="{{ route('superadmin.purchase.purchasedetails') }}">PO Management</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.purchase.accounts') || request()->is('superadmin/purchasemanagement/accounts*') ? 'active' : '' }}" href="{{ route('superadmin.purchase.accounts') }}">Vendor Accounts</a>
            </div>
        </div>
    </li>

    <!-- Accounts Management -->
    <li class="nav-item {{ $accountsActive ? 'active' : '' }}">
        <a class="nav-link {{ $accountsActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseAccounts"
            aria-expanded="{{ $accountsActive ? 'true' : 'false' }}" aria-controls="collapseAccounts">
            <i class="fas fa-fw fa-calculator"></i>
            <span>Accounts</span>
        </a>
        <div id="collapseAccounts" class="collapse {{ $accountsActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.accounts.payable.*') ? 'active' : '' }}" href="{{ route('superadmin.accounts.payable.index') }}">Payable</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.accounts.receivable.*') ? 'active' : '' }}" href="{{ route('superadmin.accounts.receivable.index') }}">Receivable</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.accounts.reports.balance-sheet') ? 'active' : '' }}" href="{{ route('superadmin.accounts.reports.balance-sheet') }}">Balance Sheet</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.accounts.reports.profit-loss') ? 'active' : '' }}" href="{{ route('superadmin.accounts.reports.profit-loss') }}">Profit & Loss</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.accounts.reports.cash-flow') ? 'active' : '' }}" href="{{ route('superadmin.accounts.reports.cash-flow') }}">Cash Flow</a>
            </div>
        </div>
    </li>

    <!-- Section: Operations -->
    <div class="sidebar-heading">Operations</div>

    <!-- Operation -->
    <li class="nav-item {{ $operationActive ? 'active' : '' }}">
        <a class="nav-link {{ $operationActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseOperation"
            aria-expanded="{{ $operationActive ? 'true' : 'false' }}" aria-controls="collapseOperation">
            <i class="fas fa-fw fa-truck-loading"></i>
            <span>Operations</span>
        </a>
        <div id="collapseOperation" class="collapse {{ $operationActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.grn.grnorder') || request()->routeIs('superadmin.grn.store') ? 'active' : '' }}" href="{{ route('superadmin.grn.grnorder') }}">GRN</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.grn.grndetails') || request()->routeIs('superadmin.grn.view') || request()->routeIs('superadmin.grn.edit') || request()->is('superadmin/grn/*') ? 'active' : '' }}" href="{{ route('superadmin.grn.grndetails') }}">GRN Management</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.routecard.index') || request()->routeIs('superadmin.routecard.store') ? 'active' : '' }}" href="{{ route('superadmin.routecard.index') }}">Route Card</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.routecard.details') || request()->routeIs('superadmin.routecard.show') || request()->routeIs('superadmin.routecard.edit') || request()->is('superadmin/routecard/*') ? 'active' : '' }}" href="{{ route('superadmin.routecard.details') }}">Route Card Management</a>
            </div>
        </div>
    </li>

    <!-- Manufacturing -->
    <li class="nav-item {{ $planningActive ? 'active' : '' }}">
        <a class="nav-link {{ $planningActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapsePlanning"
            aria-expanded="{{ $planningActive ? 'true' : 'false' }}" aria-controls="collapsePlanning">
            <i class="fas fa-fw fa-industry"></i>
            <span>Manufacturing</span>
        </a>
        <div id="collapsePlanning" class="collapse {{ $planningActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.manufacturing.planning') || request()->routeIs('superadmin.manufacturing.plan') || request()->routeIs('superadmin.manufacturing.gantt') ? 'active' : '' }}" href="{{ route('superadmin.manufacturing.planning') }}">Planning</a>
                <a class="collapse-item {{ request()->is('superadmin/ready-to-production*') || request()->routeIs('superadmin.readytoproduction') ? 'active' : '' }}" href="{{ url('superadmin/ready-to-production') }}">Ready For Production</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.production.*') || request()->is('superadmin/manufacturing/production*') ? 'active' : '' }}" href="{{ route('superadmin.production.inprogress.list') }}">Production</a>
                <a class="collapse-item {{ request()->is('superadmin/quality*') || request()->routeIs('superadmin.qualitycontrol.*') ? 'active' : '' }}" href="{{ url('superadmin/quality/qc-management') }}">Quality Control</a>
            </div>
        </div>
    </li>

    <!-- SKU and Machines -->
    <li class="nav-item {{ $skuMachinesActive ? 'active' : '' }}">
        <a class="nav-link {{ $skuMachinesActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseskumachines"
            aria-expanded="{{ $skuMachinesActive ? 'true' : 'false' }}" aria-controls="collapseskumachines">
            <i class="fas fa-fw fa-cogs"></i>
            <span>SKU & Machines</span>
        </a>
        <div id="collapseskumachines" class="collapse {{ $skuMachinesActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.sku.skumaster') || request()->routeIs('superadmin.sku.store') || request()->routeIs('superadmin.sku.edit') ? 'active' : '' }}" href="{{ route('superadmin.sku.skumaster') }}">SKU Master</a>
                <a class="collapse-item {{ request()->is('superadmin/skuapprovals*') || request()->routeIs('superadmin.sku.skuapproval') || request()->routeIs('superadmin.sku-approval.*') ? 'active' : '' }}" href="{{ url('superadmin/skuapprovals') }}">SKU Approvals</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.sku.skumovement') ? 'active' : '' }}" href="{{ route('superadmin.sku.skumovement') }}">SKU Movement</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.machine.addmachine') || request()->routeIs('superadmin.machine.store') ? 'active' : '' }}" href="{{ route('superadmin.machine.addmachine') }}">Add Machine</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.machine.machinedetails') || request()->routeIs('superadmin.machine.edit') || request()->is('superadmin/editmachine*') ? 'active' : '' }}" href="{{ route('superadmin.machine.machinedetails') }}">Machine List</a>
            </div>
        </div>
    </li>

    <!-- Section: HR & Reports -->
    <div class="sidebar-heading">HR & Reports</div>

    <!-- HRM -->
    <li class="nav-item {{ $hrmActive ? 'active' : '' }}">
        <a class="nav-link {{ $hrmActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseHRM"
            aria-expanded="{{ $hrmActive ? 'true' : 'false' }}" aria-controls="collapseHRM">
            <i class="fas fa-fw fa-user-tie"></i>
            <span>HR Management</span>
        </a>
        <div id="collapseHRM" class="collapse {{ $hrmActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.salary-structure.*') || request()->is('superadmin/salary-structure*') ? 'active' : '' }}" href="{{ route('superadmin.salary-structure.index') }}">Salary Structure</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.holiday.*') || request()->is('superadmin/holiday*') ? 'active' : '' }}" href="{{ route('superadmin.holiday.index') }}">Holidays</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.employee.employeedetails') || request()->routeIs('superadmin.employees.*') || request()->is('superadmin/employeedetails*') ? 'active' : '' }}" href="{{ route('superadmin.employee.employeedetails') }}">Employees</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.payroll.*') || request()->routeIs('superadmin.employeepayroll') || request()->is('superadmin/employeepayroll*') || request()->is('superadmin/payroll*') ? 'active' : '' }}" href="{{ url('superadmin/employeepayroll') }}">Salary</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.leave.*') || request()->routeIs('superadmin.employeeleave*') || request()->is('superadmin/employeeleave*') || request()->is('superadmin/leave*') ? 'active' : '' }}" href="{{ url('superadmin/employeeleave') }}">Leave</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.employee.index') || request()->routeIs('superadmin.attendance.*') || request()->is('superadmin/employeeattendance*') ? 'active' : '' }}" href="{{ url('superadmin/employeeattendance') }}">Attendance</a>
                <a class="collapse-item {{ (request()->is('superadmin/employeedailyreports') || request()->is('superadmin/employeedailyreport')) && !request()->is('*calendarview*') ? 'active' : '' }}" href="{{ url('superadmin/employeedailyreports') }}">Daily Report</a>
                <a class="collapse-item {{ request()->is('*calendarview*') || request()->is('superadmin/employeecalendar*') ? 'active' : '' }}" href="{{ url('superadmin/employeedailyreports/calendarview') }}">Calendar</a>
            </div>
        </div>
    </li>

    <!-- Reports -->
    <li class="nav-item {{ $reportsActive ? 'active' : '' }}">
        <a class="nav-link {{ $reportsActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseReports"
            aria-expanded="{{ $reportsActive ? 'true' : 'false' }}" aria-controls="collapseReports">
            <i class="fas fa-fw fa-file-alt"></i>
            <span>Reports</span>
        </a>
        <div id="collapseReports" class="collapse {{ $reportsActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.report.employeereport') ? 'active' : '' }}" href="{{ route('superadmin.report.employeereport') }}">Employee Report</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.report.machinereport') ? 'active' : '' }}" href="{{ route('superadmin.report.machinereport') }}">Machine Report</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.report.inventoryreport') ? 'active' : '' }}" href="{{ route('superadmin.report.inventoryreport') }}">Inventory Report</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.report.customerreport') ? 'active' : '' }}" href="{{ route('superadmin.report.customerreport') }}">Customer Report</a>
                <a class="collapse-item {{ request()->routeIs('superadmin.report.billreport') ? 'active' : '' }}" href="{{ route('superadmin.report.billreport') }}">Bill Report</a>
            </div>
        </div>
    </li>

    <!-- System -->
    <li class="nav-item {{ $activityActive ? 'active' : '' }}">
        <a class="nav-link {{ $activityActive ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseSystem"
            aria-expanded="{{ $activityActive ? 'true' : 'false' }}" aria-controls="collapseSystem">
            <i class="fas fa-fw fa-cog"></i>
            <span>System</span>
        </a>
        <div id="collapseSystem" class="collapse {{ $activityActive ? 'show' : '' }}" data-parent="#accordionSidebar">
            <div class="collapse-inner rounded">
                <a class="collapse-item {{ request()->routeIs('superadmin.activity.*') ? 'active' : '' }}" href="{{ route('superadmin.activity.index') }}">Activity Log</a>
            </div>
        </div>
    </li>

</ul>
