<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Sales Order #{{ $order->sales_order_no }}</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 15mm 10mm 12mm 10mm;
        }

        @media print {

            html,
            body {
                width: 100%;
                height: 100%;
            }

            .no-print {
                display: none !important;
            }

            body {
                background: #fff !important;
            }

            .container {
                box-shadow: none !important;
                margin: 0 !important;
                padding: 0 0 5mm 0 !important;
                width: 100% !important;
                border-radius: 0 !important;
            }

            table.details-table {
                page-break-inside: auto;
            }

            table.details-table thead {
                display: table-header-group;
            }

            table.details-table tfoot {
                display: table-footer-group;
            }

            table.details-table tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .section-title {
                page-break-after: avoid;
            }
        }

        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 1000px;
            margin: 10px auto;
            background: #fff;
            padding: 20px 20px 14px 20px;
            border-radius: 8px;
            box-shadow: 0 4px 16px rgba(80, 100, 144, .09);
        }

        .header {
            display: flex;
            align-items: center;
            border-bottom: 2px solid #506690;
            padding-bottom: 6px;
            margin-bottom: 18px;
        }

        .logo {
            width: 70px;
            margin-right: 18px;
        }

        .company-details {
            flex: 1;
        }

        .company-details h2 {
            margin: 0;
            color: #506690;
            letter-spacing: 1.1px;
            font-size: 22px;
        }

        .company-details p {
            margin: 2px 0 0 0;
            color: #555;
            font-size: 12px;
        }

        .quotation-title {
            text-align: center;
            margin: 0 0 15px 0;
            color: #263850;
            font-size: 20px;
        }

        .info-table {
            width: 100%;
            margin-bottom: 12px;
            border-collapse: collapse;
        }

        .info-table td {
            padding: 4px 6px;
            vertical-align: top;
            font-size: 12px;
        }

        .section-title {
            background: #f1f4f9;
            color: #506690;
            font-weight: bold;
            padding: 4px 8px;
            border-radius: 3px;
            margin-bottom: 7px;
            margin-top: 14px;
            font-size: 14px;
        }

        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 14px;
        }

        .details-table th,
        .details-table td {
            border: 1px solid #dbe5f1;
            padding: 5px 6px;
            font-size: 11px;
        }

        .details-table th {
            background: #f6faff;
            color: #263850;
            font-weight: 600;
        }

        .totals-table {
            width: 42%;
            margin-left: auto;
            font-size: 13px;
            margin-bottom: 10px;
        }

        .totals-table td {
            padding: 3px 6px;
        }

        .right {
            text-align: right;
        }

        .terms {
            margin-top: 8px;
            color: #555;
            font-size: 11px;
        }

        .footer {
            margin-top: 14px;
            text-align: right;
        }

        .signatory {
            margin-top: 24px;
            text-align: right;
            font-weight: bold;
            font-size: 12px;
        }

        .no-print {
            margin-bottom: 12px;
        }

        .btn {
            background: #506690;
            color: #fff;
            padding: 6px 18px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }

        .btn:hover {
            background: #354063;
        }

        .totals-signatory-section {
            margin-top: 22px;
            background: #f6faff;
            padding: 16px 24px 10px 24px;
            border-radius: 7px;
            box-shadow: 0 2px 8px rgba(80, 100, 144, .06);
        }

        @media print {
            .totals-signatory-section {
                background: none !important;
                box-shadow: none !important;
                padding: 0 !important;
                border-radius: 0 !important;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="no-print" style="text-align:right;">
            <button class="btn" onclick="window.print()">Print</button>
            <button class="btn" onclick="window.close()">Close</button>
        </div>
        <div class="header">
            <img class="logo" src="{{ asset('cbimage.png') }}" alt="Company Logo">
            <div class="company-details">
                <h2>UMBREY ENGINEERING PVT LTD</h2>
                <p>No. 31, 2nd Phase, Peenya Industrial Area, Bengaluru 560 058, Karnataka, India<br>
                    GSTN: 29AAACU2461N1ZY &nbsp; | &nbsp; PAN: AAACU2461N</p>
                <p style="font-size:11px;margin:2px 0 0 0;">Email: info@umbreygroups.com</p>
            </div>
            <div style="text-align:right;font-size:12px;">
                <strong>Sales Order #: </strong> {{ $order->sales_order_no }}<br>
                <strong>Date:</strong> {{ \Carbon\Carbon::parse($order->sales_order_date)->format('d/m/Y') }}<br>
            </div>
        </div>
        <h1 class="quotation-title">SALES ORDER</h1>

        <div class="section-title">Customer Details</div>
        <table class="info-table">
            <tr>
                <td style="width:33%;"><b>Company:</b> {{ $order->company_name ?? '-' }}<br>
                    <b>Contact:</b> {{ $order->company_phone ?? '-' }}<br>
                    <b>Email:</b> {{ $order->company_email ?? '-' }}<br>
                    <b>GST No:</b> {{ $order->company_gstn ?? '-' }}
                </td>
                <td style="width:33%;"><b>Bill Address:</b><br>{{ $order->bill_address ?? '-' }}</td>
                <td style="width:34%;"><b>Ship Address:</b><br>{{ $order->ship_address ?? '-' }}</td>
            </tr>
        </table>

        <div class="section-title">Sales Order Header</div>
        <table class="info-table">
            <tr>
                <td><b>GRN No:</b> {{ $order->grn_no ?? '-' }}</td>
                <td><b>Customer Ref No:</b> {{ $order->customer_ref_no ?? '-' }}</td>
                <td><b>Quotation No:</b> {{ $order->quotation_no ?? '-' }}</td>
            </tr>
            <tr>
                <td><b>Quotation Date:</b>
                    {{ $order->quotation_date ? \Carbon\Carbon::parse($order->quotation_date)->format('d/m/Y') : '-' }}
                </td>
                <td><b>RFQ No:</b> {{ $order->rfq_no ?? '-' }}</td>
                <td><b>RFQ Date:</b>
                    {{ $order->rfq_date ? \Carbon\Carbon::parse($order->rfq_date)->format('d/m/Y') : '-' }}</td>
            </tr>
            <tr>
                <td><b>Part No:</b> {{ $order->part_no ?? '-' }}</td>
                <td><b>Project Mat No:</b> {{ $order->project_material_no ?? '-' }}</td>
                <td><b>Drawing No:</b> {{ $order->drawing_no ?? '-' }}</td>
            </tr>
            <tr>
                <td><b>Drawing Rev:</b> {{ $order->drawing_rev ?? '-' }}</td>
                <td><b>Description:</b> {{ $order->description ?? '-' }}</td>
                <td><b>Product Type:</b> {{ $order->product_type }}</td>
            </tr>
        </table>

        <div class="section-title">Product Details</div>
        <table class="details-table">
            <thead>
                <tr>
                    <th>Sl No.</th>
                    <th>Material Code</th>
                    <th>HSN Code</th>
                    <th>Description</th>
                    <th>Additional Details</th>
                    <th>Required By Date</th>
                    <th>Quantity</th>
                    <th>UOM</th>
                    <th>Unit Rate</th>
                    <th>Discount (%)</th>
                    <th>Value (INR)</th>
                    <th>SGST (%)</th>
                    <th>CGST (%)</th>
                    <th>IGST (%)</th>
                    <th>Amount (INR)</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($order->items as $item)
                    <tr>
                        <td>{{ $item->sl_no }}</td>
                        <td>{{ $item->material_code ?? '-' }}</td>
                        <td>{{ $item->hsn_code ?? '-' }}</td>
                        <td>{{ $item->material_description ?? '-' }}</td>
                        <td>{{ $item->additional_details ?? '-' }}</td>
                        <td>{{ $item->required_by_date ? \Carbon\Carbon::parse($item->required_by_date)->format('d M Y') : '-' }}
                        </td>
                        <td>{{ $item->quantity }}</td>
                        <td>{{ $item->uom }}</td>
                        <td>{{ number_format($item->unit_rate, 2) }}</td>
                        <td>{{ $item->discount }}%</td>
                        <td>{{ number_format($item->value, 2) }}</td>
                        <td>{{ $item->sgst }}%</td>
                        <td>{{ $item->cgst }}%</td>
                        <td>{{ $item->igst }}%</td>
                        <td>{{ number_format($item->amount, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div class="totals-signatory-section"
            style="display: flex; flex-direction: column; align-items: flex-end; margin-top: 24px;">
            <table class="totals-table" style="margin-bottom: 18px;">
                <tr>
                    <td class="right">Sub Total:</td>
                    <td class="right"><strong>₹{{ number_format($order->subtotal, 2) }}</strong></td>
                </tr>
                <tr>
                    <td class="right">SGST Amount:</td>
                    <td class="right"><strong>₹{{ number_format($order->sgst_amount, 2) }}</strong></td>
                </tr>
                <tr>
                    <td class="right">CGST Amount:</td>
                    <td class="right"><strong>₹{{ number_format($order->cgst_amount, 2) }}</strong></td>
                </tr>
                <tr>
                    <td class="right">IGST Amount:</td>
                    <td class="right"><strong>₹{{ number_format($order->igst_amount, 2) }}</strong></td>
                </tr>
                <tr>
                    <td class="right">Round Up:</td>
                    <td class="right"><strong>₹{{ number_format($order->round_up, 2) }}</strong></td>
                </tr>
                <tr>
                    <td class="right">Grand Total:</td>
                    <td class="right"><strong
                            style="font-size:16px; color:#263850;">₹{{ number_format($order->grand_total, 2) }}</strong>
                    </td>
                </tr>
                <tr>
                    <td class="right">Grand Total in Words:</td>
                    <td class="right">{{ ucwords((new \NumberFormatter('en_IN', \NumberFormatter::SPELLOUT))->format($order->grand_total)) }}</td>
                </tr>
            </table>
            <div class="signatory" style="text-align:right; width: 300px;">
                For Umbrey Engineering PVT LTD,<br><br>
                Authorised Signatory
            </div>
        </div>

    </div>
</body>

</html>
