@extends('layouts.dashboard.managerapp')

@section('title', 'Purchase Order Details')

@section('content')
    <style>
        .po-view-card {
            background: linear-gradient(120deg, #f6d365 0%, #fda085 100%);
            border-radius: 1.2rem;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.09);
            overflow: hidden;
            border: none;
        }

        .po-header {
            background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
            padding: 1.5rem 2rem 1rem 2rem;
            color: #222;
            border-top-left-radius: 1.2rem;
            border-top-right-radius: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .po-header h3 {
            margin-bottom: 0;
            font-weight: 700;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .po-body {
            background: #fff;
            border-bottom-left-radius: 1.2rem;
            border-bottom-right-radius: 1.2rem;
            padding: 2rem;
        }

        .po-label {
            color: #4f4f4f;
            font-weight: 600;
        }

        .po-value {
            color: #2b2b2b;
            font-weight: 700;
        }

        .po-detail-row {
            margin-bottom: 1rem;
        }

        .po-back-btn {
            min-width: 130px;
            border-radius: 2rem;
            font-size: 1.1rem;
            font-weight: 600;
            box-shadow: 0 3px 18px rgba(253, 160, 133, 0.09);
        }

        @media (max-width: 991px) {
            .po-body {
                padding: 1.2rem;
            }
            .po-header {
                padding: 1rem 1rem 0.7rem 1rem;
            }
        }
    </style>

    <div class="container-fluid">
        <div class="row justify-content-center py-4">
            <div class="col-12 col-lg-11">
                <div class="card po-view-card">
                    <div class="po-header">
                        <h3>
                            <i class="fas fa-file-alt"></i> Purchase Order Details
                        </h3>
                        <a href="{{ route('manager.purchase.purchasedetails') }}" class="btn btn-light po-back-btn">
                            <i class="fa fa-arrow-left"></i> Back to Purchase Orders List
                        </a>
                    </div>
                    <div class="po-body">
                        <div class="row">
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Purchase Order No:</span>
                                <div class="po-value">{{ $po->purchase_order_no }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Date:</span>
                                <div class="po-value">{{ \Carbon\Carbon::parse($po->purchase_order_date)->format('d M Y') }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">GRN No:</span>
                                <div class="po-value">{{ $po->grn_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Vendor Reference No:</span>
                                <div class="po-value">{{ $po->customer_ref_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Company Name (Vendor):</span>
                                <div class="po-value">{{ $po->vendor->company ?? $po->company_name }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">GSTN:</span>
                                <div class="po-value">{{ $po->company_gstn ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Phone:</span>
                                <div class="po-value">{{ $po->company_phone ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Email:</span>
                                <div class="po-value">{{ $po->company_email ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Quotation No:</span>
                                <div class="po-value">{{ $po->quotation_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Quotation Date:</span>
                                <div class="po-value">{{ $po->quotation_date ? \Carbon\Carbon::parse($po->quotation_date)->format('d M Y') : '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">RFQ No:</span>
                                <div class="po-value">{{ $po->rfq_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">RFQ Date:</span>
                                <div class="po-value">{{ $po->rfq_date ? \Carbon\Carbon::parse($po->rfq_date)->format('d M Y') : '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Part No:</span>
                                <div class="po-value">{{ $po->part_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Project Material No:</span>
                                <div class="po-value">{{ $po->project_material_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Drawing No:</span>
                                <div class="po-value">{{ $po->drawing_no ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Drawing Revision:</span>
                                <div class="po-value">{{ $po->drawing_rev ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Description:</span>
                                <div class="po-value">{{ $po->description ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Product Type:</span>
                                <div class="po-value">{{ $po->product_type ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Bill To:</span>
                                <div class="po-value">{{ $po->bill_address ?? '-' }}</div>
                            </div>
                            <div class="col-md-6 po-detail-row">
                                <span class="po-label">Ship To:</span>
                                <div class="po-value">{{ $po->ship_address ?? '-' }}</div>
                            </div>
                        </div>
                        <div class="row">
                            
                        </div>
                        <hr class="my-4">
                        <div class="row">
                            <div class="col-md-12 po-detail-row">
                                <span class="po-label">Grand Total in Words:</span>
                                <div class="po-value">{{ $po->inr_in_words ?? '-' }}</div>
                            </div>
                            <div class="col-md-4 po-detail-row">
                                <span class="po-label">Subtotal:</span>
                                <div class="po-value">₹{{ number_format($po->subtotal, 2) }}</div>
                            </div>
                            <div class="col-md-4 po-detail-row">
                                <span class="po-label">SGST Amount:</span>
                                <div class="po-value">₹{{ number_format($po->sgst_amount, 2) }}</div>
                            </div>
                            <div class="col-md-4 po-detail-row">
                                <span class="po-label">CGST Amount:</span>
                                <div class="po-value">₹{{ number_format($po->cgst_amount, 2) }}</div>
                            </div>
                            <div class="col-md-4 po-detail-row">
                                <span class="po-label">IGST Amount:</span>
                                <div class="po-value">₹{{ number_format($po->igst_amount, 2) }}</div>
                            </div>
                            <div class="col-md-4 po-detail-row">
                                <span class="po-label">Round Up:</span>
                                <div class="po-value">₹{{ number_format($po->round_up, 2) }}</div>
                            </div>
                            <div class="col-md-4 po-detail-row">
                                <span class="po-label">Grand Total:</span>
                                <div class="po-value">₹{{ number_format($po->grand_total, 2) }}</div>
                            </div>
                        </div>
                        <hr class="my-4">

                        <h5 class="mb-3"><i class="fas fa-cubes me-2"></i>Product Details</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered align-middle">
                                <thead class="table-light">
                                    <tr class="text-center">
                                        <th>Sl No.</th>
                                        <th>Material Code</th>
                                        <th>HSN Code</th>
                                        <th>Description</th>
                                        <th>Additional Details</th>
                                        <th>Required By Date</th>
                                        <th>Quantity</th>
                                        <th>UOM</th>
                                        <th>Unit Rate</th>
                                        <th>Discount (%)</th>
                                        <th>Value (INR)</th>
                                        <th>SGST (%)</th>
                                        <th>CGST (%)</th>
                                        <th>IGST (%)</th>
                                        <th>Amount (INR)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($po->items as $item)
                                        <tr>
                                            <td>{{ $item->sl_no }}</td>
                                            <td>{{ $item->material_code ?? '-' }}</td>
                                            <td>{{ $item->hsn_code ?? '-' }}</td>
                                            <td>{{ $item->material_description ?? '-' }}</td>
                                            <td>{{ $item->additional_details ?? '-' }}</td>
                                            <td>{{ $item->required_by_date ? \Carbon\Carbon::parse($item->required_by_date)->format('d M Y') : '-' }}</td>
                                            <td>{{ $item->quantity }}</td>
                                            <td>{{ $item->uom }}</td>
                                            <td>₹{{ number_format($item->unit_rate, 2) }}</td>
                                            <td>{{ $item->discount }}%</td>
                                            <td>₹{{ number_format($item->value, 2) }}</td>
                                            <td>{{ $item->sgst }}%</td>
                                            <td>{{ $item->cgst }}%</td>
                                            <td>{{ $item->igst }}%</td>
                                            <td>₹{{ number_format($item->amount, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-end mt-4">
                            <a href="{{ route('manager.purchase.purchasedetails') }}" class="btn btn-light po-back-btn">
                                <i class="fa fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Ensure tables are scrollable if they overflow
    $('.table-responsive').each(function() {
        var table = $(this).find('table');
        if (table.width() > $(this).width()) {
            $(this).css('overflow-x', 'auto');
        }
    });
});
</script>
@endsection
