@extends('layouts.dashboard.managerapp')

@section('title', 'Edit GRN Order')

@section('content')
@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif

@if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form method="POST" action="{{ route('manager.grn.update', $grn->id) }}" enctype="multipart/form-data" id="grnForm">
    @csrf
    @method('POST')
    <div class="grn-form" id="grnContent">
        <div class="umbrey-logo">
            <img src="{{ asset('cbimage.png') }}" alt="Company Logo" />
        </div>
        <h1>Edit Goods Received Note</h1>
        <br>
        <div class="row" id="IdDateFields">
            <div class="col-md-6">
                <label>GRN ID <span class="required">*</span>
                    <input type="text" id="grnNo" name="grn_no" class="form-control" value="{{ $grn->grn_no }}" readonly>
                </label>
            </div>
            <div class="col-md-6">
                <label>GRN Date <span class="required">*</span>
                    <input type="date" id="grnDate" name="grn_date" value="{{ $grn->grn_date }}" required>
                </label>
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label>Order ID <span class="required">*</span>
                    <input type="text" id="orderNo" name="order_no" value="{{ $grn->order_no }}" required>
                </label>
            </div>
            <div class="col-md-6">
                <label>Order Date <span class="required">*</span>
                    <input type="date" id="orderDate" name="order_date" value="{{ $grn->order_date }}" required>
                </label>
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label>Order Company Name <span class="required">*</span>
                    <select id="companyNameSelect" name="company_name" class="form-control" onchange="fillCompanyDetails(this)" required>
                        <option value="">Select Company</option>
                        @foreach ($companies as $company)
                            <option value="{{ $company->company }}"
                                data-address="{{ $company->billing_Address }}"
                                data-gst="{{ $company->gstno }}"
                                data-email="{{ $company->email }}"
                                data-phone="{{ $company->mobile }}"
                                {{ $grn->company_name == $company->company ? 'selected' : '' }}>
                                {{ $company->company }}
                            </option>
                        @endforeach
                    </select>
                </label>
            </div>
            <div class="col-md-6">
                <label>Order Reference No
                    <input type="text" id="orderRefNo" name="order_ref_no" value="{{ $grn->order_ref_no }}">
                </label>
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label>Address
                    <input type="text" id="companyAddress" name="company_address" value="{{ $grn->company_address }}">
                </label>
            </div>
            <div class="col-md-6">
                <label>GST No
                    <input type="text" id="companyGSTN" name="company_gst" value="{{ $grn->company_gst }}">
                </label>
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label>Email
                    <input type="email" id="companyEmail" name="company_email" value="{{ $grn->company_email }}">
                </label>
            </div>
            <div class="col-md-6">
                <label>Contact Number
                    <input type="tel" id="companyPhone" name="company_phone" value="{{ $grn->company_phone }}">
                </label>
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label>Quotation ID
                    <input type="text" id="quotationNo" name="quotation_no" value="{{ $grn->quotation_no }}">
                </label>
            </div>
            <div class="col-md-6">
                <label>Quotation Date
                    <input type="date" id="quotationDate" name="quotation_date" value="{{ $grn->quotation_date }}">
                </label>
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label for="rfqNo">RFQ No</label>
                <input type="text" id="rfqNo" name="rfq_no" value="{{ $grn->rfq_no }}">
            </div>
            <div class="col-md-6">
                <label for="rfqDate">RFQ Date</label>
                <input type="date" id="rfqDate" name="rfq_date" value="{{ $grn->rfq_date }}">
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label for="partNo">Part No</label>
                <input type="text" id="partNo" name="part_no" value="{{ $grn->part_no }}">
            </div>
            <div class="col-md-6">
                <label for="project-materialNo">Project Material No</label>
                <input type="text" id="project-materialNo" name="project_material_no" value="{{ $grn->project_material_no }}">
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label for="drawingNo">Drawing No</label>
                <input type="text" id="drawingNo" name="drawing_no" value="{{ $grn->drawing_no }}">
            </div>
            <div class="col-md-6">
                <label for="drawingRev">Drawing Revision</label>
                <input type="text" id="drawingRev" name="drawing_rev" value="{{ $grn->drawing_rev }}">
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label for="description">Description</label>
                <textarea id="description" name="description" rows="2">{{ $grn->description }}</textarea>
            </div>
            <div class="col-md-6">
                <label>Upload Challan (PDF only)
                    <input type="file" id="grnChallan" name="challan" accept=".pdf">
                </label>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-lg-12">
                <h3>Product Details</h3>
                <div class="product-selection">
                    <label for="productType">Product Type</label>
                    <input type="text" id="productType" name="product_type" value="{{ $grn->product_type }}">
                </div>
                <table id="productTable" class="product-table grn-table">
                    <thead>
                        <tr>
                            <th>Sl No.</th>
                            <th>Description</th>
                            <th>Quantity</th>
                            <th>UOM</th>
                            <th>Date</th>
                            <th>Supplier</th>
                            <th>Remarks</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($grn->products as $index => $product)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td><input type="text" name="products[{{ $index }}][description]" value="{{ $product->description }}"></td>
                            <td><input type="number" name="products[{{ $index }}][quantity]" value="{{ $product->quantity }}"></td>
                            <td><input type="text" name="products[{{ $index }}][unit]" value="{{ $product->unit }}"></td>
                            <td><input type="date" name="products[{{ $index }}][date]" value="{{ $product->date }}"></td>
                            <td><input type="text" name="products[{{ $index }}][supplier]" value="{{ $product->supplier }}"></td>
                            <td><input type="text" name="products[{{ $index }}][remarks]" value="{{ $product->remarks }}"></td>
                            <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-md-2">
                <button type="button" onclick="addRow()">Add Row</button>
            </div>
        </div>
        <hr>
        <div class="row mt-5 mb-5">
            <div class="col-xl-3">
                <button type="submit" id="save-GRN">Update</button>
            </div>
        </div>
    </div>
</form>
<script>
    function addRow() {
        const table = document.querySelector("#productTable tbody");
        const index = table.rows.length;
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${index + 1}</td>
            <td><input type="text" name="products[${index}][description]"></td>
            <td><input type="number" name="products[${index}][quantity]"></td>
            <td><input type="text" name="products[${index}][unit]"></td>
            <td><input type="date" name="products[${index}][date]"></td>
            <td><input type="text" name="products[${index}][supplier]"></td>
            <td><input type="text" name="products[${index}][remarks]"></td>
            <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
        `;
        table.appendChild(row);
    }

    function deleteRow(button) {
        const row = button.closest("tr");
        row.remove();
        const rows = document.querySelectorAll("#productTable tbody tr");
        rows.forEach((tr, i) => {
            tr.querySelectorAll("input").forEach(input => {
                const name = input.name.replace(/products\[\d+\]/, `products[${i}]`);
                input.name = name;
            });
            tr.querySelector("td").textContent = i + 1;
        });
    }

    function fillCompanyDetails(select) {
        const selected = select.options[select.selectedIndex];
        document.getElementById('companyAddress').value = selected.getAttribute('data-address') || '';
        document.getElementById('companyGSTN').value = selected.getAttribute('data-gst') || '';
        document.getElementById('companyEmail').value = selected.getAttribute('data-email') || '';
        document.getElementById('companyPhone').value = selected.getAttribute('data-phone') || '';
    }
</script>
@endsection
