@extends('layouts.dashboard.managerapp')

@section('title', 'Salary Structure Master')

@section('styles')
<style>
    .card-header-gradient {
        background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        color: white;
    }
</style>
@endsection

@section('content')

<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Salary Structure Master</h1>
</div>

<!-- Success/Error Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<div class="row">
    <!-- List Section (View Only for Manager) -->
    <div class="col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header card-header-gradient py-3">
                <h6 class="m-0 font-weight-bold">
                    <i class="fas fa-money-check-alt mr-2"></i> Employee Salary Structures
                </h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-sm" id="structureTable" width="100%" cellspacing="0">
                        <thead class="thead-light">
                            <tr>
                                <th>Employee</th>
                                <th>Basic & DA</th>
                                <th>HRA</th>
                                <th>Conveyance</th>
                                <th>Washing Allow.</th>
                                <th>Incentive/Hr</th>
                                <th>Fixed Salary</th>
                                <th>PF %</th>
                                <th>ESI %</th>
                                <th>PT %</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($structures as $st)
                                <tr>
                                    <td>
                                        <div class="font-weight-bold">{{ $st->employee->name ?? 'N/A' }}</div>
                                        <small class="text-muted">{{ $st->employee->employee_id ?? '-' }}</small>
                                    </td>
                                    <td>{{ number_format($st->basic_da, 2) }}</td>
                                    <td>{{ number_format($st->hra, 2) }}</td>
                                    <td>{{ number_format($st->conveyance, 2) }}</td>
                                    <td>{{ number_format($st->washing_allowance, 2) }}</td>
                                    <td>{{ $st->incentive_per_hour ?? '-' }}</td>
                                    <td class="font-weight-bold text-success">{{ number_format($st->fixed_salary, 2) }}</td>
                                    <td>{{ $st->pf_percentage ?? '-' }}%</td>
                                    <td>{{ $st->esi_percentage ?? '-' }}%</td>
                                    <td>{{ $st->pt_percentage ?? '-' }}%</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('#structureTable').DataTable({
            dom: 'Bfrtip',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
        });
    });
</script>
@endsection
