<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payslip - {{ $payroll->employee->name ?? 'Employee' }} - {{ $payroll->month_year }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            .no-print { display: none !important; }
            body { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
        }
        body { font-size: 12px; }
        .payslip-container { max-width: 800px; margin: 0 auto; padding: 20px; }
        .header { border-bottom: 3px solid #4e73df; padding-bottom: 15px; margin-bottom: 20px; }
        .company-name { font-size: 24px; font-weight: bold; color: #4e73df; }
        .payslip-title { background: #4e73df; color: white; padding: 8px 15px; margin-top: 10px; }
        .section-header { background: #4e73df; color: white; padding: 5px 10px; font-weight: bold; }
        .section-header.deduction { background: #e74a3b; }
        .net-salary-box { background: #1cc88a; color: white; padding: 15px; text-align: center; }
        .net-salary-box .amount { font-size: 24px; font-weight: bold; }
        .signature-line { border-top: 1px solid #333; margin-top: 50px; padding-top: 5px; text-align: center; }
        .table-sm td, .table-sm th { padding: 0.4rem; }
    </style>
</head>
<body>
    <div class="payslip-container">
        <div class="text-right mb-3 no-print">
            <button class="btn btn-primary btn-sm" onclick="window.print()"><i class="fas fa-print"></i> Print</button>
            <a href="{{ route('manager.payroll.index') }}" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> Back</a>
        </div>

        <div class="header text-center">
            <div class="company-name">UEPL - ULTRA ENGINEERING PVT LTD</div>
            <small class="text-muted">Industrial Area, Manufacturing Hub, India</small>
            <div class="payslip-title">SALARY SLIP FOR {{ strtoupper(\Carbon\Carbon::parse($payroll->month_year)->format('F Y')) }}</div>
        </div>

        <div class="card mb-3">
            <div class="card-body p-2">
                <table class="table table-sm table-bordered mb-0">
                    <tr>
                        <td class="bg-light font-weight-bold" width="20%">Employee ID</td>
                        <td width="30%">{{ $payroll->employee->employee_id ?? '-' }}</td>
                        <td class="bg-light font-weight-bold" width="20%">Employee Name</td>
                        <td width="30%">{{ $payroll->employee->name ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td class="bg-light font-weight-bold">Department</td>
                        <td>{{ $payroll->employee->department ?? '-' }}</td>
                        <td class="bg-light font-weight-bold">Designation</td>
                        <td>{{ $payroll->employee->designation ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td class="bg-light font-weight-bold">Bank Name</td>
                        <td>{{ $payroll->employee->bank_name ?? '-' }}</td>
                        <td class="bg-light font-weight-bold">Bank A/C No.</td>
                        <td>{{ $payroll->employee->bank_account_no ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td class="bg-light font-weight-bold">Days Worked</td>
                        <td>{{ $payroll->days_worked }} / {{ $payroll->total_days }}</td>
                        <td class="bg-light font-weight-bold">OT Hours</td>
                        <td>{{ $payroll->ot_hours ?? 0 }}</td>
                    </tr>
                </table>
            </div>
        </div>

        <div class="row">
            <div class="col-6">
                <div class="section-header">EARNINGS</div>
                <table class="table table-sm table-bordered">
                    <tr><td>Basic + DA</td><td class="text-right">{{ number_format($payroll->basic_da, 2) }}</td></tr>
                    <tr><td>HRA</td><td class="text-right">{{ number_format($payroll->hra, 2) }}</td></tr>
                    <tr><td>Conveyance</td><td class="text-right">{{ number_format($payroll->conveyance, 2) }}</td></tr>
                    <tr><td>Washing Allowance</td><td class="text-right">{{ number_format($payroll->washing_allowance, 2) }}</td></tr>
                    @if($payroll->ot_amount > 0)
                    <tr><td>Overtime</td><td class="text-right">{{ number_format($payroll->ot_amount, 2) }}</td></tr>
                    @endif
                    @if($payroll->bonus > 0)
                    <tr><td>Bonus</td><td class="text-right">{{ number_format($payroll->bonus, 2) }}</td></tr>
                    @endif
                    <tr class="bg-light font-weight-bold"><td>Gross Earnings</td><td class="text-right">{{ number_format($payroll->gross_salary, 2) }}</td></tr>
                </table>
            </div>
            <div class="col-6">
                <div class="section-header deduction">DEDUCTIONS</div>
                <table class="table table-sm table-bordered">
                    <tr><td>Provident Fund (PF)</td><td class="text-right">{{ number_format($payroll->pf_deduction, 2) }}</td></tr>
                    <tr><td>ESI</td><td class="text-right">{{ number_format($payroll->esi_deduction, 2) }}</td></tr>
                    <tr><td>Professional Tax</td><td class="text-right">{{ number_format($payroll->pt_deduction, 2) }}</td></tr>
                    @if($payroll->other_deductions > 0)
                    <tr><td>Other Deductions</td><td class="text-right">{{ number_format($payroll->other_deductions, 2) }}</td></tr>
                    @endif
                    <tr class="bg-light font-weight-bold"><td>Total Deductions</td><td class="text-right">{{ number_format($payroll->total_deductions, 2) }}</td></tr>
                </table>
            </div>
        </div>

        <div class="net-salary-box mt-3">
            <div>NET SALARY PAYABLE</div>
            <div class="amount">&#8377; {{ number_format($payroll->net_salary, 2) }}</div>
            <small>({{ numberToWords($payroll->net_salary) }} Only)</small>
        </div>

        @if($payroll->status == 'Paid')
        <div class="alert alert-success mt-3 text-center">
            <strong>PAID</strong> on {{ $payroll->payment_date ? \Carbon\Carbon::parse($payroll->payment_date)->format('d-m-Y') : '-' }}
            via {{ $payroll->payment_mode ?? '-' }}
            @if($payroll->reference_number) | Ref: {{ $payroll->reference_number }} @endif
        </div>
        @endif

        <div class="row mt-5">
            <div class="col-4"><div class="signature-line">Prepared By</div></div>
            <div class="col-4"><div class="signature-line">Verified By</div></div>
            <div class="col-4"><div class="signature-line">Employee Signature</div></div>
        </div>

        <div class="text-center mt-4 text-muted small">
            This is a computer-generated payslip. For queries, contact HR.
        </div>
    </div>
</body>
</html>
