<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Admin Dashboard">
    <meta name="author" content="Indus Pro">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Admin Dashboard')</title>
    <link rel="icon" type="image/png" href="{{ asset('img/logo-sm-blue.png') }}">

    <!-- Preconnect to CDNs for faster loading -->
    <link rel="preconnect" href="https://cdn.jsdelivr.net" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://cdn.datatables.net" crossorigin>

    <!-- Google Fonts - Non-blocking -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" as="style" onload="this.onload=null;this.rel='stylesheet'">
    <noscript><link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet"></noscript>

    <!-- Critical CSS - Load immediately -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <!-- Non-critical CSS - Lazy load -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/css/bootstrap-select.min.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap4.min.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap4.min.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.39.0/css/tempusdominus-bootstrap-4.min.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" media="print" onload="this.media='all'">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.5.2/dist/select2-bootstrap4.min.css" media="print" onload="this.media='all'">

    <!-- Custom Styles -->
    <link href="{{ asset('css/style.min.css') }}" rel="stylesheet">
    <!-- Modern Theme Enhancement -->
    <link href="{{ asset('css/modern-theme.css') }}" rel="stylesheet">

    <style>
        /* General Overrides */
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fc; }
        .sidebar { min-height: 100vh; }
        
        /* Sidebar Brand */
        .sidebar-brand-text { font-weight: 700; font-size: 1.2rem; letter-spacing: 0.05rem; }
        
        /* Cards */
        .card { border: none; border-radius: 0.75rem; box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15); }
        .card-header { background-color: #f8f9fc; border-bottom: 1px solid #e3e6f0; font-weight: 700; color: #4e73df; }
        
        /* Buttons */
        .btn-primary { background-color: #4e73df; border-color: #4e73df; }
        .btn-primary:hover { background-color: #2e59d9; border-color: #2653d4; }
        
         /* Custom Scrollbar */
         ::-webkit-scrollbar { width: 8px; height: 8px; }
         ::-webkit-scrollbar-track { background: #f1f1f1; }
         ::-webkit-scrollbar-thumb { background: #c1c1c1; border-radius: 4px; }
         ::-webkit-scrollbar-thumb:hover { background: #a8a8a8; }
    </style>
    @stack('styles')
    @yield('styles')
</head>

<body id="page-top" style="font-family: 'Poppins', sans-serif;">

<div id="wrapper">
    @include('partials.superadminsidebar')

    <!-- Sidebar Toggle Button -->
    <div class="sidebar-toggle-container d-none d-md-flex">
        <button class="btn-sidebar-toggle" id="sidebarToggle" title="Toggle Sidebar">
            <i class="fas fa-angle-left"></i>
        </button>
    </div>

    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            @include('partials.topbar')

            <div class="container-fluid">
                @yield('content')
            </div>
        </div>

        @include('partials.footer')
    </div>
</div>

<!-- Core Libraries - jQuery must load first (no defer) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Deferred Scripts - Load after page renders -->
<script defer src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script defer src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/js/bootstrap-select.min.js"></script>
<script defer src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script defer src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script defer src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.39.0/js/tempusdominus-bootstrap-4.min.js"></script>

<!-- DataTables - Deferred -->
<script defer src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script defer src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
<script defer src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script defer src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap4.min.js"></script>
<script defer src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script defer src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script defer src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.colVis.min.js"></script>
<script defer src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script defer src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap4.min.js"></script>
<script defer src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script defer src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script defer src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<!-- Notifications & Utilities - Deferred -->
<script defer src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script defer src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script defer src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script defer src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


<!-- Shared Laravel JS -->
@include('layouts.scripts.methods')

<!-- Page Logic -->
<script>
    $(document).ready(function () {
        updateDateTime();
        setInterval(updateDateTime, 1000);

        $('.selectpicker').selectpicker();

        $('.datetimepicker').on("focus", function () {
            $(this).data('prev', $(this).val());
        });

        $('.datetimepicker').on("input", function () {
            const prev = $(this).data('prev');
            const value = new Date($(this).val()).getTime();
            const minTime = $(this).data('min') ? new Date($(this).data('min')).getTime() : 0;
            const maxTime = $(this).data('max') ? new Date($(this).data('max')).getTime() : Infinity;

            if (value < minTime || value > maxTime) {
                $(this).val(prev);
                if ($(this).data('min') && $(this).data('max')) {
                    alert(`Should be within ${$(this).data('min')} - ${$(this).data('max')}`);
                } else if ($(this).data('min')) {
                    alert(`Should be greater than ${$(this).data('min')}`);
                } else if ($(this).data('max')) {
                    alert(`Should be less than ${$(this).data('max')}`);
                }
            }
        });

        $('#sidebarToggle').on('click', function (e) {
            e.preventDefault();
            $('body').toggleClass('sidebar-toggled');
            $('#accordionSidebar').toggleClass('toggled');
        });
    });
</script>

@stack('scripts')
@yield('scripts')

</body>
</html>
