{{--
    DataTable Component

    Usage:
    <x-ui.data-table id="customerTable" :columns="['ID', 'Name', 'Email', 'Actions']">
        @foreach($customers as $customer)
            <tr id="row-{{ $customer->id }}">
                <td>{{ $customer->id }}</td>
                <td>{{ $customer->name }}</td>
                <td>{{ $customer->email }}</td>
                <td>
                    <x-ui.action-buttons :id="$customer->id" route="admin.customer" />
                </td>
            </tr>
        @endforeach
    </x-ui.data-table>

    Props:
    - id: Table ID for DataTable initialization (required)
    - columns: Array of column headers (required)
    - responsive: Enable responsive mode (default: true)
    - buttons: Show export buttons (default: true)
    - class: Additional CSS classes (optional)
--}}

@props([
    'id',
    'columns',
    'responsive' => true,
    'buttons' => true,
    'class' => ''
])

<div class="table-responsive">
    <table class="table table-bordered table-hover align-middle {{ $class }}" id="{{ $id }}" width="100%">
        <thead class="thead-light">
            <tr>
                @foreach($columns as $column)
                    @if(is_array($column))
                        <th style="{{ $column['style'] ?? '' }}" class="{{ $column['class'] ?? '' }}">
                            {{ $column['label'] }}
                        </th>
                    @else
                        <th>{{ $column }}</th>
                    @endif
                @endforeach
            </tr>
        </thead>
        <tbody>
            {{ $slot }}
        </tbody>
    </table>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('#{{ $id }}').DataTable({
        @if($buttons)
        dom: 'Bfrtip',
        buttons: [
            { extend: 'copy', className: 'btn btn-secondary btn-sm' },
            { extend: 'csv', className: 'btn btn-secondary btn-sm' },
            { extend: 'excel', className: 'btn btn-secondary btn-sm' },
            { extend: 'pdf', className: 'btn btn-secondary btn-sm' },
            { extend: 'print', className: 'btn btn-secondary btn-sm' }
        ],
        @endif
        pageLength: 10,
        responsive: {{ $responsive ? 'true' : 'false' }},
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        },
        order: [[0, 'desc']]
    });
});
</script>
@endpush
