{{--
    Dashboard Stat Card Component

    Usage:
    <x-ui.card title="Total Customers" value="150" icon="users" color="primary" />
    <x-ui.card title="Revenue" value="$50,000" icon="dollar-sign" color="success" :progress="75" />

    Props:
    - title: Card title (required)
    - value: Display value (required)
    - icon: FontAwesome icon name without 'fa-' prefix (required)
    - color: Bootstrap color - primary, success, info, warning, danger (default: primary)
    - progress: Progress bar percentage 0-100 (optional)
    - link: Optional link to wrap the card (optional)
--}}

@props([
    'title',
    'value',
    'icon',
    'color' => 'primary',
    'progress' => null,
    'link' => null
])

<div class="col-xl-3 col-md-6 mb-4">
    @if($link)
    <a href="{{ $link }}" class="text-decoration-none">
    @endif
    <div class="card border-left-{{ $color }} shadow h-100 py-2">
        <div class="card-body">
            <div class="row no-gutters align-items-center">
                <div class="col mr-2">
                    <div class="text-xs font-weight-bold text-{{ $color }} text-uppercase mb-1">
                        {{ $title }}
                    </div>
                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $value }}</div>
                    @if($progress !== null)
                    <div class="row no-gutters align-items-center mt-2">
                        <div class="col">
                            <div class="progress progress-sm">
                                <div class="progress-bar bg-{{ $color }}"
                                     role="progressbar"
                                     style="width: {{ $progress }}%"
                                     aria-valuenow="{{ $progress }}"
                                     aria-valuemin="0"
                                     aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                        <div class="col-auto ml-2">
                            <span class="text-xs text-gray-600">{{ $progress }}%</span>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="col-auto">
                    <i class="fas fa-{{ $icon }} fa-2x text-gray-300"></i>
                </div>
            </div>
        </div>
    </div>
    @if($link)
    </a>
    @endif
</div>
