{{--
    Bootstrap Modal Component

    Usage:
    <x-ui.bootstrap-modal id="deleteModal" title="Confirm Delete" size="md">
        <p>Are you sure you want to delete this item?</p>
        <x-slot:footer>
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
        </x-slot:footer>
    </x-ui.bootstrap-modal>

    Props:
    - id: Modal ID (required)
    - title: Modal title (required)
    - size: Modal size - sm, md, lg, xl (default: md)
    - static: Static backdrop (default: false)
    - scrollable: Scrollable content (default: false)
    - centered: Vertically centered (default: false)
    - headerClass: Additional header classes (optional)
--}}

@props([
    'id',
    'title',
    'size' => 'md',
    'static' => false,
    'scrollable' => false,
    'centered' => false,
    'headerClass' => ''
])

@php
    $modalClass = 'modal-dialog';
    if ($size !== 'md') $modalClass .= ' modal-' . $size;
    if ($scrollable) $modalClass .= ' modal-dialog-scrollable';
    if ($centered) $modalClass .= ' modal-dialog-centered';
@endphp

<div class="modal fade"
     id="{{ $id }}"
     tabindex="-1"
     aria-labelledby="{{ $id }}Label"
     aria-hidden="true"
     @if($static) data-backdrop="static" data-keyboard="false" @endif>
    <div class="{{ $modalClass }}">
        <div class="modal-content">
            <div class="modal-header {{ $headerClass }}">
                <h5 class="modal-title" id="{{ $id }}Label">{{ $title }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{ $slot }}
            </div>
            @if(isset($footer))
            <div class="modal-footer">
                {{ $footer }}
            </div>
            @endif
        </div>
    </div>
</div>
