{{--
    Action Buttons Component

    Usage:
    <x-ui.action-buttons :id="$item->id" route="admin.customer" />
    <x-ui.action-buttons :id="$item->id" route="admin.customer" :show="true" :edit="true" :delete="true" />
    <x-ui.action-buttons :id="$item->id" route="admin.rfq" :print="true" />

    Props:
    - id: Resource ID (required)
    - route: Base route name without action suffix (required)
    - show: Show view button (default: true)
    - edit: Show edit button (default: true)
    - delete: Show delete button (default: true)
    - print: Show print button (default: false)
    - approve: Show approve button (default: false)
    - size: Button size - sm, md, lg (default: sm)
--}}

@props([
    'id',
    'route',
    'show' => true,
    'edit' => true,
    'delete' => true,
    'print' => false,
    'approve' => false,
    'size' => 'sm'
])

<div class="btn-group" role="group">
    @if($show)
    <a href="{{ route($route . '.show', $id) }}"
       class="btn btn-info btn-{{ $size }}"
       title="View">
        <i class="fas fa-eye"></i>
    </a>
    @endif

    @if($edit)
    <a href="{{ route($route . '.edit', $id) }}"
       class="btn btn-warning btn-{{ $size }}"
       title="Edit">
        <i class="fas fa-edit"></i>
    </a>
    @endif

    @if($print)
    <a href="{{ route($route . '.print', $id) }}"
       class="btn btn-secondary btn-{{ $size }}"
       title="Print"
       target="_blank">
        <i class="fas fa-print"></i>
    </a>
    @endif

    @if($approve)
    <button type="button"
            class="btn btn-success btn-{{ $size }} approve-btn"
            data-id="{{ $id }}"
            title="Approve">
        <i class="fas fa-check"></i>
    </button>
    @endif

    @if($delete)
    <button type="button"
            class="btn btn-danger btn-{{ $size }} delete-btn"
            data-id="{{ $id }}"
            title="Delete">
        <i class="fas fa-trash"></i>
    </button>
    @endif
</div>
